/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.ebext;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.PasswordEncryptUtil;
import kd.fi.cas.helper.ebext.BankPasswordHelper;

public class BankPaymentCodePlugin
extends AbstractFormPlugin {
    private static final String KEY_FORGETPWD_CALLBACK = "KEY_FORGETPWD_CALLBACK";

    public void afterCreateNewData(EventObject evt) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        this.getModel().setValue("user", (Object)userId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "forgetpwd"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            String key = button.getKey();
            RequestContext requestContext = RequestContext.get();
            Long userId = Long.valueOf(requestContext.getUserId());
            if ("btnok".equals(key)) {
                this.loginByPwd(userId);
            } else if ("forgetpwd".equals(key)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cas_bankresetpwd");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FORGETPWD_CALLBACK));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                IFormView view = this.getView();
                view.showForm(showParameter);
            }
        }
    }

    private void loginByPwd(Long userId) {
        Object passWd = this.getModel().getValue("passwd");
        if (StringUtils.isNotBlank((Object)passWd)) {
            DynamicObject[] bankEtpPwdObjs = BankPasswordHelper.getBankPasswordById((Long)userId);
            boolean isSuccess = PasswordEncryptUtil.authenticate((String)((String)bankEtpPwdObjs[0].get("password")), (String)((String)passWd));
            if (!isSuccess) {
                this.showFieldTips("passwd", ResManager.loadKDString((String)"\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BankPaymentCodePlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
            } else {
                this.showFieldTips("passwd", "", true);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("loginpass", "1");
                resultMap.put("randomIdx", this.getView().getFormShowParameter().getCustomParam("randomIdx"));
                this.getView().returnDataToParent(resultMap);
                this.getView().close();
            }
        } else {
            this.showFieldTips("passwd", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5bc6\u7801", (String)"BankPaymentCodePlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
        }
    }

    private void showFieldTips(String field, String tips, boolean isHidden) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        fieldTip.setSuccess(isHidden);
        this.getView().showFieldTip(fieldTip);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)KEY_FORGETPWD_CALLBACK) && (data = (Map)event.getReturnData()) != null && "1".equals(data.get("resetsuccess"))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f\u3002", (String)"BankPasswordSettingPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }
}

