/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.er.list.plugin;

import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class UpDrawCasBillList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(UpDrawCasBillList.class);

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCustomParam("ismergerows", (Object)Boolean.FALSE);
    }

    public void setFilter(SetFilterEvent e) {
        log.info("-----\u8c03\u7528\u4e0a\u62c9\u63d2\u4ef6\u65b9\u6cd5-----");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            IDataModel parentModel = parentView.getModel();
            if (parentModel == null) {
                return;
            }
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("approveamount", parentModel.getValue("approveamount"));
                params.put("selectedEntryIDs", parentModel.getDataEntity(true).getDynamicObjectCollection("recentry").stream().map(r -> r.getLong("recbillid")).collect(Collectors.toList()));
                Long companyId = parentModel.getValue("company") != null ? (Long)((DynamicObject)parentModel.getValue("company")).getPkValue() : 0L;
                params.put("company", companyId);
                Long costcompanyId = parentModel.getValue("costcompany") != null ? (Long)((DynamicObject)parentModel.getValue("costcompany")).getPkValue() : 0L;
                params.put("costcompany", costcompanyId);
                Long payerId = 0L;
                String billPayerType = (String)parentModel.getValue("payertype");
                if (!StringUtils.isEmpty((CharSequence)billPayerType)) {
                    switch (billPayerType) {
                        case "bd_supplier": {
                            DynamicObject supplier = (DynamicObject)parentModel.getValue("supplier");
                            if (supplier == null) break;
                            payerId = (Long)supplier.getPkValue();
                            break;
                        }
                        case "bd_customer": {
                            DynamicObject customer = (DynamicObject)parentModel.getValue("customer");
                            if (customer == null) break;
                            payerId = (Long)customer.getPkValue();
                            break;
                        }
                        case "bos_org": {
                            DynamicObject casorg = (DynamicObject)parentModel.getValue("casorg");
                            if (casorg == null) break;
                            payerId = (Long)casorg.getPkValue();
                            break;
                        }
                        case "er_payeer": {
                            DynamicObject payer1;
                            DynamicObject payer = (DynamicObject)parentModel.getValue("payer");
                            if (payer == null || (payer1 = (DynamicObject)payer.get("payer")) == null || payer1.getPkValue() == null) break;
                            payerId = (Long)payer1.getPkValue();
                            break;
                        }
                    }
                }
                params.put("payer", payerId);
                QFilter selectedEntryQfilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"CasListFilterServiceImpl", (String)"getUpDrawCasBillFilter", (Object[])new Object[]{params});
                log.info("-----selectedEntryQfilter-----", (Object)(selectedEntryQfilter != null ? selectedEntryQfilter.toString() : "empty filterString"));
                e.setSpecialDataPermQFilter(null);
                e.addCustomQFilter(selectedEntryQfilter);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
    }
}

