/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service.AbstractWriteBackService;

public class TripReqBillWriteBackService
extends AbstractWriteBackService {
    private Log log = LogFactory.getLog(TripReqBillWriteBackService.class);

    @Override
    public void addKeys(List<String> keys) {
        super.addKeys(keys);
        keys.add("oriaccappamount");
        keys.add("payamount");
        keys.add("balanceamount");
        keys.add("notpayamount");
        keys.add("approveamount");
    }

    public TripReqBillWriteBackService(String opType) {
        this.opType = opType;
    }

    @Override
    public void writeBackEntryAmount(DynamicObject sourceBill, DynamicObject targetBill) {
        super.writeBackEntryAmount(sourceBill, targetBill);
        sourceBill.set("oriaccnotpayamount", (Object)sourceBill.getBigDecimal("oriaccappamount").subtract(sourceBill.getBigDecimal("oriaccpayedamount")));
        BigDecimal notPayAmount = sourceBill.getBigDecimal("oriaccnotpayamount").multiply(sourceBill.getBigDecimal("accexchangerate"));
        sourceBill.set("accnotpayamount", (Object)notPayAmount);
        if (sourceBill.getBigDecimal("oriaccpayedamount").compareTo(sourceBill.getBigDecimal("oriaccappamount")) == 0) {
            sourceBill.set("billstatusfield", (Object)"G");
        } else {
            sourceBill.set("billstatusfield", (Object)"F");
        }
    }

    @Override
    public void writeBackBillAmount(DynamicObject sourceBill) {
        super.writeBackBillAmount(sourceBill);
        BigDecimal billPayedAmount = BigDecimal.ZERO;
        DynamicObjectCollection coll = ((DynamicObject)sourceBill.getParent()).getDynamicObjectCollection("accountentry");
        for (DynamicObject dyObject : coll) {
            if (sourceBill.getPkValue().toString().equals(dyObject.getPkValue().toString())) {
                billPayedAmount = billPayedAmount.add(sourceBill.getBigDecimal("accpayedamount"));
                continue;
            }
            billPayedAmount = billPayedAmount.add(dyObject.getBigDecimal("accpayedamount"));
        }
        DynamicObject sourceParentBill = (DynamicObject)sourceBill.getParent();
        sourceParentBill.set("payamount", (Object)billPayedAmount);
        sourceParentBill.set("balanceamount", (Object)billPayedAmount);
        sourceParentBill.set("notpayamount", (Object)sourceParentBill.getBigDecimal("approveamount").subtract(billPayedAmount));
    }

    @Override
    public boolean validatorBuildAmount(BigDecimal totalBuildAmount, DynamicObject sourceBill) {
        this.log.info(String.format("target totalBuildAmount(%s)\u4e0esource orireceiveamount(%s)\u6bd4\u8f83", totalBuildAmount.toString(), sourceBill.getBigDecimal("orireceiveamount").toString()));
        return totalBuildAmount.compareTo(sourceBill.getBigDecimal("orireceiveamount")) <= 0;
    }
}

