/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BankStatementImportNewPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(BankStatementImportNewPlugin.class);
    private long count = 0L;
    private static final String ACCOUNTBANK = "accountbank";
    private static final String BANK_ACCOUNT_NUMBER = "bankaccountnumber";
    private static final String CURRENCY = "currency";
    private static final String CURRENCY_NUMBER = "number";
    private static final String SEQUENCENUMBER = "sequencenumber";
    private static final String SORTNO = "sortno";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String ORG = "org";
    private static final String BIZDATE = "bizdate";
    private Map<String, Long> orgIdMap;
    private Map<String, Long> acctIdMap;
    private Map<String, Long> currencyIdMap;
    private Map<String, String> paramCS095Map;
    private Map<String, String> paramCS096Map;
    private Map<String, DynamicObject> lastBalanceAdjustMap;
    private Map<String, DynamicObject> casInitMap;
    protected static final String OVERRIDE_NEW = "overridenew";

    public String getDefaultImportType() {
        return OVERRIDE_NEW;
    }

    public String getDefaultKeyFields() {
        return "bankvouvherno";
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeSave(rowdatas, logger);
        LOGGER.info(String.format("\u5f53\u524d\u5f15\u5165\u6279\u6b21\u6570\u636e\u5171 %s \u6761\u3002", rowdatas.size()));
        this.customBeforeSave(rowdatas, this.ctx.getFormShowParameterAppId(), (p, q) -> logger.log(p, q).fail());
    }

    protected boolean isForceBatch() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customBeforeSave(List<ImportBillData> rowdatas, String appId, BiConsumer<Integer, String> msgLog) {
        Map<String, List<ImportBillData>> groupMap = rowdatas.stream().collect(Collectors.groupingBy(v -> (v.getData().get((Object)ACCOUNTBANK) == null ? ACCOUNTBANK : ((Map)v.getData().get((Object)ACCOUNTBANK)).get(BANK_ACCOUNT_NUMBER)) + "---" + (v.getData().get((Object)CURRENCY) == null ? CURRENCY : (String)((Map)v.getData().get((Object)CURRENCY)).get("number"))));
        this.initDataMaps(rowdatas);
        HashMap<String, Pair> needReSortMap = new HashMap<String, Pair>(16);
        for (Map.Entry<String, List<ImportBillData>> entry : groupMap.entrySet()) {
            List<ImportBillData> dataList = entry.getValue();
            List sortNoList = dataList.stream().map(ImportBillData::getData).map(b -> b.getString(SORTNO)).filter(c -> null != c && !c.trim().isEmpty()).collect(Collectors.toList());
            boolean needReSort = sortNoList.size() < 1;
            boolean checkFlag = sortNoList.size() > 0 && sortNoList.size() < dataList.size();
            Pair pair = Pair.of((Object)needReSort, (Object)checkFlag);
            needReSortMap.put(entry.getKey(), pair);
        }
        this.initValidParamMaps(new HashSet<Long>(this.orgIdMap.values()), new HashSet<Long>(this.acctIdMap.values()));
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            String message = null;
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            try {
                String bankVoucherNo;
                QFilter qFilter;
                boolean exists;
                boolean isContain;
                Map accountbankMap = (Map)data.get((Object)ACCOUNTBANK);
                String acctBankPropVal = accountbankMap == null ? ACCOUNTBANK : (String)accountbankMap.get(BANK_ACCOUNT_NUMBER);
                Map currencyMap = (Map)data.get((Object)CURRENCY);
                String currencyPropVal = currencyMap == null ? CURRENCY : (String)currencyMap.get("number");
                String key = acctBankPropVal + "---" + currencyPropVal;
                Map orgMap = (Map)data.get((Object)ORG);
                String orgPropVal = orgMap == null ? ORG : (String)orgMap.get("number");
                String validResult = this.validParams(this.orgIdMap.get(orgPropVal), this.acctIdMap.get(acctBankPropVal), this.currencyIdMap.get(currencyPropVal), data.getDate(BIZDATE));
                if (EmptyUtil.isNoEmpty((String)validResult)) {
                    message = validResult;
                    continue;
                }
                Pair pair = (Pair)needReSortMap.get(key);
                if (null != pair && ((Boolean)pair.getRight()).booleanValue()) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u8d26\u6237\u201c%1$s\u201d\uff08%2$s\uff09\u672c\u6b21\u5bfc\u5165\u6570\u636e\u4e2d\u53ea\u6709\u90e8\u5206\u586b\u5199\u4e86\u6392\u5e8f\u53f7\uff0c\u8bf7\u5168\u90e8\u586b\u5199\u6392\u5e8f\u53f7\u540e\u518d\u5bfc\u5165\uff1b\u4e5f\u53ef\u4ee5\u5168\u90e8\u6e05\u7a7a\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u6839\u636e\u6570\u636e\u5bfc\u5165\u65f6\u95f4\u8fdb\u884c\u6392\u5e8f\u3002", (String)"BankStatementImportNewPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBankPropVal, currencyPropVal);
                    this.addErrMessage(errMsg);
                }
                if ((isContain = data.containsKey((Object)"bankvouvherno")) && (exists = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])(qFilter = new QFilter("bankvouvherno", "=", (Object)(bankVoucherNo = data.getString("bankvouvherno")))).toArray()))) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u94f6\u884c\u5bf9\u8d26\u5355\u660e\u7ec6\u6d41\u6c34\u53f7[%1$s]\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BankStatementManualCommitValidator_13", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVoucherNo);
                    this.addErrMessage(errMsg);
                }
                this.beforeImportOp(data);
            }
            catch (KDBizException exc) {
                message = exc.getMessage();
                LOGGER.error("\u5f15\u5165\u64cd\u4f5c\u89e3\u6790\u5f02\u5e38 - \u4e1a\u52a1\u5f02\u5e38 >>>> " + message);
            }
            catch (ParseException exc) {
                message = exc.getMessage();
                LOGGER.error("\u5f15\u5165\u64cd\u4f5c\u89e3\u6790\u5f02\u5e38 - \u89e3\u6790\u5f02\u5e38 >>>> " + message);
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
                if (null != msgLog) {
                    msgLog.accept(rowdata.getStartIndex(), message);
                }
                it.remove();
            }
        }
    }

    private void beforeImportOp(JSONObject data) throws ParseException {
        data.put(SORTNO, EmptyUtil.isEmpty((Object)data.get((Object)SORTNO)) ? Long.valueOf(new Timestamp(System.currentTimeMillis()).getTime() * 100000L + this.count++ % 100000L) : data.get((Object)SORTNO));
    }

    protected void addErrMessage(String message) {
        throw new KDBizException(message);
    }

    private void initDataMaps(List<ImportBillData> rowdatas) {
        HashSet orgNumber = new HashSet(rowdatas.size());
        HashSet acctNumber = new HashSet(rowdatas.size());
        HashSet currencyNumber = new HashSet(rowdatas.size());
        rowdatas.forEach(importBillData -> {
            JSONObject data = importBillData.getData();
            if (EmptyUtil.isNoEmpty((Object)data.get((Object)ORG)) && EmptyUtil.isNoEmpty((Object)((JSONObject)data.get((Object)ORG)).get((Object)"number"))) {
                orgNumber.add((String)((JSONObject)data.get((Object)ORG)).get((Object)"number"));
            }
            if (EmptyUtil.isNoEmpty((Object)data.get((Object)ACCOUNTBANK)) && EmptyUtil.isNoEmpty((Object)((JSONObject)data.get((Object)ACCOUNTBANK)).get((Object)BANK_ACCOUNT_NUMBER))) {
                acctNumber.add((String)((JSONObject)data.get((Object)ACCOUNTBANK)).get((Object)BANK_ACCOUNT_NUMBER));
            }
            if (EmptyUtil.isNoEmpty((Object)data.get((Object)CURRENCY)) && EmptyUtil.isNoEmpty((Object)((JSONObject)data.get((Object)CURRENCY)).get((Object)"number"))) {
                currencyNumber.add((String)((JSONObject)data.get((Object)CURRENCY)).get((Object)"number"));
            }
        });
        this.orgIdMap = QueryServiceHelper.query((String)"bos_org", (String)"id, number", (QFilter[])new QFilter("number", "in", orgNumber).toArray()).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getLong(ID), (v1, v2) -> v1));
        this.acctIdMap = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, bankaccountnumber", (QFilter[])new QFilter(BANK_ACCOUNT_NUMBER, "in", acctNumber).toArray()).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString(BANK_ACCOUNT_NUMBER), dynamicObject -> dynamicObject.getLong(ID), (v1, v2) -> v1));
        this.currencyIdMap = QueryServiceHelper.query((String)"bd_currency", (String)"id, number", (QFilter[])new QFilter("number", "in", currencyNumber).toArray()).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getLong(ID), (v1, v2) -> v1));
    }

    private void initValidParamMaps(Set<Long> orgIds, Set<Long> acctIds) {
        this.paramCS095Map = SystemParameterHelper.getBatchParameterString(new ArrayList<Long>(orgIds), (String)"cs095");
        this.paramCS096Map = SystemParameterHelper.getBatchParameterString(new ArrayList<Long>(orgIds), (String)"cs096");
        this.lastBalanceAdjustMap = BalanceAdjustHelper.getLastBalanceAdjustBatch(orgIds, acctIds, null);
        this.casInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIds);
    }

    private String validParams(Long orgId, Long acctId, Long currencyId, Date bizDate) {
        if (orgId == null || acctId == null || currencyId == null || bizDate == null) {
            return ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7ec4\u7ec7\u3001\u8d26\u6237\u3001\u5e01\u79cd\u3002", (String)"BankStatementImportNewPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        DynamicObject casInit = this.casInitMap.get(String.valueOf(orgId));
        if (EmptyUtil.isEmpty((DynamicObject)casInit) || EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("startperiod"))) {
            return ResManager.loadKDString((String)"\u51fa\u7eb3\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankStatementImportNewPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        Date startperiodBeginDate = casInit.getDynamicObject("startperiod").getDate("begindate");
        if (null != bizDate && bizDate.before(startperiodBeginDate)) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u65e9\u4e8e\u4f1a\u8ba1\u542f\u7528\u671f\u95f4\u7684\u8d77\u59cb\u65f6\u95f4\u3002", (String)"BankStatementImportNewPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("currentperiod")) || EmptyUtil.isEmpty((Object)casInit.getDynamicObject("currentperiod").getDate("begindate"))) {
            return ResManager.loadKDString((String)"\u51fa\u7eb3\u521d\u59cb\u5316\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankStatementImportNewPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        Date currentperiodBeginDate = casInit.getDynamicObject("currentperiod").getDate("begindate");
        String paramCS096 = this.paramCS096Map.get(orgId + "");
        if (null != bizDate && bizDate.before(currentperiodBeginDate) && paramCS096.equals(Boolean.FALSE.toString())) {
            return ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u6240\u5728\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8be5\u671f\u95f4\u5bf9\u8d26\u5355\u3002", (String)"BankStatementImportNewPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        String paramCS095 = this.paramCS095Map.get(orgId + "");
        DynamicObject lastBalanceAdjust = this.lastBalanceAdjustMap.get(orgId + "_" + acctId + "_" + currencyId);
        if (EmptyUtil.isNoEmpty((DynamicObject)lastBalanceAdjust) && EmptyUtil.isNoEmpty((Object)lastBalanceAdjust.get(BIZDATE)) && null != bizDate && bizDate.before(lastBalanceAdjust.getDate(BIZDATE)) && paramCS095.equals(Boolean.FALSE.toString())) {
            return String.format(ResManager.loadKDString((String)"\u65e5\u671f [%1$s] \u5df2\u751f\u6210\u63d0\u4ea4\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868 %2$s\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5bf9\u8d26\u5355\u3002", (String)"BankStatementImportNewPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), lastBalanceAdjust.getString("billno"));
        }
        return "";
    }
}

