/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin.importservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.formplugin.importplugin.importservice.ImportHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.EntityMetadataUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseImportService {
    protected Map<String, Object> data = null;
    protected String importtype = null;
    private String entityKey;
    protected Map<String, Map<String, DynamicObject>> cachedF7 = new HashMap<String, Map<String, DynamicObject>>();
    protected long orgId = 0L;
    protected long baseCurrencyId = 0L;
    protected int baseCurrencyPrecision = 2;
    private Map<String, Map<String, BigDecimal>> sumMap = new HashMap<String, Map<String, BigDecimal>>();
    protected ImportHelper importHelper;
    private MainEntityType dt;
    private String keyFields;
    private static Log logger = LogFactory.getLog(BaseImportService.class);

    @Deprecated
    public BaseImportService(Map<String, Object> data, Map<String, Object> option) {
        this.data = data;
        this.importtype = (String)option.get("importtype");
        this.keyFields = (String)option.get("KeyFields");
    }

    public BaseImportService(String entityKey, Map<String, Object> data, Map<String, Object> option) {
        this.data = data;
        this.importtype = (String)option.get("importtype");
        this.entityKey = entityKey;
        this.importHelper = new ImportHelper(entityKey, data);
        this.dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        this.keyFields = (String)option.get("KeyFields");
    }

    public void checkBankAndAcctBank(JSONObject payerAcctBankJson, JSONObject payerBankJson, boolean isPay) {
        boolean throwErr = Boolean.FALSE;
        if (EmptyUtil.isNoEmpty((Object)payerAcctBankJson) && EmptyUtil.isNoEmpty((Object)payerBankJson)) {
            String bankAccountNumber = payerAcctBankJson.getString(payerAcctBankJson.getString("importprop"));
            DynamicObject bankAccount = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
            String bankNumber = payerBankJson.getString(payerBankJson.getString("importprop"));
            DynamicObject bank = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankNumber)});
            if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount) && EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                long bankId;
                long acctBankId = bankAccount.getLong("bank");
                if (acctBankId != (bankId = bank.getLong("id"))) {
                    throwErr = Boolean.TRUE;
                }
            } else if (EmptyUtil.isEmpty((DynamicObject)bankAccount) || EmptyUtil.isEmpty((DynamicObject)bank)) {
                throwErr = Boolean.TRUE;
            }
        }
        if (throwErr) {
            if (isPay) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u4ed8\u6b3e\u94f6\u884c\u4e0d\u662f\u4ed8\u6b3e\u8d26\u53f7\u7684\u5f00\u6237\u884c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CAS-E-124481", (String)"fi-cas-formplugin", (Object[])new Object[0]), "org"));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u6536\u6b3e\u94f6\u884c\u4e0d\u662f\u6536\u6b3e\u8d26\u53f7\u7684\u5f00\u6237\u884c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CAS-E-755628", (String)"fi-cas-formplugin", (Object[])new Object[0]), "org"));
        }
    }

    public void checkOrg() throws Exception {
        DynamicObject org = this.importHelper.loadBasedata("org", 0);
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), "org"));
        }
        this.orgId = (Long)org.getPkValue();
        String startPeriodId = SystemStatusCtrolHelper.getStartPeriod((long)this.orgId).getString("id");
        if (startPeriodId == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u5bfc\u5165\u6570\u636e\u3002", (String)"BaseImportService_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        DynamicObject baseCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)this.orgId);
        this.baseCurrencyId = Long.parseLong(baseCurrency.getString("id"));
        this.baseCurrencyPrecision = Integer.parseInt(baseCurrency.getString("amtprecision"));
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", (Object)baseCurrency.getString("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
        this.checkOpenOrg(org);
    }

    public void checkNull(String key, String title) throws Exception {
        Object value = this.data.get(key);
        if (value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
    }

    public void checkText(String key, String title, boolean required, int length, String defaultValue) throws Exception {
        String value = (String)this.data.get(key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (value != null && value.length() > length) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u8d85\u8fc7\u6700\u5927\u957f\u5ea6%2$s\u3002", (String)"BaseImportService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, length));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    public void checkDate(String key, String title, boolean required, Date min, Date max, Date defaultValue) throws Exception {
        String strValue = (String)this.data.get(key);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date value = df.parse(strValue);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (min != null && value.compareTo(min) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f%2$s\u3002", (String)"BaseImportService_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, df.format(min)));
        }
        if (max != null && value.compareTo(max) >= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u665a\u4e8e\u542f\u7528\u65e5\u671f%2$s\u3002", (String)"BaseImportService_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, df.format(max)));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    public void checkEnum(String key, String title, boolean required, String[] enums, String defaultValue) throws Exception {
        String value = (String)this.data.get(key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u8f93\u5165\u503c%2$s\u4e0d\u5b58\u5728\u3002", (String)"BaseImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, value));
            }
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    public void checkCurrency(String key, String title, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        }
    }

    public void checkF7(String key, String title, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        }
    }

    public void checkEntryNull(String key, String title, JSONObject entry, int seq) throws Exception {
        Object value = entry.get((Object)key);
        if (value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title)));
        }
    }

    public void checkEntryText(String key, String title, JSONObject entry, int seq, boolean required, int length, String defaultValue) throws Exception {
        String value = (String)entry.get((Object)key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title)));
        }
        if (value != null && value.length() > length) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%1$s\u8d85\u8fc7\u6700\u5927\u957f\u5ea6%2$s\u3002", (String)"BaseImportService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, length)));
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
    }

    public void checkEntryDate(String key, String title, JSONObject entry, int seq, boolean required, Date min, Date max, Date defaultValue) throws Exception {
        String strValue = (String)entry.get((Object)key);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date value = df.parse(strValue);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title)));
        }
        if (min != null && value.compareTo(min) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u65e9\u4e8e\u65e5\u671f%2$s\u3002", (String)"BaseImportService_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, df.format(min))));
        }
        if (max != null && value.compareTo(max) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u665a\u4e8e\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"BaseImportService_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, df.format(min))));
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
    }

    public void checkEntryEnum(String key, String title, JSONObject entry, int seq, boolean required, String[] enums, String defaultValue) throws Exception {
        String value = (String)entry.get((Object)key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title)));
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%1$s\u8f93\u5165\u503c%2$s\u4e0d\u5b58\u5728\u3002", (String)"BaseImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, value)));
            }
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
    }

    public void checkEntryF7(String key, String title, JSONObject entry, int seq, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)entry.get((Object)key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            entry.put(key, (Object)value);
        }
    }

    public BigDecimal parseBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public void checkExchangeRate() throws Exception {
        DynamicObject currency = this.importHelper.loadBasedata("currency", 0);
        DynamicObject baseCurrency = this.importHelper.loadBasedata("basecurrency", 0);
        if (currency != null && baseCurrency != null && currency.getPkValue().equals(baseCurrency.getPkValue())) {
            this.data.put("exchangerate", "1");
            return;
        }
        BigDecimal value = this.importHelper.getBigDecimal("exchangerate");
        DynamicObject exratetable = this.importHelper.loadBasedata("exratetable");
        if (value == null) {
            Date exratedate = DateUtils.getCurrentDate();
            Object exratedateobj = this.data.get("exratedate");
            Object bizDate = this.data.get("bizdate");
            if (exratedateobj != null) {
                exratedate = DateUtils.stringToDate((String)String.valueOf(exratedateobj), (String)"yyyy-MM-dd");
            } else if (bizDate != null) {
                exratedate = DateUtils.stringToDate((String)String.valueOf(bizDate), (String)"yyyy-MM-dd");
            }
            if (currency != null) {
                BigDecimal exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)currency.getLong("id"), (Long)this.baseCurrencyId, (Long)this.orgId, (Date)exratedate, (Long)(exratetable == null ? 0L : exratetable.getLong("id")));
                this.data.put("exchangerate", exchangeRate.toPlainString());
            }
        }
    }

    public boolean checkLength(String value, int length) {
        return value.length() > length;
    }

    public void toSumAmt(Map<String, String> sumRelation, JSONArray entryList) {
        HashMap<String, BigDecimal> sums = new HashMap<String, BigDecimal>();
        if (sumRelation.size() != 0) {
            for (Map.Entry<String, String> amtEntry : sumRelation.entrySet()) {
                String amtKey = amtEntry.getKey();
                String value = amtEntry.getValue();
                if (entryList == null || entryList.size() == 0) continue;
                BigDecimal sumAmt = BigDecimal.ZERO;
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject row = (JSONObject)entryList.get(i);
                    BigDecimal rowAmt = row.getBigDecimal(amtKey);
                    if (rowAmt == null) continue;
                    sumAmt = sumAmt.add(rowAmt);
                }
                sums.put(value, sumAmt);
                this.sumMap.put(amtKey, sums);
                this.data.put(value, sumAmt);
            }
        }
    }

    public void isZero(HashMap<String, String[]> entryAmts, HashMap<String, BigDecimal> billAmts) throws Exception {
        for (Map.Entry<String, BigDecimal> billAmtEntry : billAmts.entrySet()) {
            String billAmtkey = billAmtEntry.getKey();
            BigDecimal billAmt = billAmtEntry.getValue();
            if (billAmt == null) continue;
            String[] entryAmtKeys = entryAmts.get(billAmtkey);
            if (BigDecimal.ZERO.compareTo(billAmt) != 0) continue;
            StringBuilder exceptionMessage = new StringBuilder();
            for (int i = 0; i < entryAmtKeys.length; ++i) {
                if (i == entryAmtKeys.length - 1) {
                    exceptionMessage.append(entryAmtKeys[i]).append(ResManager.loadKDString((String)"\u5408\u8ba1\u5373", (String)"BaseImportService_12", (String)"fi-cas-formplugin", (Object[])new Object[0])).append(billAmtkey).append(ResManager.loadKDString((String)"\u4e3a\u96f6\uff0c\u65e0\u6548\u5bfc\u5165\u3002", (String)"BaseImportService_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    continue;
                }
                exceptionMessage.append(entryAmtKeys[i]).append('\u3001');
            }
            throw new KDBizException(exceptionMessage.toString());
        }
    }

    public void toLocalAmt(String amtKey, String amtLocKey, JSONObject row) {
        BigDecimal exchangeRate = this.importHelper.getBigDecimal("exchangerate");
        if (row != null) {
            BigDecimal amt = row.getBigDecimal(amtKey);
            if (amt != null) {
                row.put(amtLocKey, (Object)exchangeRate.multiply(amt));
            }
        } else {
            BigDecimal amt = (BigDecimal)this.data.get(amtKey);
            if (amt != null) {
                this.data.put(amtLocKey, exchangeRate.multiply(amt));
            }
        }
    }

    public void checkTextLength() throws Exception {
        for (Map.Entry<String, Object> dataEntry : this.data.entrySet()) {
            String key = dataEntry.getKey();
            Object value = dataEntry.getValue();
            DynamicProperty property = null;
            if ("rowNum".equals(key) || "attachmentpanel".equals(key)) continue;
            property = EntityMetadataUtils.getProperty((MainEntityType)this.dt, (String)key);
            if (property instanceof TextProp) {
                TextProp textProp = (TextProp)property;
                if ("billno".equals(key)) {
                    this.checkText(key, textProp.getDisplayName().getLocaleValue(), false, textProp.getMaxLenth(), null);
                    continue;
                }
                this.checkText(key, textProp.getDisplayName().getLocaleValue(), textProp.isMustInput(), textProp.getMaxLenth(), null);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            JSONArray entryData = (JSONArray)value;
            for (int i = 0; i < entryData.size(); ++i) {
                JSONObject row = entryData.getJSONObject(i);
                Set entryKeySet = row.keySet();
                for (String entryKey : entryKeySet) {
                    DynamicProperty entryFieldProperty = null;
                    try {
                        if ("rowNum".equals(entryKey)) continue;
                        entryFieldProperty = EntityMetadataUtils.getProperty((String)this.entityKey, (String)entryKey);
                    }
                    catch (Exception e) {
                        logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                    if (!(entryFieldProperty instanceof TextProp)) continue;
                    TextProp entryTextProp = (TextProp)entryFieldProperty;
                    this.checkEntryText(entryKey, entryTextProp.getDisplayName().getLocaleValue(), row, i, entryTextProp.isMustInput(), entryTextProp.getMaxLenth(), null);
                }
            }
        }
    }

    public void checkBillStatus() {
        String billstatus;
        String billNo = (String)this.data.get("billno");
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.entityKey, (String)"billno,billstatus", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject) && !"A".equals(billstatus = dynamicObject.getString("billstatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5904\u4e8e\u975e\u6682\u5b58\u72b6\u6001\u65f6\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"BaseImportService_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void checkBillStatusByKeyFields() {
        if ("override".equals(this.importtype) || "overridenew".equals(this.importtype)) {
            QFilter qFilter = null;
            for (String field : this.keyFields.split(",")) {
                Object val;
                if (StringUtils.isBlank((CharSequence)field) || (val = this.data.get(field)) == null) continue;
                val = "id".equals(field) ? Long.valueOf(Long.parseLong(val.toString())) : val.toString();
                if (qFilter == null) {
                    qFilter = new QFilter(field, "=", val);
                    continue;
                }
                qFilter.and(field, "=", val);
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entityKey, (String)"billno,billstatus", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects.length == 1) {
                String billstatus = dynamicObjects[0].getString("billstatus");
                if (!"A".equals(billstatus)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5904\u4e8e\u975e\u6682\u5b58\u72b6\u6001\u65f6\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"BaseImportService_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            } else if (dynamicObjects.length > 1) {
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u552f\u4e00\u4e3b\u952e\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BaseImportService_15", (String)"fi-cas-formplugin", (Object[])new Object[]{Arrays.stream(dynamicObjects).map(o -> o.getString("billno")).toString()});
                throw new KDBizException(msg);
            }
        }
    }

    private void checkOpenOrg(DynamicObject org) {
        JSONObject openOrg = (JSONObject)this.data.get("openorg");
        if (openOrg != null && !openOrg.isEmpty()) {
            DynamicObjectCollection dCollection;
            HashSet<Long> setOrgIds = new HashSet<Long>(10);
            if (this.isOpenOrg(org)) {
                setOrgIds.add(org.getLong("id"));
            }
            if ((dCollection = this.getOrgRelation(org)) != null && !dCollection.isEmpty()) {
                for (DynamicObject obj : dCollection) {
                    setOrgIds.add(obj.getLong("fromorg"));
                }
            }
            QFilter idFilter = new QFilter("id", "in", setOrgIds);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            DynamicObjectCollection openOrgs = BaseDataServiceHelper.queryBaseData((String)"bos_org", (Long)this.orgId, (QFilter)idFilter.and(enableFilter).and(statusFilter), (String)"id, name, number");
            if (openOrg.containsKey((Object)"number")) {
                String number = (String)openOrg.get((Object)"number");
                Set numberSet = openOrgs.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
                if (!numberSet.contains(number)) {
                    this.data.put("openorg", null);
                    logger.warn("\u6838\u7b97\u7ec4\u7ec7{}\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (Object)number);
                }
            } else if (openOrg.containsKey((Object)"name")) {
                String name = (String)openOrg.get((Object)"name");
                Set nameSet = openOrgs.stream().map(o -> o.getString("name")).collect(Collectors.toSet());
                if (!nameSet.contains(name)) {
                    this.data.put("openorg", null);
                    logger.warn("\u6838\u7b97\u7ec4\u7ec7{}\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (Object)name);
                } else {
                    openOrgs.forEach(o -> {
                        if (name.equals(o.getString("name"))) {
                            openOrg.put("number", (Object)o.getString("number"));
                            this.data.put("openorg", openOrg);
                        }
                    });
                }
            } else if (openOrg.containsKey((Object)"id")) {
                String id = String.valueOf(openOrg.get((Object)"id"));
                Set idSet = openOrgs.stream().map(o -> String.valueOf(o.getLong("id"))).collect(Collectors.toSet());
                if (!idSet.contains(id)) {
                    this.data.put("openorg", null);
                    logger.warn("\u6838\u7b97\u7ec4\u7ec7{}\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (Object)id);
                } else {
                    openOrgs.forEach(o -> {
                        if (id.equals(String.valueOf(o.getLong("id")))) {
                            openOrg.put("number", (Object)o.getString("number"));
                            openOrg.put("name", (Object)o.getString("name"));
                            this.data.put("openorg", openOrg);
                        }
                    });
                }
            } else {
                this.data.put("openorg", null);
            }
        }
    }

    public boolean isOpenOrg(DynamicObject org) {
        if (org == null) {
            return false;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", org.get("id"))};
        if ((org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fisaccounting", (QFilter[])qFilters)) == null) {
            return false;
        }
        return org.getBoolean("fisaccounting");
    }

    public DynamicObjectCollection getOrgRelation(DynamicObject org) {
        if (org == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("fromtype", "=", (Object)"10"), new QFilter("totype", "=", (Object)"08")};
        DynamicObject relation = QueryServiceHelper.queryOne((String)"bos_org_typerelation", (String)"id", (QFilter[])qFilters);
        DynamicObjectCollection relationCol = null;
        if (relation != null) {
            qFilters = new QFilter[]{new QFilter("typerelation", "=", relation.get("id")), new QFilter("toorg", "=", org.get("id"))};
            relationCol = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg", (QFilter[])qFilters);
        }
        return relationCol;
    }

    public Map<String, Map<String, BigDecimal>> getSumMap() {
        return this.sumMap;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getImporttype() {
        return this.importtype;
    }

    public Map<String, Map<String, DynamicObject>> getCachedF7() {
        return this.cachedF7;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getBaseCurrencyId() {
        return this.baseCurrencyId;
    }

    public int getBaseCurrencyPrecision() {
        return this.baseCurrencyPrecision;
    }

    public void queryCheck() {
        String sourceBillType;
        if (EmptyUtil.isEmpty((String)this.keyFields)) {
            return;
        }
        String[] splits = this.keyFields.split(",");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(splits.length);
        for (String key : splits) {
            if (EmptyUtil.isEmpty((String)key)) continue;
            String value = (String)this.data.get(key);
            QFilter qFilter = new QFilter(key, "=", (Object)value);
            qFilters.add(qFilter);
        }
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)this.entityKey, (String)"billno, sourcebilltype", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (EmptyUtil.isNoEmpty((DynamicObject)queryOne) && EmptyUtil.isNoEmpty((String)(sourceBillType = queryOne.getString("sourcebilltype")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u5355\u636e\u7684\u201c\u6e90\u5355\u7c7b\u578b\u201d\u503c\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\u66f4\u65b0\u3002", (String)"BaseImportService_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }
}

