/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin.importservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.importplugin.importservice.BaseImportService;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillImportService
extends BaseImportService {
    private static final String PUR_PAY = "cas_paybill_pur_BT_S";
    private static final String OTHER_SETTLE_PAY = "cas_paybill_other&settle_BT_S";
    private IAppCache iAppCache = TmcAppCache.get((String)"cas", (String)"paybill", (String)"imp");

    public PaymentBillImportService(Map<String, Object> data, Map<String, Object> option) {
        super("cas_paybill", data, option);
    }

    public void calcEntryAmt(JSONObject row, String billtypeNum) {
        BigDecimal payableamt = row.getBigDecimal("e_payableamt");
        BigDecimal discountamt = row.getBigDecimal("e_discountamt");
        if (payableamt == null) {
            payableamt = BigDecimal.ZERO;
        }
        if (discountamt == null) {
            discountamt = BigDecimal.ZERO;
        }
        if (PUR_PAY.equals(billtypeNum) || OTHER_SETTLE_PAY.equals(billtypeNum)) {
            row.put("e_actamt", (Object)payableamt.subtract(discountamt));
        }
        row.put("e_unlockamt", (Object)payableamt);
        row.put("e_unsettledamt", (Object)payableamt);
    }

    public void setPayeeInfo() {
        String payeeType;
        DynamicObject payeebank = this.importHelper.loadBasedata("payeebank");
        if (payeebank != null && (payeebank = QueryServiceHelper.queryOne((String)payeebank.getDataEntityType().getName(), (String)"id,name,number,country.name,country.id,country.number,provincetxt,citytxt", (QFilter[])new QFilter[]{new QFilter("id", "=", payeebank.getPkValue())})) != null) {
            if (this.data.get("payeebankname") == null) {
                this.data.put("payeebankname", payeebank.getString("name"));
            }
            if (this.data.get("recbanknumber") == null) {
                this.data.put("recbanknumber", payeebank.getString("number"));
            }
            if (this.data.get("reccountry") == null && payeebank.getString("country.number") != null) {
                HashMap<String, String> countryM = new HashMap<String, String>();
                countryM.put("number", payeebank.getString("country.number"));
                this.data.put("reccountry", new JSONObject(countryM));
            }
            if (this.data.get("recprovince") == null) {
                this.data.put("recprovince", payeebank.getString("provincetxt"));
            }
            if (this.data.get("reccity") == null) {
                this.data.put("reccity", payeebank.getString("citytxt"));
            }
        }
        if (!"other".equals(payeeType = (String)this.data.get("payeetype"))) {
            String number = (String)this.data.get("payeenumber");
            String name = (String)this.data.get("payeename");
            StringBuilder cacheKey = new StringBuilder();
            cacheKey.append(payeeType).append("-");
            QFilter nameOrNoFilter = null;
            if (StringUtils.isNotBlank((CharSequence)number)) {
                number = number.trim();
                nameOrNoFilter = new QFilter("number", "=", (Object)number);
                cacheKey.append(number);
            } else if (StringUtils.isNotBlank((CharSequence)name)) {
                name = name.trim();
                nameOrNoFilter = new QFilter("name", "=", (Object)name);
                cacheKey.append(name);
            } else {
                return;
            }
            String cache_key = cacheKey.toString();
            String payeeInfoStr = (String)this.iAppCache.get(cache_key, String.class);
            if (StringUtils.isNotBlank((CharSequence)payeeInfoStr)) {
                Object[] payeeInfos = (Object[])SerializationUtils.fromJsonString((String)payeeInfoStr, Object[].class);
                this.data.put("payee", payeeInfos[0]);
                this.data.put("payeename", payeeInfos[1]);
                this.data.put("payeenumber", payeeInfos[2]);
                this.data.put("payeeformid", payeeType);
            } else if (EmptyUtil.isNoEmpty((String)payeeType)) {
                DynamicObjectCollection payee = BaseDataServiceHelper.queryBaseData((String)payeeType, (Long)this.orgId, (QFilter)nameOrNoFilter.and(new QFilter("enable", "=", (Object)"1")), (String)"id,name,number");
                if (payee != null && payee.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6536\u6b3e\u4eba\u7c7b\u578b\u201c%1$s\u201d\u548c\u7f16\u7801/\u540d\u79f0\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"PaymentBillImportService_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), payeeType, StringUtils.isNotBlank((CharSequence)number) ? number : name));
                }
                if (payee != null && payee.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6536\u6b3e\u4eba\u7c7b\u578b\u201c%1$s\u201d\u548c\u7f16\u7801/\u540d\u79f0\u201c%2$s\u201d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\u3002", (String)"PaymentBillImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), payeeType, StringUtils.isNotBlank((CharSequence)number) ? number : name));
                }
                if (payee != null) {
                    this.data.put("payee", ((DynamicObject)payee.get(0)).get("id"));
                    this.data.put("payeename", ((DynamicObject)payee.get(0)).getString("name"));
                    this.data.put("payeenumber", ((DynamicObject)payee.get(0)).getString("number"));
                    Object[] payeeInfos = new Object[]{((DynamicObject)payee.get(0)).get("id"), ((DynamicObject)payee.get(0)).getString("name"), ((DynamicObject)payee.get(0)).getString("number")};
                    this.iAppCache.put(cache_key, (Object)SerializationUtils.toJsonString((Object)payeeInfos), 600);
                    this.data.put("payeeformid", payeeType);
                }
            }
        }
    }

    public void setPayeeBankInfo() {
        String payeetype = (String)this.data.get("payeetype");
        Long payee = (Long)this.data.get("payee");
        String acctBankNum = (String)this.data.get("payeebanknum");
        DynamicObject payeeBank = this.importHelper.loadBasedata("payeebank");
        String payeeBankName = (String)this.data.get("payeebankname");
        if (payeeBank != null) {
            if (StringUtils.isBlank((CharSequence)payeeBankName)) {
                this.data.put("payeebankname", payeeBank.getString("name"));
            } else if (!payeeBankName.equals(payeeBank.getString("name"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c\uff08\u57fa\u7840\u8d44\u6599\uff09\u4e0e\u6536\u6b3e\u94f6\u884c\uff08\u6587\u672c\uff09\u5bfc\u5165\u503c\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PaymentBillImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if (!StringUtils.isBlank((CharSequence)payeeBankName)) {
            this.data.put("payeebank", this.getBeBank(payeeBankName));
        } else if (acctBankNum != null && payee != null) {
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeetype) || AsstActTypeEnum.CUSTOMER.getValue().equals(payeetype)) {
                DynamicObject payeeDY = BusinessDataServiceHelper.loadSingle((Object)payee, (String)payeetype);
                DynamicObject org = this.importHelper.loadBasedata("org");
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)org, (DynamicObject)payeeDY);
                if (internalOrg != null) {
                    this.setBeBankByAcct((Long)internalOrg.getPkValue(), acctBankNum);
                } else {
                    for (DynamicObject entry : payeeDY.getDynamicObjectCollection("entry_bank")) {
                        if (!acctBankNum.equals(entry.getString("bankaccount"))) continue;
                        this.data.put("payeebank", entry.getDynamicObject("bank"));
                        this.data.put("payeebankname", entry.getDynamicObject("bank").getString("name"));
                    }
                }
            } else if (AsstActTypeEnum.EMPLOYEE.getValue().equals(payeetype)) {
                QFilter filter = new QFilter("payer", "=", (Object)payee).and("status", "=", (Object)"C").and("payeraccount", "=", (Object)acctBankNum);
                DynamicObject[] payeers = BusinessDataServiceHelper.load((String)"er_payeer", (String)"id,payerbank", (QFilter[])new QFilter[]{filter});
                if (payeers.length == 1) {
                    DynamicObject bebank = payeers[0].getDynamicObject("payerbank");
                    this.data.put("payeebank", bebank);
                    this.data.put("payeebankname", bebank.getString("name"));
                }
            } else if (AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) {
                DynamicObject billType = this.importHelper.loadBasedata("billtype");
                String businesstype = (String)this.data.get("businesstype");
                if (BillTypeConstants.PAYBILL_CASH.equals(billType.getPkValue()) && businesstype != null && PayBusinessTypeEnum.CASHOUT.getValue().equals(businesstype)) {
                    return;
                }
                this.setBeBankByAcct(payee, acctBankNum);
            }
        }
    }

    public void isZeroPayment(String billtypeNum) throws Exception {
        if (PUR_PAY.equals(billtypeNum) || OTHER_SETTLE_PAY.equals(billtypeNum)) {
            HashMap<String, String[]> entryAmts = new HashMap<String, String[]>();
            String[] keyname = new String[]{ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"PaymentBillImportService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263", (String)"PaymentBillImportService_3", (String)"fi-cas-formplugin", (Object[])new Object[0])};
            entryAmts.put(ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d", (String)"PaymentBillImportService_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), keyname);
            HashMap<String, BigDecimal> billAmts = new HashMap<String, BigDecimal>();
            BigDecimal actpayamt = (BigDecimal)this.data.get("actpayamt");
            billAmts.put(ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d", (String)"PaymentBillImportService_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), actpayamt);
            this.isZero(entryAmts, billAmts);
        }
    }

    @Override
    public void toLocalAmt(String amtKey, String amtLocKey, JSONObject row) {
        int amtprecision;
        Map basecurrency;
        String number;
        DynamicObject currency;
        JSONObject value;
        super.toLocalAmt(amtKey, amtLocKey, row);
        BigDecimal amt = BigDecimal.ZERO;
        amt = row != null ? row.getBigDecimal(amtLocKey) : (BigDecimal)this.data.get(amtLocKey);
        if (null != amt && amt.compareTo(BigDecimal.ZERO) != 0 && (value = (JSONObject)this.data.get("basecurrency")) != null && null != (currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = (String)(basecurrency = (Map)value.toJavaObject(Map.class)).get("number")))})) && (amtprecision = currency.getInt("amtprecision")) > 0) {
            amt = amt.setScale(amtprecision, RoundingMode.HALF_UP);
        }
        if (row != null) {
            row.put(amtLocKey, (Object)amt);
        } else {
            this.data.put(amtLocKey, amt);
        }
    }

    private void setBeBankByAcct(Long payee, String acctBankNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter[] accountFilter = AccountBankHelper.getUsableAccountFilter((long)payee);
        filters.addAll(Arrays.asList(accountFilter));
        filters.add(new QFilter("bankaccountnumber", "=", (Object)acctBankNumber));
        DynamicObject[] accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank.name", (QFilter[])filters.toArray(new QFilter[0]));
        if (accountbanks != null && accountbanks.length > 0) {
            this.data.put("payeebankname", accountbanks[0].getString("bank.name"));
            DynamicObject bebank = this.getBeBank(accountbanks[0].getString("bank.name"));
            if (bebank != null) {
                this.data.put("payeebank", bebank);
                if (StringUtils.isBlank(this.data.get("recbanknumber"))) {
                    this.data.put("recbanknumber", bebank.getString("union_number"));
                }
                if (StringUtils.isBlank(this.data.get("recprovince"))) {
                    this.data.put("recprovince", bebank.getString("provincetxt"));
                }
                if (StringUtils.isBlank(this.data.get("reccity"))) {
                    this.data.put("reccity", bebank.getString("citytxt"));
                }
                if (CasHelper.isEmpty(this.data.get("reccountry"))) {
                    this.data.put("reccountry", bebank.get("country"));
                }
            }
        }
    }

    private DynamicObject getBeBank(String name) {
        DynamicObject bebank = null;
        QFilter filter = new QFilter("name", "=", (Object)name).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        DynamicObject[] bebanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number,union_number,country,provincetxt,citytxt", (QFilter[])new QFilter[]{filter});
        if (bebanks != null && bebanks.length > 0) {
            bebank = bebanks[0];
        }
        return bebank;
    }
}

