/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin.importservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.importplugin.importservice.BaseImportService;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingBillImportService
extends BaseImportService {
    public ReceivingBillImportService(Map<String, Object> data, Map<String, Object> option) {
        super("cas_recbill", data, option);
    }

    public void calcEntryAmt(JSONObject row, JSONObject receivingtype, String billtype) throws Exception {
        DynamicObject receivingbilltype = this.importHelper.loadBasedata("receivingtype", 0, "id,name,number,ispartreceivable");
        if (receivingbilltype != null) {
            boolean ispartreceivable = receivingbilltype.getBoolean("ispartreceivable");
            if ("SalesRec".equals(billtype) || "OtherRec".equals(billtype)) {
                DynamicObject org = this.importHelper.loadBasedata("org", 0);
                int cs = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs117");
                BigDecimal discountamt = row.getBigDecimal("e_discountamt");
                BigDecimal efee = row.getBigDecimal("e_fee");
                if (discountamt == null) {
                    discountamt = BigDecimal.ZERO;
                }
                if (efee == null) {
                    efee = BigDecimal.ZERO;
                }
                if (cs == 2) {
                    BigDecimal actamt = row.getBigDecimal("e_actamt");
                    if (actamt == null) {
                        actamt = BigDecimal.ZERO;
                    }
                    BigDecimal receivableamt = actamt.add(discountamt).add(efee);
                    row.put("e_receivableamt", (Object)receivableamt);
                    row.put("e_unlockamt", (Object)receivableamt);
                    row.put("e_unsettledamt", (Object)receivableamt);
                } else {
                    BigDecimal receivableamt = row.getBigDecimal("e_receivableamt");
                    if (receivableamt == null) {
                        receivableamt = BigDecimal.ZERO;
                    }
                    row.put("e_actamt", (Object)receivableamt.subtract(discountamt).subtract(efee));
                    row.put("e_unlockamt", (Object)receivableamt);
                    row.put("e_unsettledamt", (Object)receivableamt);
                }
            }
        } else {
            throw new Exception(ResManager.loadKDString((String)"\u5bfc\u5165\u7ec8\u6b62\u3002\u539f\u56e0\uff1a\u83b7\u53d6\u6536\u6b3e\u7c7b\u578b\u5931\u8d25\uff0c\u5bf9\u5e94\u7f16\u7801\u7684\u6536\u6b3e\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a\u3002", (String)"ReceivingBillImportService_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void toLocalAmt(String amtKey, String amtLocKey, JSONObject row) {
        int amtprecision;
        Map basecurrency;
        String number;
        DynamicObject currency;
        JSONObject value;
        super.toLocalAmt(amtKey, amtLocKey, row);
        BigDecimal amt = BigDecimal.ZERO;
        amt = row != null ? row.getBigDecimal(amtLocKey) : (BigDecimal)this.data.get(amtLocKey);
        if (null != amt && amt.compareTo(BigDecimal.ZERO) != 0 && (value = (JSONObject)this.data.get("basecurrency")) != null && null != (currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = (String)(basecurrency = (Map)value.toJavaObject(Map.class)).get("number")))})) && (amtprecision = currency.getInt("amtprecision")) > 0) {
            amt = amt.setScale(amtprecision, RoundingMode.HALF_UP);
        }
        if (row != null) {
            row.put(amtLocKey, (Object)amt);
        } else {
            this.data.put(amtLocKey, amt);
        }
    }

    public void setPayerInfo() {
        String payerType = (String)this.data.get("payertype");
        if (!"other".equals(payerType)) {
            String name = (String)this.data.get("payername");
            String payernumber = (String)this.data.get("payernumber");
            if (CasHelper.isEmpty((Object)payerType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ed8\u6b3e\u4eba\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ReceivingBillImportService_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (CasHelper.isEmpty((Object)name) && CasHelper.isEmpty((Object)payernumber)) {
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            String tipname = "";
            String payerinfo = "";
            if (CasHelper.isNotEmpty((Object)payernumber)) {
                tipname = ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u7f16\u7801", (String)"ReceivingBillImportService_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                payerinfo = payernumber;
                qFilters.add(new QFilter("number", "=", (Object)payernumber.trim()));
            } else {
                tipname = ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u540d\u79f0", (String)"ReceivingBillImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                payerinfo = name;
                qFilters.add(new QFilter("name", "=", (Object)name.trim()));
            }
            qFilters.add(new QFilter("enable", "=", (Object)true));
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)payerType, (Long)this.orgId));
            Object[] payer = BusinessDataServiceHelper.load((String)payerType, (String)"id,name,number,status,enable", (QFilter[])qFilters.toArray(new QFilter[0]));
            Object payerDy = null;
            if (EmptyUtil.isEmpty((Object[])payer)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ed8\u6b3e\u4eba\u7c7b\u578b\u201c%1$s\u201d\u548c%2$s\u201c%3$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ReceivingBillImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), payerType, tipname, payerinfo));
            }
            if (payer.length != 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ed8\u6b3e\u4eba\u7c7b\u578b\u201c%1$s\u201d\u548c%2$s\u201c%3$s\u201d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\u3002", (String)"ReceivingBillImportService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), payerType, tipname, payerinfo));
            }
            payerDy = payer[0];
            if ("bd_supplier".equals(payerType) || "bd_customer".equals(payerType)) {
                String status = payerDy.getString("status");
                String enable = payerDy.getString("enable");
                if (!BillStatusEnum.AUDIT.getValue().equals(status) || !"1".equals(enable)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u5546\u4e3b\u6570\u636e\u4e0d\u6ee1\u8db3\uff1a\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u3002", (String)"ReceivingBillImportService_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            }
            this.data.put("payer", payerDy.getPkValue());
            this.data.put("payerformid", payerType);
            this.data.put("payernumber", payerDy.getString("number"));
            this.data.put("payername", payerDy.getString("name"));
        }
    }

    public void setPayerBankInfo() {
        String payertype = (String)this.data.get("payertype");
        Long payer = (Long)this.data.get("payer");
        String acctBankNum = (String)this.data.get("payeracctbanknum");
        DynamicObject payerBank = this.importHelper.loadBasedata("f7_payerbank");
        String payerBankName = (String)this.data.get("payerbankname");
        if (payerBank != null) {
            if (StringUtils.isBlank((CharSequence)payerBankName)) {
                this.data.put("payerbankname", payerBank.getString("name"));
            } else if (!payerBankName.equals(payerBank.getString("name"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\uff08\u57fa\u7840\u8d44\u6599\uff09\u4e0e\u4ed8\u6b3e\u94f6\u884c\uff08\u6587\u672c\uff09\u5bfc\u5165\u503c\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ReceivingBillImportService_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if (!StringUtils.isBlank((CharSequence)payerBankName)) {
            this.data.put("f7_payerbank", this.getBeBank(payerBankName));
        } else if (acctBankNum != null && payer != null) {
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payertype) || AsstActTypeEnum.CUSTOMER.getValue().equals(payertype)) {
                DynamicObject payerDY = BusinessDataServiceHelper.loadSingle((Object)payer, (String)payertype);
                DynamicObject org = this.importHelper.loadBasedata("org");
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)org, (DynamicObject)payerDY);
                if (internalOrg != null) {
                    if (payerBank == null && payerBankName == null && acctBankNum != null) {
                        this.setBeBankByAcct((Long)internalOrg.getPkValue(), acctBankNum);
                    }
                } else {
                    for (DynamicObject entry : payerDY.getDynamicObjectCollection("entry_bank")) {
                        if (!acctBankNum.equals(entry.getString("bankaccount"))) continue;
                        this.data.put("f7_payerbank", entry.getDynamicObject("bank"));
                        this.data.put("payerbankname", entry.getDynamicObject("bank").getString("name"));
                    }
                }
            } else if (AsstActTypeEnum.EMPLOYEE.getValue().equals(payertype)) {
                QFilter filter = new QFilter("payer", "=", (Object)payer).and("status", "=", (Object)"C").and("payeraccount", "=", (Object)acctBankNum);
                DynamicObject[] payeers = BusinessDataServiceHelper.load((String)"er_payeer", (String)"id,payerbank", (QFilter[])new QFilter[]{filter});
                if (payeers.length == 1) {
                    DynamicObject bebank = payeers[0].getDynamicObject("payerbank");
                    this.data.put("f7_payerbank", bebank);
                    this.data.put("payerbankname", bebank.getString("name"));
                }
            } else if (AsstActTypeEnum.COMPANY.getValue().equals(payertype)) {
                this.setBeBankByAcct(payer, acctBankNum);
            }
        }
    }

    public void isZeroReceiving(JSONObject receivingtype, String billtype) throws Exception {
        DynamicObject receivingbilltype = this.importHelper.loadBasedata("receivingtype", 0, "id,name,number,ispartreceivable");
        if (receivingbilltype != null) {
            boolean ispartreceivable = receivingbilltype.getBoolean("ispartreceivable");
            if ("SalesRec".equals(billtype) || "OtherRec".equals(billtype) && ispartreceivable) {
                HashMap<String, String[]> entryAmts = new HashMap<String, String[]>();
                String[] keyname = new String[]{ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"ReceivingBillImportService_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263", (String)"ReceivingBillImportService_4", (String)"fi-cas-formplugin", (Object[])new Object[0])};
                entryAmts.put(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"ReceivingBillImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), keyname);
                HashMap<String, BigDecimal> billAmts = new HashMap<String, BigDecimal>();
                BigDecimal actpayamt = (BigDecimal)this.data.get("actrecamt");
                billAmts.put(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"ReceivingBillImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), actpayamt);
                this.isZero(entryAmts, billAmts);
            }
        }
    }

    private void setBeBankByAcct(Long payer, String acctBankNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter[] accountFilter = AccountBankHelper.getUsableAccountFilter((long)payer);
        filters.addAll(Arrays.asList(accountFilter));
        filters.add(new QFilter("bankaccountnumber", "=", (Object)acctBankNumber));
        DynamicObject[] accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank.name", (QFilter[])filters.toArray(new QFilter[0]));
        if (accountbanks != null && accountbanks.length > 0) {
            this.data.put("payerbankname", accountbanks[0].getString("bank.name"));
            this.data.put("f7_payerbank", this.getBeBank(accountbanks[0].getString("bank.name")));
        }
    }

    private DynamicObject getBeBank(String name) {
        DynamicObject beBank = null;
        QFilter filter = new QFilter("name", "=", (Object)name).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        DynamicObject[] bebanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        if (bebanks != null && bebanks.length > 0) {
            beBank = bebanks[0];
        }
        return beBank;
    }
}

