/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin.importservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.EntityMetadataUtils;

public class ReceivingBillImportServiceNew {
    private static Log log = LogFactory.getLog(ReceivingBillImportServiceNew.class);
    private DynamicObjectCollection orgDys;
    private DynamicObjectCollection recivetypeDys;
    private DynamicObjectCollection uniqueFieldDys;
    private Map<String, Object> options;
    private Set<Integer> errRows = new HashSet<Integer>(16);

    public ReceivingBillImportServiceNew(List<ImportBillData> rowdatas, ImportLogger logger, Map<String, Object> options) {
        this.errRows.addAll(this.getErrRows(logger));
        this.options = options;
        this.orgDys = this.loadBasedata(rowdatas, "org", "id,name,number,fisaccounting", logger, true);
        this.recivetypeDys = this.loadBasedata(rowdatas, "receivingtype", "id,name,number,ispartreceivable", logger, false);
        this.uniqueFieldDys = this.getBillDys(rowdatas);
    }

    private DynamicObject getBeBank(String name) {
        DynamicObject beBank = null;
        QFilter filter = new QFilter("name", "=", (Object)name).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        DynamicObject[] bebanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        if (bebanks != null && bebanks.length > 0) {
            beBank = bebanks[0];
        }
        return beBank;
    }

    private Long getId_file(JSONObject json) {
        return json == null ? 0L : (json.containsKey((Object)"id") ? json.getLong("id") : 0L);
    }

    private Set<Integer> getErrRows(ImportLogger logger) {
        HashSet<Integer> hasErrs = logger.getLogCache() == null ? new HashSet(0) : logger.getLogCache().keySet();
        hasErrs = hasErrs == null ? new HashSet<Integer>(0) : hasErrs;
        return hasErrs;
    }

    private void doErrRows(ImportBillData rowdata, ImportLogger logger, String msg) {
        this.errRows.add(rowdata.getStartIndex());
        int err_row = rowdata.getStartIndex();
        Set<Integer> hasErrs = this.getErrRows(logger);
        if (!hasErrs.contains(err_row)) {
            logger.log(Integer.valueOf(err_row), msg).fail();
        }
    }

    public boolean isErrRow(ImportBillData rowdata) {
        return this.errRows.contains(rowdata.getStartIndex());
    }

    public void setPayerBankInfo(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        this.getDataValus(rowdatas, "payerbankname");
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection payerbankDys = this.loadBasedata(rowdatas, "f7_payerbank", null, logger, false);
        DynamicObjectCollection beBankDys = this.getQueryResults("bd_bebank", "id,name,number", this.getDataValus(rowdatas, "payerbankname"), "name", filter);
        DynamicObjectCollection payeersDys = this.getQueryResults("er_payeer", "id,payerbank,payeraccount", this.getDataValusLong(rowdatas, "payer"), "payer", filter);
        Map<String, DynamicObjectCollection> needQueryDys = this.getNeedQueryDys(rowdatas, null, true);
        Map<Long, DynamicObject> payerbankDys_Map = payerbankDys.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        Map<Long, DynamicObject> orgDys_Map = this.orgDys.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        Map<String, DynamicObject> beBankDys_Map = beBankDys.stream().collect(Collectors.toMap(o -> o.getString("name"), o -> o));
        Map<Long, DynamicObject> payeersDys_Map = payeersDys.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            JSONObject payerBankJson = (JSONObject)data.get((Object)"f7_payerbank");
            JSONObject orgJson = (JSONObject)data.get((Object)"org");
            String payertype = (String)data.get((Object)"payertype");
            Long payer = (Long)data.get((Object)"payer");
            String acctBankNum = (String)data.get((Object)"payeracctbanknum");
            DynamicObject payerBank = payerbankDys_Map.get(this.getId_file(payerBankJson));
            String payerBankName = (String)data.get((Object)"payerbankname");
            if (payerBank != null) {
                if (StringUtils.isBlank((CharSequence)payerBankName)) {
                    data.put("payerbankname", (Object)payerBank.getString("name"));
                    continue;
                }
                if (payerBankName.equals(payerBank.getString("name"))) continue;
                this.doErrRows(rowdata, logger, ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\uff08\u57fa\u7840\u8d44\u6599\uff09\u4e0e\u4ed8\u6b3e\u94f6\u884c\uff08\u6587\u672c\uff09\u5bfc\u5165\u503c\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ReceivingBillImportService_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)payerBankName)) {
                data.put("f7_payerbank", (Object)beBankDys_Map.get(payerBankName));
                continue;
            }
            if (acctBankNum == null || payer == null) continue;
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payertype) || AsstActTypeEnum.CUSTOMER.getValue().equals(payertype)) {
                DynamicObjectCollection payerDYs = needQueryDys.get(payertype);
                Map<Long, DynamicObject> payerDYs_Map = payerDYs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
                DynamicObject payerDY = payerDYs_Map.get(payer);
                DynamicObject org = orgDys_Map.get(this.getId_file(orgJson));
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)org, (DynamicObject)payerDY);
                if (internalOrg != null) {
                    if (payerBank != null || payerBankName != null || acctBankNum == null) continue;
                    this.setBeBankByAcct((Long)internalOrg.getPkValue(), acctBankNum, data);
                    continue;
                }
                for (DynamicObject entry : payerDY.getDynamicObjectCollection("entry_bank")) {
                    if (!acctBankNum.equals(entry.getString("bankaccount"))) continue;
                    data.put("f7_payerbank", (Object)entry.getDynamicObject("bank"));
                    data.put("payerbankname", (Object)entry.getDynamicObject("bank").getString("name"));
                }
                continue;
            }
            if (AsstActTypeEnum.EMPLOYEE.getValue().equals(payertype)) {
                String _acctBankNum;
                DynamicObject payeers = payeersDys_Map.get(payer);
                if (payeers == null || !acctBankNum.equals(_acctBankNum = payeers.getString("payeraccount"))) continue;
                DynamicObject bebank = payeers.getDynamicObject("payerbank");
                data.put("f7_payerbank", (Object)bebank);
                data.put("payerbankname", (Object)bebank.getString("name"));
                continue;
            }
            if (!AsstActTypeEnum.COMPANY.getValue().equals(payertype)) continue;
            this.setBeBankByAcct(payer, acctBankNum, data);
        }
    }

    private void setBeBankByAcct(Long payer, String acctBankNumber, JSONObject data) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter[] accountFilter = AccountBankHelper.getUsableAccountFilter((long)payer);
        filters.addAll(Arrays.asList(accountFilter));
        filters.add(new QFilter("bankaccountnumber", "=", (Object)acctBankNumber));
        DynamicObject[] accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank.name", (QFilter[])filters.toArray(new QFilter[0]));
        if (accountbanks != null && accountbanks.length > 0) {
            data.put("payerbankname", (Object)accountbanks[0].getString("bank.name"));
            data.put("f7_payerbank", (Object)this.getBeBank(accountbanks[0].getString("bank.name")));
        }
    }

    public void checkTextLength(List<ImportBillData> rowdatas, ImportLogger logger) throws Exception {
        if (rowdatas.size() == 0) {
            return;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"cas_recbill");
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            for (Map.Entry dataEntry : data.entrySet()) {
                String key = (String)dataEntry.getKey();
                Object value = dataEntry.getValue();
                DynamicProperty property = null;
                if ("rowNum".equals(key) || "attachmentpanel".equals(key)) continue;
                property = EntityMetadataUtils.getProperty((MainEntityType)dt, (String)key);
                if (property instanceof TextProp) {
                    TextProp textProp = (TextProp)property;
                    this.checkText(it, logger, rowdata, data, key, textProp.getDisplayName().getLocaleValue(), textProp.isMustInput(), textProp.getMaxLenth(), null);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                JSONArray entryData = (JSONArray)value;
                for (int i = 0; i < entryData.size(); ++i) {
                    JSONObject row = entryData.getJSONObject(i);
                    Set entryKeySet = row.keySet();
                    for (String entryKey : entryKeySet) {
                        DynamicProperty entryFieldProperty = null;
                        try {
                            if ("rowNum".equals(entryKey)) continue;
                            entryFieldProperty = EntityMetadataUtils.getProperty((String)"cas_recbill", (String)entryKey);
                        }
                        catch (Exception e) {
                            log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                        }
                        if (!(entryFieldProperty instanceof TextProp)) continue;
                        TextProp entryTextProp = (TextProp)entryFieldProperty;
                        this.checkEntryText(logger, rowdata, entryKey, entryTextProp.getDisplayName().getLocaleValue(), row, i, entryTextProp.isMustInput(), entryTextProp.getMaxLenth(), null);
                    }
                }
            }
        }
    }

    private void checkText(Iterator<ImportBillData> it, ImportLogger logger, ImportBillData rowdata, JSONObject data, String key, String title, boolean required, int length, String defaultValue) throws Exception {
        String value = (String)data.get((Object)key);
        if (required && value == null) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
        if (value != null && value.length() > length) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%1$s\u8d85\u8fc7\u6700\u5927\u957f\u5ea6%2$s\u3002", (String)"BaseImportService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, length));
        }
        if (value == null && defaultValue != null) {
            data.put(key, (Object)defaultValue);
        }
    }

    private void checkEntryText(ImportLogger logger, ImportBillData rowdata, String key, String title, JSONObject entry, int seq, boolean required, int length, String defaultValue) throws Exception {
        String value = (String)entry.get((Object)key);
        if (required && value == null) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title)));
        }
        if (value != null && value.length() > length) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"BaseImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), seq + 1, String.format(ResManager.loadKDString((String)"%1$s\u8d85\u8fc7\u6700\u5927\u957f\u5ea6%2$s\u3002", (String)"BaseImportService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, length)));
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
    }

    private List<String> getUniqueFields(String keyFields) {
        if (StringUtils.isBlank((CharSequence)keyFields)) {
            return null;
        }
        ArrayList<String> returns = new ArrayList<String>(5);
        String[] fields = keyFields.split(",");
        for (int i = 0; i < fields.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)fields[i])) continue;
            returns.add(fields[i]);
        }
        return returns;
    }

    private Map<String, Set<Object>> getUniqueValues_file(List<ImportBillData> rowdatas, List<String> uniqueFields) {
        if (uniqueFields == null || uniqueFields.size() == 0) {
            return new HashMap<String, Set<Object>>(0);
        }
        HashMap<String, Set<Object>> returns = new HashMap<String, Set<Object>>(uniqueFields.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            for (String uniqueField : uniqueFields) {
                Set uniqueValue = returns.computeIfAbsent(uniqueField, k -> new HashSet(16));
                Object val = data.get((Object)uniqueField);
                if ("id".equals(uniqueField)) {
                    uniqueValue.add(Long.parseLong(val.toString()));
                    continue;
                }
                uniqueValue.add(val.toString());
            }
        }
        return returns;
    }

    private DynamicObjectCollection getBillDys(List<ImportBillData> rowdatas) {
        List<String> uniqueFields = this.getUniqueFields((String)this.options.get("KeyFields"));
        if (uniqueFields == null || uniqueFields.size() == 0) {
            return null;
        }
        Map<String, Set<Object>> uniqueValues_file = this.getUniqueValues_file(rowdatas, uniqueFields);
        QFilter filter = null;
        for (String uniqueField : uniqueFields) {
            Set<Object> values = uniqueValues_file.get(uniqueField);
            if (values == null || values.size() == 0) continue;
            if (filter == null) {
                filter = new QFilter(uniqueField, "in", values);
                continue;
            }
            filter.or(uniqueField, "in", values);
        }
        log.info("getQueryResults.field.filter:{}", (Object)(filter == null ? "null" : filter.toString()));
        if (filter == null) {
            return new DynamicObjectCollection();
        }
        HashSet<String> selects = new HashSet<String>(uniqueFields);
        selects.add("billno");
        selects.add("billstatus");
        selects.add("sourcebilltype");
        return QueryServiceHelper.query((String)"cas_recbill", (String)String.join((CharSequence)",", selects), (QFilter[])new QFilter[]{filter});
    }

    private String getUniqueKey_bill(DynamicObject o, List<String> uniqueFields) {
        StringBuilder sb = new StringBuilder();
        for (String uniqueField : uniqueFields) {
            sb.append(o.getString(uniqueField)).append("!");
        }
        return sb.toString();
    }

    private String getUniqueKey_file(JSONObject o, List<String> uniqueFields) {
        StringBuilder sb = new StringBuilder();
        for (String uniqueField : uniqueFields) {
            sb.append(o.getString(uniqueField)).append("!");
        }
        return sb.toString();
    }

    public void checkBillStatusByKeyFields(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas.size() == 0) {
            return;
        }
        String keyFields = (String)this.options.get("KeyFields");
        if (EmptyUtil.isEmpty((String)keyFields)) {
            return;
        }
        String importtype = (String)this.options.get("importtype");
        if ("override".equals(importtype) || "overridenew".equals(importtype)) {
            List<String> uniqueFields = this.getUniqueFields((String)this.options.get("KeyFields"));
            Map billDys_map = this.uniqueFieldDys.stream().collect(Collectors.groupingBy(e -> this.getUniqueKey_bill((DynamicObject)e, uniqueFields), Collectors.mapping(o -> o, Collectors.toList())));
            for (ImportBillData rowdata : rowdatas) {
                JSONObject data = rowdata.getData();
                if (this.isErrRow(rowdata)) continue;
                String uniqueKey_file = this.getUniqueKey_file(data, uniqueFields);
                List billDy_uniqueKeys = billDys_map.get(uniqueKey_file);
                if (billDy_uniqueKeys.size() == 1) {
                    String billstatus = ((DynamicObject)billDy_uniqueKeys.get(0)).getString("billstatus");
                    if ("A".equals(billstatus)) continue;
                    this.doErrRows(rowdata, logger, ResManager.loadKDString((String)"\u5355\u636e\u5904\u4e8e\u975e\u6682\u5b58\u72b6\u6001\u65f6\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"BaseImportService_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (billDy_uniqueKeys.size() <= 1) continue;
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u552f\u4e00\u4e3b\u952e\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BaseImportService_15", (String)"fi-cas-formplugin", (Object[])new Object[]{billDy_uniqueKeys.stream().map(o -> o.getString("billno")).toString()});
                this.doErrRows(rowdata, logger, msg);
            }
        }
    }

    private void calcEntryAmt(JSONObject row, JSONObject receivingtype, String billtype, DynamicObject recivetypeDy, DynamicObject orgDy, Object sysParam) throws Exception {
        if (recivetypeDy != null) {
            boolean ispartreceivable = recivetypeDy.getBoolean("ispartreceivable");
            if ("SalesRec".equals(billtype) || "OtherRec".equals(billtype)) {
                int cs = sysParam == null ? 0 : Integer.parseInt(sysParam.toString());
                BigDecimal discountamt = row.getBigDecimal("e_discountamt");
                BigDecimal efee = row.getBigDecimal("e_fee");
                if (discountamt == null) {
                    discountamt = BigDecimal.ZERO;
                }
                if (efee == null) {
                    efee = BigDecimal.ZERO;
                }
                if (cs == 2) {
                    BigDecimal actamt = row.getBigDecimal("e_actamt");
                    if (actamt == null) {
                        actamt = BigDecimal.ZERO;
                    }
                    BigDecimal receivableamt = actamt.add(discountamt).add(efee);
                    row.put("e_receivableamt", (Object)receivableamt);
                    row.put("e_unlockamt", (Object)receivableamt);
                    row.put("e_unsettledamt", (Object)receivableamt);
                } else {
                    BigDecimal receivableamt = row.getBigDecimal("e_receivableamt");
                    if (receivableamt == null) {
                        receivableamt = BigDecimal.ZERO;
                    }
                    row.put("e_actamt", (Object)receivableamt.subtract(discountamt).subtract(efee));
                    row.put("e_unlockamt", (Object)receivableamt);
                    row.put("e_unsettledamt", (Object)receivableamt);
                }
            }
        } else {
            throw new Exception(ResManager.loadKDString((String)"\u5bfc\u5165\u7ec8\u6b62\u3002\u539f\u56e0\uff1a\u83b7\u53d6\u6536\u6b3e\u7c7b\u578b\u5931\u8d25\uff0c\u5bf9\u5e94\u7f16\u7801\u7684\u6536\u6b3e\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a\u3002", (String)"ReceivingBillImportService_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void doAmt(List<ImportBillData> rowdatas, ImportLogger logger) throws Exception {
        if (rowdatas.size() == 0) {
            return;
        }
        Set<String> values_num = this.getDataValus(rowdatas, "basecurrency", "number");
        DynamicObjectCollection currencyDys = this.loadByNameOrNum("bd_currency", "id,amtprecision", null, "number", null, values_num, null);
        Map<String, DynamicObject> currencyDys_map = currencyDys.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        Map<String, DynamicObject> recivetypeDys_map = this.recivetypeDys.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        Map<String, DynamicObject> orgDys_map = this.orgDys.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        List orgIds = this.orgDys.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        Map sysparams = SystemParameterHelper.getSystemParamsByOrgIds(orgIds, (String)"cs117");
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            JSONArray entryList = (JSONArray)data.get((Object)"entry");
            String billtype = (String)data.get((Object)"biztype");
            JSONObject currency = (JSONObject)data.get((Object)"basecurrency");
            String currencyid = currency.containsKey((Object)"id") ? currency.getString("id") : "";
            DynamicObject currencyDy = currencyDys_map.get(currencyid);
            JSONObject recivetype = (JSONObject)data.get((Object)"receivingtype");
            String recivetypeid = recivetype.containsKey((Object)"id") ? recivetype.getString("id") : "";
            DynamicObject recivetypeDy = recivetypeDys_map.get(recivetypeid);
            JSONObject org = (JSONObject)data.get((Object)"org");
            String orgid = org.containsKey((Object)"id") ? org.getString("id") : "";
            DynamicObject orgDy = orgDys_map.get(orgid);
            if (billtype == null || "".equals(billtype)) {
                billtype = "OtherRec";
                data.put("biztype", (Object)billtype);
            }
            if (entryList == null) continue;
            for (int i = 0; i < entryList.size(); ++i) {
                JSONObject row = (JSONObject)entryList.get(i);
                this.calcEntryAmt(row, recivetype, billtype, recivetypeDy, orgDy, sysparams.get(orgid));
                this.toLocalAmt(data, "e_actamt", "e_localamt", row, currencyDy);
                this.toLocalAmt(data, "e_receivableamt", "e_receivablelocamt", row, currencyDy);
                this.toLocalAmt(data, "e_discountamt", "e_discountlocamt", row, currencyDy);
            }
        }
    }

    private void toLocalAmt(JSONObject data, String amtKey, String amtLocKey, JSONObject row, DynamicObject currency) {
        int amtprecision;
        BigDecimal amt = BigDecimal.ZERO;
        amt = row != null ? row.getBigDecimal(amtLocKey) : (BigDecimal)data.get((Object)amtLocKey);
        if (null != amt && amt.compareTo(BigDecimal.ZERO) != 0 && null != currency && (amtprecision = currency.getInt("amtprecision")) > 0) {
            amt = amt.setScale(amtprecision, RoundingMode.HALF_UP);
        }
        if (row != null) {
            row.put(amtLocKey, (Object)amt);
        } else {
            data.put(amtLocKey, (Object)amt);
        }
    }

    private void addNameOrNums(Map<String, Set<String>> key_queryIds, String nameOrNum, String key) {
        if (StringUtils.isNotBlank((CharSequence)nameOrNum)) {
            Set str_all = key_queryIds.computeIfAbsent(key, k -> new HashSet(16));
            str_all.add(nameOrNum);
        }
    }

    private DynamicObject getDyBynameOrNum(DynamicObjectCollection payTypeDys, String file_value_name, String file_value_num) {
        if (payTypeDys == null || payTypeDys.size() == 0) {
            return null;
        }
        Map<String, DynamicObject> name_ids = payTypeDys.stream().collect(Collectors.toMap(o -> o.getString("name"), o -> o));
        Map<String, DynamicObject> number_ids = payTypeDys.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o));
        Long name_id = 0L;
        Long num_id = 0L;
        if (StringUtils.isNotBlank((CharSequence)file_value_name)) {
            DynamicObject nameIdDy = name_ids.get(file_value_name);
            name_id = nameIdDy == null ? 0L : nameIdDy.getLong("id");
        }
        if (StringUtils.isNotBlank((CharSequence)file_value_num)) {
            DynamicObject numIdDy = number_ids.get(file_value_num);
            num_id = numIdDy == null ? 0L : numIdDy.getLong("id");
        }
        if (StringUtils.isNotBlank((CharSequence)file_value_name) && StringUtils.isNotBlank((CharSequence)file_value_num) && name_id.compareTo(num_id) == 0) {
            return name_ids.get(file_value_name);
        }
        if (StringUtils.isBlank((CharSequence)file_value_name) && StringUtils.isBlank((CharSequence)file_value_num)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)file_value_name)) {
            return name_ids.get(file_value_name);
        }
        if (StringUtils.isNotBlank((CharSequence)file_value_num)) {
            return number_ids.get(file_value_num);
        }
        return null;
    }

    public void setPayerInfo(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)true);
        Map<String, DynamicObjectCollection> needQueryDys = this.getNeedQueryDys(rowdatas, qFilter, false);
        for (ImportBillData rowdata : rowdatas) {
            String payerType;
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata) || "other".equals(payerType = (String)data.get((Object)"payertype"))) continue;
            String name = (String)data.get((Object)"payername");
            String payernumber = (String)data.get((Object)"payernumber");
            if (CasHelper.isEmpty((Object)payerType)) {
                this.doErrRows(rowdata, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ed8\u6b3e\u4eba\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ReceivingBillImportService_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (CasHelper.isEmpty((Object)name) && CasHelper.isEmpty((Object)payernumber)) continue;
            String tipname = "";
            String payerinfo = "";
            if (CasHelper.isNotEmpty((Object)payernumber)) {
                tipname = ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u7f16\u7801", (String)"ReceivingBillImportService_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                payerinfo = payernumber;
            } else {
                tipname = ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u540d\u79f0", (String)"ReceivingBillImportService_8", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                payerinfo = name;
            }
            DynamicObjectCollection payTypeDys = needQueryDys.get(payerType);
            DynamicObject payerDy = this.getDyBynameOrNum(payTypeDys, name, payernumber);
            if (payerDy == null) {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ed8\u6b3e\u4eba\u7c7b\u578b\u201c%1$s\u201d\u548c%2$s\u201c%3$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ReceivingBillImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), payerType, tipname, payerinfo));
                continue;
            }
            if ("bd_supplier".equals(payerType) || "bd_customer".equals(payerType)) {
                String status = payerDy.getString("status");
                String enable = payerDy.getString("enable");
                if (!BillStatusEnum.AUDIT.getValue().equals(status) || !"1".equals(enable)) {
                    this.doErrRows(rowdata, logger, ResManager.loadKDString((String)"\u5ba2\u5546\u4e3b\u6570\u636e\u4e0d\u6ee1\u8db3\uff1a\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u3002", (String)"ReceivingBillImportService_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            data.put("payer", payerDy.getPkValue());
            data.put("payerformid", (Object)payerType);
            data.put("payernumber", (Object)payerDy.getString("number"));
            data.put("payername", (Object)payerDy.getString("name"));
        }
    }

    public void isZeroReceiving(List<ImportBillData> rowdatas, ImportLogger logger) throws Exception {
        if (rowdatas.size() == 0) {
            return;
        }
        Map<String, DynamicObject> recivetypeDys_map = this.recivetypeDys.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        for (ImportBillData rowdata : rowdatas) {
            DynamicObject receivingtypeDy;
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            String billtype = (String)data.get((Object)"biztype");
            JSONObject receivingtype = (JSONObject)data.get((Object)"receivingtype");
            String id = "";
            if (receivingtype.containsKey((Object)"id")) {
                id = receivingtype.getString("id");
            }
            if ((receivingtypeDy = recivetypeDys_map.get(id)) == null) continue;
            boolean ispartreceivable = receivingtypeDy.getBoolean("ispartreceivable");
            if (!"SalesRec".equals(billtype) && (!"OtherRec".equals(billtype) || !ispartreceivable)) continue;
            HashMap<String, String[]> entryAmts = new HashMap<String, String[]>();
            String[] keyname = new String[]{ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"ReceivingBillImportService_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263", (String)"ReceivingBillImportService_4", (String)"fi-cas-formplugin", (Object[])new Object[0])};
            entryAmts.put(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"ReceivingBillImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), keyname);
            HashMap<String, BigDecimal> billAmts = new HashMap<String, BigDecimal>();
            BigDecimal actpayamt = (BigDecimal)data.get((Object)"actrecamt");
            billAmts.put(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"ReceivingBillImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), actpayamt);
            this.isZero(rowdata, logger, entryAmts, billAmts);
        }
    }

    private void isZero(ImportBillData rowdata, ImportLogger logger, HashMap<String, String[]> entryAmts, HashMap<String, BigDecimal> billAmts) throws Exception {
        for (Map.Entry<String, BigDecimal> billAmtEntry : billAmts.entrySet()) {
            String billAmtkey = billAmtEntry.getKey();
            BigDecimal billAmt = billAmtEntry.getValue();
            if (billAmt == null) continue;
            String[] entryAmtKeys = entryAmts.get(billAmtkey);
            if (BigDecimal.ZERO.compareTo(billAmt) != 0) continue;
            StringBuilder exceptionMessage = new StringBuilder();
            for (int i = 0; i < entryAmtKeys.length; ++i) {
                if (i == entryAmtKeys.length - 1) {
                    exceptionMessage.append(entryAmtKeys[i]).append(ResManager.loadKDString((String)"\u5408\u8ba1\u5373", (String)"BaseImportService_12", (String)"fi-cas-formplugin", (Object[])new Object[0])).append(billAmtkey).append(ResManager.loadKDString((String)"\u4e3a\u96f6\uff0c\u65e0\u6548\u5bfc\u5165\u3002", (String)"BaseImportService_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    continue;
                }
                exceptionMessage.append(entryAmtKeys[i]).append('\u3001');
            }
            this.doErrRows(rowdata, logger, exceptionMessage.toString());
        }
    }

    public void toSumAmt(List<ImportBillData> rowdatas) {
        if (rowdatas.size() == 0) {
            return;
        }
        HashMap<String, String> sumRelation = new HashMap<String, String>();
        sumRelation.put("e_actamt", "actrecamt");
        sumRelation.put("e_localamt", "localamt");
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            JSONArray entryList = (JSONArray)data.get((Object)"entry");
            if (sumRelation.size() == 0) continue;
            for (Map.Entry amtEntry : sumRelation.entrySet()) {
                String amtKey = (String)amtEntry.getKey();
                String value = (String)amtEntry.getValue();
                if (entryList == null || entryList.size() == 0) continue;
                BigDecimal sumAmt = BigDecimal.ZERO;
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject row = (JSONObject)entryList.get(i);
                    BigDecimal rowAmt = row.getBigDecimal(amtKey);
                    if (rowAmt == null) continue;
                    sumAmt = sumAmt.add(rowAmt);
                }
                data.put(value, (Object)sumAmt);
            }
        }
    }

    public void queryCheck(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas.size() == 0) {
            return;
        }
        String keyFields = (String)this.options.get("KeyFields");
        if (EmptyUtil.isEmpty((String)keyFields)) {
            return;
        }
        List<String> uniqueFields = this.getUniqueFields((String)this.options.get("KeyFields"));
        Map billDys_map = this.uniqueFieldDys.stream().collect(Collectors.groupingBy(e -> this.getUniqueKey_bill((DynamicObject)e, uniqueFields), Collectors.mapping(o -> o, Collectors.toList())));
        for (ImportBillData rowdata : rowdatas) {
            String uniqueKey_file;
            List billDy_uniqueKeys;
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata) || (billDy_uniqueKeys = billDys_map.get(uniqueKey_file = this.getUniqueKey_file(data, uniqueFields))) == null || billDy_uniqueKeys.size() == 0 || billDy_uniqueKeys.isEmpty()) continue;
            if (billDy_uniqueKeys.size() == 1) {
                String sourceBillType = ((DynamicObject)billDy_uniqueKeys.get(0)).getString("sourcebilltype");
                if (!EmptyUtil.isNoEmpty((String)sourceBillType)) continue;
                this.doErrRows(rowdata, logger, ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u5355\u636e\u7684\u201c\u6e90\u5355\u7c7b\u578b\u201d\u503c\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\u66f4\u65b0\u3002", (String)"BaseImportService_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                continue;
            }
            this.doErrRows(rowdata, logger, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u552f\u4e00\u4e3b\u952e\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BaseImportService_15", (String)"fi-cas-formplugin", (Object[])new Object[]{billDy_uniqueKeys.stream().map(o -> o.getString("billno")).toString()}));
        }
    }

    public void checkNull(ImportBillData rowdata, ImportLogger logger, JSONObject data, String key, String title) throws Exception {
        Object value = data.get((Object)key);
        if (value == null) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
    }

    public void checkF7(ImportBillData rowdata, ImportLogger logger, JSONObject data, String key, String title, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)data.get((Object)key);
        if (required && value == null) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
            return;
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            data.put(key, (Object)value);
        }
    }

    public void checkEnum(ImportBillData rowdata, ImportLogger logger, JSONObject data, String key, String title, boolean required, String[] enums, String defaultValue) throws Exception {
        String value = (String)data.get((Object)key);
        if (required && value == null) {
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
            return;
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%1$s\u8f93\u5165\u503c%2$s\u4e0d\u5b58\u5728\u3002", (String)"BaseImportService_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), title, value));
                return;
            }
        }
        if (value == null && defaultValue != null) {
            data.put(key, (Object)defaultValue);
        }
    }

    public void checkOrg(List<ImportBillData> rowdatas, ImportLogger logger) throws Exception {
        if (this.orgDys == null || this.orgDys.size() == 0 || rowdatas.size() == 0) {
            return;
        }
        Set<Long> orgids = this.orgDys.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        this.checkOrgFinishInit(orgids, rowdatas, logger);
        this.addBaseCurrency(orgids, rowdatas);
        this.checkOpenOrg(rowdatas);
    }

    private void addBaseCurrency(Set<Long> orgids, List<ImportBillData> rowdatas) {
        Map orgId_inits = SystemStatusCtrolHelper.getSystemStatusCtrol(orgids);
        for (ImportBillData rowdata : rowdatas) {
            String id;
            DynamicObject orgId_init;
            JSONObject data;
            JSONObject values;
            if (this.isErrRow(rowdata) || !(values = (JSONObject)(data = rowdata.getData()).get((Object)"org")).containsKey((Object)"id") || (orgId_init = (DynamicObject)orgId_inits.get(id = values.getString("id"))) == null) continue;
            DynamicObject baseCurrency = orgId_init.getDynamicObject("standardcurrency");
            Long baseCurrencyId = Long.parseLong(baseCurrency.getString("id"));
            JSONObject jsonBaseCurrency = new JSONObject();
            jsonBaseCurrency.put("id", (Object)baseCurrencyId);
            jsonBaseCurrency.put("number", (Object)baseCurrency.getString("number"));
            data.put("basecurrency", (Object)jsonBaseCurrency);
        }
    }

    private void checkOrgFinishInit(Set<Long> orgids, List<ImportBillData> rowdatas, ImportLogger logger) {
        Map orgId_inits = SystemStatusCtrolHelper.getSystemStatusCtrol(orgids);
        String name_field = this.getFieldName("cas_recbill", true);
        String number_field = this.getFieldName("cas_recbill", false);
        String name_file_value = null;
        String number_file_value = null;
        for (ImportBillData rowdata : rowdatas) {
            if (this.isErrRow(rowdata)) continue;
            JSONObject data = rowdata.getData();
            JSONObject values = (JSONObject)data.get((Object)"org");
            name_file_value = values.getString(name_field);
            number_file_value = values.getString(number_field);
            if (!values.containsKey((Object)"id")) {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), "org"));
                continue;
            }
            String id = values.getString("id");
            DynamicObject orgId_init = (DynamicObject)orgId_inits.get(id);
            if (orgId_init == null) {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u4e14\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684%3$s\u3002", (String)"ImportHelper_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), name_file_value, number_file_value, "org"));
                continue;
            }
            DynamicObject startPeriod = orgId_init.getDynamicObject("startperiod");
            if (startPeriod != null) continue;
            this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u5bfc\u5165\u6570\u636e\u3002", (String)"BaseImportService_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), orgId_init.getString("name")));
        }
    }

    private DynamicObjectCollection getOrgRelation(Set<Long> orgids) {
        if (orgids == null || orgids.size() == 0) {
            return new DynamicObjectCollection();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("fromtype", "=", (Object)"10"), new QFilter("totype", "=", (Object)"08")};
        DynamicObject relation = QueryServiceHelper.queryOne((String)"bos_org_typerelation", (String)"id", (QFilter[])qFilters);
        DynamicObjectCollection relationCol = null;
        if (relation != null) {
            qFilters = new QFilter[]{new QFilter("typerelation", "=", relation.get("id")), new QFilter("toorg", "in", orgids)};
            relationCol = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg", (QFilter[])qFilters);
        }
        return relationCol;
    }

    private void checkOpenOrg(List<ImportBillData> rowdatas) {
        Set<Long> orgids = this.orgDys.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection dCollections = this.getOrgRelation(orgids);
        Map<Long, Boolean> openOrgsMap = this.orgDys.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getBoolean("fisaccounting")));
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            JSONObject openOrg = (JSONObject)data.get((Object)"openorg");
            JSONObject org_file = (JSONObject)data.get((Object)"org");
            Long orgid_file = 0L;
            if (org_file.containsKey((Object)"id")) {
                orgid_file = org_file.getLong("id");
            }
            if (orgid_file.compareTo(0L) == 0) {
                data.put("openorg", null);
                log.warn("orgid_file_is_null:{}.", (Object)org_file);
                continue;
            }
            if (openOrg == null || openOrg.isEmpty()) continue;
            HashSet<Long> setOrgIds = new HashSet<Long>(10);
            Boolean isOpenOrg = openOrgsMap.get(orgid_file);
            if (isOpenOrg != null && isOpenOrg.booleanValue()) {
                setOrgIds.add(orgid_file);
            }
            if (dCollections != null && !dCollections.isEmpty()) {
                for (DynamicObject obj : dCollections) {
                    setOrgIds.add(obj.getLong("fromorg"));
                }
            }
            QFilter idFilter = new QFilter("id", "in", setOrgIds);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            Map openOrgs = BaseDataServiceHelper.queryBaseDataFromCache((String)"bos_org", (Long)orgid_file, (QFilter)idFilter.and(enableFilter).and(statusFilter), (String)"id, name, number");
            if (openOrg.containsKey((Object)"number")) {
                String number = (String)openOrg.get((Object)"number");
                Set numberSet = openOrgs.values().stream().map(o -> o.getString("number")).collect(Collectors.toSet());
                if (numberSet.contains(number)) continue;
                data.put("openorg", null);
                log.warn("\u6838\u7b97\u7ec4\u7ec7{}\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (Object)number);
                continue;
            }
            if (openOrg.containsKey((Object)"name")) {
                String name = (String)openOrg.get((Object)"name");
                Set nameSet = openOrgs.values().stream().map(o -> o.getString("name")).collect(Collectors.toSet());
                if (!nameSet.contains(name)) {
                    data.put("openorg", null);
                    log.warn("\u6838\u7b97\u7ec4\u7ec7{}\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (Object)name);
                    continue;
                }
                openOrgs.values().forEach(o -> {
                    if (name.equals(o.getString("name"))) {
                        openOrg.put("number", (Object)o.getString("number"));
                        data.put("openorg", (Object)openOrg);
                    }
                });
                continue;
            }
            if (openOrg.containsKey((Object)"id")) {
                String id = String.valueOf(openOrg.get((Object)"id"));
                Set idSet = openOrgs.values().stream().map(o -> String.valueOf(o.getLong("id"))).collect(Collectors.toSet());
                if (!idSet.contains(id)) {
                    data.put("openorg", null);
                    log.warn("\u6838\u7b97\u7ec4\u7ec7{}\u8303\u56f4\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (Object)id);
                    continue;
                }
                openOrgs.values().forEach(o -> {
                    if (id.equals(String.valueOf(o.getLong("id")))) {
                        openOrg.put("number", (Object)o.getString("number"));
                        openOrg.put("name", (Object)o.getString("name"));
                        data.put("openorg", (Object)openOrg);
                    }
                });
                continue;
            }
            data.put("openorg", null);
        }
    }

    public void checkExchangeRate(List<ImportBillData> rowdatas, ImportLogger logger) throws Exception {
        if (rowdatas.size() == 0) {
            return;
        }
        DynamicObjectCollection currencys = this.loadBasedata(rowdatas, "currency", null, logger, false);
        DynamicObjectCollection baseCurrencys = this.loadBasedata(rowdatas, "basecurrency", null, logger, false);
        DynamicObjectCollection exratetables = this.loadBasedata(rowdatas, "exratetable", null, logger, false);
        Map<String, DynamicObject> currencys_map = currencys.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        Map<String, DynamicObject> baseCurrencys_map = baseCurrencys.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        Map<String, DynamicObject> exratetables_map = exratetables.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o));
        DynamicObject currency = null;
        DynamicObject baseCurrency = null;
        DynamicObject exratetable = null;
        for (ImportBillData rowdata : rowdatas) {
            String exratetable_id_file;
            String baseCurrency_id_file;
            String currency_id_file;
            JSONObject data = rowdata.getData();
            if (this.isErrRow(rowdata)) continue;
            JSONObject currency_file = (JSONObject)data.get((Object)"currency");
            JSONObject baseCurrency_file = (JSONObject)data.get((Object)"basecurrency");
            JSONObject exratetable_file = (JSONObject)data.get((Object)"exratetable");
            JSONObject org_file = (JSONObject)data.get((Object)"org");
            JSONObject basecurrency_file = (JSONObject)data.get((Object)"basecurrency");
            String string = currency_file == null ? "" : (currency_id_file = currency_file.containsKey((Object)"id") ? currency_file.getString("id") : null);
            String string2 = baseCurrency_file == null ? "" : (baseCurrency_id_file = baseCurrency_file.containsKey((Object)"id") ? baseCurrency_file.getString("id") : null);
            String string3 = exratetable_file == null ? "" : (exratetable_id_file = exratetable_file.containsKey((Object)"id") ? exratetable_file.getString("id") : null);
            Long org_id_file = org_file == null ? 0L : (org_file.containsKey((Object)"id") ? org_file.getLong("id") : 0L);
            Long basecurrency_id_file = basecurrency_file == null ? 0L : (basecurrency_file != null ? basecurrency_file.getLong("id") : 0L);
            if (currency_id_file != null) {
                currency = currencys_map.get(currency_id_file);
            }
            if (baseCurrency_id_file != null) {
                baseCurrency = baseCurrencys_map.get(baseCurrency_id_file);
            }
            if (exratetable_id_file != null) {
                exratetable = exratetables_map.get(exratetable_id_file);
            }
            if (currency != null && baseCurrency != null && currency.getString("id").equals(baseCurrency.getString("id"))) {
                data.put("exchangerate", (Object)"1");
                continue;
            }
            BigDecimal value = this.getBigDecimal(rowdata, "exchangerate", logger);
            if (value != null) continue;
            Date exratedate = DateUtils.getCurrentDate();
            Object exratedateobj = data.get((Object)"exratedate");
            Object bizDate = data.get((Object)"bizdate");
            if (exratedateobj != null) {
                exratedate = DateUtils.stringToDate((String)String.valueOf(exratedateobj), (String)"yyyy-MM-dd");
            } else if (bizDate != null) {
                exratedate = DateUtils.stringToDate((String)String.valueOf(bizDate), (String)"yyyy-MM-dd");
            }
            if (currency == null) continue;
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)currency.getLong("id"), (Long)basecurrency_id_file, (Long)org_id_file, (Date)exratedate, (Long)(exratetable == null ? 0L : exratetable.getLong("id")));
            data.put("exchangerate", (Object)exchangeRate.toPlainString());
        }
    }

    private BigDecimal getBigDecimal(ImportBillData rowdata, String key, ImportLogger logger) {
        JSONObject data = rowdata.getData();
        Object value = data.get((Object)key);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value != null) {
            try {
                return BigDecimal.valueOf(Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException nfe) {
                this.doErrRows(rowdata, logger, nfe.getMessage());
            }
        }
        return null;
    }

    private boolean checkOrgNull(JSONObject rowdata) {
        return rowdata == null;
    }

    private DynamicObjectCollection loadBasedata(List<ImportBillData> rowdatas, String key, String selectors, ImportLogger logger, boolean checkNull) {
        if (rowdatas.size() == 0) {
            return new DynamicObjectCollection();
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"cas_recbill");
        DynamicObjectCollection key_value_dys = this.loadBasedataByDt(dt, rowdatas, key, selectors, null);
        Map name_ids = key_value_dys.stream().collect(Collectors.groupingBy(e -> e.getString("name"), Collectors.mapping(o -> o.getLong("id"), Collectors.toSet())));
        Map<String, Long> number_ids = key_value_dys.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o.getLong("id")));
        BasedataProp property = (BasedataProp)EntityMetadataUtils.getProperty((MainEntityType)dt, (String)key);
        String basedataEntityKey = property.getBaseEntityId();
        BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)basedataEntityKey);
        String displayName = basedataEntityType.getDisplayName().getLocaleValue();
        String name_field = this.getFieldName(basedataEntityKey, true);
        String number_field = this.getFieldName(basedataEntityKey, false);
        String name_file_value = null;
        String number_file_value = null;
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data;
            JSONObject values;
            if (this.isErrRow(rowdata) || (values = (JSONObject)(data = rowdata.getData()).get((Object)key)) == null) continue;
            if (checkNull && this.checkOrgNull(values)) {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseImportService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), "org"));
                continue;
            }
            if (values.containsKey((Object)number_field) && values.containsKey((Object)name_field)) {
                number_file_value = values.getString(number_field);
                name_file_value = values.getString(name_field);
            } else if (values.containsKey((Object)number_field)) {
                number_file_value = values.getString(number_field);
            } else if (values.containsKey((Object)name_field)) {
                name_file_value = values.getString(name_field);
            } else {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u57fa\u7840\u8d44\u6599\u540d\u79f0\u5c5e\u6027\u548c\u7f16\u7801\u5c5e\u6027\u90fd\u4e3a\u7a7a\u3002", (String)"ImportHelper_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            Set id_names = name_ids.get(name_file_value);
            Long id_number = number_ids.get(number_file_value);
            if (name_file_value != null && number_file_value != null) {
                boolean is_all_null;
                boolean bl = is_all_null = id_names == null || id_number == null || !id_names.contains(id_number);
                if (is_all_null) {
                    this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u4e14\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684%3$s\u3002", (String)"ImportHelper_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), number_file_value, name_file_value, displayName));
                    continue;
                }
            } else if (number_file_value != null) {
                boolean is_number_null;
                boolean bl = is_number_null = id_number == null;
                if (is_number_null) {
                    this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"ImportHelper_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), number_file_value, displayName));
                    continue;
                }
            } else if (name_file_value != null) {
                boolean is_name_null;
                boolean bl = is_name_null = id_names == null;
                if (is_name_null) {
                    this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"ImportHelper_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), name_file_value, displayName));
                    continue;
                }
                if (id_names.size() > 1) {
                    this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5b58\u5728\u591a\u6761\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"ReceivingBillImportServiceNew_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), name_file_value, displayName));
                    continue;
                }
            } else {
                this.doErrRows(rowdata, logger, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u57fa\u7840\u8d44\u6599\u540d\u79f0\u5c5e\u6027\u548c\u7f16\u7801\u5c5e\u6027\u90fd\u4e3a\u7a7a\u3002", (String)"ImportHelper_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            values.put("id", (Object)id_number);
        }
        return key_value_dys;
    }

    private String getFieldName(String formid, boolean isName) {
        String field = "number";
        if ("bd_accountbanks".equals(formid)) {
            field = "bankaccountnumber";
        }
        if (isName) {
            field = "name";
        }
        return field;
    }

    private Set<String> getDataValus(List<ImportBillData> rowdatas, String key, String field) {
        HashSet<String> returns = new HashSet<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject values;
            JSONObject data = rowdata.getData();
            if (data == null || this.isErrRow(rowdata) || (values = (JSONObject)data.get((Object)key)) == null || !values.containsKey((Object)field)) continue;
            returns.add(values.getString(field));
        }
        return returns;
    }

    private Set<String> getDataValus(List<ImportBillData> rowdatas, String field) {
        HashSet<String> returns = new HashSet<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (data == null || this.isErrRow(rowdata) || !data.containsKey((Object)field)) continue;
            returns.add(data.getString(field));
        }
        return returns;
    }

    private Set<Long> getDataValusLong(List<ImportBillData> rowdatas, String field) {
        HashSet<Long> returns = new HashSet<Long>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (data == null || this.isErrRow(rowdata) || !data.containsKey((Object)field)) continue;
            returns.add(data.getLong(field));
        }
        return returns;
    }

    private DynamicObjectCollection loadBasedataByDt(MainEntityType dt, List<ImportBillData> rowdatas, String key, String selectors, QFilter addFilter) {
        BasedataProp property = (BasedataProp)EntityMetadataUtils.getProperty((MainEntityType)dt, (String)key);
        String basedataEntityKey = property.getBaseEntityId();
        BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)basedataEntityKey);
        String nameProperty = basedataEntityType.getNameProperty();
        String numberProperty = basedataEntityType.getNumberProperty();
        if (selectors == null) {
            selectors = String.join((CharSequence)",", "id", nameProperty + " as name", numberProperty + " as number");
        }
        String field_name = this.getFieldName(basedataEntityKey, true);
        String field_number = this.getFieldName(basedataEntityKey, false);
        Set<String> values_name = this.getDataValus(rowdatas, key, field_name);
        Set<String> values_num = this.getDataValus(rowdatas, key, field_number);
        return this.loadByNameOrNum(basedataEntityKey, selectors, nameProperty, numberProperty, values_name, values_num, addFilter);
    }

    private QFilter getFilterByNameOrNum(String nameField, String numField, Set<String> nameValues, Set<String> numValues, QFilter addFilter) {
        QFilter filter = null;
        if (nameValues != null && nameValues.size() > 0) {
            filter = new QFilter(nameField, "in", nameValues);
        }
        if (numValues != null && numValues.size() > 0) {
            QFilter _filter = new QFilter(numField, "in", numValues);
            QFilter qFilter = filter = filter == null ? _filter : filter.or(_filter);
        }
        if (addFilter != null) {
            filter = filter == null ? addFilter : filter.and(addFilter);
        }
        return filter;
    }

    private DynamicObjectCollection loadByNameOrNum(String formId, String selectors, String nameField, String numField, Set<String> nameValues, Set<String> numValues, QFilter addFilter) {
        QFilter filter = this.getFilterByNameOrNum(nameField, numField, nameValues, numValues, addFilter);
        log.info("loadByNameOrNum.filter:{}", (Object)(filter == null ? "null" : filter.toString()));
        if (!(nameValues != null && nameValues.size() != 0 || numValues != null && numValues.size() != 0)) {
            return new DynamicObjectCollection();
        }
        return this.getDyCollections(formId, selectors, filter);
    }

    private DynamicObjectCollection getDyCollections(String formId, String selectors, QFilter filter) {
        Map results = BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectors, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection returns = new DynamicObjectCollection();
        for (DynamicObject result : results.values()) {
            returns.add((Object)result);
        }
        return returns;
    }

    private <T> DynamicObjectCollection getQueryResults(String formId, String selectors, Set<T> values, String field, QFilter filter) {
        if (values == null || values.size() == 0) {
            return new DynamicObjectCollection();
        }
        QFilter _filter = new QFilter(field, "in", values);
        if (filter == null) {
            filter = _filter;
        } else {
            filter.and(_filter);
        }
        log.info("getQueryResults.field.filter:{}", (Object)filter.toString());
        return this.getDyCollections(formId, selectors, filter);
    }

    private Map<String, DynamicObjectCollection> getNeedQueryDys(List<ImportBillData> rowdatas, QFilter qFilter, boolean includeEntry) {
        HashMap<String, DynamicObjectCollection> returns = new HashMap<String, DynamicObjectCollection>(16);
        HashMap<String, Set<String>> needQueryNames = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> needQueryNums = new HashMap<String, Set<String>>(16);
        if (rowdatas == null || rowdatas.size() == 0) {
            return returns;
        }
        for (ImportBillData importBillData : rowdatas) {
            JSONObject data = importBillData.getData();
            if (this.isErrRow(importBillData)) continue;
            String payertype = data.getString("payertype");
            String payername = data.getString("payername");
            String payernumber = data.getString("payernumber");
            if ("other".equals(payertype)) continue;
            this.addNameOrNums(needQueryNames, payername, payertype);
            this.addNameOrNums(needQueryNums, payernumber, payertype);
        }
        for (Map.Entry entry : needQueryNames.entrySet()) {
            String type = (String)entry.getKey();
            Set name_values = (Set)entry.getValue();
            Set num_values = (Set)needQueryNums.get(type);
            String selects = "id,name,number,status,enable";
            if (includeEntry && AsstActTypeEnum.SUPPLIER.getValue().equals(type) || AsstActTypeEnum.CUSTOMER.getValue().equals(type)) {
                selects = selects + ",entry_bank.bankaccount,entry_bank.bank";
            }
            returns.put(type, this.loadByNameOrNum(type, selects, "name", "number", name_values, num_values, qFilter));
        }
        return returns;
    }

    public void removeErrRows(List<ImportBillData> rowdatas) {
        if (rowdatas.size() == 0 || this.errRows.size() == 0) {
            return;
        }
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData rowdata = it.next();
            int i = rowdata.getStartIndex();
            if (!this.errRows.contains(i)) continue;
            it.remove();
        }
    }
}

