/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importscheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IEntryOperate;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.BankStatementDownloadEdit;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.RecDecInitHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class BankStatementImportEdit
extends BillEditPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(BankStatementDownloadEdit.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SUB_ENTRY_ENTITY = "subentryentity";
    private static final String ENTRY_ENTITY1 = "entryentity1";
    private static final String IMPORT_SCHEME = "ankstaimpsche";
    private static String CACHE_BANKSTATEMENT_DATA = "bank_statement_cache";
    private static Map<String, String> ERROR_TIPS_VALUE;
    private static String[] dateFormat;
    private static final String[] TIME_FORMATER;
    private static final Date MAX_DATE;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"cancel", "distinguish", "prev", "import"});
        Toolbar toolbar = (Toolbar)this.getControl("advcontoolbarap");
        toolbar.addUploadListener((UploadListener)this);
        toolbar.addItemClickListener((ItemClickListener)this);
        this.initOrgF7();
        this.intAccountBankF7();
        this.fillCurrency();
    }

    private void initOrgF7() {
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("org");
        f7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List orgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cas_bankstatement", (String)"47156aff000000ac");
            showParameter.setCustomParam("range", (Object)orgList);
        });
    }

    private void intAccountBankF7() {
        BasedataEdit acctCtr = (BasedataEdit)this.getControl("accountbank");
        acctCtr.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getValue("org");
            QFilter usableAccountFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)(org != null ? org.getLong("id") : -99999L));
            ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
            Collections.addAll(qFilterArrayList, usableAccountFilter);
            qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            List ids = entryEntity.stream().map(c -> c.getLong("accountbank.id")).collect(Collectors.toList());
            qFilterArrayList.add(new QFilter("id", "not in", ids));
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setQFilters(qFilterArrayList);
        });
    }

    private void fillCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject accountCash = (DynamicObject)this.getModel().getValue("accountbank");
            if (accountCash != null) {
                Set currencys = AccountBankHelper.getCurrencyPks((long)accountCash.getLong("id"));
                qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        List attachInfos = evt.getAttachInfos();
        this.getPageCache().put("attachInfos", SerializationUtils.toJsonString((Object)attachInfos));
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        String callbackKey = evt.getCallbackKey();
        if ("upload_file".equals(callbackKey)) {
            Object[] urls = evt.getUrls();
            if (EmptyUtil.isEmpty((Object[])urls)) {
                return;
            }
            String jsonString = this.getPageCache().get("attachInfos");
            List attachInfos = SerializationUtils.fromJsonStringToList((String)jsonString, Map.class);
            for (Map map : attachInfos) {
                map.put("url", urls[0]);
                map.put("status", "success");
                map.put("creator", UserServiceHelper.getCurrentUserId());
                map.put("modifytime", System.currentTimeMillis());
            }
            String newAttacheName = (String)((Map)attachInfos.get(0)).get("name");
            AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
            List oldAttachInfos = panel.getAttachmentData();
            for (Map oldAttachInfo : oldAttachInfos) {
                String oldAttacheName = (String)oldAttachInfo.get("name");
                if (!oldAttacheName.equals(newAttacheName)) continue;
                panel.remove(oldAttachInfo);
            }
            panel.upload(attachInfos);
            this.getView().updateView("attachmentpanelap");
            Optional<Map> attachInfoOptional = panel.getAttachmentData().stream().filter(c -> newAttacheName.equals(c.get("name"))).findFirst();
            if (attachInfoOptional.isPresent()) {
                this.getModel().beginInit();
                DynamicObject[] importSchemes = this.findImportSchemes();
                HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
                paramMap.put("error_rows", new ArrayList(2));
                paramMap.put("success_rows", new ArrayList(2));
                paramMap.put("warn_rows", new ArrayList(2));
                this.recognizeExcel(importSchemes, attachInfoOptional.get(), paramMap);
                this.sortEntryEntity(paramMap);
                this.getModel().endInit();
                this.getView().updateView(ENTRY_ENTITY);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirm_close".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cancel": {
                this.previous();
                break;
            }
            case "distinguish": {
                this.distinguish();
                break;
            }
            case "prev": {
                this.previous();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("barnew".equals(actionId)) {
            Map callBackData = (Map)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isEmpty((Object)callBackData)) {
                return;
            }
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY1);
            this.setValue("accountbank1", callBackData.get("accountbank"), row);
            this.setValue("currency1", callBackData.get("currency"), row);
            this.setValue("init_balance1", callBackData.get("beginbalanceamt"), row);
            this.setValue("last_balance1", callBackData.get("endbalanceamt"), row);
            this.setValue("total_debitamount1", callBackData.get("debitamounttotal"), row);
            this.setValue("total_creditamount1", callBackData.get("creditamounttotal"), row);
            this.setValue("deal_count1", callBackData.get("countbalanceamt"), row);
            JSONObject jsonObject = this.getBankStatementPkIdCache();
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRY_ENTITY1, row);
            jsonObject.put(dynamicObject.getString("uid1"), callBackData.get("addKey"));
            this.setBankStatementPkIdCache(jsonObject.toJSONString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("import".equals(operateKey) && args.getOperationResult().isSuccess()) {
            if (this.validateBankStament()) {
                return;
            }
            try (TXHandle tx = TX.required();){
                try {
                    this.importBankStatement();
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            this.next();
        } else if ("select_edit".equals(operateKey)) {
            this.showBillEdit();
        }
    }

    private boolean validateBankStament() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
            Optional<DynamicObject> dyObjectOptional = collection.stream().filter(c -> CasHelper.isEmpty((Object)c.getBigDecimal("debitamount")) && CasHelper.isEmpty((Object)c.getBigDecimal("creditamount"))).findFirst();
            if (!dyObjectOptional.isPresent()) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u6587\u4ef6\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BankStatementImportEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
            return true;
        }
        return false;
    }

    private void importBankStatement() {
        int failcount = 0;
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        JSONObject jsonObject = this.getBankStatementPkIdCache();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if ("-1".equals(dynamicObject.getString("error_level"))) {
                dynamicObject.set("init_balance", null);
                dynamicObject.set("last_balance", null);
                dynamicObject.set("total_debitamount", null);
                dynamicObject.set("total_creditamount", null);
                dynamicObject.set("deal_count", null);
                this.createImportResultEntry(dynamicObject);
                ++failcount;
                continue;
            }
            DynamicObject bankstatementImportScheme = dynamicObject.getDynamicObject(IMPORT_SCHEME);
            String uniqueFiled = bankstatementImportScheme.getString("uniquefiled");
            List<Object> successPkIds = new ArrayList(2);
            logger.info("begin insert/update bankstatement : {}", (Object)uniqueFiled);
            if (StringUtils.isBlank((CharSequence)uniqueFiled)) {
                successPkIds = this.insertBankStatements(dynamicObject);
            } else {
                String[] uniqueFileds = uniqueFiled.split(",");
                List uniqueFiledList = Arrays.stream(uniqueFileds).filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(uniqueFiledList)) {
                    successPkIds = this.insertBankStatements(dynamicObject);
                } else {
                    DynamicObjectCollection subEntryEntity = dynamicObject.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
                    List sortNoList = subEntryEntity.stream().map(o -> o.getLong("sortno")).filter(c -> c != 0L).collect(Collectors.toList());
                    boolean needReSort = sortNoList.size() < 1;
                    long count = 0L;
                    for (DynamicObject entity : subEntryEntity) {
                        QFilter qFilter = new QFilter("1", "=", (Object)1);
                        uniqueFiledList.stream().forEach(property -> {
                            if ("accountbank".equals(property)) {
                                qFilter.and("accountbank", "=", (Object)dynamicObject.getDynamicObject("accountbank").getLong("id"));
                            } else if ("currency".equals(property)) {
                                qFilter.and("currency", "=", (Object)dynamicObject.getDynamicObject("currency").getLong("id"));
                            } else {
                                qFilter.and(property, "=", entity.get(property));
                            }
                        });
                        DynamicObject[] bankStatements = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        Object[] pkIds = (Long[])Arrays.stream(bankStatements).map(c -> c.getLong("id")).toArray(Long[]::new);
                        for (DynamicObject bankStatement : bankStatements = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement"))) {
                            bankStatement.set("accountbank", (Object)dynamicObject.getDynamicObject("accountbank").getLong("id"));
                            bankStatement.set("currency", (Object)dynamicObject.getDynamicObject("currency").getLong("id"));
                            bankStatement.set("org", (Object)dynamicObject.getDynamicObject("org").getLong("id"));
                            bankStatement.set("bizdate", entity.get("bizdate"));
                            bankStatement.set("description", entity.get("description"));
                            bankStatement.set("debitamount", entity.get("debitamount"));
                            bankStatement.set("creditamount", entity.get("creditamount"));
                            bankStatement.set("balanceamt", entity.get("balanceamt"));
                            bankStatement.set("oppunit", entity.get("oppunitname"));
                            bankStatement.set("oppbank", entity.get("oppbank"));
                            bankStatement.set("oppaccountnumber", entity.get("oppaccountnumber"));
                            bankStatement.set("settlementnumber", entity.get("settlementnumber"));
                            bankStatement.set("bankcheckflag", entity.get("bankcheckflag"));
                            bankStatement.set("bankvouvherno", entity.get("bankvouvherno"));
                            bankStatement.set("sortno", needReSort ? Long.valueOf(new Timestamp(System.currentTimeMillis()).getTime() * 100000L + count++ % 100000L) : entity.get("sortno"));
                            bankStatement.set("cashier", entity.get("cashier"));
                            bankStatement.set("tradenumber", entity.get("tradenumber"));
                            bankStatement.set("bankdetailno", entity.get("bankdetailno"));
                            bankStatement.set("ratesdate", entity.get("ratesdate"));
                            bankStatement.set("transtime", entity.get("transtime"));
                        }
                        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])bankStatements, (OperateType)OperateType.DELETE);
                        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])bankStatements, (OperateType)OperateType.ADD);
                        SaveServiceHelper.save((DynamicObject[])bankStatements);
                        successPkIds.addAll(Arrays.asList(pkIds));
                    }
                }
            }
            jsonObject.put(dynamicObject.getString("uid"), (Object)StringUtils.join(successPkIds, (String)","));
            this.createImportResultEntry(dynamicObject);
        }
        this.setBankStatementPkIdCache(jsonObject.toJSONString());
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY1);
        Label label = (Label)this.getView().getControl("labelap");
        label.setText(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff1a%1$s\uff0c\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002", (String)"BankStatementImportEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), entryEntity.size() - failcount, failcount));
    }

    private List<Object> insertBankStatements(DynamicObject dynamicObject) {
        DynamicObject bankStatementManual = this.createBankStatementManual(dynamicObject);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isModify", null);
        option.setVariableValue("add", null);
        option.setVariableValue("source", "3");
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"b_save", (String)"cas_bankstatement_manual", (DynamicObject[])new DynamicObject[]{bankStatementManual}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
        }
        List successPkIds = operationResult.getSuccessPkIds();
        return successPkIds;
    }

    private void createImportResultEntry(DynamicObject dynamicObject) {
        int row = this.getModel().createNewEntryRow(ENTRY_ENTITY1);
        this.setValue("uid1", dynamicObject.getString("uid"), row);
        this.setValue("org1", dynamicObject.get("org"), row);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY1);
        List items = entryGrid.getItems();
        for (Control item : items) {
            if (item instanceof OperationColumn) continue;
            String entryEntityKey = item.getKey().substring(0, item.getKey().length() - 1);
            this.setValue(item.getKey(), dynamicObject.get(entryEntityKey), row);
        }
        if ("-1".equals(dynamicObject.getString("error_level"))) {
            ArrayList<String> hideColums = new ArrayList<String>(1);
            hideColums.add("select_edit");
            entryGrid.hideOperateItems("operationcolumnap", row, hideColums);
        }
    }

    private DynamicObject createBankStatementManual(DynamicObject dynamicObject) {
        DynamicObject bankStatementManual = BusinessDataServiceHelper.newDynamicObject((String)"cas_bankstatement_manual");
        bankStatementManual.set("sourcebilltype", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355", (String)"BankStatementImportEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        bankStatementManual.set("org", dynamicObject.get("org"));
        bankStatementManual.set("accountbank", dynamicObject.get("accountbank"));
        bankStatementManual.set("currency", dynamicObject.get("currency"));
        bankStatementManual.set("beginbalanceamt", dynamicObject.get("init_balance"));
        bankStatementManual.set("debitamounttotal", dynamicObject.get("total_debitamount"));
        bankStatementManual.set("creditamounttotal", dynamicObject.get("total_creditamount"));
        bankStatementManual.set("countbalanceamt", dynamicObject.get("deal_count"));
        bankStatementManual.set("endbalanceamt", dynamicObject.get("last_balance"));
        DynamicObjectCollection subEntryEntity = dynamicObject.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
        bankStatementManual.set(ENTRY_ENTITY, (Object)subEntryEntity);
        return bankStatementManual;
    }

    private void showBillEdit() {
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("formid", "cas_bankstatementimp");
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRY_ENTITY1, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY1));
        customParams.put("data", (String)dynamicObject);
        customParams.put("addKey", this.getBankStatementPkIdCache().getString(dynamicObject.getString("uid1")));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cas_bankstatement_manual");
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barnew"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void cancel() {
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachInfos = panel.getAttachmentData();
        if (!EmptyUtil.isEmpty((Collection)attachInfos)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u6709\u4e0a\u4f20\u7684\u6587\u4ef6\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"BankStatementImportEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm_close", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        ChangeData[] changeData = e.getChangeSet();
        switch (propertyName = e.getProperty().getName()) {
            case "accountbank": {
                this.accountCashChanged();
                break;
            }
            case "org": {
                this.orgChanged();
                break;
            }
            case "ankstaimpsche": {
                this.importSchemeChanged(changeData[0]);
                break;
            }
            case "currency": {
                this.currencyChanged(changeData[0]);
            }
        }
    }

    private void currencyChanged(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        DynamicObject currentRow = changeData.getDataEntity();
        DynamicObjectCollection collection = currentRow.getDynamicObjectCollection(SUB_ENTRY_ENTITY);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue("currency2", newValue, i, changeData.getRowIndex());
        }
    }

    private void importSchemeChanged(ChangeData changeData) {
        DynamicObject[] dynamicObjectArray;
        Object newValue = changeData.getNewValue();
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachInfos = panel.getAttachmentData();
        String uid = (String)this.getValue("uid");
        Map attachInfo = null;
        for (Map attach : attachInfos) {
            if (!uid.equals(attach.get("uid"))) continue;
            attachInfo = attach;
            break;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("error_rows", new ArrayList(1));
        paramMap.put("success_rows", new ArrayList(1));
        paramMap.put("warn_rows", new ArrayList(1));
        paramMap.put("operateKey", "update");
        this.setValue("begin_date", null, changeData.getRowIndex());
        this.setValue("end_date", null, changeData.getRowIndex());
        this.setValue("init_balance", null, changeData.getRowIndex());
        this.setValue("last_balance", null, changeData.getRowIndex());
        this.setValue("total_debitamount", null, changeData.getRowIndex());
        this.setValue("total_creditamount", null, changeData.getRowIndex());
        this.setValue("deal_count", null, changeData.getRowIndex());
        this.getModel().deleteEntryData(SUB_ENTRY_ENTITY);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, changeData.getRowIndex());
        entryRowEntity.set(SUB_ENTRY_ENTITY, null);
        if (EmptyUtil.isEmpty((Object)newValue)) {
            dynamicObjectArray = new DynamicObject[]{};
        } else {
            DynamicObject[] dynamicObjectArray2 = new DynamicObject[1];
            dynamicObjectArray = dynamicObjectArray2;
            dynamicObjectArray2[0] = (DynamicObject)newValue;
        }
        DynamicObject[] importSchemes = dynamicObjectArray;
        this.recognizeExcel(importSchemes, attachInfo, paramMap);
    }

    public void distinguish() {
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachInfos = panel.getAttachmentData();
        if (EmptyUtil.isEmpty((Collection)attachInfos)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e0a\u4f20\u5bf9\u8d26\u5355\u6587\u4ef6\u3002", (String)"BankStatementImportEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.recognize(attachInfos);
        this.next();
    }

    private void recognize(List<Map<String, Object>> attachInfos) {
        this.delNoFileEntry(attachInfos);
        DynamicObject[] importSchemes = this.findImportSchemes();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        paramMap.put("error_rows", new ArrayList(2));
        paramMap.put("success_rows", new ArrayList(2));
        paramMap.put("warn_rows", new ArrayList(2));
        for (Map<String, Object> attachInfo : attachInfos) {
            this.getModel().beginInit();
            String uid = (String)attachInfo.get("uid");
            Optional<DynamicObject> attachOptional = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(c -> uid.equals(c.getString("uid"))).findFirst();
            if (attachOptional.isPresent()) continue;
            this.recognizeExcel(importSchemes, attachInfo, paramMap);
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
        this.getModel().beginInit();
        this.sortEntryEntity(paramMap);
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void sortEntryEntity(Map<String, Object> paramMap) {
        List errorRows = (List)paramMap.get("error_rows");
        List successRows = (List)paramMap.get("success_rows");
        List warnRows = (List)paramMap.get("warn_rows");
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (errorRows.size() == entryRowCount || successRows.size() == entryRowCount || warnRows.size() == entryRowCount) {
            return;
        }
        if (!(CollectionUtils.isEmpty((Collection)errorRows) || CollectionUtils.isEmpty((Collection)successRows) || CollectionUtils.isEmpty((Collection)warnRows))) {
            this.getModel().setEntryRowTop(ENTRY_ENTITY, errorRows.stream().mapToInt(Integer::valueOf).toArray());
            this.getModel().setEntryRowBottom(ENTRY_ENTITY, successRows.stream().mapToInt(Integer::valueOf).toArray());
        } else if (!CollectionUtils.isEmpty((Collection)errorRows) && (CollectionUtils.isEmpty((Collection)successRows) || CollectionUtils.isEmpty((Collection)warnRows))) {
            this.getModel().setEntryRowTop(ENTRY_ENTITY, errorRows.stream().mapToInt(Integer::valueOf).toArray());
        } else if (CollectionUtils.isEmpty((Collection)errorRows) && !CollectionUtils.isEmpty((Collection)successRows) && !CollectionUtils.isEmpty((Collection)warnRows)) {
            this.getModel().setEntryRowTop(ENTRY_ENTITY, warnRows.stream().mapToInt(Integer::valueOf).toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void recognizeExcel(final DynamicObject[] importSchemes, Map<String, Object> attachInfo, Map<String, Object> paramMap) {
        block31: {
            accountbank = new DynamicObject[1];
            importSchemeObj = new DynamicObject[1];
            errorLevel = null;
            errorTips = this.getMsgSuccess();
            tipsContainer = new String[]{null};
            isAllExist = new boolean[]{false};
            bankStatementExists = new boolean[]{false};
            importSchemePropertyMap = new HashMap<DynamicObject, HashMap<K, V>>(2);
            importSchemeMap = new HashMap<DynamicObject, DynamicObject>(2);
            importSchemeSet2 = new HashSet<DynamicObject>(2);
            operateKey = (String)paramMap.get("operateKey");
            cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                inputStream = cache.getInputStream((String)attachInfo.get("url"));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"BankStatementImportEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            row = "update".equals(operateKey) != false ? this.getModel().getEntryCurrentRowIndex("entryentity") : this.getModel().createNewEntryRow("entryentity");
            entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("entryentity", row);
            fileName = (String)attachInfo.get("name");
            if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)"xls")) ** GOTO lbl101
            result = this.recognizeXls(inputStream);
            if (result != null) break block31;
            this.fillErrorInfo(attachInfo, errorTips, errorLevel, row);
            this.fillErrorRowIndexMap(paramMap, errorLevel, row);
            return;
        }
        try {
            block32: {
                count = 1;
                for (i = 0; i < result.size(); ++i) {
                    mapData = result.get(i);
                    valueOptional = mapData.values().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recognizeExcel$13(java.lang.String ), (Ljava/lang/String;)Z)()).findFirst();
                    if (!valueOptional.isPresent()) continue;
                    rowData = new ArrayList<String>(mapData.values());
                    isDataRow = true;
                    for (DynamicObject importScheme : importSchemes) {
                        locationinfile = importScheme.getString("locationinfile");
                        split = locationinfile.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                        rowNum = Integer.parseInt(split[1]) - 1;
                        columnNum = this.transToNumber(split[0]);
                        if (rowNum == i && !EmptyUtil.isEmpty((String)mapData.get(columnNum))) {
                            bankAccountNo = mapData.get(columnNum);
                            bankFilter = new QFilter("bankaccountnumber", "=", (Object)bankAccountNo);
                            appId = this.getView().getFormShowParameter().getAppId();
                            appId = EmptyUtil.isNotEmpty((String)appId) != false ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                            orgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankstatement", (String)"47156aff000000ac");
                            bankFilter.and("company.id", "in", (Object)orgList);
                            bankFilter.and("isvirtual", "=", (Object)"0");
                            bankAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,company,currency, openorg", (QFilter[])new QFilter[]{bankFilter});
                            bankAccount = this.getBankAccount(bankAccountNo, orgList, bankAccount);
                            if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
                                if (bankAccount.getString("bank.id").equals(importScheme.getString("bank.id"))) {
                                    importSchemeMap.put(importScheme, bankAccount);
                                } else {
                                    importSchemeMap.put(null, bankAccount);
                                }
                            }
                        }
                        entryentity = importScheme.getDynamicObjectCollection("entryentity");
                        isAllExists = true;
                        for (DynamicObject fieldSetting : entryentity) {
                            if (!fieldSetting.getBoolean("mustrecord") || rowData.contains(fieldSetting.getString("columnname"))) continue;
                            isAllExists = false;
                            break;
                        }
                        if (!isAllExists) continue;
                        importSchemeSet2.add(importScheme);
                        isDataRow = false;
                        propertyMap = new HashMap<String, Integer>(2);
                        for (DynamicObject fieldSetting : entryentity) {
                            for (Map.Entry<Integer, String> entry : mapData.entrySet()) {
                                if (!fieldSetting.getString("columnname").equals(entry.getValue())) continue;
                                propertyMap.put(fieldSetting.getString("billfield"), entry.getKey());
                            }
                        }
                        importSchemePropertyMap.put(importScheme, propertyMap);
                    }
                    for (Map.Entry entry : importSchemeMap.entrySet()) {
                        accountbank[0] = (DynamicObject)entry.getValue();
                        if (EmptyUtil.isEmpty((DynamicObject)((DynamicObject)entry.getKey()))) continue;
                        importSchemeObj[0] = (DynamicObject)entry.getKey();
                        importSchemeOptional = importSchemeSet2.stream().filter((Predicate<DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recognizeExcel$14(java.util.Map$Entry kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Z)((Map.Entry)entry)).findFirst();
                        if (!importSchemeOptional.isPresent()) continue;
                        isAllExist[0] = true;
                    }
                    if (!isAllExist[0]) continue;
                    this.validateBankStatement(mapData, (Map)importSchemePropertyMap.get(importSchemeObj[0]), bankStatementExists, importSchemeObj, accountbank[0]);
                    if (!isDataRow) continue;
                    try {
                        this.createSubEntryEntity(mapData, (IEntryOperate)entryOperate, row, importSchemeObj[0], (Map)importSchemePropertyMap.get(importSchemeObj[0]), count++, accountbank[0]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        tipsContainer[0] = e.getMessage();
                    }
                }
                break block32;
lbl101:
                // 1 sources

                excelReader = new ExcelReader();
                excelReader.read(inputStream, new SheetHandler((IEntryOperate)entryOperate, row, tipsContainer){
                    int count = 1;
                    final /* synthetic */ IEntryOperate val$entryOperate;
                    final /* synthetic */ int val$row;
                    final /* synthetic */ String[] val$tipsContainer;
                    {
                        this.val$entryOperate = iEntryOperate;
                        this.val$row = n;
                        this.val$tipsContainer = stringArray;
                    }

                    public void handleRow(SheetHandler.ParsedRow parsedRow) {
                        Map mapData = parsedRow.getData();
                        if (mapData.size() == 0) {
                            return;
                        }
                        ArrayList rowData = new ArrayList(mapData.values());
                        boolean isDataRow = true;
                        for (DynamicObject importScheme : importSchemes) {
                            String locationinfile = importScheme.getString("locationinfile");
                            String[] split = locationinfile.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                            int rowNum = Integer.parseInt(split[1]) - 1;
                            int columnNum = BankStatementImportEdit.this.transToNumber(split[0]);
                            if (rowNum == parsedRow.getRowNum() && !EmptyUtil.isEmpty((String)((String)mapData.get(columnNum)))) {
                                String bankAccountNo = (String)mapData.get(columnNum);
                                QFilter bankFilter = new QFilter("bankaccountnumber", "=", (Object)bankAccountNo);
                                List orgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cas_bankstatement", (String)"47156aff000000ac");
                                bankFilter.and("company.id", "in", (Object)orgList);
                                bankFilter.and("isvirtual", "=", (Object)"0");
                                Iterator bankAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,company,currency,openorg", (QFilter[])new QFilter[]{bankFilter});
                                bankAccount = BankStatementImportEdit.this.getBankAccount(bankAccountNo, orgList, (DynamicObject)bankAccount);
                                if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
                                    if (bankAccount.getString("bank.id").equals(importScheme.getString("bank.id"))) {
                                        importSchemeMap.put(importScheme, bankAccount);
                                    } else {
                                        importSchemeMap.put(null, bankAccount);
                                    }
                                }
                            }
                            DynamicObjectCollection entryentity = importScheme.getDynamicObjectCollection(BankStatementImportEdit.ENTRY_ENTITY);
                            boolean isAllExists = true;
                            for (DynamicObject fieldSetting : entryentity) {
                                if (!fieldSetting.getBoolean("mustrecord") || rowData.contains(fieldSetting.getString("columnname"))) continue;
                                isAllExists = false;
                                break;
                            }
                            if (!isAllExists) continue;
                            importSchemeSet2.add(importScheme);
                            isDataRow = false;
                            HashMap propertyMap = new HashMap(2);
                            for (DynamicObject fieldSetting : entryentity) {
                                for (Map.Entry entry : mapData.entrySet()) {
                                    if (!fieldSetting.getString("columnname").equals(entry.getValue())) continue;
                                    propertyMap.put(fieldSetting.getString("billfield"), entry.getKey());
                                }
                            }
                            importSchemePropertyMap.put(importScheme, propertyMap);
                        }
                        for (Map.Entry entry : importSchemeMap.entrySet()) {
                            accountbank[0] = (DynamicObject)entry.getValue();
                            if (EmptyUtil.isEmpty((DynamicObject)((DynamicObject)entry.getKey()))) continue;
                            importSchemeObj[0] = (DynamicObject)entry.getKey();
                            Optional<DynamicObject> importSchemeOptional = importSchemeSet2.stream().filter(c -> c.getString("id").equals(((DynamicObject)entry.getKey()).getString("id"))).findFirst();
                            if (!importSchemeOptional.isPresent()) continue;
                            isAllExist[0] = true;
                        }
                        if (!isAllExist[0]) {
                            return;
                        }
                        BankStatementImportEdit.this.validateBankStatement(mapData, (Map)importSchemePropertyMap.get(importSchemeObj[0]), bankStatementExists, importSchemeObj, accountbank[0]);
                        if (isDataRow) {
                            try {
                                BankStatementImportEdit.this.createSubEntryEntity(mapData, this.val$entryOperate, this.val$row, importSchemeObj[0], (Map)importSchemePropertyMap.get(importSchemeObj[0]), this.count++, accountbank[0]);
                            }
                            catch (RuntimeException e) {
                                this.val$tipsContainer[0] = e.getMessage();
                            }
                        }
                    }
                });
            }
            this.getView().updateView("subentryentity");
            if (!"update".equals(operateKey)) {
                if (EmptyUtil.isNoEmpty((DynamicObject)accountbank[0])) {
                    entryentity = this.getModel().getEntryEntity("entryentity");
                    accountId = accountbank[0].getPkValue() + "";
                    paymentBankRecord = entryentity.stream().filter((Predicate<DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recognizeExcel$15(java.lang.String kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Z)((String)accountId)).findFirst();
                    if (paymentBankRecord.isPresent()) {
                        errorTips = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u4e00\u94f6\u884c\u8d26\u53f7\u91cd\u590d\u8bc6\u522b", (String)"BankStatementImportEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    }
                    this.setValue("org", accountbank[0].getDynamicObject("company"), row);
                    this.setValue("accountbank", accountbank[0], row);
                    currencyCollect = accountbank[0].getDynamicObjectCollection("currency");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencyCollect) && currencyCollect.size() > 0) {
                        this.setValue("currency", ((DynamicObject)currencyCollect.get(0)).getDynamicObject("fbasedataid"), row);
                    }
                }
                this.setValue("ankstaimpsche", importSchemeObj[0], row);
            }
            if (this.getMsgSuccess().equals(errorTips) && EmptyUtil.isEmpty((DynamicObject)importSchemeObj[0])) {
                errorTips = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bfc\u5165\u65b9\u6848\u3002", (String)"BankStatementImportEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (this.getMsgSuccess().equals(errorTips) && !isAllExist[0]) {
                errorTips = ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u4e0e\u5bfc\u5165\u6587\u4ef6\u4e0d\u5339\u914d\u3002", (String)"BankStatementImportEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (this.getMsgSuccess().equals(errorTips) && (count = importSchemeSet2.stream().filter((Predicate<DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recognizeExcel$16(java.util.Map kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Z)(importSchemeMap)).count()) > 1L) {
                importSchemeObj[0] = null;
                this.setValue("ankstaimpsche", null, row);
                errorTips = ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u5bfc\u5165\u65b9\u6848\uff0c\u8bf7\u9009\u62e9", (String)"BankStatementImportEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (this.getMsgSuccess().equals(errorTips) && StringUtils.isNotBlank((CharSequence)tipsContainer[0])) {
                errorTips = tipsContainer[0];
            }
            if (this.getMsgSuccess().equals(errorTips) && this.getModel().getEntryRowCount("subentryentity") > 0) {
                firstRowData = this.getModel().getEntryRowEntity("subentryentity", 0, row);
                firstRowDate = firstRowData.getDate("bizdate");
                if (this.getMsgSuccess().equals(errorTips) && EmptyUtil.isEmpty((Object)firstRowDate)) {
                    errorTips = ResManager.loadKDString((String)"\u65e5\u671f/\u65f6\u95f4\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5", (String)"BankStatementImportEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                if (this.getMsgSuccess().equals(errorTips) && bankStatementExists[0] && EmptyUtil.isEmpty((String)importSchemeObj[0].getString("uniquefiled"))) {
                    errorTips = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u671f\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"BankStatementImportEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                errorTips = this.fillBalanceAmount(errorTips, row, firstRowData, firstRowDate);
            }
            if (this.getMsgSuccess().equals(errorTips) && this.getModel().getEntryRowCount("subentryentity") < 1) {
                errorTips = ResManager.loadKDString((String)"\u6587\u4ef6\u6570\u636e\u672a\u89e3\u6790\u3002", (String)"BankStatementImportEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            errorLevel = BankStatementImportEdit.ERROR_TIPS_VALUE.get(errorTips);
            this.fillErrorInfo(attachInfo, errorTips, errorLevel, row);
            this.fillErrorRowIndexMap(paramMap, errorLevel, row);
        }
        catch (Exception e) {
            try {
                BankStatementImportEdit.logger.error("Recognize Excel Error", (Throwable)e);
                errorLevel = "-1";
                errorTips = ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u3002", (String)"BankStatementImportEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.fillErrorInfo(attachInfo, errorTips, errorLevel, row);
                this.fillErrorRowIndexMap(paramMap, errorLevel, row);
            }
            catch (Throwable var43_54) {
                this.fillErrorInfo(attachInfo, errorTips, errorLevel, row);
                this.fillErrorRowIndexMap(paramMap, errorLevel, row);
                throw var43_54;
            }
        }
    }

    private DynamicObject getBankAccount(String bankAccountNo, List<Long> orgList, DynamicObject bankAccount) {
        if (bankAccount == null || EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            String bankAccountNoTrim = bankAccountNo.replaceAll("\\s*", "");
            QFilter filter = new QFilter("bankaccountnumber", "=", (Object)bankAccountNoTrim);
            filter.and("company.id", "in", orgList);
            filter.and("isvirtual", "=", (Object)"0");
            bankAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,company,currency, openorg", (QFilter[])new QFilter[]{filter});
        }
        return bankAccount;
    }

    private List<Map<Integer, String>> recognizeXls(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        int startRow = 0;
        int lastRowNum = sheet.getLastRowNum();
        ArrayList<Map<Integer, String>> result = new ArrayList<Map<Integer, String>>(lastRowNum);
        for (int rowNum = startRow; rowNum <= lastRowNum; ++rowNum) {
            Row rowLine = sheet.getRow(rowNum);
            if (rowLine == null) {
                result.add(Collections.emptyMap());
                continue;
            }
            int firstCellNum = rowLine.getFirstCellNum();
            short lastCellNum = rowLine.getLastCellNum();
            if (lastCellNum == 0) continue;
            HashMap<Integer, String> mapData = new HashMap<Integer, String>();
            for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                Cell cell = rowLine.getCell(cellNum);
                if (cell == null) {
                    mapData.put(cellNum, null);
                    continue;
                }
                CellType cellType = cell.getCellType();
                if (CellType.NUMERIC.equals((Object)cellType) || CellType.FORMULA.equals((Object)cellType)) {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date dateCellValue = cell.getDateCellValue();
                        mapData.put(cellNum, DateFormatUtils.format((Date)dateCellValue, (String)"yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    mapData.put(cellNum, BigDecimal.valueOf(cell.getNumericCellValue()).toString());
                    continue;
                }
                mapData.put(cellNum, StringUtils.trim((String)cell.getStringCellValue()));
            }
            result.add(mapData);
        }
        return result;
    }

    private void fillErrorInfo(Map<String, Object> attachInfo, String errorTips, String errorLevel, int row) {
        this.setValue("error_level", errorLevel, row);
        this.setValue("error_tips", errorTips, row);
        this.setValue("file_name", attachInfo.get("name"), row);
        this.setValue("uid", attachInfo.get("uid"), row);
    }

    public Date stringToDate(String datestr) {
        Date date = null;
        if (EmptyUtil.isEmpty((String)datestr)) {
            return date;
        }
        String[] arr = datestr.split("\\s+");
        try {
            date = EmptyUtil.isEmpty((String)arr[0]) ? null : org.apache.commons.lang3.time.DateUtils.parseDate((String)arr[0], (String[])dateFormat);
        }
        catch (ParseException e) {
            logger.error("Error date format", (Throwable)e);
        }
        return date;
    }

    private void validateBankStatement(Map<Integer, String> mapData, Map<String, Integer> propertyMap, boolean[] bankStatementExists, DynamicObject[] importSchemeObj, DynamicObject accountbank) {
        Date bizdate = this.stringToDate(mapData.get(propertyMap.get("bizdate")));
        if (!(bankStatementExists[0] || !EmptyUtil.isNoEmpty((Object)bizdate) || EmptyUtil.isEmpty((DynamicObject)importSchemeObj[0]) || !EmptyUtil.isEmpty((String)importSchemeObj[0].getString("uniquefiled")) || EmptyUtil.isEmpty((String)mapData.get(propertyMap.get("debitamount"))) && EmptyUtil.isEmpty((String)mapData.get(propertyMap.get("creditamount"))))) {
            QFilter bankStatementFilter = new QFilter("bizdate", "=", (Object)bizdate);
            bankStatementFilter.and("accountbank", "=", (Object)accountbank.getLong("id"));
            bankStatementExists[0] = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])new QFilter[]{bankStatementFilter});
        }
    }

    private void createSubEntryEntity(Map<Integer, String> mapData, IEntryOperate entryOperate, int row, DynamicObject importScheme, Map<String, Integer> propertyMap, int count, DynamicObject accountbank) {
        String transtime;
        BigDecimal debitamount = this.getBigDecimal(mapData, propertyMap, "debitamount");
        BigDecimal creditamount = this.getBigDecimal(mapData, propertyMap, "creditamount");
        Date bizdate = this.stringToDate(mapData.get(propertyMap.get("bizdate")));
        DynamicObject currency = null;
        DynamicObjectCollection currencyCollect = accountbank.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencyCollect) && currencyCollect.size() > 0) {
            currency = ((DynamicObject)currencyCollect.get(0)).getDynamicObject("fbasedataid");
        }
        int subRow = entryOperate.createNewEntryRow(SUB_ENTRY_ENTITY);
        this.getModel().setValue("bizdate", (Object)bizdate, subRow, row);
        this.getModel().setValue("description", (Object)mapData.get(propertyMap.get("description")), subRow, row);
        this.getModel().setValue("currency2", (Object)currency, subRow, row);
        BigDecimal balanceamt = this.getBigDecimal(mapData, propertyMap, "balanceamt");
        if (debitamount == null && creditamount == null) {
            String msg = ResManager.loadKDString((String)"\u91d1\u989d\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5", (String)"BankStatementImportEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            throw new RuntimeException(msg);
        }
        if (propertyMap.get("debitamount").equals(propertyMap.get("creditamount"))) {
            DynamicObjectCollection fieldEntrys = importScheme.getDynamicObjectCollection(ENTRY_ENTITY);
            Optional<DynamicObject> fieldEntryOptional = fieldEntrys.stream().filter(c -> "debitamount".equals(c.getString("billfield"))).findFirst();
            DynamicObject fieldEntry = fieldEntryOptional.get();
            int number = fieldEntry.getInt("fieldrule.number");
            if (number > 0) {
                if (debitamount.compareTo(BigDecimal.ZERO) >= 0) {
                    this.getModel().setValue("debitamount", (Object)debitamount, subRow, row);
                    this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO, subRow, row);
                } else {
                    this.getModel().setValue("debitamount", (Object)BigDecimal.ZERO, subRow, row);
                    this.getModel().setValue("creditamount", (Object)debitamount.negate(), subRow, row);
                }
            } else if (debitamount.compareTo(BigDecimal.ZERO) >= 0) {
                this.getModel().setValue("debitamount", (Object)BigDecimal.ZERO, subRow, row);
                this.getModel().setValue("creditamount", (Object)debitamount, subRow, row);
            } else {
                this.getModel().setValue("debitamount", (Object)debitamount.negate(), subRow, row);
                this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO, subRow, row);
            }
        } else {
            this.getModel().setValue("debitamount", (Object)debitamount, subRow, row);
            this.getModel().setValue("creditamount", (Object)creditamount, subRow, row);
        }
        this.getModel().setValue("balanceamt", (Object)balanceamt, subRow, row);
        this.getModel().setValue("oppunitname", (Object)mapData.get(propertyMap.get("oppunitname")), subRow, row);
        this.getModel().setValue("oppbank", (Object)mapData.get(propertyMap.get("oppbank")), subRow, row);
        this.getModel().setValue("oppaccountnumber", (Object)mapData.get(propertyMap.get("oppaccountnumber")), subRow, row);
        this.getModel().setValue("settlementtype", (Object)mapData.get(propertyMap.get("settlementtype")), subRow, row);
        this.getModel().setValue("settlementnumber", (Object)mapData.get(propertyMap.get("settlementnumber")), subRow, row);
        this.getModel().setValue("bankcheckflag", (Object)mapData.get(propertyMap.get("bankcheckflag")), subRow, row);
        this.getModel().setValue("bankvouvherno", (Object)mapData.get(propertyMap.get("bankvouvherno")), subRow, row);
        this.getModel().setValue("sortno", (Object)mapData.get(propertyMap.get("sortno")), subRow, row);
        this.getModel().setValue("cashier", (Object)mapData.get(propertyMap.get("cashier")), subRow, row);
        this.getModel().setValue("tradenumber", (Object)mapData.get(propertyMap.get("tradenumber")), subRow, row);
        this.getModel().setValue("bankdetailno", (Object)mapData.get(propertyMap.get("bankdetailno")), subRow, row);
        Date ratesDate = null;
        String ratesdateStr = mapData.get(propertyMap.get("ratesdate"));
        if (!EmptyUtil.isEmpty((String)ratesdateStr) && ((ratesDate = this.stringToDate(ratesdateStr)) == null || ratesDate.after(MAX_DATE))) {
            BankStatementImportEdit.throwDateException();
        }
        this.getModel().setValue("ratesdate", (Object)ratesDate, subRow, row);
        if (bizdate == null || bizdate.after(MAX_DATE)) {
            BankStatementImportEdit.throwDateException();
        }
        debitamount = (BigDecimal)this.getModel().getValue("debitamount", subRow);
        creditamount = (BigDecimal)this.getModel().getValue("creditamount", subRow);
        if (debitamount != null && creditamount != null && (creditamount.compareTo(BigDecimal.ZERO) == 0 && debitamount.compareTo(BigDecimal.ZERO) == 0 || creditamount.compareTo(BigDecimal.ZERO) != 0 && debitamount.compareTo(BigDecimal.ZERO) != 0)) {
            String msg = ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u7684\u501f\u8d37\u91d1\u989d\u4e0d\u5408\u6cd5,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementImportEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            throw new RuntimeException(msg);
        }
        this.getModel().setValue("isvalid", (Object)RecDecInitHelper.getValid((DynamicObject)accountbank, (Date)bizdate), subRow, row);
        if (EmptyUtil.isEmpty((String)mapData.get(propertyMap.get("transtime")))) {
            if (EmptyUtil.isNotEmpty((String)mapData.get(propertyMap.get("transtime_date")))) {
                transtime = mapData.get(propertyMap.get("transtime_time"));
                if (StringUtils.isBlank((CharSequence)transtime)) {
                    return;
                }
                String transdate = mapData.get(propertyMap.get("transtime_date"));
                Date transDated = this.stringToDate(transdate);
                if (transDated == null || transDated.after(MAX_DATE)) {
                    BankStatementImportEdit.throwDateException();
                }
                String time = this.formatTime(transtime, false);
                String transDateStr = DateFormatUtils.format((Date)transDated, (String)"yyyy-MM-dd");
                this.getModel().setValue("transtime", (Object)DateUtils.stringToDate((String)(transDateStr + " " + time), (String)"yyyy-MM-dd HH:mm:ss"), subRow, row);
            }
        } else {
            transtime = mapData.get(propertyMap.get("transtime"));
            transtime = this.formatTime(transtime, true);
            this.getModel().setValue("transtime", (Object)DateUtils.stringToDate((String)transtime, (String)"yyyy-MM-dd HH:mm:ss"), subRow, row);
        }
    }

    private static void throwDateException() {
        String msg = ResManager.loadKDString((String)"\u65e5\u671f/\u65f6\u95f4\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5", (String)"BankStatementImportEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        throw new RuntimeException(msg);
    }

    public String formatTime(String transTime, boolean isDateTimeFormat) {
        DateTimeFormatter hmsFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (String timeFormat : TIME_FORMATER) {
            try {
                LocalTime time = LocalTime.parse(transTime, DateTimeFormatter.ofPattern(timeFormat));
                return time.format(hmsFormatter);
            }
            catch (Exception e) {
                logger.error("getTime parse time error", (Throwable)e);
            }
        }
        ArrayList<String> formatList = new ArrayList<String>(dateFormat.length * TIME_FORMATER.length * 2);
        for (String dateFmt : dateFormat) {
            for (String timFmt : TIME_FORMATER) {
                formatList.add(dateFmt + " " + timFmt);
                formatList.add(dateFmt + timFmt);
            }
        }
        for (String dateTimeFmt : formatList) {
            try {
                LocalDateTime dateTime = LocalDateTime.parse(transTime, DateTimeFormatter.ofPattern(dateTimeFmt));
                return dateTime.format(isDateTimeFormat ? dateTimeFormatter : hmsFormatter);
            }
            catch (Exception e) {
                logger.error("getTime dateTime time error", (Throwable)e);
            }
        }
        String msg = ResManager.loadKDString((String)"\u65e5\u671f/\u65f6\u95f4\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5", (String)"BankStatementImportEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        throw new RuntimeException(msg);
    }

    private String fillBalanceAmount(String errorTips, int row, DynamicObject firstRowData, Date firstRowDate) {
        DynamicObject lastRowData = this.getModel().getEntryRowEntity(SUB_ENTRY_ENTITY, this.getModel().getEntryRowCount(SUB_ENTRY_ENTITY) - 1, row);
        Date lastRowDate = lastRowData.getDate("bizdate");
        if (EmptyUtil.isNoEmpty((Object)firstRowDate) && EmptyUtil.isNoEmpty((Object)lastRowDate)) {
            BigDecimal lastBalance;
            BigDecimal initBalance;
            BigDecimal firstRowDebitamount;
            BigDecimal firstRowCreditamount;
            BigDecimal balanceamt;
            if (lastRowDate.before(firstRowDate)) {
                Date tempDate = firstRowDate;
                firstRowDate = lastRowDate;
                lastRowDate = tempDate;
                balanceamt = lastRowData.getBigDecimal("balanceamt");
                firstRowCreditamount = lastRowData.getBigDecimal("creditamount");
                firstRowDebitamount = lastRowData.getBigDecimal("debitamount");
                initBalance = balanceamt.add(firstRowDebitamount).subtract(firstRowCreditamount);
                lastBalance = firstRowData.getBigDecimal("balanceamt");
            } else {
                balanceamt = firstRowData.getBigDecimal("balanceamt");
                firstRowCreditamount = firstRowData.getBigDecimal("creditamount");
                firstRowDebitamount = firstRowData.getBigDecimal("debitamount");
                initBalance = balanceamt.add(firstRowDebitamount).subtract(firstRowCreditamount);
                lastBalance = lastRowData.getBigDecimal("balanceamt");
            }
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
            BigDecimal totalDebitamount = subEntryEntity.stream().map(c -> c.getBigDecimal("debitamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCreditamount = subEntryEntity.stream().map(c -> c.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal newBalance = initBalance.add(totalCreditamount).subtract(totalDebitamount);
            if (this.getMsgSuccess().equals(errorTips) && newBalance.compareTo(lastBalance) != 0) {
                errorTips = ResManager.loadKDString((String)"\u521d\u59cb\u4f59\u989d+\u8d37\u65b9\u5408\u8ba1-\u501f\u65b9\u5408\u8ba1\u4e0d\u7b49\u4e8e\u672b\u7b14\u4f59\u989d\u3002", (String)"BankStatementImportEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            this.setValue("begin_date", firstRowDate, row);
            this.setValue("end_date", lastRowDate, row);
            this.setValue("init_balance", initBalance, row);
            this.setValue("last_balance", lastBalance, row);
            this.setValue("total_debitamount", totalDebitamount, row);
            this.setValue("total_creditamount", totalCreditamount, row);
            this.setValue("deal_count", this.getModel().getEntryRowCount(SUB_ENTRY_ENTITY), row);
        }
        return errorTips;
    }

    private BigDecimal getBigDecimal(Map<Integer, String> mapData, Map<String, Integer> propertyMap, String property) {
        String amount = mapData.get(propertyMap.get(property));
        if (EmptyUtil.isEmpty((String)amount)) {
            return null;
        }
        amount = amount.replace(",", "");
        BigDecimal result = null;
        try {
            result = new BigDecimal(amount);
        }
        catch (Exception e) {
            logger.error("Error BigDecimal format", (Throwable)e);
        }
        return result;
    }

    private void fillErrorRowIndexMap(Map<String, Object> paramMap, String errorLevel, int row) {
        if ("-1".equals(errorLevel)) {
            List errorRows = (List)paramMap.get("error_rows");
            errorRows.add(row);
            paramMap.put("error_rows", errorRows);
        } else if ("1".equals(errorLevel)) {
            List successRows = (List)paramMap.get("success_rows");
            successRows.add(row);
            paramMap.put("success_rows", successRows);
        } else if ("0".equals(errorLevel)) {
            List warnRows = (List)paramMap.get("warn_rows");
            warnRows.add(row);
            paramMap.put("warn_rows", warnRows);
        }
    }

    private DynamicObject[] findImportSchemes() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"cas_bankstaimpsche", (QFilter[])new QFilter[]{enableFilter}, null, (int)200);
        DynamicObject[] importSchemes = BusinessDataServiceHelper.load((Object[])idList.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_bankstaimpsche"));
        return importSchemes;
    }

    private void delNoFileEntry(List<Map<String, Object>> attachInfos) {
        ArrayList<Integer> delRowIndex = new ArrayList<Integer>(2);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            String uid = entity.getString("uid");
            Optional<Map> attachInfoOptional = attachInfos.stream().filter(c -> uid.equals(c.get("uid"))).findFirst();
            if (attachInfoOptional.isPresent()) continue;
            delRowIndex.add(i);
        }
        int[] delRowIndexArr = delRowIndex.stream().mapToInt(Integer::valueOf).toArray();
        this.getModel().deleteEntryRows(ENTRY_ENTITY, delRowIndexArr);
    }

    private void next() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
            break;
        }
    }

    private void previous() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(0)).getKey())) {
                this.cancel();
                return;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            break;
        }
    }

    private int transToNumber(String str) {
        if (EmptyUtil.isEmpty((String)str) || this.sumStrAscii(str.toLowerCase()) < 97 || this.sumStrAscii(str.toLowerCase()) > 122) {
            return -1;
        }
        ArrayList<String> list = new ArrayList<String>(2);
        list.addAll(Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"));
        return list.indexOf(str.toLowerCase());
    }

    public int sumStrAscii(String str) {
        byte[] byteStr = str.getBytes(StandardCharsets.UTF_8);
        int sum = 0;
        for (int i = 0; i < byteStr.length; ++i) {
            sum += byteStr[i];
        }
        return sum;
    }

    private void accountCashChanged() {
        DynamicObject accountCash = this.getDynamicObject("accountbank");
        if (accountCash == null) {
            return;
        }
        DynamicObjectCollection currencyCollect = accountCash.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencyCollect) && currencyCollect.size() > 0) {
            this.setValue("currency", ((DynamicObject)currencyCollect.get(0)).getDynamicObject("fbasedataid"));
        }
        if (EmptyUtil.isEmpty((Object)this.getValue(IMPORT_SCHEME))) {
            DynamicObject bank = accountCash.getDynamicObject("bank");
            QFilter bankFilter = new QFilter("bank", "=", (Object)bank.getLong("id"));
            bankFilter.and("enable", "=", (Object)Boolean.TRUE);
            DynamicObject importScheme = QueryServiceHelper.queryOne((String)"cas_bankstaimpsche", (String)"id", (QFilter[])new QFilter[]{bankFilter});
            this.setValue(IMPORT_SCHEME, EmptyUtil.isEmpty((DynamicObject)importScheme) ? null : Long.valueOf(importScheme.getLong("id")));
        }
    }

    private void orgChanged() {
        this.setValue("accountbank", null);
    }

    public JSONObject getBankStatementPkIdCache() {
        String cache = this.getPageCache().get(CACHE_BANKSTATEMENT_DATA);
        if (EmptyUtil.isNotEmpty((String)cache)) {
            return JSON.parseObject((String)cache);
        }
        return new JSONObject();
    }

    public void setBankStatementPkIdCache(String data) {
        this.getPageCache().put(CACHE_BANKSTATEMENT_DATA, data);
    }

    private String getMsgSuccess() {
        return "";
    }

    private static /* synthetic */ boolean lambda$recognizeExcel$16(Map importSchemeMap, DynamicObject c) {
        return EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)importSchemeMap.get(c)));
    }

    private static /* synthetic */ boolean lambda$recognizeExcel$15(String accountId, DynamicObject c) {
        return EmptyUtil.isNoEmpty((DynamicObject)c.getDynamicObject("accountbank")) && accountId.equals(c.getDynamicObject("accountbank").getString("id"));
    }

    private static /* synthetic */ boolean lambda$recognizeExcel$14(Map.Entry entry, DynamicObject c) {
        return c.getString("id").equals(((DynamicObject)entry.getKey()).getString("id"));
    }

    private static /* synthetic */ boolean lambda$recognizeExcel$13(String c) {
        return EmptyUtil.isNotEmpty((String)c);
    }

    static {
        dateFormat = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMdd"};
        TIME_FORMATER = new String[]{"HH:mm:ss", "HHmmss", "HH:mm", "HHmm"};
        MAX_DATE = DateUtils.stringToDate((String)"9999-12-31 23:59:59", (String)"yyyy-MM-dd HH:mm:ss");
        ERROR_TIPS_VALUE = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("", "1");
                this.put(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u5bfc\u5165\u65b9\u6848\uff0c\u8bf7\u9009\u62e9", (String)"BankStatementImportEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bfc\u5165\u65b9\u6848\u3002", (String)"BankStatementImportEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u4e0e\u5bfc\u5165\u6587\u4ef6\u4e0d\u5339\u914d\u3002", (String)"BankStatementImportEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u6587\u4ef6\u6570\u636e\u672a\u89e3\u6790\u3002", (String)"BankStatementImportEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u671f\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"BankStatementImportEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u521d\u59cb\u4f59\u989d+\u8d37\u65b9\u5408\u8ba1-\u501f\u65b9\u5408\u8ba1\u4e0d\u7b49\u4e8e\u672b\u7b14\u4f59\u989d\u3002", (String)"BankStatementImportEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), "0");
                this.put(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u3002", (String)"BankStatementImportEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u4e00\u94f6\u884c\u8d26\u53f7\u91cd\u590d\u8bc6\u522b", (String)"BankStatementImportEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u91d1\u989d\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5", (String)"BankStatementImportEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
                this.put(ResManager.loadKDString((String)"\u65e5\u671f/\u65f6\u95f4\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5", (String)"BankStatementImportEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), "-1");
            }
        };
    }
}

