/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.init;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.helper.CasHelper;

public class CasInitHelper {
    public static Map<String, Map<String, Object>> getAccountCash(DynamicObject org) {
        HashMap<String, Map<String, Object>> CashNumberMap = new HashMap<String, Map<String, Object>>();
        if (CasHelper.isEmpty((Object)org)) {
            return CashNumberMap;
        }
        long orgId = org.getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "!=", (Object)"1")};
        DynamicObject[] accountCashMap = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)"id,number,name,currency,defaultcurrency", (QFilter[])filters);
        if (!CasHelper.isEmpty((DynamicObject[])accountCashMap)) {
            for (DynamicObject cash : accountCashMap) {
                HashMap<String, Object> cashMap = new HashMap<String, Object>();
                cashMap.put("number", cash.getString("number"));
                cashMap.put("name", cash.getString("name"));
                DynamicObjectCollection currencyList = cash.getDynamicObjectCollection("currency");
                for (DynamicObject currency : currencyList) {
                    cashMap.put("currency", currency.getPkValue());
                    DynamicObject curr = currency.getDynamicObject("fbasedataid");
                    if (CasHelper.isEmpty((Object)curr)) continue;
                    CashNumberMap.put(String.valueOf(cash.getPkValue()) + String.valueOf(curr.getPkValue()), cashMap);
                }
            }
        }
        return CashNumberMap;
    }

    public static Map<String, Map<String, Object>> getAccountBank(DynamicObject org) {
        HashMap<String, Map<String, Object>> bankNumberMap = new HashMap<String, Map<String, Object>>();
        if (CasHelper.isEmpty((Object)org)) {
            return bankNumberMap;
        }
        long orgId = org.getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("company", "=", (Object)orgId), new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue())};
        DynamicObject[] accountBankMap = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,name,currency,defaultcurrency", (QFilter[])filters);
        if (!CasHelper.isEmpty((DynamicObject[])accountBankMap)) {
            for (DynamicObject cash : accountBankMap) {
                HashMap<String, Object> cashMap = new HashMap<String, Object>();
                cashMap.put("number", cash.getString("bankaccountnumber"));
                cashMap.put("name", cash.getString("name"));
                DynamicObjectCollection currencyList = cash.getDynamicObjectCollection("currency");
                for (DynamicObject currency : currencyList) {
                    cashMap.put("currency", currency.getPkValue());
                    DynamicObject curr = currency.getDynamicObject("fbasedataid");
                    if (CasHelper.isEmpty((Object)curr)) continue;
                    bankNumberMap.put(String.valueOf(cash.getPkValue()) + String.valueOf(curr.getPkValue()), cashMap);
                }
            }
        }
        return bankNumberMap;
    }

    public static void casInitDeleteCash(String batchNo) {
        if (!CasHelper.isEmpty((Object)batchNo)) {
            DB.execute((DBRoute)DBRouteConst.cas, (String)"delete from T_CAS_CashMgtInitCash where fbatchno=? ", (Object[])new Object[]{batchNo});
        }
    }

    public static void casInitDeleteBank(String batchNo) {
        if (!CasHelper.isEmpty((Object)batchNo)) {
            DB.execute((DBRoute)DBRouteConst.cas, (String)"delete from T_CAS_CashMgtInitBank where fbatchno=? ", (Object[])new Object[]{batchNo});
        }
    }

    public static List<Map<String, Object>> getCashImportData(DynamicObject org, String batchNo) {
        final Map<String, Map<String, Object>> accountCash = CasInitHelper.getAccountCash(org);
        final ArrayList rsList = new ArrayList();
        List list = (List)DB.query((DBRoute)DBRouteConst.cas, (String)("select fid,faccountcashid,fcurrencyid,fyeardebit,fyearcredit,fbalance from T_CAS_CashMgtInitCash where fbatchno= '" + batchNo + "'"), (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> map = null;
                while (rs.next()) {
                    map = new HashMap<String, Object>();
                    Long cashId = rs.getLong("faccountcashid");
                    String key = cashId + String.valueOf(rs.getObject("fcurrencyid"));
                    if (CasHelper.isEmpty(accountCash.get(key))) continue;
                    Map cashImp = (Map)accountCash.get(key);
                    map.put("faccountcashid", cashId);
                    map.put("fbalance", rs.getObject("fbalance"));
                    map.put("number", cashImp.get("number"));
                    map.put("currency", rs.getObject("fcurrencyid"));
                    map.put("fyeardebit", rs.getObject("fyeardebit"));
                    map.put("fyearcredit", rs.getObject("fyearcredit"));
                    map.put("name", cashImp.get("name"));
                    rsList.add(map);
                }
                return rsList;
            }
        });
        return list;
    }

    public static List<Map<String, Object>> getBankImportData(DynamicObject org, String batchNo) {
        final Map<String, Map<String, Object>> accountBank = CasInitHelper.getAccountBank(org);
        final ArrayList rsList = new ArrayList();
        List list = (List)DB.query((DBRoute)DBRouteConst.cas, (String)("select fid,faccountbankid,fcurrencyid,fjournaldebit,fjournalcredit,fjournalbalance,fstatementdebit,fstatementcredit,fstatementbalance,fequal from T_CAS_CashMgtInitBank where fbatchno= '" + batchNo + "'"), (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> map = null;
                while (rs.next()) {
                    map = new HashMap<String, Object>();
                    Long bankId = rs.getLong("faccountbankid");
                    String key = bankId + String.valueOf(rs.getObject("fcurrencyid"));
                    if (CasHelper.isEmpty(accountBank.get(key))) continue;
                    Map bankImp = (Map)accountBank.get(key);
                    map.put("faccountcashid", bankId);
                    map.put("number", bankImp.get("number"));
                    map.put("name", bankImp.get("name"));
                    map.put("currency", rs.getObject("fcurrencyid"));
                    map.put("journaldebit", rs.getObject("fjournaldebit"));
                    map.put("journalcredit", rs.getObject("fjournalcredit"));
                    map.put("journalbalance", rs.getObject("fjournalbalance"));
                    map.put("statementdebit", rs.getObject("fstatementdebit"));
                    map.put("statementcredit", rs.getObject("fstatementcredit"));
                    map.put("statementbalance", rs.getObject("fstatementbalance"));
                    map.put("equal", rs.getObject("fequal"));
                    rsList.add(map);
                }
                return rsList;
            }
        });
        return list;
    }
}

