/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class CasInitImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        Object importType = option.get("importtype");
        if (StringUtils.equals((CharSequence)"new", (CharSequence)importType.toString())) {
            return;
        }
        super.beforeSave(billdatas, logger);
        HashSet<DynamicObject[]> orgNumbers = new HashSet<DynamicObject[]>(billdatas.size());
        HashMap<String, Set<Integer>> indexOrgNumbers = new HashMap<String, Set<Integer>>(16);
        for (ImportBillData billData : billdatas) {
            JSONObject jsonData = billData.getData();
            Map org = (Map)jsonData.get((Object)"org");
            DynamicObject[] orgNum = (DynamicObject[])org.get("number");
            orgNumbers.add(orgNum);
            HashSet<Integer> indexes = (HashSet<Integer>)indexOrgNumbers.get(orgNum);
            if (indexes == null) {
                indexes = new HashSet<Integer>(16);
                indexOrgNumbers.put((String)orgNum, (Set<Integer>)indexes);
            }
            indexes.add(billData.getDataIndex());
        }
        DynamicObject[] casMghtObjects = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id, org, isfinishinit,standardcurrency, periodtype, startperiod, exratetable", (QFilter[])new QFilter[]{new QFilter("org.number", "in", orgNumbers)});
        HashSet<String> casmghtInitOrgIds = new HashSet<String>(casMghtObjects.length);
        HashSet<String> notConfigOrgIds = new HashSet<String>(16);
        HashSet<String> finishInitOrgIds = new HashSet<String>(16);
        for (DynamicObject casMghtObject : casMghtObjects) {
            String orgNum = casMghtObject.getString("org.number");
            casmghtInitOrgIds.add(orgNum);
            if (casMghtObject.getDynamicObject("standardcurrency") == null || casMghtObject.getDynamicObject("periodtype") == null || casMghtObject.getDynamicObject("startperiod") == null || casMghtObject.getDynamicObject("exratetable") == null) {
                notConfigOrgIds.add(orgNum);
            }
            if (!casMghtObject.getBoolean("isfinishinit")) continue;
            finishInitOrgIds.add(orgNum);
        }
        HashSet<String> notExistOrgNumbers = new HashSet<String>(orgNumbers.size());
        notExistOrgNumbers.addAll(orgNumbers);
        notExistOrgNumbers.removeAll(casmghtInitOrgIds);
        if (notExistOrgNumbers.size() > 0) {
            String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"CasInitImportOp_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.removeData(notExistOrgNumbers, indexOrgNumbers, billdatas, logger, message);
        }
        if (notConfigOrgIds.size() > 0) {
            String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a\u201c%1$s\u201d\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\u3002", (String)"CasInitImportOp_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.removeData(notConfigOrgIds, indexOrgNumbers, billdatas, logger, message);
        }
        if (finishInitOrgIds.size() > 0) {
            String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a\u201c%1$s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u3002", (String)"CasInitImportOp_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            this.removeData(finishInitOrgIds, indexOrgNumbers, billdatas, logger, message);
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        Object importType = option.get("importtype");
        if (StringUtils.equals((CharSequence)"new", (CharSequence)importType.toString())) {
            String message = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u51fa\u7eb3\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165\u3002\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u901a\u8fc7\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65b9\u5f0f\u5bfc\u5165\u3002", (String)"CasInitImportOp_01", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        this.setEntryBankDefaultOpenOrg(rowdatas);
        HashSet<String> orgNumbers = new HashSet<String>(16);
        HashMap<String, List<String>> orgAccounts = new HashMap<String, List<String>>(16);
        this.importAccountsAndOrg(rowdatas, orgNumbers, orgAccounts);
        HashMap<String, Set<Long>> entryIds = new HashMap<String, Set<Long>>(16);
        this.preAccounts(orgNumbers, entryIds);
        ApiResult apiResult = super.save(rowdatas, logger);
        ArrayList data = (ArrayList)apiResult.getData();
        HashSet<Long> dataIds = new HashSet<Long>(data.size());
        for (Map dataMap : data) {
            Long id = (Long)dataMap.get("id");
            dataIds.add(id);
        }
        if (dataIds.size() > 0) {
            DynamicObject[] cashMgtInits = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_cashmgtinit"));
            HashSet<Long> removeCashIds = new HashSet<Long>(16);
            HashSet<Long> removeBankIds = new HashSet<Long>(16);
            this.dealEntry(cashMgtInits, orgAccounts, entryIds, removeCashIds, removeBankIds);
            this.deleteAccount(removeCashIds, removeBankIds);
        }
        return apiResult;
    }

    private void importAccountsAndOrg(List<ImportBillData> rowdatas, Set<String> orgNumbers, Map<String, List<String>> orgAccounts) {
        for (ImportBillData rowData : rowdatas) {
            JSONArray jsonEntryBank;
            JSONObject jsonData = rowData.getData();
            JSONArray jsonEntryCash = (JSONArray)jsonData.get((Object)"entrycash");
            JSONObject jsonOrg = (JSONObject)jsonData.get((Object)"org");
            String orgNumber = jsonOrg.getString("number");
            orgNumbers.add(orgNumber);
            List<String> accounts = orgAccounts.get(orgNumber);
            if (accounts == null) {
                accounts = new ArrayList<String>(16);
                orgAccounts.put(orgNumber, accounts);
            }
            if (jsonEntryCash != null) {
                for (int i = 0; i < jsonEntryCash.size(); ++i) {
                    JSONObject jsonCash = (JSONObject)jsonEntryCash.get(i);
                    JSONObject jsonCashNumber = (JSONObject)jsonCash.get((Object)"cash_accountcash");
                    String cashNumber = jsonCashNumber.getString("number");
                    JSONObject jsonCurrency = (JSONObject)jsonCash.get((Object)"cash_currency");
                    String currencyNumber = jsonCurrency.getString("number");
                    String value = "cash_" + cashNumber + "_" + currencyNumber;
                    accounts.add(value);
                }
            }
            if ((jsonEntryBank = (JSONArray)jsonData.get((Object)"entrybank")) == null) continue;
            for (int i = 0; i < jsonEntryBank.size(); ++i) {
                JSONObject jsonBank = (JSONObject)jsonEntryBank.get(i);
                JSONObject jsonBankNumber = (JSONObject)jsonBank.get((Object)"bank_accountbank");
                String bankNumber = jsonBankNumber.getString("bankaccountnumber");
                JSONObject jsonCurrency = (JSONObject)jsonBank.get((Object)"bank_currency");
                String currencyNumber = jsonCurrency.getString("number");
                String value = "bank_" + bankNumber + "_" + currencyNumber;
                accounts.add(value);
            }
        }
    }

    private void preAccounts(Set<String> orgNumbers, Map<String, Set<Long>> entryIds) {
        DynamicObject[] cashmgtinits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,orgentrycash,  entrycash.cash_accountcash, entrycash.cash_currency,entrybank,  entrybank.bank_accountbank, entrybank.bank_currency", (QFilter[])new QFilter[]{new QFilter("org.number", "in", orgNumbers)});
        entryIds.put("cash", new HashSet());
        entryIds.put("bank", new HashSet());
        for (DynamicObject cashmgtinit : cashmgtinits) {
            DynamicObjectCollection cashObjectColl = cashmgtinit.getDynamicObjectCollection("entrycash");
            for (DynamicObject cashObject : cashObjectColl) {
                entryIds.get("cash").add((Long)cashObject.getPkValue());
            }
            DynamicObjectCollection bankObjectColl = cashmgtinit.getDynamicObjectCollection("entrybank");
            for (DynamicObject bankObject : bankObjectColl) {
                entryIds.get("bank").add((Long)bankObject.getPkValue());
            }
        }
    }

    private void dealEntry(DynamicObject[] cashMgtInits, Map<String, List<String>> orgAccounts, Map<String, Set<Long>> entryIds, Set<Long> removeCashIds, Set<Long> removeBankIds) {
        for (DynamicObject cashmgtinit : cashMgtInits) {
            DynamicObject org = cashmgtinit.getDynamicObject("org");
            String orgNumber = org.getString("number");
            List<String> accountModels = orgAccounts.get(orgNumber);
            HashSet<DynamicObject> removeCash = new HashSet<DynamicObject>(16);
            HashSet<DynamicObject> removeBank = new HashSet<DynamicObject>(16);
            DynamicObjectCollection cashObjectColl = cashmgtinit.getDynamicObjectCollection("entrycash");
            for (DynamicObject cashObject : cashObjectColl) {
                DynamicObject cashNumberObject = cashObject.getDynamicObject("cash_accountcash");
                String cashNumber = cashNumberObject.getString("number");
                DynamicObject cashCurrencyObject = cashObject.getDynamicObject("cash_currency");
                String cashCurrency = cashCurrencyObject.getString("number");
                Long entryId = (Long)cashObject.getPkValue();
                String value = "cash_" + cashNumber + "_" + cashCurrency;
                Set<Long> cashEntry = entryIds.get("cash");
                if (!cashEntry.contains(entryId) || !accountModels.contains(value)) continue;
                removeCash.add(cashObject);
                removeCashIds.add(entryId);
            }
            cashObjectColl.removeAll(removeCash);
            DynamicObjectCollection bankObjectColl = cashmgtinit.getDynamicObjectCollection("entrybank");
            for (DynamicObject bankObject : bankObjectColl) {
                DynamicObject bankNumberObject = bankObject.getDynamicObject("bank_accountbank");
                String bankNumber = bankNumberObject.getString("bankaccountnumber");
                DynamicObject bankCurrencyObject = bankObject.getDynamicObject("bank_currency");
                String bankCurrency = bankCurrencyObject.getString("number");
                Long entryId = (Long)bankObject.getPkValue();
                String value = "bank_" + bankNumber + "_" + bankCurrency;
                Set<Long> bankEntry = entryIds.get("bank");
                if (!bankEntry.contains(entryId) || !accountModels.contains(value)) continue;
                removeBank.add(bankObject);
                removeBankIds.add(entryId);
            }
            bankObjectColl.removeAll(removeBank);
        }
    }

    /*
     * Exception decompiling
     */
    private void deleteAccount(Set<Long> removeCashIds, Set<Long> removeBankIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeData(Set<String> data, Map<String, Set<Integer>> indexOrgNumbers, List<ImportBillData> billdatas, ImportLogger logger, String message) {
        for (String num : data) {
            Set<Integer> indexes = indexOrgNumbers.get(num);
            for (Integer row : indexes) {
                int index = row - 1;
                if (index == -1) {
                    index = 0;
                }
                if (billdatas.size() > 0) {
                    billdatas.remove(index);
                }
                logger.log(row, String.format(message, num)).fail();
            }
        }
    }

    private void setEntryBankDefaultOpenOrg(List<ImportBillData> rowdatas) {
        for (ImportBillData importBillData : rowdatas) {
            JSONObject data = importBillData.getData();
            JSONArray entryBankList = data.getJSONArray("entrybank");
            if (CollectionUtils.isEmpty((Collection)entryBankList)) continue;
            for (Object entryBankObj : entryBankList) {
                JSONObject accountBank;
                String importprop;
                QFilter filter;
                DynamicObject account;
                Object accountBankObj;
                JSONObject entryBank = (JSONObject)entryBankObj;
                if (entryBank.get((Object)"bank_openorg") != null || (accountBankObj = entryBank.get((Object)"bank_accountbank")) == null || (account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"openorg", (QFilter[])(filter = new QFilter(importprop = (accountBank = (JSONObject)accountBankObj).getString("importprop"), "=", accountBank.get((Object)importprop))).toArray())) == null) continue;
                JSONObject openOrg = new JSONObject();
                openOrg.put("importprop", (Object)"id");
                openOrg.put("id", (Object)account.getLong("openorg"));
                entryBank.put("bank_openorg", (Object)openOrg);
            }
        }
    }

    private static /* synthetic */ Object[] lambda$deleteAccount$1(Long removeId) {
        return new Object[]{removeId};
    }
}

