/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journal;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankJournalDownloadEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BankJournalDownloadEditPlugin.class);
    private long beginTime = 0L;
    private static int INIT_CAPACITY = 3;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setF7SelectListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("enddate", (Object)new Date());
        List customOrgId = (List)this.getView().getFormShowParameter().getCustomParam("customorg");
        QFilter[] filter = new QFilter[]{new QFilter("org", "in", (Object)customOrgId)};
        DynamicObjectCollection obj = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id,currentperiod.id,currentperiod.begindate,startperiod.id,startperiod.begindate", (QFilter[])filter);
        if (obj != null) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObject[] org = BusinessDataServiceHelper.load((Object[])customOrgId.toArray(), (DynamicObjectType)type);
            DynamicObjectCollection orgCol = MultiBaseDataHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"org", (DynamicObject[])org);
            this.getModel().setValue("org", (Object)orgCol);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("accountbank", null);
                this.getModel().setValue("begindate", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.beforeDownloadOp(args);
    }

    private void beforeDownloadOp(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (!"download".equals(op.getOperateKey())) {
            return;
        }
        this.beginTime = System.currentTimeMillis();
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u8f7d\u4e2d...", (String)"BankJournalDownloadEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        if (!this.verifyParameter()) {
            args.cancel = true;
        }
    }

    private boolean verifyParameter() {
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgCol)) {
            this.getView().hideLoading();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"BankJournalDownloadEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (beginDate == null) {
            this.getView().hideLoading();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"BankJournalDownloadEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (endDate == null) {
            this.getView().hideLoading();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f\u3002", (String)"BankJournalDownloadEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (beginDate.after(endDate)) {
            this.getView().hideLoading();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"BankJournalDownloadEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        int dates = DateUtils.getDiffDays((Date)beginDate, (Date)endDate);
        if (dates > 31) {
            this.getView().hideLoading();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u95f4\u9694\u6700\u591a\u652f\u6301\u4e00\u4e2a\u6708\uff08\u4e0d\u8d85\u8fc731\u5929\uff09\u3002", (String)"BankJournalDownloadEditPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.afterDownloadOp(args);
    }

    private void afterDownloadOp(AfterDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (!"download".equals(op.getOperateKey())) {
            return;
        }
        this.getView().hideLoading();
        this.getView().getParentView().invokeOperation("refresh");
        OperationResult result = args.getOperationResult();
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
        } else {
            this.successHandler(result);
        }
    }

    public void successHandler(OperationResult result) {
        HashSet errorPkIds;
        int successCount = result.getSuccessPkIds().size() - 1;
        int failCount = 0;
        ValidateResultCollection validateResult = result.getValidateResult();
        if (validateResult != null && (errorPkIds = validateResult.getErrorPkIds()) != null) {
            failCount = errorPkIds.size();
        }
        int acctBankCount = 0;
        DynamicObjectCollection acctBanks = (DynamicObjectCollection)this.getModel().getValue("accountbank");
        if (!acctBanks.isEmpty()) {
            acctBankCount = acctBanks.size();
        } else {
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("org");
            if (orgCol != null) {
                Set ids = orgCol.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toSet());
                QFilter filter = new QFilter("org", "in", ids);
                DynamicObject[] acctBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filter});
                acctBankCount = acctBank.length;
            }
        }
        HashMap<String, Integer> returnData = new HashMap<String, Integer>(INIT_CAPACITY);
        returnData.put("acctBankCount", acctBankCount);
        returnData.put("successCount", successCount);
        returnData.put("failCount", failCount);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
        long time = System.currentTimeMillis() - this.beginTime;
        logger.info(String.format("The application of bank journal : %s accounts have been downloaded successfully that spent %sms", successCount, time));
    }

    private void setF7SelectListener() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,org.id", (QFilter[])new QFilter[0]);
        List orgInitIds = Arrays.stream(objects).map(object -> object.get("org.id")).collect(Collectors.toList());
        orgCtrl.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            Long userId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cas_bankjournalformrpt", (String)"4730fc9f000007ae");
            orgInitIds.retainAll(orgIds);
            QFilter filter = new QFilter("id", "in", (Object)orgInitIds);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit accountCtrl = (BasedataEdit)this.getControl("accountbank");
        accountCtrl.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("org");
            Set ids = orgCol.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(ids)) {
                QFilter[] qFilters = new QFilter[]{new QFilter("createorg", "in", ids), new QFilter("isvirtual", "=", (Object)"0")};
                showParameter.setIsolationOrg(false);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilters));
            }
        });
    }
}

