/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.business.journal.VoucherMatcher;
import kd.fi.cas.helper.CasHelper;

public class BankUnreachFormDataPlugin
extends AbstractReportFormPlugin {
    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (rowData.size() > 0) {
            ArrayList<DynamicObject> journalData = new ArrayList<DynamicObject>();
            HashSet<Long> rowIds = new HashSet<Long>(10);
            for (int i = 0; i < rowData.size(); ++i) {
                DynamicObject row = (DynamicObject)rowData.get(i);
                if (CasHelper.isEmpty((Object)row.getLong("id")) || !"2".equals(row.getString("source")) && !"4".equals(row.getString("source"))) continue;
                rowIds.add(Long.valueOf(row.getString("id")));
                journalData.add(row);
            }
            DynamicObject[] journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,sourcebilltype,sourcebillid,sourcebillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", rowIds)});
            Map voucherJournalMap = new VoucherMatcher().findRelatedVouchers(Arrays.asList(journals), "cas_bankjournal");
            HashMap result = new HashMap();
            String fields = "vouchertype.name,billno";
            if (this.getVoucherFields() != null && this.getVoucherFields().size() > 0) {
                fields = fields + "," + String.join((CharSequence)",", this.getVoucherFields());
            }
            Map voucherMap = new VoucherBookService().queryVouchers(voucherJournalMap, fields);
            HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
            voucherJournalMap.forEach((journal, voucherPks) -> {
                ArrayList voucherTypeNos = new ArrayList();
                LinkedList voucherBillNos = new LinkedList();
                voucherPks.forEach(voucherPk -> {
                    DynamicObject voucher = (DynamicObject)voucherMap.get(voucherPk);
                    if (voucher != null) {
                        String voucherType = voucher.getString("vouchertype.name");
                        String voucherNumber = voucher.getString("billno");
                        String voucherTypeNumber = voucherType + " " + voucherNumber;
                        voucherTypeNos.add(voucherTypeNumber);
                        voucherBillNos.add(voucherNumber);
                        resultMap.computeIfAbsent(journal.getString("id"), k -> new ArrayList());
                        resultMap.computeIfPresent(journal.getString("id"), (k, v) -> {
                            v.add(voucher);
                            return v;
                        });
                    }
                });
                String sourceBillType = journal.getString("sourcebilltype");
                SourceNumber sourceNumber = new SourceNumber();
                sourceNumber.setSourceType(sourceBillType);
                sourceNumber.setVoucherNo(String.join((CharSequence)",", voucherTypeNos));
                if ("gl_voucher".equals(sourceBillType)) {
                    sourceNumber.setBillno(String.join((CharSequence)",", voucherBillNos));
                } else {
                    sourceNumber.setBillno(journal.getString("sourcebillnumber"));
                }
                result.put(journal, sourceNumber);
            });
            HashMap numMap = new HashMap();
            result.keySet().forEach(key -> numMap.put(key.getString("id"), result.get(key)));
            for (DynamicObject journal2 : journalData) {
                SourceNumber voucherNumber = (SourceNumber)numMap.get(journal2.getString("id"));
                if (voucherNumber == null) continue;
                journal2.set("vouchernum", (Object)voucherNumber.getVoucherNo());
                journal2.set("sourcebillnumber", (Object)voucherNumber.getBillno());
            }
            this.customBizProcessData(journalData, resultMap);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            String key;
            if (!(column instanceof ReportColumn) || !(key = (col = (ReportColumn)column).getFieldKey()).equals("id")) continue;
            col.setHide(true);
        }
    }

    public void customBizProcessData(List<DynamicObject> journalData, Map<String, List<DynamicObject>> resultMap) {
    }

    public Set<String> getVoucherFields() {
        return null;
    }
}

