/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayBillInnerAccount
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setFinAccF7Filter();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showOrHideInnerAccountPanel();
        this.changeCurrencyOrActPayAmt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        if (key.equals("paymenttype")) {
            this.showOrHideInnerAccountPanel();
            this.changeCurrencyOrActPayAmt();
        }
        if (key.equals("currency")) {
            this.changeCurrencyOrActPayAmt();
        }
        if (key.equals("actpayamt")) {
            this.changeCurrencyOrActPayAmt();
        }
        if (key.equals("org") || "payee".equals(key)) {
            this.showOrHideInnerAccountPanel();
        }
        if (key.equals("payeracctbank")) {
            this.showOrHideInnerAccountPanel();
        }
    }

    private void setInnerVal() {
        DynamicObject[] dynamicObject;
        DynamicObject[] innerAccounts;
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("inneraccount"))) {
            return;
        }
        DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        if (payerAcctBank != null && (innerAccounts = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"number,relationacc", (QFilter[])new QFilter("relationacc.fbasedataid.id", "=", (Object)payerAcctBank.getLong("id")).toArray())) != null && innerAccounts.length > 0 && (dynamicObject = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)innerAccounts[0].getString("number"))})) != null && dynamicObject.length > 0) {
            this.getModel().setValue("inneraccount", (Object)dynamicObject[0].getLong("id"));
        }
    }

    private void showOrHideInnerAccountPanel() {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
        if ("fca_transupbill".equals(sourceBillType)) {
            DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
            if (payerAcctBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)payerAcctBank)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                this.getModel().setValue("inneraccount", null);
                return;
            }
            if (paymentType != null) {
                if (paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_UP.getValue())) {
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    if (SystemParameterHelper.isShowInternalAccount((long)org.getLong("id"))) {
                        this.setInnerVal();
                        this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("inneraccount") != null), new String[]{"flex_inneraccount"});
                    } else {
                        this.getModel().setValue("inneraccount", null);
                        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                    }
                } else {
                    this.getModel().setValue("inneraccount", null);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                }
            } else {
                this.getModel().setValue("inneraccount", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
            }
        } else {
            String payeeType = (String)this.getModel().getValue("payeetype");
            if (paymentType != null && paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_UP.getValue()) && Arrays.asList("bos_org", "bd_customer", "bd_supplier").contains(payeeType)) {
                QFilter typeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
                Object org = this.getModel().getValue("payee");
                QFilter orgFilter = new QFilter("org.id", "=", org);
                DynamicObject[] bdFinorginfo = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{typeFilter.and(orgFilter)});
                List bds = Arrays.stream(bdFinorginfo).map(e -> e.getLong("id")).collect(Collectors.toList());
                if (bds == null || bds.size() == 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                    return;
                }
                QFilter orgFilterP = new QFilter("finorg.id", "in", bds);
                DynamicObject payOrg = (DynamicObject)this.getModel().getValue("org");
                QFilter orgFilterC = new QFilter("company.id", "=", (Object)payOrg.getLong("id"));
                Object[] flagP = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{orgFilterP.and(orgFilterC)});
                if (EmptyUtil.isNoEmpty((Object[])flagP)) {
                    this.setInnerVal();
                    this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("inneraccount") != null), new String[]{"flex_inneraccount"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                    this.getModel().setValue("inneraccount", null);
                }
            } else {
                boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)this.getModel().getDataEntity());
                if (!isLinkagePayment) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                    this.getModel().setValue("inneraccount", null);
                }
            }
        }
    }

    private void changeCurrencyOrActPayAmt() {
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
        if (paymentType != null && paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_UP.getValue())) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("inneraccountcurrency", currency == null ? "" : currency.get("name"));
            BigDecimal actPayAmt = new BigDecimal(this.getModel().getValue("actpayamt").toString());
            this.getModel().setValue("inneraccountamount", (Object)actPayAmt.toPlainString());
        }
    }

    private void setFinAccF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("inneraccount");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject currency;
            DynamicObject payOrg;
            QFilter innerAccQFilter = new QFilter("finorgtype", "=", (Object)"1");
            innerAccQFilter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
            Long org = (Long)this.getModel().getValue("payee");
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)this.getModel().getDataEntity());
            if (org != null && !isLinkagePayment) {
                innerAccQFilter.and(new QFilter("bank.org.id", "in", (Object)org));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(payOrg = (DynamicObject)this.getModel().getValue("org")))) {
                QFilter orgFilterC = new QFilter("company.id", "=", (Object)payOrg.getLong("id"));
                innerAccQFilter.and(orgFilterC);
            }
            if ((currency = (DynamicObject)this.getModel().getValue("currency")) != null) {
                innerAccQFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(innerAccQFilter);
        });
    }
}

