/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.ISingleTaskContext;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.util.EmptyUtil;

public class PayBillLinkagePayment
extends BillEditPlugin {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.controlProperty();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) && EmptyUtil.isNoEmpty((String)this.getString("sourcebilltype"))) {
            this.setInnerAccountInfo(false);
        } else {
            this.controlProperty();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "settletype": 
            case "payeracctbank": 
            case "paymenttype": 
            case "payee": 
            case "currency": {
                this.fillLinkPayRelation();
                break;
            }
            case "paymentchannel": {
                this.showUsage();
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Object isFromWebApi = this.getModel().getContextVariable("MODEL_INIT_BY_WEBAPI");
        if (Boolean.TRUE.equals(isFromWebApi)) {
            this.setInnerAccountInfo(false);
        }
    }

    private void controlProperty() {
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
        if (settleType != null && paymentType != null) {
            String bizType = paymentType.getString("biztype");
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)this.getModel().getDataEntity());
            if (!isLinkagePayment && !PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(bizType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
            } else if (isLinkagePayment) {
                if (this.getModel().getValue("inneraccount") == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flex_inneraccount"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountamount"});
                    this.showUsage();
                    this.setPaymentChannel();
                    DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                    if (currency != null) {
                        this.getModel().setValue("inneraccountcurrency", currency.get("name"));
                    }
                }
            }
        }
    }

    private void fillLinkPayRelation() {
        DynamicObject payerAccountBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        Object payee = this.getModel().getValue("payee");
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
        if (settleType != null && paymentType != null) {
            String bizType = paymentType.getString("biztype");
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)this.getModel().getDataEntity());
            if (!isLinkagePayment && !PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(bizType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
            } else if (isLinkagePayment && PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(bizType)) {
                QFilter orgFilter;
                QFilter typeFilter;
                DynamicObject[] finorgInfos;
                if (payee != null && (finorgInfos = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,finorgtype.type", (QFilter[])new QFilter[]{typeFilter = new QFilter("finorgtype.type", "=", (Object)"1"), orgFilter = new QFilter("org.id", "=", payee)})) != null && finorgInfos.length != 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u52a8\u4e0a\u5b58\u7ed3\u7b97\u4e2d\u5fc3\u8d44\u91d1\u4e0d\u80fd\u4f7f\u7528\u8054\u52a8\u652f\u4ed8\u7684\u7ed3\u7b97\u65b9\u5f0f\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayBillLinkagePayment_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("settletype", null);
                }
            } else if (isLinkagePayment && payerAccountBank != null) {
                DynamicObject bank = payerAccountBank.getDynamicObject("bank");
                DynamicObject finorgInfo = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"id,finorgtype.type");
                Optional<String> type = Optional.ofNullable(finorgInfo).map(b -> b.getDynamicObject("finorgtype")).map(f -> f.getString("type"));
                if (type.isPresent() && PayAndRecBizTypeEnum.FUNDS_UP.getValue().equals(type.get())) {
                    this.getModel().setValue("payeracctbank", null);
                    this.getModel().setValue("settletype", null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u8054\u52a8\u652f\u4ed8\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u7ed3\u7b97\u65b9\u5f0f\u6216\u66f4\u6362\u4ed8\u6b3e\u8d26\u6237\u3002", (String)"PayBillLinkagePayment_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setInnerAccountInfo(true);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
        }
    }

    public boolean matchRuleBill(String filterStr, DynamicObject detailDy) {
        Map<String, DynamicProperty> fldProperties = PayBillLinkagePayment.getFilterProperties(detailDy);
        boolean isMatchRule = false;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_paybill");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                if (baseBoolean) {
                    isMatchRule = true;
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    private static Map<String, DynamicProperty> getFilterProperties(DynamicObject info) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_paybill");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || propName.contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    private void setPaymentChannel() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
        for (PaymentChannelEnum paymentChannelEnum : PaymentChannelEnum.values()) {
            ComboItem item = new ComboItem();
            item.setValue(paymentChannelEnum.getValue());
            item.setCaption(new LocaleString(paymentChannelEnum.getName()));
            comboItems.add(item);
        }
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        paymentChannel.setComboItems(comboItems);
    }

    private void showUsage() {
        boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)this.getModel().getDataEntity());
        if (isLinkagePayment && this.getModel().getValue("inneraccount") != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"usage"});
        }
    }

    private void setInnerAccountInfo(boolean isShowErr) {
        boolean isLinkagePayment;
        DynamicObject payerAccountBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("paymenttype");
        if (settleType != null && paymentType != null && (isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)this.getModel().getDataEntity())) && payerAccountBank != null) {
            DynamicObject linkPayRelation;
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            QFilter qFilter = new QFilter("entryentity.e_account", "=", payerAccountBank.getPkValue());
            qFilter.and("acctpaymodel", "=", (Object)"0");
            qFilter.and("enable", "=", (Object)true);
            if (currency != null) {
                qFilter.and("currency", "=", currency.getPkValue());
            }
            if ((linkPayRelation = BusinessDataServiceHelper.loadSingle((String)"am_linkpayrelation", (String)"currency,entryentity,entryentity.e_internalacct,entryentity.e_parentacct,entryentity.e_bank,entryentity.e_default,entryentity.e_datafilter,entryentity.e_datafilter_tag", (QFilter[])new QFilter[]{qFilter})) != null) {
                DynamicObjectCollection entries = linkPayRelation.getDynamicObjectCollection("entryentity");
                boolean isMatchRule = false;
                DynamicObject innerAccount = null;
                DynamicObject parentAccount = null;
                DynamicObject currency0 = linkPayRelation.getDynamicObject("currency");
                for (DynamicObject entry : entries) {
                    String dataFilter = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entry.getString("e_datafilter")) ? entry.getString("e_datafilter") : entry.getString("e_datafilter_tag");
                    isMatchRule = this.matchRuleBill(dataFilter, this.getModel().getDataEntity());
                    if (!isMatchRule) continue;
                    innerAccount = entry.getDynamicObject("e_internalacct");
                    parentAccount = entry.getDynamicObject("e_parentacct");
                    break;
                }
                if (!isMatchRule) {
                    DynamicObject entry;
                    Optional<DynamicObject> entryOption = entries.stream().filter(e -> e.getBoolean("e_default")).findFirst();
                    entry = null;
                    if (entryOption.isPresent()) {
                        entry = entryOption.get();
                    }
                    if (entry != null) {
                        innerAccount = entry.getDynamicObject("e_internalacct");
                        parentAccount = entry.getDynamicObject("e_parentacct");
                    }
                }
                this.getModel().setValue("inneraccount", innerAccount);
                if (innerAccount == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flex_inneraccount"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountamount"});
                    this.showUsage();
                    this.setPaymentChannel();
                    String defaultPaymentChannel = PaymentChannelEnum.COUNTER.getValue();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)settleType.getString("defaultpaymentchannel"))) {
                        defaultPaymentChannel = settleType.getString("defaultpaymentchannel");
                    }
                    this.getModel().setValue("paymentchannel", (Object)defaultPaymentChannel);
                }
                this.getModel().setValue("parentacct", (Object)parentAccount);
                if (currency0 != null) {
                    this.getModel().setValue("inneraccountcurrency", currency0.get("name"));
                }
            } else if (isShowErr) {
                this.getModel().setValue("payeracctbank", null);
                this.getModel().setValue("settletype", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u8054\u52a8\u652f\u4ed8\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u7ed3\u7b97\u65b9\u5f0f\u6216\u66f4\u6362\u4ed8\u6b3e\u8d26\u6237\u3002", (String)"PayBillLinkagePayment_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

