/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayBillReceiptListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PayBillReceiptListPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "receipt".equals(operateKey)) {
            logger.info("-- \u4ed8\u6b3e\u5355\u8054\u67e5\u7535\u5b50\u56de\u5355\u5f00\u59cb --");
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (!selectedRows.isEmpty()) {
                List<Object> payBillIdList = Arrays.asList(selectedRows.getPrimaryKeyValues());
                logger.info("\u9009\u4e2d\u4ed8\u6b3e\u5355ID:" + payBillIdList);
            }
            Set isAllSet = HandLinkBillHelper.showBotpRtansDetails((ListSelectedRowCollection)selectedRows, (String)"cas_paybill");
            List receiptNos = HandLinkBillHelper.getReceiptNoByDetails((ListSelectedRowCollection)selectedRows, (String)"cas_paybill");
            String bankcheckflag = HandLinkBillHelper.getBankCheckFlagNoDetail((ListSelectedRowCollection)selectedRows, (String)"cas_paybill");
            logger.info("\u4ea4\u6613\u660e\u7ec6ID:" + isAllSet + " \u5bf9\u8d26\u6807\u8bc6\u7801:" + bankcheckflag);
            if (!isAllSet.isEmpty() || EmptyUtil.isNoEmpty((String)bankcheckflag)) {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cas_multitag");
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = "cas".equals(appId) ? "cbei" : "bei";
                para.getCustomParams().put("checkRightAppId", appId);
                if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
                    logger.info("\u5bf9\u8d26\u6807\u8bc6\u7801:" + bankcheckflag);
                    logger.info("\u7535\u5b50\u56de\u5355\u53f7:" + receiptNos);
                    para.setCustomParam("receiptID", (Object)bankcheckflag);
                    para.setCustomParam("receiptNo", (Object)JSON.toJSONString((Object)receiptNos));
                }
                if (!isAllSet.isEmpty()) {
                    para.setCustomParam("detailIds", (Object)JSON.toJSONString((Object)isAllSet));
                }
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(para);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u3002", (String)"PayBillViewReceiptOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

