/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.payment.PaymentPayScheduleSource;
import kd.fi.cas.util.EmptyUtil;

public class PayBillSchePlugin
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setWaitSche();
        this.loadFieldsNoEvent();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setWaitSche();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Long billId = (Long)this.getModel().getDataEntity().getPkValue();
        Boolean isSchePay = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"isSchePayBill", (Object[])new Object[]{billId});
        if (isSchePay.booleanValue()) {
            BasedataEdit draftBillEdit = (BasedataEdit)this.getControl("draftbill");
            draftBillEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setCustomParam("source", (Object)"pay");
                showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            });
        }
    }

    private void loadFieldsNoEvent() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String srcBillType = dataEntity.getString("sourcebilltype");
        boolean isWaitSche = dataEntity.getBoolean("iswaitsche");
        if (EmptyUtil.isNoEmpty((String)srcBillType) && isWaitSche) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"draftbill", "settletnumber"});
        }
        if (isWaitSche) {
            this.getView().setVisible(Boolean.valueOf(!isWaitSche), new String[]{"m_deleterow", "m_addrow", "copyentryrow", "bar_submit", "navbill", "bar_del"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"iswaitsche"});
    }

    private void setWaitSche() {
        DynamicObject payBill = this.getModel().getDataEntity(true);
        if (this.exists(payBill.getPkValue(), payBill.getDataEntityType().getName())) {
            return;
        }
        String srcBillType = payBill.getString("sourcebilltype");
        DynamicObject org = payBill.getDynamicObject("org");
        if (null != org && EmptyUtil.isNoEmpty((String)srcBillType) && !"lc_arrival".equals(srcBillType)) {
            Long orgId = org.getLong("id");
            String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
            Object isOpenSche = SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"psd001");
            if (!EmptyUtil.isEmpty((Object)isOpenSche) && ((Boolean)isOpenSche).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"iswaitsche"});
                Boolean isAddToSchedule = PaymentPayScheduleSource.getInstance().isAddScheduleSource(payBill);
                if (isAddToSchedule.booleanValue()) {
                    this.getModel().setValue("iswaitsche", (Object)"1");
                } else {
                    this.getModel().setValue("iswaitsche", (Object)"0");
                }
            } else {
                this.getModel().setValue("iswaitsche", (Object)"0");
            }
        }
    }

    private boolean exists(Object pk, String entityName) {
        try {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
            return !EmptyUtil.isEmpty((DynamicObject)info);
        }
        catch (Exception e) {
            return false;
        }
    }
}

