/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Image;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.BaseDataHelper;

public class PayBillSynOfPsdCallPlugin
extends BillEditPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String source = (String)fsp.getCustomParam("source");
        if (null != source && source.equals("psd_balancedcheck")) {
            Object orgId = fsp.getCustomParam("orgId");
            Long paymentAcctId = (Long)fsp.getCustomParam("paymentAcctId");
            Object paymentCurrency = fsp.getCustomParam("paymentCurrency");
            BigDecimal balance = (BigDecimal)fsp.getCustomParam("balance");
            String accType = (String)fsp.getCustomParam("accType");
            this.getModel().setValue("org", orgId);
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            this.getModel().setValue("currency", paymentCurrency);
            this.getModel().setValue("payeeaccformid", (Object)accType);
            this.getModel().setValue("payeeacctbank", (Object)paymentAcctId);
            DynamicObject paymentAcct = BusinessDataServiceHelper.loadSingle((Object)paymentAcctId, (String)"am_accountbank");
            this.getModel().setValue("actpayamt", (Object)balance.abs());
            this.getModel().setValue("billtype", (Object)BillTypeConstants.PAYBILL_SYN);
            this.getModel().setValue("payeename", (Object)org.getLocaleString("name").getLocaleValue());
            this.getModel().setValue("payeebanknum", (Object)paymentAcct.getString("bankaccountnumber"));
            this.getModel().setValue("recaccbankname", (Object)paymentAcct.getLocaleString("acctname").getLocaleValue());
            Object bank = paymentAcct.getDynamicObject("bank").getPkValue();
            DynamicObject bdFinorginfo = BusinessDataServiceHelper.loadSingle((Object)bank, (String)"bd_finorginfo");
            DynamicObject bebank = bdFinorginfo.getDynamicObject("bebank");
            this.getModel().setValue("payeebank", bebank.getPkValue());
            this.getModel().setValue("payeebankname", (Object)paymentAcct.getDynamicObject("bank").getString("name"));
            this.getModel().setValue("recbanknumber", (Object)paymentAcct.getDynamicObject("bank").getString("union_number"));
            this.getModel().setValue("openorg", org.getPkValue());
            this.getModel().setValue("payeeformid", (Object)"bos_org");
            this.getModel().setValue("payeetype", (Object)"bos_org");
            this.getModel().setValue("payee", org.getPkValue());
            DynamicObject casCashmgtinit = BusinessDataServiceHelper.loadSingle((String)"cas_cashmgtinit", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", orgId)});
            DynamicObject standardcurrency = casCashmgtinit.getDynamicObject("standardcurrency");
            this.getModel().setValue("basecurrency", standardcurrency.getPkValue());
            this.getModel().setValue("sourcetype", (Object)"CAS");
            this.getModel().setValue("entrance", (Object)"SYN");
            this.getModel().setValue("reccountry", Optional.ofNullable(bebank.getDynamicObject("country")).map(o -> o.getPkValue()).orElseGet(() -> 0L));
            this.getModel().setValue("recprovince", (Object)Optional.ofNullable(bebank).map(o -> o.getString("provincetxt")).orElseGet(() -> ""));
            this.getModel().setValue("reccity", (Object)Optional.ofNullable(bebank).map(o -> o.getString("citytxt")).orElseGet(() -> ""));
            this.getModel().setValue("paymenttype", (Object)993276399341123584L);
            this.getModel().setValue("orgv", (Object)org.getLocaleString("name").getLocaleValue());
            this.getModel().setValue("payeenamev", (Object)org.getLocaleString("name").getLocaleValue());
            Image payeePic = (Image)this.getControl("payeepic");
            String payeeformid = this.getString("payeeformid");
            long payeeId = (Long)this.getValue("payee");
            String defaultUrl = BaseDataHelper.getPictureUrl((Long)payeeId, (String)payeeformid);
            defaultUrl = defaultUrl == null ? "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png" : defaultUrl;
            payeePic.setUrl(defaultUrl);
            this.getView().updateView("payeenamev");
        }
    }
}

