/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;

public class PayCoreBillF7List
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String name = this.getView().getParentView().getModel().getDataEntityType().getName();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        QFilter qFilter = CoreBillSettingHelper.getCoreBillFilter((Map)customParams, (String)name);
        e.getQFilters().add(qFilter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.getPageCache().put("clickBtnOk", "true");
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            this.getPageCache().put("clickBtnOk", "true");
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.getPageCache().put("clickBtnOk", "true");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String clickBtnOk = this.getPageCache().get("clickBtnOk");
        ArrayList returnData = new ArrayList();
        if ("true".equals(clickBtnOk)) {
            ListView listView = (ListView)e.getSource();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Map extQueryFieldMap = (Map)customParams.get("EXT_QUERY_FIELD_MAP");
            DynamicObjectCollection billInfo = this.queryPerformEntities(selectedRows, extQueryFieldMap);
            Map headMap = billInfo.stream().collect(Collectors.toMap(s -> s.get("id"), Function.identity(), (a, b) -> a));
            Map entryMap = billInfo.stream().filter(s -> CasHelper.isNotEmpty((Object)s.get("entry.id"))).collect(Collectors.toMap(s -> s.get("entry.id"), Function.identity()));
            boolean isBatchOp = "true".equals(customParams.get("IS_BATCH_OP"));
            for (ListSelectedRow selectedRow : selectedRows) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                map.put(isBatchOp ? "corebillid" : "e_corebillid", primaryKeyValue);
                map.put(isBatchOp ? "corebillno" : "e_corebillno", selectedRow.getBillNo());
                if (!isBatchOp) {
                    Object entryPrimaryKeyValue = selectedRow.getEntryPrimaryKeyValue();
                    map.put("e_corebillentryid", entryPrimaryKeyValue);
                    if (entryPrimaryKeyValue != null && entryMap.size() > 0) {
                        DynamicObject entryInfo = (DynamicObject)entryMap.get(entryPrimaryKeyValue);
                        map.put("e_corebillentryseq", entryInfo.get("entry.seq"));
                        CoreBillSettingHelper.setExtQueryFieldInfo(map, (Map)extQueryFieldMap, (DynamicObject)entryInfo, (boolean)false);
                    }
                }
                CoreBillSettingHelper.setExtQueryFieldInfo(map, (Map)extQueryFieldMap, (DynamicObject)((DynamicObject)headMap.get(primaryKeyValue)), (boolean)true);
                returnData.add(map);
            }
            this.getView().returnDataToParent(returnData);
        }
        this.getPageCache().remove("clickBtnOk");
        this.getView().returnDataToParent(returnData);
    }

    private DynamicObjectCollection queryPerformEntities(ListSelectedRowCollection selectedRows, Map<String, String> extQueryFieldMap) {
        String extQueryField = "";
        if (extQueryFieldMap != null && extQueryFieldMap.size() > 0) {
            extQueryField = "," + String.join((CharSequence)",", extQueryFieldMap.keySet());
        }
        Set ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)"cas_paybill", (String)("id,actpayamt,entry.id, entry.seq" + extQueryField), (QFilter[])qFilter.toArray());
    }
}

