/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PayInvalidPlugin
extends AbstractFormPlugin {
    private static final String BTN_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BigDecimal recAmount = (BigDecimal)customParams.get("recAmount");
        this.getModel().setValue("recamount", (Object)recAmount);
        BigDecimal lockedAmount = (BigDecimal)customParams.get("lockedAmount");
        this.getModel().setValue("lockedamount", (Object)lockedAmount);
        Object payCurrency = customParams.get("payCurrency");
        if (payCurrency != null) {
            this.getModel().setValue("currency", payCurrency);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (BTN_BTNOK.equals(key)) {
            IDataModel model = this.getModel();
            HashMap<String, BigDecimal> returnData = new HashMap<String, BigDecimal>(2);
            BigDecimal invalidAmount = (BigDecimal)model.getValue("invalidamount");
            if (invalidAmount == null || BigDecimal.ZERO.compareTo(invalidAmount) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62d2\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0\u3002", (String)"PayInvalidPlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal recAmount = (BigDecimal)this.getModel().getValue("recamount");
            if (BigDecimal.ZERO.compareTo(recAmount) < 0 && BigDecimal.ZERO.compareTo(invalidAmount) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62d2\u4ed8\u91d1\u989d\u9700\u8981\u5927\u4e8e0\u3002", (String)"PayInvalidPlugin_03", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (BigDecimal.ZERO.compareTo(recAmount) > 0 && BigDecimal.ZERO.compareTo(invalidAmount) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62d2\u4ed8\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002", (String)"PayInvalidPlugin_04", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal lockedAmount = (BigDecimal)this.getModel().getValue("lockedamount");
            BigDecimal balance = recAmount.subtract(lockedAmount);
            if (invalidAmount.abs().compareTo(balance.abs()) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9501\u5b9a\u91d1\u989d\u7684\u7edd\u5bf9\u503c\u5fc5\u987b\u5927\u4e8e\u62d2\u4ed8\u91d1\u989d\u7684\u7edd\u5bf9\u503c\u3002", (String)"PayInvalidPlugin_02", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            returnData.put("invalidAmount", invalidAmount);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

