/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.cas.business.ebank.impl.EBankExcelFileCreateImpl;
import kd.fi.cas.business.ebank.impl.EBankTxTFileCreateImpl;
import kd.fi.cas.consts.FetchDataReponse;
import kd.fi.cas.consts.FetchDataRequest;
import kd.fi.cas.helper.AppLogHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PayApplyExportNetBankFilePlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PayApplyExportNetBankFilePlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("exportnetbankfile".equals(operateKey)) {
            this.openExportTemplatePage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if ("payapplyexportnetbankfile_callback".equals(args.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)args.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            Long templateId = (Long)returnData.getPrimaryKeyValues()[0];
            this.prepareExportFile(primaryKeyValues, templateId);
        }
    }

    private void prepareExportFile(Object[] primaryKeyValues, Long templateId) {
        String errMsg;
        InputStream txtFileInStream;
        String fileName;
        EBankTxTFileCreateImpl fileCreate;
        FetchDataRequest requestMsg = new FetchDataRequest();
        requestMsg.setBillNo("cas_payapplybill");
        requestMsg.setTemplateId(templateId);
        Set selectPayApplyIds = Arrays.stream(primaryKeyValues).filter(Objects::nonNull).map(o -> Long.valueOf(o.toString())).collect(Collectors.toSet());
        requestMsg.setIdSet(selectPayApplyIds);
        String responseMsgJson = null;
        try {
            String reqMsgJson = SerializationUtils.toJsonString((Object)requestMsg);
            logger.info(String.format("\u7f51\u94f6\u5bfc\u51fa\u63a5\u53e3\u8c03\u7528\u8bf7\u6c42\u62a5\u6587: %s", reqMsgJson));
            responseMsgJson = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"eBankFetchValueHelper", (String)"exportData", (Object[])new Object[]{reqMsgJson});
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7f51\u94f6\u5bfc\u51fa\u63a5\u53e3\u5f02\u5e38: \n" + e);
        }
        if (null == responseMsgJson || responseMsgJson.trim().length() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u6536\u5230\u54cd\u5e94\u62a5\u6587\uff0c\u65e0\u6cd5\u5bfc\u51fa\u7f51\u94f6\u6587\u4ef6\u3002", (String)"PayApplyExportNetBankFilePlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        logger.info(String.format("\u7f51\u94f6\u5bfc\u51fa\u63a5\u53e3\u8c03\u7528\u54cd\u5e94\u62a5\u6587: %s", responseMsgJson));
        FetchDataReponse responseMsg = (FetchDataReponse)SerializationUtils.fromJsonString((String)responseMsgJson, FetchDataReponse.class);
        String url = null;
        if (responseMsg.getHeader().getExportType().equals("txt")) {
            fileCreate = new EBankTxTFileCreateImpl(this.getView(), "cas_payapplybill");
            fileName = fileCreate.getTemporaryFilename("cas_payapplybill", ".txt");
            try {
                txtFileInStream = fileCreate.createFileContent(responseMsg, new Object[0]);
                url = fileCreate.writeTemporaryFile(txtFileInStream, fileName);
            }
            catch (Exception e) {
                errMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u751f\u6210 TXT \u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"InternetBankExport_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e));
                InputStream txtFileInStream2 = fileCreate.createFileContent(errMsg);
                try {
                    url = fileCreate.writeTemporaryFile(txtFileInStream2, fileName);
                }
                catch (IOException ex) {
                    throw new KDBizException(ex.getMessage());
                }
            }
        } else if (responseMsg.getHeader().getExportType().equals("xls")) {
            fileCreate = new EBankExcelFileCreateImpl(this.getView(), "cas_payapplybill");
            fileName = fileCreate.getTemporaryFilename("cas_payapplybill", ".xlsx");
            try {
                txtFileInStream = fileCreate.createFileContent(responseMsg, new Object[]{ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7f51\u94f6\u5bfc\u51fa\u6570\u636e", (String)"PayBillExportFilesList_0", (String)"fi-cas-formplugin", (Object[])new Object[0])});
                url = fileCreate.writeTemporaryFile(txtFileInStream, fileName);
            }
            catch (Exception e) {
                errMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u751f\u6210EXCEL \u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"InternetBankExport_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e));
                InputStream txtFileInStream3 = fileCreate.createFileContent(errMsg);
                try {
                    url = fileCreate.writeTemporaryFile(txtFileInStream3, fileName);
                }
                catch (IOException ex) {
                    throw new KDBizException(ex.getMessage());
                }
            }
        }
        if (url != null) {
            this.getView().download(url);
        }
        Map failureDatas = responseMsg.getBody().getFailureDatas();
        MultiLangEnumBridge opDesc = AppLogHelper.buildMultiLangBridge((String)"\u672c\u6b21\u5bfc\u51fa\u5171%1$s\u6761\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"PayBillExportFilesList_1", (String)"fi-cas-formplugin");
        MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u5bfc\u51fa\u7f51\u94f6\u6587\u4ef6", (String)"PayBillExportFilesList_2", (String)"fi-cas-formplugin");
        AppLogInfo appLogInfo = AppLogHelper.createAppLog((String)"cas_payapplybill", (long)RequestContext.get().getOrgId(), (String)"exportnetbankfile", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDesc, (Object[])new Object[]{primaryKeyValues.length, primaryKeyValues.length - failureDatas.size(), failureDatas.size()});
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private void openExportTemplatePage() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() <= 0) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"fbd_export_template", (boolean)false);
        List filters = lsp.getListFilterParameter().getQFilters();
        QFilter qf = new QFilter("bizobject.number", "=", (Object)"cas_payapplybill");
        qf.and(new QFilter("enable", "=", (Object)"1"));
        if (null != filters) {
            filters.add(qf);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "payapplyexportnetbankfile_callback");
        lsp.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void showErrorMessage(List<String> errMsgs, String title) {
        if (errMsgs.size() > 1) {
            this.getView().showMessage(title, errMsgs.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
        } else if (errMsgs.size() == 1) {
            this.getView().showErrorNotification(errMsgs.get(0));
        }
    }
}

