/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.AbstractCasBillListPlugin;
import kd.fi.cas.formplugin.payapply.PayApplyEntryEdit;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.LoggerPrintHelper;
import kd.fi.cas.helper.PayApplyHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyList
extends AbstractCasBillListPlugin {
    private static Log logger = LogFactory.getLog(PayApplyList.class);
    private static final String CFMARRIVAL = "cfmArrival";
    private static final List<String> CFMARRIVALOP = Arrays.asList("save", "submit", "comfirmsche");
    private static final String BAR_BATCH_INPUT = "batchinput";

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        ArrayList<String> errList;
        DynamicObject[] payApplyBills;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        FormOperate source = (FormOperate)beforeDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        List<Long> selectedIdList = this.getSelectedIdList();
        if ("batchsche".equals(operateKey)) {
            if (selectedIdList == null || selectedIdList.isEmpty()) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            for (DynamicObject payApplyBill : payApplyBills = BusinessDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"))) {
                DynamicObjectCollection payApplyEntry = payApplyBill.getDynamicObjectCollection("cas_payapplyentry");
                Set settlementType = payApplyEntry.stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet());
                if (!settlementType.contains(SettleMentTypeEnum.DCEP.getValue())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u201c%s\u201d\u7684\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u6570\u5e01\u94b1\u5305\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u6392\u6b3e\u3002", (String)"PayApplyEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[]{payApplyBill.getString("billno")}));
                break;
            }
            FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
            operate.getOption().setVariableValue("strictvalidation", String.valueOf(true));
        }
        if ("push".equals(operateKey)) {
            if (selectedIdList == null || selectedIdList.isEmpty()) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            payApplyBills = BusinessDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"));
            errList = new ArrayList<String>(10);
            ListSelectedRowCollection listSelectedData = beforeDoOperationEventArgs.getListSelectedData();
            for (DynamicObject payApplyBill : payApplyBills) {
                DynamicObjectCollection payApplyEntry = payApplyBill.getDynamicObjectCollection("cas_payapplyentry");
                BigDecimal payApplyAmt = payApplyEntry.stream().filter(Objects::nonNull).map(entry -> entry.getBigDecimal("e_payeeamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                DynamicObjectCollection payInfoEntry = payApplyBill.getDynamicObjectCollection("cas_payinfo");
                BigDecimal payInfoAmt = payInfoEntry.stream().filter(Objects::nonNull).map(entry -> {
                    BigDecimal val = BigDecimal.ZERO;
                    String payStatus = entry.getString("entry_paystatus");
                    if (!payStatus.equals(PayStatusEnum.CLANCEL.getValue())) {
                        val = entry.getBigDecimal("entry_payeeamount");
                    }
                    return val;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (payApplyBill.getBoolean("refundandrepay")) {
                    BigDecimal refundAmount = payInfoEntry.stream().filter(e -> !PayStatusEnum.CLANCEL.getValue().equals(e.getString("entry_paystatus"))).filter(e -> EmptyUtil.isNoEmpty((BigDecimal)e.getBigDecimal("entry_refundamount"))).map(e -> e.getBigDecimal("entry_refundamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    payInfoAmt = payInfoAmt.subtract(refundAmount);
                }
                if (payInfoAmt.compareTo(payApplyAmt) == 0) continue;
                String errMsg = String.format(ResManager.loadKDString((String)"%s: \u7533\u8bf7\u660e\u7ec6\u5206\u5f55\u548c\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7684\u6536\u6b3e\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u63a8\u4ed8\u6b3e\u3002", (String)"PayApplyEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), payApplyBill.getString("billno"));
                errList.add(errMsg);
                listSelectedData.remove(payApplyBill.getPkValue());
            }
            if (!errList.isEmpty()) {
                this.showErrMessage(errList);
            }
            if (PayApplyHelper.checkPayeeTypeFreeze(Arrays.asList(payApplyBills))) {
                this.getView().showErrorNotification(new PaymentErrorCode().CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
                beforeDoOperationEventArgs.setCancel(true);
            }
            beforeDoOperationEventArgs.setListSelectedData(listSelectedData);
        }
        if ("submit".equals(operateKey)) {
            if (selectedIdList == null || selectedIdList.isEmpty()) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            payApplyBills = BusinessDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"));
            errList = new ArrayList(0);
            for (DynamicObject payApplyBill : payApplyBills) {
                BigDecimal payeeamount = payApplyBill.getBigDecimal("payeeamount");
                BigDecimal e_payeeamount = BigDecimal.ZERO;
                for (DynamicObject payApply : payApplyBill.getDynamicObjectCollection("cas_payapplyentry")) {
                    e_payeeamount = e_payeeamount.add(payApply.getBigDecimal("e_payeeamount"));
                }
                if (payeeamount.compareTo(e_payeeamount) != 0) {
                    selectedIdList.remove(payApplyBill.getPkValue());
                    errList.add(String.format(ResManager.loadKDString((String)"%s\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5e94\u7b49\u4e8e\u6536\u6b3e\u603b\u989d\u3002", (String)"PayApplyEntryEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)payApplyBill.getString("billno"), "\u3010", "\u3011")));
                    continue;
                }
                BigDecimal entry_payeeamount = BigDecimal.ZERO;
                for (DynamicObject payInfo : payApplyBill.getDynamicObjectCollection("cas_payinfo").stream().filter(item -> !PayStatusEnum.CLANCEL.getValue().equals(item.getString("entry_paystatus"))).collect(Collectors.toList())) {
                    entry_payeeamount = entry_payeeamount.add(payInfo.getBigDecimal("entry_payeeamount"));
                }
                if (payeeamount.compareTo(entry_payeeamount) == 0) continue;
                selectedIdList.remove(payApplyBill.getPkValue());
                errList.add(String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)payApplyBill.getString("billno"), "\u3010", "\u3011")));
            }
            if (!errList.isEmpty()) {
                this.getView().showErrorNotification(String.join((CharSequence)"\r\n", errList));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
        }
        if (CFMARRIVALOP.contains(operateKey)) {
            if (selectedIdList == null || selectedIdList.isEmpty()) {
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            payApplyBills = BusinessDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"));
            ArrayList<String> cfmArrivalMsgList = new ArrayList<String>(0);
            for (DynamicObject payApplyBill : payApplyBills) {
                DynamicObjectCollection payInfoEntry = payApplyBill.getDynamicObjectCollection("cas_payinfo");
                cfmArrivalMsgList.addAll(PayApplyEntryEdit.checkArrivalUnlockAmt(payInfoEntry));
            }
            if (cfmArrivalMsgList.size() > 0) {
                this.getPageCache().put("checkOp", operateKey);
                if (!Boolean.parseBoolean(this.getPageCache().get("checkOpResult"))) {
                    this.getView().showConfirm(String.join((CharSequence)"\n", cfmArrivalMsgList), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CFMARRIVAL, (IFormPlugin)this));
                    beforeDoOperationEventArgs.setCancel(true);
                    return;
                }
                this.getPageCache().put("checkOpResult", Boolean.FALSE.toString());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sourceApp = (String)this.getView().getFormShowParameter().getCustomParam("sourceApp");
        if ("dhc".equals(sourceApp)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"batchsche", "comfirmsche", "tblpushtopaybill"});
        }
        this.getPageCache().put("sourceApp", sourceApp);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter showParameter = e.getParameter();
        showParameter.setCustomParam("sourceApp", (Object)this.getPageCache().get("sourceApp"));
        Long billId = (Long)showParameter.getPkId();
        Boolean iscopy = (Boolean)showParameter.getCustomParam("iscopy");
        DynamicObject payApply = BusinessDataServiceHelper.loadSingle((String)"cas_payapplybill", (String)"invalidflag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        boolean invalidflag = Optional.ofNullable(payApply).map(o -> o.getBoolean("invalidflag")).orElseGet(() -> false);
        if (billId != null && invalidflag && (iscopy != null && !iscopy.booleanValue() || iscopy == null)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        List<Long> selectIds = this.getSelectedIdList();
        if (key.equals("tblpushtopaybill")) {
            DynamicObject[] infoObjs;
            QFilter filter = new QFilter("id", "in", selectIds);
            QFilter[] filters = new QFilter[]{filter};
            for (DynamicObject info : infoObjs = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id,invalidflag,billstatus,cas_payapplyentry,cas_payapplyentry.e_chgstatus,cas_payinfo,cas_payinfo.entry_paystatus,cas_payinfo.entry_expectdate", (QFilter[])filters)) {
                if (info.getBoolean("invalidflag")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String billStatus = (String)info.get("billstatus");
                if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u7684\u7533\u8bf7\u5355\u5141\u8bb8\u4e0b\u63a8\u4ed8\u6b3e\u5904\u7406", (String)"PayApplyEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection applyEntryCol = info.getDynamicObjectCollection("cas_payapplyentry");
                applyEntryCol.stream().filter(Objects::nonNull).forEach(entry -> {
                    String chgstatus = entry.getString("e_chgstatus");
                    if (chgstatus.equals(PayApplyRecChgStatusEnum.CHGING.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u7533\u8bf7\u5206\u5f55\u6570\u636e\u5904\u4e8e\u201c\u53d8\u66f4\u4e2d\u201d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyComfirmScheValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                });
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String operateKey = op.getOperateKey();
        if ("batchsche".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            List<Object> successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            successPkIds = successPkIds.stream().filter(pk -> {
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"cas_payapplybill", (String)"id, billno, cas_payapplyentry, cas_payapplyentry.e_settlementtype", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
                DynamicObjectCollection payEntry = bill.getDynamicObjectCollection("cas_payapplyentry");
                Set settlementType = payEntry.stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet());
                return !settlementType.contains(SettleMentTypeEnum.DCEP.getValue());
            }).collect(Collectors.toList());
            this.showDoSchePage(successPkIds);
        } else if ("invalid".equals(operateKey)) {
            List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            this.showInvalidMsg(successPkIds, afterDoOperationEventArgs.getOperationResult().getValidateResult());
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            this.refreshList();
        } else if ("canclecomfirmsche".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        } else if ("comfirmsche".equals(operateKey)) {
            String opKey = this.getView().getPageCache().get("op");
            if ("comfirmscheandpushpay".equals(opKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("push");
                this.getView().getPageCache().remove("op");
            }
            this.refreshList();
        } else if (BAR_BATCH_INPUT.equals(operateKey)) {
            CasPluginHelper.viewBatchInput((IFormView)this.getView(), (String)"cas_batchpayapply");
        }
    }

    private void showInvalidMsg(List<Object> successPkIds, ValidateResultCollection tValidateResult) {
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"PayApplyList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), successPkIds.size() + tValidateResult.getErrorDataIndexs().size(), successPkIds.size(), tValidateResult.getErrorDataIndexs().size());
        ArrayList errorMsgs = new ArrayList();
        tValidateResult.getValidateErrors().forEach(ValidateResult2 -> ValidateResult2.getAllErrorInfo().forEach(OperateErrorInfo2 -> {
            String[] errMsg = OperateErrorInfo2.getMessage().split(":");
            if (errMsg.length > 1) {
                errorMsgs.add(ResManager.loadKDString((String)String.format("\u3010%s\u3011%s", errMsg[0], errMsg[1].trim()), (String)"PayApplyList_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                errorMsgs.add(OperateErrorInfo2.getMessage());
            }
        }));
        if (errorMsgs.size() > 0) {
            this.getView().showMessage(title, errorMsgs.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
        } else if (successPkIds.size() > 0) {
            this.getView().showSuccessNotification(title);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (CFMARRIVAL.equals(id) && MessageBoxResult.Yes.equals((Object)res) && CFMARRIVALOP.contains(this.getPageCache().get("checkOp"))) {
            this.getPageCache().put("checkOpResult", Boolean.TRUE.toString());
            this.getView().invokeOperation(this.getPageCache().get("checkOp"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("DOSCHE_CALLBACK".equals(actionId)) {
            Map params = (Map)closedCallBackEvent.getReturnData();
            if (null == params) {
                return;
            }
            String op = (String)params.get("op");
            this.getView().getPageCache().put("op", op);
            String doScheJSONStr = (String)params.get("doScheInfo");
            List successPkIds = JSON.parseArray((String)((String)params.get("successPkIds")), Long.class);
            logger.info(String.format("\u6392\u6b3e\u4fe1\u606f\u754c\u9762\u4f20\u9012\u7684\u53c2\u6570: \u64cd\u4f5c\u7c7b\u578b = {%s}; \u6392\u6b3e\u4fe1\u606f = {%s}; \u6821\u9a8c\u6210\u529f\u7684ID = {%s}", op, doScheJSONStr, LoggerPrintHelper.printCollectionLogger((Collection)successPkIds)));
            OperateOption option = OperateOption.create();
            option.setVariableValue("doScheInfo", doScheJSONStr);
            option.setVariableValue("isCheck", "0");
            this.getView().invokeOperation("comfirmsche", option);
        }
    }

    public void showDoSchePage(List<Object> successPkIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_doscheinfo");
        showParameter.setAppId("cas");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("successPkIds", successPkIds);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "DOSCHE_CALLBACK"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
        if (selectedRows.isEmpty()) {
            return null;
        }
        for (ListSelectedRow listSelectedRowValue : selectedRows) {
            idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
        }
        return idList;
    }

    private void refreshList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672c\u6b21\u6279\u91cf\u4e0b\u63a8\u5931\u8d25\u3002\u5b58\u5728\u4e0d\u53ef\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"PayApplyEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }
}

