/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.payapply.PayApplyEntryEdit;
import kd.fi.cas.formplugin.payapply.PaymentChannelHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.pojo.ModelRequestBean;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class PayApplySplitPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(PayApplySplitPlugin.class);
    private static final String BILLID = "billid";
    private static final String CAS_PAYINFO_SEL = "cas_payinfo_sel";
    private static final String NEWENTRYINFO = "newentryinfo";
    private static final String BILL = "bill";
    private static final String PKVALUE = "pkValue";
    private static final String BTNOK = "btnok";
    private static final String BTNOK_CALLBACK = "btnok_callback";
    private static final String[] FIELD_COMPARE = new String[]{"entry_settlementtype", "entry_payeraccbank", "entry_paymentchannel"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit settletNumber = (TextEdit)this.getView().getControl("entry_settletnumber");
        settletNumber.addButtonClickListener((ClickListener)this);
        PayApplyEntryEdit.initDraftAmtTotal(this.getView());
        PayApplyEntryEdit.initArrivalUnlockAmt(this.getView());
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("entry_settletnumber".equals(key)) {
            DynamicObject settleType = (DynamicObject)this.getModel().getValue("entry_settlementtype");
            if (PayApplyEntryEdit.isDraftbillSettlement(settleType)) {
                evt.setCancel(false);
            } else if (PayApplyEntryEdit.isArrivalSettlement(settleType)) {
                evt.setCancel(false);
            } else {
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "entry_settletnumber": {
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("entry_settlementtype");
                if (PayApplyEntryEdit.isDraftbillSettlement(settleType)) {
                    this.draftbillSettlementClick();
                    break;
                }
                if (!PayApplyEntryEdit.isArrivalSettlement(settleType)) break;
                this.arrivalSettlementClick();
            }
        }
    }

    private void arrivalSettlementClick() {
        Object currency = this.getModel().getValue("payeecurrency");
        if (CasHelper.isEmpty((Object)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object payeetype = this.getModel().getValue("entry_payeetype");
        Object payeename = this.getModel().getValue("entry_payeename");
        if (CasHelper.isEmpty((Object)payeetype) || CasHelper.isEmpty((Object)payeename)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object org = this.getModel().getValue("payorg");
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"lc_arrival", (boolean)false);
        Object payeeId = this.getModel().getValue("entry_payeeid");
        Object payeeAmount = this.getModel().getValue("entry_payeeamount");
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("entry_settlementtype");
        String settlementType = settleType.getString("settlementtype");
        QFilter qFilter = PayApplyEntryEdit.getArrivalNoQFilter((DynamicObject)org, (DynamicObject)currency, payeetype.toString(), (Long)payeeId, payeename.toString(), (BigDecimal)payeeAmount, settlementType);
        showParameter.getListFilterParameter().setFilter(qFilter);
        EntryGrid entryentity1 = (EntryGrid)this.getView().getControl("cas_payinfo");
        int[] selectRows = entryentity1.getSelectRows();
        if (selectRows.length >= 1) {
            int index = selectRows[0];
            DynamicObject cas_payinfo_sel = this.getModel().getEntryRowEntity("cas_payinfo", index);
            this.getPageCache().put(PKVALUE, cas_payinfo_sel.getPkValue().toString());
        }
        showParameter.setIsolationOrg(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "settletnumber"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void draftbillSettlementClick() {
        Object payeetype = this.getModel().getValue("entry_payeetype");
        if (CasHelper.isEmpty((Object)payeetype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"PayApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        MulBasedataEdit draftbill = (MulBasedataEdit)this.getControl("entry_draftbill");
        draftbill.addBeforeF7SelectListener(e -> {
            Object currency = this.getModel().getValue("payeecurrency");
            if (CasHelper.isEmpty((Object)currency)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object payeename = this.getModel().getValue("entry_payeename");
            if (CasHelper.isEmpty((Object)payeename)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            DynamicObject org = this.getModel().getValue("payorg") == null ? null : (DynamicObject)this.getModel().getValue("payorg");
            ArrayList ids = new ArrayList(0);
            List<Object> lockIds = new ArrayList(0);
            try {
                DynamicObject payApplyBillFromDB = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue(BILLID), (String)"cas_payapplybill");
                lockIds = PayApplyEntryEdit.getDraftBillList(payApplyBillFromDB.getDynamicObjectCollection("cas_payinfo"), true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            List<Long> otherIds = PayApplyEntryEdit.getDraftBillList(this.getModel().getEntryEntity("cas_payinfo"), false);
            lockIds.removeAll(otherIds);
            DynamicObjectCollection draftbillColls = (DynamicObjectCollection)this.getModel().getValue("entry_draftbill");
            if (draftbillColls != null && draftbillColls.size() > 0) {
                ids.addAll(draftbillColls.stream().map(coll -> coll.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
                lockIds.addAll(ids);
            }
            Object settleType = this.getModel().getValue("entry_settlementtype");
            Object payeeId = this.getModel().getValue("entry_payeeid");
            QFilter qFilter = PayApplyEntryEdit.getDraftBillQFilter(org, (DynamicObject)settleType, (DynamicObject)currency, payeetype.toString(), (Long)payeeId, payeename.toString(), this.getModel().getDataEntity().getPkValue(), lockIds);
            otherIds.removeAll(ids);
            if (otherIds.size() > 0) {
                qFilter.and(new QFilter("id", "not in", otherIds));
            }
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
        draftbill.click();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        int rowIndex = changeData.getRowIndex();
        if ("entry_payeeamount".equals(fieldKey)) {
            boolean isSame;
            BigDecimal payeeAmount = (BigDecimal)this.getModel().getValue("e_payeeamount");
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            boolean bl = isSame = payeeAmount.signum() == newValue.signum();
            if (!isSame) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u6536\u6b3e\u91d1\u989d\u65b9\u5411\u4e0e\u62c6\u5206\u524d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u8bb0\u5f55\u3002", (String)"PayApplySplitPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entry_payeeamount", null, rowIndex);
                return;
            }
            boolean isDeficit = false;
            DynamicObject payOrg = (DynamicObject)this.getModel().getValue("payorg");
            if (payOrg != null) {
                isDeficit = SystemParameterHelper.getParameterBoolean((long)payOrg.getLong("id"), (String)"isdeficit");
            }
            if (!isDeficit && BigDecimal.ZERO.compareTo(newValue) >= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u5e94\u5927\u4e8e0\u3002", (String)"PayApplySplitPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("entry_settlementtype".equals(fieldKey)) {
            String newType;
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (EmptyUtil.isEmpty((DynamicObject)newValue) || EmptyUtil.isEmpty((DynamicObject)oldValue)) {
                return;
            }
            String oldType = (String)oldValue.get("settlementtype");
            if (!oldType.equals(newType = (String)newValue.get("settlementtype")) && (SettleMentTypeEnum.VIRTUAL.getValue().equals(oldType) || SettleMentTypeEnum.VIRTUAL.getValue().equals(newType))) {
                model.setValue("entry_payeraccbank", null, rowIndex);
            }
            if (PayApplyEntryEdit.isDraftbillSettlement(oldValue) != PayApplyEntryEdit.isDraftbillSettlement(newValue)) {
                model.setValue("entry_draftbill", null, rowIndex);
            }
            if (PayApplyEntryEdit.isArrivalSettlement(oldValue) != PayApplyEntryEdit.isArrivalSettlement(newValue)) {
                model.setValue("entry_arrivalno", null, rowIndex);
            }
            PayApplyEntryEdit.initDraftAmtTotal(this.getView());
            PayApplyEntryEdit.initArrivalUnlockAmt(this.getView());
            PaymentChannelHelper.initPaymentChannel(rowIndex, newValue, (DynamicObject)model.getValue("entry_payeraccbank", rowIndex), this.getView());
        } else if ("entry_paymentchannel".equals(fieldKey)) {
            String newValue = (String)changeData.getNewValue();
            String oldValue = (String)changeData.getOldValue();
            DynamicObject payerAccBank = (DynamicObject)model.getValue("entry_payeraccbank", rowIndex);
            String result = PayApplyEntryEdit.checkPaymentChannel(payerAccBank, newValue);
            if (result != null) {
                model.setValue("entry_paymentchannel", (Object)oldValue, rowIndex);
                this.getView().showErrorNotification(result);
            }
        } else if ("entry_draftbill".equals(fieldKey)) {
            DynamicObjectCollection newValue = (DynamicObjectCollection)changeData.getNewValue();
            CharSequence[] draftbillnos = (String[])newValue.stream().map(coll -> coll.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
            model.setValue("entry_settletnumber", (Object)String.join((CharSequence)"\uff1b", draftbillnos), rowIndex);
            BigDecimal draftamttotal = BigDecimal.ZERO;
            List amountList = newValue.stream().map(coll -> coll.getDynamicObject("fbasedataid").getBigDecimal("amount")).collect(Collectors.toList());
            for (BigDecimal amount : amountList) {
                draftamttotal = draftamttotal.add(amount);
            }
            model.setValue("entry_draftamttotal", (Object)draftamttotal, rowIndex);
        } else if ("entry_arrivalno".equals(fieldKey)) {
            int index = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            BigDecimal arrivalunlockamt = null;
            String settletnumber = null;
            if (newValue != null) {
                DynamicObject arrivalBill = BusinessDataServiceHelper.loadSingle((Object)newValue, (String)"lc_arrival");
                arrivalunlockamt = arrivalBill.getBigDecimal("todoamount").subtract(arrivalBill.getBigDecimal("lockamount"));
                settletnumber = arrivalBill.getString("arrivalno");
            }
            model.setValue("entry_settletnumber", settletnumber, index);
            model.setValue("entry_arrivalunlockamt", arrivalunlockamt, index);
        } else if ("entry_settletnumber".equals(fieldKey)) {
            DynamicObject settleType = (DynamicObject)this.getModel().getValue("entry_settlementtype", rowIndex);
            if (PayApplyEntryEdit.isDraftbillSettlement(settleType)) {
                DynamicObjectCollection draftBill = (DynamicObjectCollection)model.getValue("entry_draftbill", rowIndex);
                if (draftBill != null && draftBill.size() > 0) {
                    String newValue = (String)changeData.getNewValue();
                    if (newValue == null || newValue.length() < 1) {
                        model.setValue("entry_draftbill", null, rowIndex);
                    } else {
                        CharSequence[] draftbillnos = (String[])draftBill.stream().map(coll -> coll.getDynamicObject("fbasedataid").getString("draftbillno")).toArray(String[]::new);
                        if (!String.join((CharSequence)"\uff1b", draftbillnos).equals(newValue)) {
                            model.setValue("entry_settletnumber", (Object)String.join((CharSequence)"\uff1b", draftbillnos), rowIndex);
                        }
                    }
                } else {
                    model.setValue("entry_settletnumber", null, rowIndex);
                }
            } else if (PayApplyEntryEdit.isArrivalSettlement(settleType)) {
                String newValue = (String)changeData.getNewValue();
                if (newValue == null || newValue.length() < 1) {
                    model.setValue("entry_arrivalno", null, rowIndex);
                } else {
                    model.setValue("entry_arrivalno", model.getValue("entry_arrivalno", rowIndex), rowIndex);
                }
            }
        } else if ("entry_payeraccbank".equals(fieldKey) || "entry_paycurrency".equals(fieldKey)) {
            this.updateBalance(new int[]{rowIndex});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryevent = e.getEntryProp();
        IDataModel model = this.getModel();
        if ("cas_payinfo".equals(entryevent.getName())) {
            int[] idxs;
            String pkValue = (String)model.getValue(CAS_PAYINFO_SEL);
            for (int idx : idxs = e.getRowIndexs()) {
                DynamicObject entryentity_sel = model.getEntryRowEntity(entryevent.getName(), idx);
                if (!PayStatusEnum.NOTPAYING.getValue().equals(entryentity_sel.getString("entry_paystatus"))) {
                    e.setCancel(true);
                } else if (entryentity_sel.getPkValue() != null && pkValue.equals(entryentity_sel.getPkValue().toString())) {
                    e.setCancel(true);
                } else if (entryentity_sel.getBoolean("entry_invalid")) {
                    e.setCancel(true);
                }
                if (!e.isCancel()) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4ed8\u6b3e\u4e14\u975e\u5f85\u62c6\u5206\u884c\uff0c\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"PayApplySplitPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object oSource = args.getSource();
        if (oSource instanceof FormOperate) {
            FormOperate source = (FormOperate)args.getSource();
            String opKey = source.getOperateKey();
            IDataModel model = this.getModel();
            if (BTNOK.equals(opKey)) {
                boolean isDeficit = false;
                DynamicObject payOrg = (DynamicObject)this.getModel().getValue("payorg");
                if (payOrg != null) {
                    isDeficit = SystemParameterHelper.getParameterBoolean((long)payOrg.getLong("id"), (String)"isdeficit");
                }
                DynamicObjectCollection entryentity1 = model.getEntryEntity("cas_payinfo");
                if (!isDeficit && !this.chkAmount(entryentity1)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u5e94\u5927\u4e8e0\u3002", (String)"PayApplySplitPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancelMessage(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u5e94\u5927\u4e8e0\u3002", (String)"PayApplySplitPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (!this.chkTotalamount(model.getEntryEntity("cas_payapplyentry"), entryentity1)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u8bb0\u5f55", (String)"PayApplySplitPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancelMessage(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6539\u62c6\u5206\u8bb0\u5f55", (String)"PayApplySplitPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    String error = this.checkPaymentChannel();
                    if (StringUtils.isNotEmpty((CharSequence)error)) {
                        this.getView().showTipNotification(error);
                        args.setCancel(true);
                        return;
                    }
                    String result = this.comparePayInfoData(model.getEntryEntity("cas_payinfo"));
                    if (result != null) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTNOK_CALLBACK, (IFormPlugin)this);
                        this.getView().showConfirm(result, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    } else {
                        this.doBtnOk(model);
                    }
                }
            }
        }
    }

    private String checkPaymentChannel() {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("cas_payinfo");
        for (int i = 0; i < entry.size(); ++i) {
            List paymentChannels;
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject settlementType = row.getDynamicObject("entry_settlementtype");
            if (settlementType == null) continue;
            String paymentChannel = settlementType.getString("paymentchannel");
            String currentPaymentChannel = row.getString("entry_paymentchannel");
            if (!StringUtils.isNotEmpty((CharSequence)paymentChannel) || !StringUtils.isNotEmpty((CharSequence)currentPaymentChannel) || (paymentChannels = Arrays.stream(paymentChannel.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList())).contains(currentPaymentChannel)) continue;
            ArrayList<String> channelNames = new ArrayList<String>(paymentChannels.size());
            for (String channel : paymentChannels) {
                channelNames.add(PaymentChannelEnum.getName((String)channel));
            }
            String join = String.join((CharSequence)",", channelNames);
            sb.append(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u3010%1$s\u3011\u7684\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u4e3a\u3010%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplySplitPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), settlementType.getString("name"), join)).append("\r\n");
        }
        return sb.toString();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"settletnumber") && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            PayApplyEntryEdit.setEntryArrivalNo(this.getModel(), "cas_payinfo", this.getPageCache().get(PKVALUE), rows.get(0).getPrimaryKeyValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (BTNOK_CALLBACK.equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            this.doBtnOk(this.getModel());
        }
    }

    private void doBtnOk(IDataModel model) {
        DynamicObject bill = model.getDataEntity();
        model.getEntryEntity("cas_payapplyentry");
        model.getEntryEntity("cas_payinfo");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("splitbill", SerializeHelper.serializeDynamicObj((Object)bill));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entryapplyid = "0";
        if (params != null && params.size() > 0) {
            entryapplyid = (String)params.get("entry_applyid");
        }
        returnData.put("entry_applyid", entryapplyid);
        returnData.put(PKVALUE, this.getModel().getValue(CAS_PAYINFO_SEL));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        IDataModel model = this.getModel();
        if (NEWENTRYINFO.equals(opKey)) {
            EntryGrid entryentity1 = (EntryGrid)this.getView().getControl("cas_payinfo");
            int[] selectRows = entryentity1.getSelectRows();
            if (selectRows.length == 1) {
                DynamicObject entryentity_sel = model.getEntryRowEntity("cas_payinfo", selectRows[0]);
                this.copyNewPayInfoData(model.getEntryEntity("cas_payinfo"), entryentity_sel);
            } else {
                String pkValue = (String)model.getValue(CAS_PAYINFO_SEL);
                DynamicObjectCollection caspayinfos = model.getEntryEntity("cas_payinfo");
                for (int idx = 0; idx < caspayinfos.size(); ++idx) {
                    DynamicObject entryentitysel = (DynamicObject)caspayinfos.get(idx);
                    if (entryentitysel.getPkValue() == null || !pkValue.equals(entryentitysel.getPkValue().toString())) continue;
                    this.copyNewPayInfoData(model.getEntryEntity("cas_payinfo"), entryentitysel);
                    break;
                }
            }
            this.getView().updateView("cas_payinfo");
        }
    }

    private boolean chkAmount(DynamicObjectCollection payInfoEntry) {
        for (DynamicObject payInfo : payInfoEntry) {
            if (BigDecimal.ZERO.compareTo(payInfo.getBigDecimal("entry_payeeamount")) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean chkTotalamount(DynamicObjectCollection payapplyentry, DynamicObjectCollection payInfoEntry) {
        BigDecimal entry_payeeamount = BigDecimal.ZERO;
        if (payapplyentry != null && payapplyentry.size() > 0) {
            for (DynamicObject payapply : payapplyentry) {
                entry_payeeamount = entry_payeeamount.add(payapply.getBigDecimal("e_payeeamount"));
            }
        }
        BigDecimal sumpayinfoentry = BigDecimal.ZERO;
        if (payInfoEntry != null && payInfoEntry.size() > 0) {
            for (DynamicObject payInfo : payInfoEntry) {
                if (PayStatusEnum.CLANCEL.getValue().equals(payInfo.getString("entry_paystatus"))) continue;
                sumpayinfoentry = sumpayinfoentry.add(payInfo.getBigDecimal("entry_payeeamount"));
            }
        }
        return entry_payeeamount.compareTo(sumpayinfoentry) == 0;
    }

    private String comparePayInfoData(DynamicObjectCollection payInfoEntry) {
        for (int a = 0; a < payInfoEntry.size(); ++a) {
            for (int b = a + 1; b < payInfoEntry.size(); ++b) {
                if (!this.comparePayInfoData((DynamicObject)payInfoEntry.get(a), (DynamicObject)payInfoEntry.get(b))) continue;
                return String.format(ResManager.loadKDString((String)"\u9664\u6536\u6b3e\u91d1\u989d\u5916\uff0c\u7b2c %1$s \u884c\u548c\u7b2c %2$s \u884c\u6240\u6709\u4fe1\u606f\u5747\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u62c6\u5206", (String)"PayApplySplitPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), a + 1, b + 1);
            }
        }
        return null;
    }

    private boolean comparePayInfoData(DynamicObject aData, DynamicObject bData) {
        if (PayStatusEnum.NOTPAYING.getValue().equals(aData.getString("entry_paystatus")) && PayStatusEnum.NOTPAYING.getValue().equals(bData.getString("entry_paystatus"))) {
            for (String entryProperty : FIELD_COMPARE) {
                try {
                    if (aData.get(entryProperty) != null && bData.get(entryProperty) != null) {
                        Object aDataProperty = aData.get(entryProperty);
                        if (!(aDataProperty instanceof String ? !aData.getString(entryProperty).equals(bData.getString(entryProperty)) : aDataProperty instanceof DynamicObject && !aData.getDynamicObject(entryProperty).getPkValue().equals(bData.getDynamicObject(entryProperty).getPkValue()))) continue;
                        return false;
                    }
                    if (aData.get(entryProperty) == null && bData.get(entryProperty) == null) continue;
                    return false;
                }
                catch (Exception e) {
                    logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            return true;
        }
        return false;
    }

    private void copyNewPayInfoData(DynamicObjectCollection payInfoEntry, DynamicObject oldData) {
        DynamicObject newEntryData = payInfoEntry.addNew();
        Set entryPropertyS = EntityPropertyHelper.getEntryPropertys((String)"cas_payapplybill", (String)"cas_payinfo");
        for (String entryProperty : entryPropertyS) {
            try {
                newEntryData.set(entryProperty, oldData.get(entryProperty));
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        newEntryData.set("id", (Object)DB.genLongId((String)"cas_payinfo"));
        newEntryData.set("entry_payeraccbank", null);
        newEntryData.set("entry_payerbank", null);
        newEntryData.set("entry_balance", null);
        newEntryData.set("entry_paymentchannel", null);
        newEntryData.set("entry_payeeamount", null);
        newEntryData.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
        newEntryData.set("entry_statusexplain", null);
        newEntryData.set("entry_lastmodifytime", null);
        newEntryData.set("entry_paydate", null);
        newEntryData.set("entry_paybillno", null);
        newEntryData.set("entry_draftbill", null);
        newEntryData.set("entry_settletnumber", null);
        newEntryData.set("entry_draftamttotal", null);
        newEntryData.set("entry_isdiffcur", null);
        newEntryData.set("entry_paycurrency", null);
        newEntryData.set("entry_exratetable", null);
        newEntryData.set("entry_exchangerate", null);
        newEntryData.set("entry_payamount", null);
        newEntryData.set("entry_quotation", null);
        newEntryData.set("entry_backbill", (Object)false);
        newEntryData.set("entry_invalid", (Object)false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateBalance();
        PayApplyEntryEdit.initDraftAmtTotal(this.getView());
        PayApplyEntryEdit.initArrivalUnlockAmt(this.getView());
    }

    private void updateBalance() {
        DynamicObjectCollection payInfoEntries = this.getModel().getEntryEntity("cas_payinfo");
        ArrayList<BizBalanceModelBean> bizBeanList = new ArrayList<BizBalanceModelBean>(payInfoEntries.size());
        DynamicObject org = (DynamicObject)this.getModel().getValue("payorg");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return;
        }
        String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < payInfoEntries.size(); ++i) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", i);
            DynamicObject payerAccBank = ((DynamicObject)payInfoEntries.get(i)).getDynamicObject("entry_payeraccbank");
            String payStatus = (String)this.getModel().getValue("entry_paystatus", i);
            if (currency == null || payerAccBank == null || !PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) continue;
            String payerAccBankId = String.valueOf(payerAccBank.getLong("id"));
            String currencyId = String.valueOf(currency.getLong("id"));
            keySet.add(payerAccBankId.concat(";").concat(currencyId));
        }
        for (String key : keySet) {
            BizBalanceModelBean bizBean = new BizBalanceModelBean();
            String[] keys = key.split(";");
            bizBean.setAccountId(Long.valueOf(Long.parseLong(keys[0])));
            bizBean.setCurrencyId(Long.valueOf(Long.parseLong(keys[1])));
            bizBean.setBalanceType(balanceType);
            bizBeanList.add(bizBean);
        }
        Map<String, BizBalanceModelBean> bizBalanceModelBeanMap = null;
        if (!bizBeanList.isEmpty()) {
            ModelRequestBean modelRequestBean = new ModelRequestBean();
            modelRequestBean.setBizBeans(bizBeanList);
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalanceBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)modelRequestBean)});
            modelRequestBean = (ModelRequestBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), ModelRequestBean.class);
            if (modelRequestBean != null && modelRequestBean.getBizBeans() != null) {
                bizBalanceModelBeanMap = modelRequestBean.getBizBeans().stream().filter(d -> d != null && EmptyUtil.isNoEmpty((Long)d.getAccountId()) && EmptyUtil.isNoEmpty((Long)d.getCurrencyId())).collect(Collectors.toMap(e -> e.getAccountId() + ";" + e.getCurrencyId(), e -> e, (v1, v2) -> v2));
            }
        }
        for (int i = 0; i < payInfoEntries.size(); ++i) {
            this.updateBalance(i, bizBalanceModelBeanMap);
        }
    }

    private void updateBalance(int[] selectRows) {
        DynamicObjectCollection payInfoEntries = this.getModel().getEntryEntity("cas_payinfo");
        ArrayList<BizBalanceModelBean> bizBeanList = new ArrayList<BizBalanceModelBean>(payInfoEntries.size());
        DynamicObject org = (DynamicObject)this.getModel().getValue("payorg");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return;
        }
        String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
        HashSet<String> keySet = new HashSet<String>();
        for (int i : selectRows) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", i);
            DynamicObject payerAccBank = ((DynamicObject)payInfoEntries.get(i)).getDynamicObject("entry_payeraccbank");
            String payStatus = (String)this.getModel().getValue("entry_paystatus", i);
            if (currency == null || payerAccBank == null || !PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) continue;
            String payerAccBankId = String.valueOf(payerAccBank.getLong("id"));
            String currencyId = String.valueOf(currency.getLong("id"));
            keySet.add(payerAccBankId.concat(";").concat(currencyId));
        }
        Object object = keySet.iterator();
        while (object.hasNext()) {
            String key = (String)object.next();
            BizBalanceModelBean bizBean = new BizBalanceModelBean();
            String[] keys = key.split(";");
            bizBean.setAccountId(Long.valueOf(Long.parseLong(keys[0])));
            bizBean.setCurrencyId(Long.valueOf(Long.parseLong(keys[1])));
            bizBean.setBalanceType(balanceType);
            bizBeanList.add(bizBean);
        }
        Map<String, BizBalanceModelBean> bizBalanceModelBeanMap = null;
        if (!bizBeanList.isEmpty()) {
            ModelRequestBean modelRequestBean = new ModelRequestBean();
            modelRequestBean.setBizBeans(bizBeanList);
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalanceBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)modelRequestBean)});
            modelRequestBean = (ModelRequestBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), ModelRequestBean.class);
            if (modelRequestBean != null && modelRequestBean.getBizBeans() != null) {
                bizBalanceModelBeanMap = modelRequestBean.getBizBeans().stream().filter(d -> d != null && EmptyUtil.isNoEmpty((Long)d.getAccountId()) && EmptyUtil.isNoEmpty((Long)d.getCurrencyId())).collect(Collectors.toMap(e -> e.getAccountId() + ";" + e.getCurrencyId(), e -> e, (v1, v2) -> v2));
            }
        }
        for (int i : selectRows) {
            this.updateBalance(i, bizBalanceModelBeanMap);
        }
    }

    private void updateBalance(int i, Map<String, BizBalanceModelBean> bizBalanceModelBeanMap) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("entry_paycurrency", i);
        DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("entry_payeraccbank");
        String payStatus = (String)this.getModel().getValue("entry_paystatus", i);
        BigDecimal balance = null;
        if (PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) {
            BizBalanceModelBean bizBalanceModelBean;
            if (payerAccBank != null && currency != null && bizBalanceModelBeanMap != null && (bizBalanceModelBean = bizBalanceModelBeanMap.get(payerAccBank.getLong("id") + ";" + currency.getLong("id"))) != null) {
                balance = bizBalanceModelBean.getAmount();
            }
            this.getModel().setValue("entry_balance", balance, i);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.size() > 0) {
            String billstr = (String)params.get(BILL);
            final Object pkValue = params.get(PKVALUE);
            String entryapplyid = (String)params.get("entry_applyid");
            DynamicObject bill = SerializeHelper.deserializeDynamicObj((String)"cas_payapplybill", (String)billstr);
            DynamicObject payeecurrency = (DynamicObject)bill.get("payeecurrency");
            DynamicObjectCollection casPayApplyEntrys = (DynamicObjectCollection)bill.get("cas_payapplyentry");
            DynamicObjectCollection casPayinfos = (DynamicObjectCollection)bill.get("cas_payinfo");
            DynamicObject payorg = (DynamicObject)bill.get("payorg");
            DynamicObjectCollection cas_payapplyentry_dosplit = new DynamicObjectCollection();
            casPayApplyEntrys.forEach(caspayapplyentry -> {
                if (entryapplyid.equals(caspayapplyentry.getString("e_splitid"))) {
                    cas_payapplyentry_dosplit.add(caspayapplyentry);
                }
            });
            DynamicObjectCollection casPayinfosDoSplit = new DynamicObjectCollection();
            casPayinfos.forEach(caspayinfo -> {
                if (entryapplyid.equals(caspayinfo.getString("entry_applyid"))) {
                    casPayinfosDoSplit.add(caspayinfo);
                }
            });
            this.getModel().setValue(BILLID, (Object)bill.getPkValue().toString());
            this.getModel().setValue(CAS_PAYINFO_SEL, pkValue);
            this.getModel().setValue("payeecurrency", payeecurrency.get("id"));
            if (cas_payapplyentry_dosplit.size() > 0) {
                this.importEntry("cas_payapplyentry", cas_payapplyentry_dosplit);
            }
            this.initDisplay("cas_payapplyentry", cas_payapplyentry_dosplit);
            this.getModel().setValue("payorg", payorg.get("id"));
            if (casPayinfosDoSplit.size() > 0) {
                casPayinfosDoSplit.sort((Comparator)new Comparator<DynamicObject>(){
                    List<String> paystatusorder = Arrays.asList(PayStatusEnum.PAYMENTSUCCESS.getValue(), PayStatusEnum.PAYING.getValue(), PayStatusEnum.PAYSCHEFUND.getValue(), PayStatusEnum.CLANCEL.getValue(), PayStatusEnum.NOTPAYING.getValue());

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        String o1_paystatus = o1.getString("entry_paystatus");
                        String o2_paystatus = o2.getString("entry_paystatus");
                        if (PayStatusEnum.NOTPAYING.getValue().equals(o1_paystatus) && o1_paystatus.equals(o2_paystatus)) {
                            if (!o1.getBoolean("entry_invalid") && !o2.getBoolean("entry_invalid")) {
                                return Boolean.compare(pkValue.equals(o1.getPkValue()), pkValue.equals(o2.getPkValue())) * -1;
                            }
                            return Boolean.compare(o1.getBoolean("entry_invalid"), o2.getBoolean("entry_invalid")) * -1;
                        }
                        return Integer.compare(this.paystatusorder.indexOf(o1_paystatus), this.paystatusorder.indexOf(o2_paystatus));
                    }
                });
                this.importEntry("cas_payinfo", casPayinfosDoSplit);
            }
        }
    }

    private void initDisplay(String entryName, DynamicObjectCollection entryInfos) {
        if ("cas_payapplyentry".equals(entryName)) {
            if (entryInfos != null && entryInfos.size() > 0) {
                String e_chgstatus = ((DynamicObject)entryInfos.get(0)).getString("e_chgstatus");
                if (PayApplyRecChgStatusEnum.NOCHG.getValue().equals(e_chgstatus)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_chgstatus", "e_chgpayeeaccbanknum", "e_chgpayeebank"});
                }
            }
        } else if ("cas_payinfo".equals(entryName)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entry_lastmodifytime", "entry_expectdate", "entry_payeetype", "entry_payeename", "entry_payeeaccbanknum", "entry_accountname", "entry_payeebank", "entry_recbanknumber", "entry_usage", "entry_remark", "entry_priority", "entry_paydate", "entry_paybillno", "entry_backbill"});
        }
    }

    private void importEntry(String entryName, DynamicObjectCollection entryInfos) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String doid = ".id";
        model.beginInit();
        if ("cas_payapplyentry".equals(entryName)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("e_settlementtype", new Object[0]);
            vs.addField("e_payeeamount", new Object[0]);
            vs.addField("e_payeetype", new Object[0]);
            vs.addField("e_payeename", new Object[0]);
            vs.addField("e_payeeaccbanknum", new Object[0]);
            vs.addField("e_payeebank", new Object[0]);
            vs.addField("e_priority", new Object[0]);
            vs.addField("e_accountname", new Object[0]);
            vs.addField("e_paidamount", new Object[0]);
            vs.addField("e_remark", new Object[0]);
            vs.addField("e_chgstatus", new Object[0]);
            vs.addField("e_chgpayeeaccbanknum", new Object[0]);
            vs.addField("e_chgpayeebank", new Object[0]);
            for (DynamicObject entryInfo : entryInfos) {
                vs.addRow(new Object[]{entryInfo.getPkValue(), entryInfo.getString("e_settlementtype.id"), entryInfo.getBigDecimal("e_payeeamount"), entryInfo.getString("e_payeetype"), entryInfo.getString("e_payeename"), entryInfo.getString("e_payeeaccbanknum"), entryInfo.getString("e_payeebank.id"), entryInfo.getString("e_priority"), entryInfo.getString("e_accountname"), entryInfo.getBigDecimal("e_paidamount"), entryInfo.getString("e_remark"), entryInfo.getString("e_chgstatus"), entryInfo.getString("e_chgpayeeaccbanknum"), entryInfo.getString("e_chgpayeebank.id")});
            }
            model.batchCreateNewEntryRow(entryName, vs);
        } else if ("cas_payinfo".equals(entryName)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("entry_settlementtype", new Object[0]);
            vs.addField("entry_payeraccbank", new Object[0]);
            vs.addField("entry_payerbank", new Object[0]);
            vs.addField("entry_balance", new Object[0]);
            vs.addField("entry_paymentchannel", new Object[0]);
            vs.addField("entry_payeeamount", new Object[0]);
            vs.addField("entry_paystatus", new Object[0]);
            vs.addField("entry_statusexplain", new Object[0]);
            vs.addField("entry_settletnumber", new Object[0]);
            vs.addField("entry_draftamttotal", new Object[0]);
            vs.addField("entry_arrivalunlockamt", new Object[0]);
            vs.addField("entry_lastmodifytime", new Object[0]);
            vs.addField("entry_expectdate", new Object[0]);
            vs.addField("entry_payeetype", new Object[0]);
            vs.addField("entry_payeeid", new Object[0]);
            vs.addField("entry_payeename", new Object[0]);
            vs.addField("entry_payeeaccbanknum", new Object[0]);
            vs.addField("entry_accountname", new Object[0]);
            vs.addField("entry_payeebank", new Object[0]);
            vs.addField("entry_recbanknumber", new Object[0]);
            vs.addField("entry_usage", new Object[0]);
            vs.addField("entry_remark", new Object[0]);
            vs.addField("entry_priority", new Object[0]);
            vs.addField("entry_paydate", new Object[0]);
            vs.addField("entry_paybillno", new Object[0]);
            vs.addField("entry_recswiftcode", new Object[0]);
            vs.addField("entry_recroutingnum", new Object[0]);
            vs.addField("entry_recothercode", new Object[0]);
            vs.addField("entry_draftbill", new Object[0]);
            vs.addField("entry_arrivalno", new Object[0]);
            vs.addField("entry_backbill", new Object[0]);
            vs.addField("entry_isdiffcur", new Object[0]);
            vs.addField("entry_paycurrency", new Object[0]);
            vs.addField("entry_exratetable", new Object[0]);
            vs.addField("entry_exratedate", new Object[0]);
            vs.addField("entry_exchangerate", new Object[0]);
            vs.addField("entry_payamount", new Object[0]);
            vs.addField("entry_quotation", new Object[0]);
            vs.addField("entry_invalid", new Object[0]);
            for (DynamicObject entryInfo : entryInfos) {
                vs.addRow(new Object[]{entryInfo.getPkValue(), entryInfo.getString("entry_settlementtype.id"), entryInfo.getString("entry_payeraccbank.id"), entryInfo.getString("entry_payerbank.id"), entryInfo.getBigDecimal("entry_balance"), entryInfo.getString("entry_paymentchannel"), entryInfo.getBigDecimal("entry_payeeamount"), entryInfo.getString("entry_paystatus"), entryInfo.getString("entry_statusexplain"), entryInfo.getString("entry_settletnumber"), entryInfo.getBigDecimal("entry_draftamttotal"), entryInfo.getBigDecimal("entry_arrivalunlockamt"), entryInfo.getDate("entry_lastmodifytime"), entryInfo.getDate("entry_expectdate"), entryInfo.getString("entry_payeetype"), entryInfo.getString("entry_payeeid"), entryInfo.getString("entry_payeename"), entryInfo.getString("entry_payeeaccbanknum"), entryInfo.getString("entry_accountname"), entryInfo.getString("entry_payeebank.id"), entryInfo.getString("entry_recbanknumber"), entryInfo.getString("entry_usage"), entryInfo.getString("entry_remark"), entryInfo.getString("entry_priority"), entryInfo.getDate("entry_paydate"), entryInfo.getString("entry_paybillno"), entryInfo.getString("entry_recswiftcode"), entryInfo.getString("entry_recroutingnum"), entryInfo.getString("entry_recothercode"), entryInfo.getDynamicObjectCollection("entry_draftbill"), entryInfo.getString("entry_arrivalno"), entryInfo.get("entry_backbill"), entryInfo.get("entry_isdiffcur"), entryInfo.getString("entry_paycurrency.id"), entryInfo.getString("entry_exratetable.id"), entryInfo.get("entry_exratedate"), entryInfo.get("entry_exchangerate"), entryInfo.get("entry_payamount"), entryInfo.getString("entry_quotation"), entryInfo.getBoolean("entry_invalid")});
            }
            model.batchCreateNewEntryRow(entryName, vs);
        }
        model.endInit();
    }
}

