/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.util.PsdUtils;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class Pay2ScheConvertPlugin
extends AbstractConvertPlugIn {
    private static final String SETTLE_TYPE_ARRIVAL = "7";

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            String[] field = new String[]{"sourcebillid", "sourcebilltype"};
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject payBillDO = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paybill");
            Long sourceBillId = targetBill.getLong("sourcebillid");
            String sourceBillType = payBillDO.getString("sourcebilltype");
            if (!CasHelper.isEmpty((Object)sourceBillId) && !CasHelper.isEmpty((Object)sourceBillType)) {
                DynamicObject sourDO = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
                String billno = sourDO.getString("billno");
                targetBill.set("sourcebillnumber", (Object)billno);
            }
            if (payBillDO.get("expectdate") == null) {
                Object srcBizDate = payBillDO.get("bizdate");
                if (srcBizDate == null) {
                    srcBizDate = payBillDO.get("createtime");
                }
                if (srcBizDate == null) {
                    srcBizDate = new Date();
                }
                targetBill.set("expectdate", srcBizDate);
            }
            targetBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            targetBill.set("balanceamt", (Object)targetBill.getBigDecimal("applyamt"));
            targetBill.set("waitpayamt", (Object)targetBill.getBigDecimal("applyamt"));
            DynamicObject applysettletype = targetBill.getDynamicObject("applysettletype");
            if (EmptyUtil.isNoEmpty((DynamicObject)applysettletype)) {
                String settlementtype = applysettletype.getString("settlementtype");
                Set draftTypeList = Stream.of("2", "5", "6", SETTLE_TYPE_ARRIVAL).collect(Collectors.toSet());
                if (draftTypeList.contains(settlementtype)) {
                    targetBill.set("draftsettletype", (Object)applysettletype);
                } else {
                    targetBill.set("settletype", (Object)applysettletype);
                }
                if (SettleMentTypeEnum.MONEY.getValue().equals(applysettletype.getString("settlementtype"))) {
                    targetBill.set("acctbanktype", (Object)"cas_accountcash");
                } else {
                    targetBill.set("acctbanktype", (Object)"bd_accountbanks");
                    targetBill.set("acctbank", (Object)targetBill.getDynamicObject("applyacctbank"));
                }
                if (SETTLE_TYPE_ARRIVAL.equals(settlementtype)) {
                    targetBill.set("lcarrivalno", (Object)payBillDO.getString("settletnumber"));
                }
            }
            targetBill.set("paymentchannel", targetBill.get("applypaychannel"));
            targetBill.set("draftpaychannel", targetBill.get("applypaychannel"));
            if (PsdUtils.isEntrust((DynamicObject)payBillDO)) {
                targetBill.set("entrustpayid", (Object)payBillDO.getLong("id"));
            }
            if (!StringUtils.equals((CharSequence)PayBusinessTypeEnum.WALLETUP.getValue(), (CharSequence)payBillDO.getString("businesstype"))) continue;
            targetBill.set("institutioncode", (Object)payBillDO.getString("institutioncode"));
            targetBill.set("institutionname", (Object)payBillDO.getString("institutionname"));
        }
    }
}

