/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillDraftInfoEntryConverter
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(PaymentBillDraftInfoEntryConverter.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"));
            logger.info("PaymentBillDraftInfoEntryConverter is start" + sourceBill.getString("billno"));
            DynamicObjectCollection sourceFieldRows = sourceBill.getDynamicObjectCollection("cas_draftinfo");
            DynamicObjectCollection draftbills = targetBill.getDynamicObjectCollection("draftbill");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)draftbills) || draftbills.size() == 0) {
                return;
            }
            Set draftBillIds = draftbills.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)sourceFieldRows) && sourceFieldRows.size() > 0) {
                for (DynamicObject sourceFieldRow : sourceFieldRows) {
                    long id = sourceFieldRow.getDynamicObject("draftbillinfo").getLong("id");
                    if (!draftBillIds.contains(id)) continue;
                    DynamicObject entry = targetBill.getDynamicObjectCollection("cas_draftinfo").addNew();
                    DynamicObject draftinfo = sourceFieldRow.getDynamicObject("draftbillinfo");
                    BigDecimal transamount = sourceFieldRow.getBigDecimal("transamount");
                    Long draftBillLogId = sourceFieldRow.getLong("draftbilllogid");
                    DynamicObject paybillcurrency = sourceFieldRow.getDynamicObject("paybillcurrency");
                    entry.set("draftbillinfo", (Object)draftinfo);
                    entry.set("transamount", (Object)transamount);
                    entry.set("draftbilllogid", (Object)draftBillLogId);
                    entry.set("paybillcurrency", (Object)paybillcurrency);
                    entry.set("srcbilltype", (Object)"cas_paybill");
                    entry.set("srcbillindex", (Object)"1");
                }
            }
            logger.info("PaymentBillDraftInfoEntryConverter is end" + sourceBill.getString("billno") + ":\u751f\u6210\u7968\u9762\u4fe1\u606f\u5206\u5f55" + sourceFieldRows.size() + "\u6761");
        }
    }
}

