/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payinfochg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.MessageTypes;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.sign.PayChgReviewExecutor;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.sign.ISignExecutor;
import kd.fi.cas.sign.ISignInvoker;
import kd.fi.cas.sign.SignHandler;

public class PayInfoChgCrossBillSignPlugin
extends AbstractFormPlugin
implements ISignInvoker {
    private static final long serialVersionUID = -3173590293011834686L;
    private static final String RECCHG = "recchg";
    private static Log logger = LogFactory.getLog(PayInfoChgCrossBillSignPlugin.class);
    public static final String OP_CONFIRM = "confirm";
    public static final String KEY_SUCCESSIDLIST = "_KEY_SUCCESSIDLIST_";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (OP_CONFIRM.equals(op.getOperateKey())) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        block16: {
            super.afterDoOperation(afterDoOperationEventArgs);
            String opKey = afterDoOperationEventArgs.getOperateKey();
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (OP_CONFIRM.equals(opKey) && result.isSuccess()) {
                List<Object> pkList = this.getPayChgBillIdList();
                String entityName = this.getEntityName();
                AtomicBoolean needSign = new AtomicBoolean(false);
                List requestIds = null;
                DynamicObject[] dataList = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
                ArrayList<DynamicObject> fillerlist = new ArrayList<DynamicObject>(dataList.length);
                boolean hasdata = false;
                boolean isPayApply = false;
                for (DynamicObject object : dataList) {
                    if (!object.getString("chgtype").equals(RECCHG) || !object.getString("sourcetype").equals("cas_payapplybill")) {
                        fillerlist.add(object);
                        hasdata = true;
                        continue;
                    }
                    isPayApply = true;
                }
                if (!hasdata && isPayApply) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"PayInfoChgCrossBillSignPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList errors = new ArrayList();
                List idList = fillerlist.stream().map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
                Map request = MutexServiceHelper.batchRequest(idList, (String)entityName, (String)OP_CONFIRM);
                try {
                    requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])dataList, errors, (Map)request);
                    this.getPageCache().put(KEY_SUCCESSIDLIST, SerializationUtils.toJsonString((Object)requestIds));
                    SignHandler handler = this.createHandler(true);
                    needSign.set(handler.sign());
                    if (!needSign.get()) {
                        String errorMessage = handler.getErrorMessage();
                        if (errorMessage != null && errorMessage.length() > 0) {
                            if (this.getPayChgBillIdList().size() > 1) {
                                this.getView().showMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f, \u4f46\u6709\u90e8\u5206\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4", (String)"PayInfoChgCrossBillSignPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorMessage, MessageTypes.Default);
                            } else {
                                this.getView().showErrorNotification(errorMessage);
                            }
                        } else {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"PayInfoChgCrossBillSignPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
                catch (Exception e) {
                    needSign.set(false);
                    if (e instanceof IllegalArgumentException) {
                        this.getView().showErrorNotification(e.getMessage());
                        break block16;
                    }
                    throw e;
                }
                finally {
                    if (!needSign.get()) {
                        MutexServiceHelper.batchRelease((List)requestIds, (String)entityName, (String)OP_CONFIRM);
                    }
                }
            }
        }
    }

    public SignHandler createHandler(boolean isInit) {
        String entityName = this.getEntityName();
        String successIdList = this.getPageCache().get(KEY_SUCCESSIDLIST);
        List pkIdList = (List)SerializationUtils.fromJsonString((String)successIdList, List.class);
        DynamicObject[] payBillArr = BusinessDataServiceHelper.load((Object[])pkIdList.stream().map(Object::toString).map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashMap result = new HashMap(0);
        for (DynamicObject tpayBillArr : payBillArr) {
            String sourceType = tpayBillArr.getString("sourcetype");
            List tList = result.get(sourceType) == null ? new ArrayList() : (List)result.get(sourceType);
            tList.add(tpayBillArr);
            result.put(sourceType, tList);
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u6e90\u5355\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u786e\u8ba4\u3002", (String)"PayInfoChgCrossBillSignPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        ArrayList<PayChgReviewExecutor> tPayChgReviewExecutorList = new ArrayList<PayChgReviewExecutor>(10);
        for (Map.Entry entry : result.entrySet()) {
            tPayChgReviewExecutorList.add(new PayChgReviewExecutor((List)entry.getValue(), (String)entry.getKey()));
        }
        return new SignHandler(this.getView(), (ISignInvoker)this, isInit, (ISignExecutor[])tPayChgReviewExecutorList.toArray(new PayChgReviewExecutor[tPayChgReviewExecutorList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCallback(SignCallbackEvent evt) {
        try {
            SignHandler handler = this.createHandler(false);
            handler.signCallback(evt);
            String errorMessage = handler.getErrorMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                if (this.getPayChgBillIdList().size() > 1) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f, \u4f46\u6709\u90e8\u5206\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4%s", (String)"PayInfoChgCrossBillSignPlugin_1_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorMessage, MessageTypes.Default);
                } else {
                    this.getView().showErrorNotification(errorMessage);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"PayInfoChgCrossBillSignPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String message = e instanceof KDException ? e.getMessage() : ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            this.getView().showErrorNotification(message);
        }
        finally {
            String successIdList = this.getPageCache().get(KEY_SUCCESSIDLIST);
            List requestIds = (List)SerializationUtils.fromJsonString((String)successIdList, List.class);
            MutexServiceHelper.batchRelease((List)requestIds, (String)this.getEntityName(), (String)OP_CONFIRM);
            this.doRefresh(this.getEntityName());
        }
    }

    private List<Object> getPayChgBillIdList() {
        ArrayList<Object> pkList = new ArrayList<Object>();
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            ListSelectedRowCollection selectRows = billList.getSelectedRows();
            if (selectRows.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u786e\u8ba4\u7684\u6570\u636e\u3002", (String)"PayInfoChgCrossBillSignPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            Object[] pkArr = selectRows.getPrimaryKeyValues();
            pkList.addAll(Arrays.asList(pkArr));
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Object id = dataEntity.getPkValue();
            pkList.add(id);
        }
        return pkList;
    }

    private String getEntityName() {
        String entityName;
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            entityName = billList.getEntityType().getName();
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            entityName = dataEntity.getDataEntityType().getName();
        }
        return entityName;
    }

    private void doRefresh(String entityName) {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            billList.refresh();
        }
    }
}

