/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.consts.ReceivingBillModel;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.StringUtils;

public class RecBillInnerAccount
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setFinAccF7Filter();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showOrHideInnerAccountPanel();
        this.changeCurrencyOrActPayAmt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        if (key.equals("receivingtype")) {
            this.showOrHideInnerAccountPanel();
            this.changeCurrencyOrActPayAmt();
        }
        if (key.equals("currency")) {
            this.changeCurrencyOrActPayAmt();
        }
        if (key.equals("actrecamt")) {
            this.changeCurrencyOrActPayAmt();
        }
    }

    private void showOrHideInnerAccountPanel() {
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("receivingtype");
        if (paymentType != null) {
            String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
            if (paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_DOWN.getValue()) && "fca_transdownbill".equals(sourceBillType)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (this.getModel().getValue("inneraccount") != null && SystemParameterHelper.isShowInternalAccount((long)org.getLong("id"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flex_inneraccount"});
                    ((TextEdit)this.getControl("inneraccountamount")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"RecBillInnerAccount_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
                }
            } else if (paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flex_inneraccount"});
                ((TextEdit)this.getControl("inneraccountamount")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"RecBillInnerAccount_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
        }
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        if (accountBank == null) {
            return;
        }
        if (PayBillCrossHelper.isInnerAcct((Object)accountBank.getPkValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_inneraccount"});
        }
    }

    private void changeCurrencyOrActPayAmt() {
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("receivingtype");
        if (paymentType != null && (paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_DOWN.getValue()) || paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue()))) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("inneraccountcurrency", currency == null ? "" : currency.get("name"));
            BigDecimal actPayAmt = new BigDecimal(this.getModel().getValue("actrecamt").toString());
            this.getModel().setValue("inneraccountamount", (Object)actPayAmt.toPlainString());
        }
    }

    private void setFinAccF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("inneraccount");
        String payerType = (String)this.getModel().getValue("payertype");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara;
            Long payerId;
            DynamicObject orgId;
            QFilter innerAccQFilter = new QFilter("acctclassify", "=", (Object)"I");
            innerAccQFilter.and(new QFilter("acctstatus", "not in", Arrays.asList("closed", "freeze")));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency != null) {
                innerAccQFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            }
            if ((orgId = (DynamicObject)this.getModel().getValue("org")) != null) {
                innerAccQFilter.and(new QFilter("bank.org.id", "=", orgId.getPkValue()));
            }
            if (StringUtils.isNotEmpty((String)payerType) && ReceivingBillModel.HEAD_ENUMS_PAYERTYPE[2].equals(payerType) && (payerId = (Long)this.getModel().getValue("payer")).compareTo(Long.valueOf("0")) != 0) {
                innerAccQFilter.and(new QFilter("company.id", "=", (Object)payerId));
            }
            if (CasHelper.isNotEmpty((Object)(showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter()))) {
                showPara.setCustomParam("isclearcorefilter", (Object)"true");
                showPara.getListFilterParameter().setFilter(innerAccQFilter);
            }
        });
    }
}

