/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import org.apache.commons.lang3.ObjectUtils;

public class RecRelationInfoEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadFields();
    }

    private void loadFields() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        IDataModel model = this.getModel();
        DynamicObject recBill = model.getDataEntity();
        List<Map<String, Object>> info = this.getInfoObject(recBill);
        ApprovalRecord arControl = (ApprovalRecord)this.getControl("approvalrecordap");
        List arData = arControl.getArData();
        if (OperationStatus.ADDNEW == status || (arData == null || arData.size() == 0) && (info == null || info.size() == 0)) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
        }
        if (info == null || info.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap1"});
        }
        if (arData == null || arData.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap"});
        }
        this.batchFillEntity("entryentity", (AbstractFormDataModel)model, info);
        if (info != null && info.size() > 0) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tabpageap1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (("submit".equals(args.getOperateKey()) || "save".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            IDataModel model = this.getModel();
            DynamicObject recBill = model.getDataEntity();
            List<Map<String, Object>> info = this.getInfoObject(recBill);
            this.batchFillEntity("entryentity", (AbstractFormDataModel)model, info);
        }
    }

    private List<Map<String, Object>> getInfoObject(DynamicObject recBill) {
        if (recBill == null) {
            return new ArrayList<Map<String, Object>>();
        }
        Object pkValue = recBill.getPkValue();
        if (CasHelper.isEmpty((Object)pkValue)) {
            return new ArrayList<Map<String, Object>>();
        }
        QFilter qFilter = new QFilter("sourcebillid", "=", pkValue);
        DynamicObject[] chgBills = BusinessDataServiceHelper.load((String)"cas_recchgbill", (String)"id,billno,createtime,creator,chgreson", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");
        ArrayList<Map<String, Object>> billList = new ArrayList<Map<String, Object>>(chgBills.length);
        HashMap<String, Object> bill = new HashMap<String, Object>();
        for (DynamicObject bills : chgBills) {
            bill = new HashMap();
            bill.put("chgcreateor", bills.getDynamicObject("creator").getString("name"));
            bill.put("chgno", bills.getString("billno"));
            bill.put("chgdate", bills.getString("createtime").substring(0, 19));
            bill.put("relationid", bills.getPkValue());
            String chgreson = bills.getString("chgreson");
            if (chgreson.length() > 50) {
                chgreson = chgreson.substring(0, 50) + "...";
            }
            bill.put("chgresonson", chgreson);
            billList.add(bill);
        }
        return billList;
    }

    private void batchFillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataMap) {
        boolean dataChanged = this.getModel().getDataChanged();
        model.deleteEntryData(entryName);
        if (null != dataMap && dataMap.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (Map<String, Object> map : dataMap) {
                map.forEach((key, value) -> {
                    if (value instanceof DynamicObject) {
                        value = ((DynamicObject)value).getPkValue();
                    }
                    vs.addField(key, new Object[]{value});
                });
            }
            model.batchCreateNewEntryRow(entryName, vs);
        }
        if (!dataChanged) {
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid bankcheckentity = (EntryGrid)this.getView().getControl("bankcheckentity");
        bankcheckentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        if ("chgno".equals(key)) {
            this.showRelation(evt);
        } else if ("edetailbillno".equals(key)) {
            int rowIndex = evt.getRowIndex();
            BillShowParameter showForm = new BillShowParameter();
            showForm.setFormId("bei_transdetail_cas");
            showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showForm.setPkId(this.getModel().getValue("edetailid", rowIndex));
            showForm.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showForm);
        }
    }

    private void showRelation(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject[] recBills;
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Long relationId = entryRowEntity.getLong("relationid");
            if (CasHelper.isNotEmpty((Object)relationId) && !CasHelper.isEmpty((DynamicObject[])(recBills = BusinessDataServiceHelper.load((String)"cas_recchgbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relationId)})))) {
                String billStatus = recBills[0].getString("billstatus");
                paramMap.put("pkValue", relationId);
                paramMap.put("billtype", BillStatusEnum.SAVE.getValue().equals(billStatus) ? "cas_recbill_change" : "cas_recchgbill");
                paramMap.put("showType", ShowType.MainNewTabPage);
                this.showWebBill(paramMap, (AbstractFormPlugin)this);
            }
        }
    }

    private void showWebBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get("billtype");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        if (null != paramMap.get("pkValue")) {
            showParameter.setPkId(paramMap.get("pkValue"));
            showParameter.setStatusValue(OperationStatus.EDIT.getValue());
        }
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get("showType"), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        formPlugin.getView().showForm((FormShowParameter)showParameter);
    }
}

