/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec.matchRecBill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.formplugin.rec.matchRecBill.IRecBusinessAccount;
import kd.fi.cas.formplugin.rec.matchRecBill.SallOrderMatchRecParamsImpl;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.param.SallOrderMatchResult;
import kd.fi.cas.param.SallOrderParams;

public class RecBusinessAccountImpl
implements IRecBusinessAccount {
    private static final Log log = LogFactory.getLog(RecBusinessAccountImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String operate(String params) {
        SallOrderMatchResult resultStr = new SallOrderMatchResult();
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        try {
            SallOrderParams sallOrderParams = (SallOrderParams)JSON.parseObject((String)params, SallOrderParams.class);
            List billIdList = sallOrderParams.getDetails().stream().map(e -> e.getBillId().toString()).collect(Collectors.toList());
            log.info("\u4ed8\u6b3e\u5355id\uff1a", (Object)JSON.toJSONString(billIdList));
            Map lockResultMap = MutexServiceHelper.batchRequest(billIdList, (String)"cas_payScheduleBill", (String)"sallOrderMatchRec");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                SallOrderMatchResult result = new SallOrderMatchResult();
                result.setStatus("ERROR");
                result.setErrMsg(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RecBusinessAccountImpl_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                String string = JSON.toJSONString((Object)result);
                return string;
            }
            resultStr = this.operateMethods(resultStr, sallOrderParams);
        }
        catch (Exception e2) {
            log.error("e is:", (Object)e2.getMessage());
            resultStr.setStatus("ERROR");
            resultStr.setErrMsg("SystemException" + e2.getMessage());
            resultStr.setDetails(null);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"cas_payScheduleBill", (String)"sallOrderMatchRec");
        }
        return JSON.toJSONString((Object)resultStr);
    }

    public SallOrderMatchResult operateMethods(SallOrderMatchResult resultStr, SallOrderParams sallOrderParams) {
        String operateStr;
        SallOrderMatchRecParamsImpl sallOrderMatchRecParams = new SallOrderMatchRecParamsImpl();
        switch (operateStr = sallOrderParams.getOperate()) {
            case "matchValidate": {
                resultStr = sallOrderMatchRecParams.matchValidate(sallOrderParams);
                break;
            }
            case "cancelMatchValidate": {
                resultStr = sallOrderMatchRecParams.canceMatchValidate(sallOrderParams);
                break;
            }
            case "match": {
                QFilter qFilter = new QFilter("batchnumber", "=", (Object)sallOrderParams.getBatchNumber());
                qFilter.and(new QFilter("successflag", "=", (Object)"1"));
                DynamicObject[] sallDetailResults = BusinessDataServiceHelper.load((String)"cas_salldetailparams", (String)"id,batchnumber,message_tag,successflag", (QFilter[])new QFilter[]{qFilter});
                if (null != sallDetailResults && sallDetailResults.length > 0) {
                    DynamicObject sallDetailResult = sallDetailResults[0];
                    String messageTag = sallDetailResult.getString("message_tag");
                    resultStr = (SallOrderMatchResult)JSON.parseObject((String)messageTag, SallOrderMatchResult.class);
                    break;
                }
                resultStr = sallOrderMatchRecParams.matchValidate(sallOrderParams);
                if (resultStr.getStatus().equalsIgnoreCase("ERROR")) break;
                resultStr = sallOrderMatchRecParams.match(sallOrderParams);
                break;
            }
            case "cancelMatch": {
                resultStr = sallOrderMatchRecParams.canceMatchValidate(sallOrderParams);
                if (resultStr.getStatus().equalsIgnoreCase("ERROR")) break;
                resultStr = sallOrderMatchRecParams.canceMatch(sallOrderParams);
                break;
            }
        }
        return resultStr;
    }
}

