/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recbill.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBilllToChangeConvertPlugin
extends AbstractConvertPlugIn {
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        DynamicObject dynamicObject = (DynamicObject)e.getSourceRows().get(0);
        if (StringUtils.equals((CharSequence)dynamicObject.getString((IDataEntityProperty)fldProperties.get("itempayertype")), (CharSequence)"other")) {
            dynamicObject.set((IDataEntityProperty)fldProperties.get("itempayer"), (Object)0L);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject[] claims;
            String quotation;
            String recpayer;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)targetBill.get("sourcebillid"), (String)targetBill.getString("sourcebilltype"));
            Object sourceId = recBill.get("sourcebillid");
            String sourceType = recBill.getString("sourcebilltype");
            if (EmptyUtil.isEmpty((Object)sourceId) || EmptyUtil.isEmpty((String)sourceType)) {
                return;
            }
            Object[] loads = BusinessDataServiceHelper.load((Object[])new Object[]{sourceId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceType));
            if (EmptyUtil.isEmpty((Object[])loads)) {
                return;
            }
            Object sourceBill = loads[0];
            targetBill.set("isdelete", (Object)true);
            StringBuilder chgreson = new StringBuilder();
            String claimtype = "";
            String claimstatus = sourceBill.getString("claimstatus");
            if (StringUtils.equals((CharSequence)ClaimStatusEnum.APPEAL.getValue(), (CharSequence)claimstatus)) {
                chgreson.append(ResManager.loadKDString((String)"\u8ba4\u9886\u7533\u8bc9\u6210\u529f", (String)"RecBilllToChangeConvertPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                claimtype = ClaimTypeEnum.APPEAL.getValue();
            } else if (StringUtils.equals((CharSequence)ClaimStatusEnum.CHANGE.getValue(), (CharSequence)claimstatus)) {
                chgreson.append(ResManager.loadKDString((String)"\u8ba4\u9886\u53d8\u66f4\u6210\u529f", (String)"RecBilllToChangeConvertPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                claimtype = ClaimTypeEnum.CHANGE.getValue();
            } else {
                chgreson.append(ResManager.loadKDString((String)"\u672a\u8ba4\u9886\u5165\u8d26\u540e\u7eed\u8ba4\u9886\u786e\u8ba4", (String)"RecBilllToChangeConvertPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                claimtype = ClaimTypeEnum.CLAIM.getValue();
            }
            chgreson.append("\uff0c");
            chgreson.append(ResManager.loadKDString((String)"\u89e6\u53d1\u6536\u6b3e\u4e1a\u52a1\u53d8\u66f4", (String)"RecBilllToChangeConvertPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            targetBill.set("chgreson", (Object)chgreson.toString());
            String paymentType = sourceBill.getString("paymenttype");
            String oppbankNumber = sourceBill.getString("oppbanknumber");
            String payerFormId = "other";
            if ("bd_supplier".equals(paymentType) || "bd_customer".equals(paymentType)) {
                QFilter accountbankFilter;
                QFilter filter;
                QFilter payerFilter;
                DynamicObject[] baseBills;
                recpayer = sourceBill.getString("recpayer");
                if (CasHelper.isNotEmpty((Object)recpayer) && (baseBills = BusinessDataServiceHelper.load((String)paymentType, (String)"id", (QFilter[])new QFilter[]{payerFilter = new QFilter("id", "=", (Object)Long.valueOf(recpayer)), filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("enable", "=", (Object)"1"), accountbankFilter = new QFilter("entry_bank.bankaccount", "=", (Object)oppbankNumber)})) != null && baseBills.length != 0) {
                    payerFormId = "bd_accountbanks";
                }
            } else if ("bos_org".equals(paymentType) && CasHelper.isNotEmpty((Object)oppbankNumber)) {
                DynamicObject[] baseBills = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)oppbankNumber)});
                if (baseBills != null && baseBills.length != 0) {
                    payerFormId = "bd_accountbanks";
                }
            } else if ("bos_user".equals(paymentType)) {
                payerFormId = "er_payeer";
            }
            recpayer = sourceBill.getString("recpayer");
            if (!"other".equals(paymentType)) {
                if (CasHelper.isEmpty((Object)recpayer)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u63a8\u6536\u6b3e\u5355", (String)"Claim2RecBillConvertPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                DynamicObject[] baseBills = BusinessDataServiceHelper.load((String)paymentType, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(recpayer))});
                if (!CasHelper.isEmpty((DynamicObject[])baseBills)) {
                    DynamicObject baseBill = baseBills[0];
                    targetBill.set("payername", (Object)baseBill.getString("name"));
                    targetBill.set("payer", baseBill.getPkValue());
                    targetBill.set("itempayer", baseBill.getPkValue());
                }
            } else {
                targetBill.set("payername", (Object)sourceBill.getString("recpayer"));
            }
            targetBill.set("payeraccformid", (Object)payerFormId);
            DynamicObject cur = targetBill.getDynamicObject("currency");
            DynamicObject exRateTable = targetBill.getDynamicObject("exratetable");
            Date exRateDate = (Date)targetBill.get("exratedate");
            BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
            if (exchangeRate == null) {
                exchangeRate = BigDecimal.ONE;
            }
            DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
            int round = 10;
            if (baseCurrency != null) {
                round = baseCurrency.getInt("amtprecision");
            }
            if (null == (quotation = targetBill.getString("quotation"))) {
                Map exchangeRateByRules;
                quotation = "0";
                if (cur != null && baseCurrency != null && exRateTable != null && exRateDate != null && (exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)cur.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exRateDate)).get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
                    quotation = "1";
                }
            }
            targetBill.set("entry", null);
            DynamicObjectCollection recFirstEntrys = targetBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection sourceEntrys = sourceBill.getDynamicObjectCollection("entryentity");
            Set chgFields = EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"entryentity");
            Set changeFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"entry");
            DynamicObjectCollection entrysTemp = null;
            BigDecimal allfee = sourceBill.getBigDecimal("fee");
            Boolean isaddfee = sourceBill.getBoolean("isaddfee");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)sourceEntrys)) {
                entrysTemp = sourceEntrys.stream().filter(dy -> !dy.getBoolean("e_billstatus")).collect(Collectors.toCollection(DynamicObjectCollection::new));
                DynamicObject entry = null;
                if (isaddfee.booleanValue()) {
                    entrysTemp.sort((dy1, dy2) -> dy1.getLong("id") - dy2.getLong("id") > 0L ? 1 : -1);
                    DynamicObject currency = sourceBill.getDynamicObject("currency");
                    BigDecimal fee = BigDecimal.ZERO;
                    BigDecimal totolfee = BigDecimal.ZERO;
                    BigDecimal actamt = BigDecimal.ZERO;
                    BigDecimal totolamt = entrysTemp.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    for (int i = 0; i < entrysTemp.size(); ++i) {
                        entry = (DynamicObject)entrysTemp.get(i);
                        BigDecimal tempFee = entry.getBigDecimal("e_fee");
                        fee = entry.getBigDecimal("e_receivableamt");
                        fee = fee.multiply(allfee).divide(totolamt, currency.getInt("amtprecision"), RoundingMode.DOWN);
                        if (i == entrysTemp.size() - 1) {
                            fee = allfee.subtract(totolfee);
                        } else {
                            totolfee = totolfee.add(fee);
                        }
                        entry.set("e_fee", (Object)fee);
                        actamt = entry.getBigDecimal("e_actamt").add(tempFee).subtract(fee);
                        entry.set("e_actamt", (Object)actamt);
                    }
                }
                for (int i = 0; i < entrysTemp.size(); ++i) {
                    entry = (DynamicObject)entrysTemp.get(i);
                    DynamicObject newEntry = recFirstEntrys.addNew();
                    for (String chgField : chgFields) {
                        if (!changeFields.contains(chgField)) continue;
                        newEntry.set(chgField, entry.get(chgField));
                    }
                    newEntry.set("project", entry.get("e_project"));
                    newEntry.set("e_unsettledamt", newEntry.get("e_receivableamt"));
                    newEntry.set("e_unlockamt", newEntry.get("e_receivableamt"));
                    newEntry.set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)newEntry.getBigDecimal("e_receivableamt"), (BigDecimal)exchangeRate, (String)quotation, (int)round));
                }
            }
            targetBill.set("fee", (Object)allfee);
            targetBill.set("bbizdate", sourceBill.get("bizdate"));
            QFilter filter = new QFilter("sourceid", "=", (Object)sourceBill.getPkValue().toString()).and(new QFilter("sourcetype", "=", (Object)sourceBill.getDataEntityType().getName())).and(new QFilter("claimtype", "=", (Object)claimtype)).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
            for (DynamicObject claim : claims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,multireceivingtype,recpaytype,paymenttype,recpayer,bizdate", (QFilter[])new QFilter[]{filter}, (String)" auditdate asc ")) {
                String payType = claim.getString("paymenttype");
                boolean multiReceivingType = claim.getBoolean("multireceivingtype");
                targetBill.set("payerformid", (Object)payType);
                targetBill.set("itempayertype", (Object)payType);
                targetBill.set("receivingtype", (Object)claim.getDynamicObject("recpaytype"));
                targetBill.set("payertype", (Object)payType);
                targetBill.set("multireceivingtype", (Object)multiReceivingType);
                String recPayer = claim.getString("recpayer");
                if ("other".equals(payType)) {
                    targetBill.set("payername", (Object)recPayer);
                } else {
                    targetBill.set("payer", (Object)recPayer);
                    targetBill.set("itempayer", (Object)recPayer);
                    DynamicObject[] payer = BusinessDataServiceHelper.load((Object[])new Object[]{Long.valueOf(recPayer)}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)payType));
                    if (payer != null && payer.length > 0) {
                        targetBill.set("payername", payer[0].get("name"));
                    }
                }
                targetBill.set("bizdate", (Object)claim.getDate("bizdate"));
            }
        }
    }
}

