/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recbill.convert;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class RecevieBillToApPayConverter
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(RecevieBillToApPayConverter.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        try {
            ExtendedDataEntity[] billDataEntitys;
            String targetEntityNumber = this.getTgtMainType().getName();
            block2: for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
                DynamicObject targetBill = billDataEntity.getDataEntity();
                DynamicObjectCollection detailentry = targetBill.getDynamicObjectCollection("detailentry");
                if (detailentry == null) continue;
                BigDecimal pricetaxTotal = ((DynamicObject)detailentry.get(0)).getBigDecimal("e_pricetaxtotal");
                List srcRows = (List)billDataEntity.getValue("ConvertSource");
                Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
                DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cas_recbill", (String)"org,entry.e_settleorg,entry.e_actamt");
                DynamicObject org = sourceBill.getDynamicObject("org");
                DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
                if (org == null || entry == null || entry.size() <= 0) continue;
                for (DynamicObject row : entry) {
                    BigDecimal actamt = row.getBigDecimal("e_actamt");
                    if (pricetaxTotal.compareTo(actamt) != 0) continue;
                    String settleOrgName = row.getDynamicObject("e_settleorg").getString("name");
                    DynamicObject basedata = this.matchByName((Long)org.getPkValue(), settleOrgName);
                    if (basedata == null) continue block2;
                    targetBill.set("asstacttype", (Object)basedata.getDataEntityType().getName());
                    targetBill.set("asstact", basedata.getPkValue());
                    continue block2;
                }
            }
        }
        catch (Exception error) {
            logger.error("RecevieBillToApPayConverter error:", (Throwable)error);
        }
    }

    private DynamicObject matchByName(Long orgId, String name) {
        String basedataSelector = "id,name,number";
        QFilter filter = new QFilter("name", "=", (Object)name);
        String[] oppType = new String[]{"bd_customer", "bd_supplier"};
        for (int i = 0; i < oppType.length; ++i) {
            DynamicObjectCollection customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType[i], (Long)orgId, (QFilter)filter, (String)basedataSelector);
            if (customerOrSupplier == null || customerOrSupplier.isEmpty()) continue;
            return (DynamicObject)customerOrSupplier.get(0);
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)basedataSelector, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        if (org != null) {
            for (int i = 0; i < oppType.length; ++i) {
                DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)oppType[i], (String)basedataSelector, (QFilter[])new QFilter[]{new QFilter("internal_company", "=", (Object)org.getLong("id"))});
                if (customerOrSupplier == null) continue;
                return customerOrSupplier;
            }
            return org;
        }
        DynamicObject userobject = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)basedataSelector, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        if (userobject != null) {
            return userobject;
        }
        return null;
    }
}

