/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimnotice;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DevHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class BatchClaimPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private StringBuilder errorMessage = new StringBuilder();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"recpaytypestr"});
        this.addClickListeners(new String[]{"paymenttypestr"});
        this.addClickListeners(new String[]{"payer"});
        this.addClickListeners(new String[]{"settleorgstr"});
        this.addClickListeners(new String[]{"corebilltypestr"});
        this.addClickListeners(new String[]{"corebillno"});
        this.addClickListeners(new String[]{"paysettleorgstr"});
        this.addClickListeners(new String[]{"paytypestr"});
        this.addClickListeners(new String[]{"recviewpayee"});
        this.addClickListeners(new String[]{"payeetypestr"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnsubmit"});
        EntryGrid billList = (EntryGrid)this.getControl("cas_claim");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("batchinput".equals(opKey)) {
            this.doBatchInput();
        } else if ("recinfobatchedit".equals(opKey)) {
            this.showRecInfo();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("recinfobatchedit".equals(operateKey) && (selectRows = (entryGrid = (EntryGrid)this.getControl("cas_claim")).getSelectRows()).length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExportExcelErrorCode_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("recpaytypestr".equals(key) || "paymenttypestr".equals(key) || "payer".equals(key) || "settleorgstr".equals(key) || "corebilltypestr".equals(key) || "corebillno".equals(key)) {
            this.showRecInfo();
        } else if ("paysettleorgstr".equals(key) || "paytypestr".equals(key) || "recviewpayee".equals(key) || "payeetypestr".equals(key)) {
            this.showPayInfo();
        } else if ("btnok".equals(key)) {
            DynamicObjectCollection casClaimCol = this.getModel().getEntryEntity("cas_claim");
            if (CasHelper.isEmpty((Object)casClaimCol)) {
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (params != null && params.size() > 0) {
                List clAnId = (List)params.get("claimannounceid");
                DynamicObject[] claimAnnounces = BusinessDataServiceHelper.load((Object[])clAnId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimannounce"));
                Set claimnos = casClaimCol.stream().map(v -> v.getString("claimno")).collect(Collectors.toSet());
                ArrayList<Object> claimBillListId = new ArrayList<Object>(10);
                ArrayList<DynamicObject> claimAnPush = new ArrayList<DynamicObject>(10);
                for (DynamicObject dynamicObject : claimAnnounces) {
                    QFilter claimtypeQf;
                    QFilter creatorQf;
                    String billNo = dynamicObject.getString("billno");
                    if (!claimnos.contains(billNo)) continue;
                    QFilter qFilter = new QFilter("claimno", "=", (Object)billNo);
                    QFilter billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
                    DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf, creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CLAIM.getValue())});
                    if (claimblls.length >= 1) {
                        Object recentDateId = null;
                        Date recentDate = null;
                        for (DynamicObject claimbill : claimblls) {
                            Date createtime = claimbill.getDate("createtime");
                            if (recentDate == null) {
                                recentDate = createtime;
                                recentDateId = claimbill.getPkValue();
                            }
                            recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getPkValue() : recentDateId;
                        }
                        claimBillListId.add(recentDateId);
                        continue;
                    }
                    claimAnPush.add(dynamicObject);
                }
                DynamicObject[] claimBills = new DynamicObject[]{};
                DynamicObject[] pushClaimBills = new DynamicObject[]{};
                if (claimBillListId.size() >= 1) {
                    claimBills = BusinessDataServiceHelper.load((Object[])claimBillListId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimbill"));
                }
                if (claimAnPush.size() >= 1) {
                    pushClaimBills = BatchClaimPlugin.pushs(claimAnPush.toArray(new DynamicObject[0]), "cas_claimbill");
                }
                Throwable throwable = null;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        OperationResult result = this.getOperationResult(claimBills, "save");
                        OperationResult resultPush = this.getOperationResult(pushClaimBills, "save");
                        this.showResult(result, resultPush, "save");
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
                catch (Throwable e) {
                    Throwable throwable2 = e;
                    throw e;
                }
            }
        } else if ("btnsubmit".equals(key)) {
            DynamicObjectCollection casClaimCol = this.getModel().getEntryEntity("cas_claim");
            if (CasHelper.isEmpty((Object)casClaimCol)) {
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (params != null && params.size() > 0) {
                List clAnId = (List)params.get("claimannounceid");
                DynamicObject[] claimAnnounces = BusinessDataServiceHelper.load((Object[])clAnId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimannounce"));
                Set claimnos = casClaimCol.stream().map(v -> v.getString("claimno")).collect(Collectors.toSet());
                ArrayList<Object> claimBillListId = new ArrayList<Object>(10);
                for (DynamicObject claimAnnounce : claimAnnounces) {
                    QFilter claimtypeQf;
                    QFilter creatorQf;
                    String string = claimAnnounce.getString("billno");
                    if (!claimnos.contains(string)) continue;
                    QFilter qFilter = new QFilter("claimno", "=", (Object)string);
                    QFilter billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
                    DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf, creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CLAIM.getValue())});
                    if (claimblls.length < 1) continue;
                    Object recentDateId = null;
                    Date recentDate = null;
                    for (DynamicObject claimbill : claimblls) {
                        Date createtime = claimbill.getDate("createtime");
                        if (recentDate == null) {
                            recentDate = createtime;
                            recentDateId = claimbill.getPkValue();
                        }
                        recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getPkValue() : recentDateId;
                    }
                    claimBillListId.add(recentDateId);
                }
                DynamicObject[] claimBills = new DynamicObject[]{};
                if (claimBillListId.size() >= 1) {
                    claimBills = BusinessDataServiceHelper.load((Object[])claimBillListId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimbill"));
                }
                OperationResult result = new OperationResult();
                OperationResult resultPush = new OperationResult();
                Throwable throwable = null;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        result = this.getOperationResult(claimBills, "submit");
                        this.showResult(result, resultPush, "submit");
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
                catch (Throwable e) {
                    Throwable throwable3 = e;
                    throw e;
                }
                List successPkIds = result.getSuccessPkIds();
                DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimbill"));
                Set successBillNo = Arrays.stream(dynamicObjectArray).map(o -> o.getString("claimno")).collect(Collectors.toSet());
                for (int i = casClaimCol.size() - 1; i >= 0; --i) {
                    if (!successBillNo.contains(((DynamicObject)casClaimCol.get(i)).getString("claimno"))) continue;
                    this.getModel().deleteEntryRow("cas_claim", i);
                }
            }
        }
    }

    private void showResult(OperationResult result, OperationResult resultPush, String option) {
        List errorInfos = result.getAllErrorOrValidateInfo();
        ValidateResultCollection validateResult = result.getValidateResult();
        List errorInfosPush = resultPush.getAllErrorOrValidateInfo();
        ValidateResultCollection validateResultPush = resultPush.getValidateResult();
        for (IOperateInfo errorInfo : errorInfos) {
            this.errorMessage = this.errorMessage.append(errorInfo.getMessage()).append('\n');
        }
        for (IOperateInfo errorInfo : errorInfosPush) {
            this.errorMessage = this.errorMessage.append(errorInfo.getMessage()).append('\n');
        }
        if (result == null || !result.isSuccess() || resultPush == null || !resultPush.isSuccess()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_operationresult");
            parameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u64cd\u4f5c", (String)"BatchClaimPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            if (errorInfos.size() > 0 || errorInfosPush.size() > 0) {
                int size = result.getSuccessPkIds().size() + resultPush.getSuccessPkIds().size() + validateResult.errorSize() + validateResultPush.errorSize();
                parameter.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u8ba4\u9886\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"BatchClaimPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), size, result.getSuccessPkIds().size() + resultPush.getSuccessPkIds().size(), validateResult.errorSize() + validateResultPush.errorSize()));
                parameter.setCustomParam("errorMsg", (Object)this.errorMessage);
                this.getView().showForm(parameter);
            }
            StringBuilder message = new StringBuilder();
            if (errorInfos.size() == 0 && result.getSuccessPkIds().size() == 0) {
                message.append(result.getMessage());
            }
            if (errorInfosPush.size() == 0 && resultPush.getSuccessPkIds().size() == 0) {
                if (message.length() > 0) {
                    message.append(resultPush.getMessage());
                    parameter.setCustomParam("errorMsg", (Object)message);
                } else if (CasHelper.isNotEmpty((Object)resultPush.getMessage()) && resultPush.getMessage().length() > 0) {
                    parameter.setCustomParam("errorMsg", (Object)resultPush.getMessage());
                }
            }
            this.getView().showForm(parameter);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnsubmit"});
            if ("submit".equals(option)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BatchClaimPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba4\u9886\u6210\u529f", (String)"BatchClaimPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private OperationResult getOperationResult(DynamicObject[] claimBills, String optionStr) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        Set entryPropertyAll = allFields.keySet();
        for (DynamicObject claimBill : claimBills) {
            String billNoPage;
            DynamicObject entryDt;
            String billNo = claimBill.getString("claimno");
            DynamicObjectCollection casClaimCol = this.getModel().getEntryEntity("cas_claim");
            claimBill.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
            if ("cas_batchpayclaim".equals(this.getModel().getDataEntityType().getName())) {
                entryDt = (DynamicObject)claimBill.getDynamicObjectCollection("payentity").get(0);
                for (DynamicObject casClaim : casClaimCol) {
                    billNoPage = casClaim.getString("claimno");
                    String payeeType = casClaim.getString("payeetype");
                    Object payeeid = casClaim.get("recbasepayee");
                    if (!CasHelper.isNotEmpty((Object)billNo) || !billNo.equals(billNoPage)) continue;
                    claimBill.set("bizdate", casClaim.get("bizdate"));
                    claimBill.set("paytype", casClaim.get("paytype"));
                    claimBill.set("payeetype", casClaim.get("payeetype"));
                    claimBill.set("recbasetype", casClaim.get("recbasetype"));
                    claimBill.set("recbasepayee", casClaim.get("recbasepayee"));
                    if (EmptyUtil.isNotEmpty((String)payeeType) && !StringUtils.equals((CharSequence)payeeType, (CharSequence)"other") && CasHelper.isNotEmpty((Object)payeeid)) {
                        claimBill.set("recpayee", (Object)casClaim.getDynamicObject("recbasepayee").getString("name"));
                    }
                    if (EmptyUtil.isNotEmpty((String)payeeType) && !StringUtils.equals((CharSequence)payeeType, (CharSequence)"other") && CasHelper.isEmpty((Object)payeeid)) {
                        claimBill.set("recpayee", casClaim.get("recpayee"));
                    }
                    if (EmptyUtil.isNotEmpty((String)payeeType) && StringUtils.equals((CharSequence)payeeType, (CharSequence)"other")) {
                        claimBill.set("recpayee", (Object)casClaim.getString("recviewpayee"));
                    }
                    claimBill.set("claimamount", casClaim.get("claimamount"));
                    claimBill.set("recviewpayee", casClaim.get("recviewpayee"));
                    entryDt.set("e_paysettleorg", casClaim.get("settleorg"));
                    entryDt.set("e_paymaterial", casClaim.get("material"));
                    entryDt.set("e_expenseitem", casClaim.get("expenseitem"));
                    entryDt.set("e_payableamt", casClaim.get("payableamt"));
                    entryDt.set("e_paydiscountamt", casClaim.get("paydiscountamt"));
                    entryDt.set("e_payactamt", casClaim.get("payactamt"));
                    entryDt.set("project", casClaim.get("project"));
                    entryDt.set("e_payfundflowitem", casClaim.get("fundflowitem"));
                    entryDt.set("e_contractnumber", casClaim.get("contractnumber"));
                    entryDt.set("e_payremark", casClaim.get("remark"));
                    entryDt.set("e_paymenttype", casClaim.get("paytype"));
                    entryDt.set("pcostcenter", casClaim.get("pcostcenter"));
                    entryDt.set("pproductline", casClaim.get("pproductline"));
                    for (String entryProperty : entryPropertyAll) {
                        if (entryProperty.contains("entry_customer_") || entryProperty.contains("ecus_")) {
                            entryDt.set(entryProperty, casClaim.get(entryProperty));
                            continue;
                        }
                        if (!entryProperty.contains("customer_") && !entryProperty.contains("cus_")) continue;
                        claimBill.set(entryProperty, casClaim.get(entryProperty));
                    }
                }
                continue;
            }
            entryDt = (DynamicObject)claimBill.getDynamicObjectCollection("entryentity").get(0);
            for (DynamicObject casClaim : casClaimCol) {
                billNoPage = casClaim.getString("claimno");
                String paymentType = casClaim.getString("paymenttype");
                Object payerid = casClaim.get("payerid");
                if (!CasHelper.isNotEmpty((Object)billNo) || !billNo.equals(billNoPage)) continue;
                claimBill.set("bizdate", casClaim.get("bizdate"));
                claimBill.set("recpaytype", casClaim.get("recpaytype"));
                claimBill.set("paymenttype", casClaim.get("paymenttype"));
                claimBill.set("paymentbasetype", casClaim.get("paymentbasetype"));
                claimBill.set("recbasepayer", casClaim.get("payerid"));
                if (EmptyUtil.isNotEmpty((String)paymentType) && !StringUtils.equals((CharSequence)paymentType, (CharSequence)"other") && CasHelper.isNotEmpty((Object)payerid)) {
                    claimBill.set("recpayer", casClaim.getDynamicObject("payerid").getPkValue());
                }
                if (EmptyUtil.isNotEmpty((String)paymentType) && !StringUtils.equals((CharSequence)paymentType, (CharSequence)"other") && CasHelper.isEmpty((Object)payerid)) {
                    claimBill.set("recpayer", casClaim.get("recpayer"));
                }
                if (EmptyUtil.isNotEmpty((String)paymentType) && StringUtils.equals((CharSequence)paymentType, (CharSequence)"other")) {
                    claimBill.set("recpayer", (Object)casClaim.getString("payer"));
                }
                claimBill.set("claimamount", casClaim.get("claimamount"));
                claimBill.set("recviewpayer", casClaim.get("payer"));
                entryDt.set("e_settleorg", casClaim.get("settleorg"));
                entryDt.set("e_corebilltype", casClaim.get("corebilltype"));
                entryDt.set("e_corebillno", casClaim.get("corebillno"));
                entryDt.set("e_corebillid", casClaim.get("corebillid"));
                entryDt.set("e_corebillentryseq", casClaim.get("corebillentryseq"));
                entryDt.set("e_itemname", casClaim.get("itemname"));
                entryDt.set("e_material", casClaim.get("material"));
                entryDt.set("e_receivableamt", casClaim.get("receivableamt"));
                entryDt.set("e_discountamt", casClaim.get("discountamt"));
                entryDt.set("e_fee", casClaim.get("fee"));
                entryDt.set("e_actamt", casClaim.get("actamt"));
                entryDt.set("e_project", casClaim.get("project"));
                entryDt.set("e_fundflowitem", casClaim.get("fundflowitem"));
                entryDt.set("e_saleman", casClaim.get("saleman"));
                claimBill.set("description", casClaim.get("description"));
                entryDt.set("e_remark", casClaim.get("remark"));
                entryDt.set("e_receivingtype", casClaim.get("recpaytype"));
                for (String entryProperty : entryPropertyAll) {
                    if (entryProperty.contains("entry_customer_") || entryProperty.contains("ecus_")) {
                        entryDt.set(entryProperty, casClaim.get(entryProperty));
                        continue;
                    }
                    if (!entryProperty.contains("customer_") && !entryProperty.contains("cus_")) continue;
                    claimBill.set(entryProperty, casClaim.get(entryProperty));
                }
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        return OperationServiceHelper.executeOperate((String)optionStr, (String)"cas_claimbill", (DynamicObject[])claimBills, (OperateOption)option);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnsubmit"});
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.size() > 0) {
            ArrayList<DynamicObject> claimBillList = new ArrayList<DynamicObject>(10);
            List clAnId = (List)params.get("claimannounceid");
            if (CasHelper.isEmpty((Object)clAnId)) {
                return;
            }
            DynamicObject[] claimAnnounces = BusinessDataServiceHelper.load((Object[])clAnId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimannounce"));
            List billNoList = Arrays.stream(claimAnnounces).map(o -> o.getString("billno")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("claimno", "in", billNoList);
            QFilter billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            QFilter creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
            QFilter claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CLAIM.getValue());
            DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimno,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf, creatorQf, claimtypeQf});
            Map<String, List<DynamicObject>> claimBillListMap = Arrays.stream(claimblls).collect(Collectors.groupingBy(o -> o.getString("claimno")));
            ArrayList<Object> claimBillListId = new ArrayList<Object>(10);
            ArrayList<DynamicObject> claimAnPush = new ArrayList<DynamicObject>(10);
            for (DynamicObject claimAnnounce : claimAnnounces) {
                List<DynamicObject> claimBills = claimBillListMap.get(claimAnnounce.getString("billno"));
                if (null != claimBills && claimBills.size() >= 1) {
                    Object recentDateId = null;
                    Date recentDate = null;
                    for (DynamicObject claimbill : claimBills) {
                        Date createtime = claimbill.getDate("createtime");
                        if (recentDate == null) {
                            recentDate = createtime;
                            recentDateId = claimbill.getPkValue();
                        }
                        recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getPkValue() : recentDateId;
                    }
                    claimBillListId.add(recentDateId);
                    continue;
                }
                claimAnPush.add(claimAnnounce);
            }
            DynamicObject[] claimBills = new DynamicObject[]{};
            DynamicObject[] pushClaimBills = new DynamicObject[]{};
            if (claimBillListId.size() >= 1) {
                claimBills = BusinessDataServiceHelper.load((Object[])claimBillListId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimbill"));
                claimBillList.addAll(Arrays.asList(claimBills));
            }
            if (claimAnPush.size() >= 1) {
                pushClaimBills = BatchClaimPlugin.pushs(claimAnPush.toArray(new DynamicObject[0]), "cas_claimbill");
                claimBillList.addAll(Arrays.asList(pushClaimBills));
            }
            ArrayList<String> serializeDtObjList = new ArrayList<String>(10);
            for (DynamicObject dt : claimBillList) {
                String serializeDynamicObj = SerializeHelper.serializeDynamicObj((Object)dt);
                serializeDtObjList.add(serializeDynamicObj);
            }
            this.getPageCache().put("claimBillList", SerializationUtils.toJsonString(serializeDtObjList));
            if ("cas_batchpayclaim".equals(this.getModel().getDataEntityType().getName())) {
                this.importPayEntry(claimBills, pushClaimBills);
            } else {
                this.importEntry(claimBills, pushClaimBills);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection casClaimCol = this.getModel().getEntryEntity("cas_claim");
        if ("cas_batchclaim".equals(this.getModel().getDataEntityType().getName())) {
            for (int i = 0; i < casClaimCol.size(); ++i) {
                DynamicObject recpaytype = ((DynamicObject)casClaimCol.get(i)).getDynamicObject("recpaytype");
                if (CasHelper.isNotEmpty((Object)recpaytype) && !recpaytype.getBoolean("ispartreceivable")) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"corebillentryseq", "itemname", "material", "discountamt", "saleman"});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"corebillentryseq", "itemname", "material", "discountamt", "saleman"});
            }
        } else {
            for (int i = 0; i < casClaimCol.size(); ++i) {
                DynamicObject payType = ((DynamicObject)casClaimCol.get(i)).getDynamicObject("paytype");
                if (CasHelper.isNotEmpty((Object)payType) && !payType.getBoolean("ispartpayment")) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"material", "payableamt", "paydiscountamt", "discountamt", "saleman"});
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"payactamt"});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"material", "payableamt", "paydiscountamt", "discountamt", "saleman"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"payactamt"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty iDataEntityProperty = e.getProperty();
        String propertyName = iDataEntityProperty.getName();
        Object recpaytypeObj = e.getChangeSet()[0].getNewValue();
        int entryInd = this.getModel().getEntryCurrentRowIndex("cas_claim");
        if (!(StringUtils.equals((CharSequence)propertyName, (CharSequence)"receivableamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"discountamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"fee"))) {
            if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"recpaytype")) {
                DynamicObject recpaytype = (DynamicObject)recpaytypeObj;
                if (CasHelper.isNotEmpty((Object)recpaytype) && !recpaytype.getBoolean("ispartreceivable")) {
                    this.getView().setEnable(Boolean.valueOf(false), entryInd, new String[]{"corebillentryseq", "itemname", "material", "discountamt", "saleman"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), entryInd, new String[]{"corebillentryseq", "itemname", "material", "discountamt", "saleman"});
                }
            } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"paytype")) {
                DynamicObject recpaytype = (DynamicObject)recpaytypeObj;
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (null != recpaytype && null != oldValue) {
                    if (recpaytype.getBoolean("ispartpayment") && !oldValue.getBoolean("ispartpayment")) {
                        this.getModel().setValue("payableamt", (Object)BigDecimal.ZERO, entryInd);
                        this.getModel().setValue("paydiscountamt", (Object)BigDecimal.ZERO, entryInd);
                        this.getModel().setValue("payactamt", (Object)BigDecimal.ZERO, entryInd);
                    }
                    if (!recpaytype.getBoolean("ispartpayment") && oldValue.getBoolean("ispartpayment")) {
                        this.getModel().setValue("payableamt", (Object)BigDecimal.ZERO, entryInd);
                        this.getModel().setValue("paydiscountamt", (Object)BigDecimal.ZERO, entryInd);
                        this.getModel().setValue("payactamt", (Object)BigDecimal.ZERO, entryInd);
                    }
                }
                if (null != recpaytype && !recpaytype.getBoolean("ispartpayment")) {
                    this.getView().setEnable(Boolean.valueOf(false), entryInd, new String[]{"material", "payableamt", "paydiscountamt", "discountamt", "saleman"});
                    this.getView().setEnable(Boolean.valueOf(true), entryInd, new String[]{"payactamt"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), entryInd, new String[]{"material", "payableamt", "paydiscountamt", "discountamt", "saleman"});
                    this.getView().setEnable(Boolean.valueOf(false), entryInd, new String[]{"payactamt"});
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnData;
        super.closedCallBack(e);
        if ("cas_batchclaim_info".equals(e.getActionId())) {
            Map returnData2 = (Map)e.getReturnData();
            if (!CasHelper.isEmpty((Object)returnData2)) {
                boolean isBatchEdit = (Boolean)returnData2.get("isbatchedit");
                EntryGrid entryGrid = (EntryGrid)this.getControl("cas_claim");
                int[] selectRows = entryGrid.getSelectRows();
                if (isBatchEdit && selectRows.length > 1) {
                    for (int selectRowIdx : selectRows) {
                        this.setRecClaimInfo(returnData2, selectRowIdx);
                    }
                } else {
                    int entryIdx = this.getModel().getEntryCurrentRowIndex("cas_claim");
                    this.setRecClaimInfo(returnData2, entryIdx);
                }
            }
        } else if ("cas_batchpayclaim_info".equals(e.getActionId()) && !CasHelper.isEmpty((Object)(returnData = (Map)e.getReturnData()))) {
            int entryInd = this.getModel().getEntryCurrentRowIndex("cas_claim");
            DynamicObject payType = (DynamicObject)returnData.get("paytype");
            String payeetype = (String)returnData.get("payeetype");
            DynamicObject settleorg = (DynamicObject)returnData.get("settleorg");
            if (CasHelper.isNotEmpty((Object)payType)) {
                String payTypeStr = payType.getLocaleString("name").getLocaleValue();
                this.getModel().setValue("paytypestr", (Object)payTypeStr, entryInd);
            }
            if (CasHelper.isNotEmpty((Object)payeetype)) {
                String payeetypestr = (String)this.getType(payeetype);
                this.getModel().setValue("payeetypestr", (Object)payeetypestr, entryInd);
            }
            if (CasHelper.isNotEmpty((Object)settleorg)) {
                String settleorgstr = settleorg.getLocaleString("name").getLocaleValue();
                this.getModel().setValue("paysettleorgstr", (Object)settleorgstr, entryInd);
            }
            this.getModel().setValue("paytype", (Object)payType, entryInd);
            this.getModel().setValue("payeetype", (Object)payeetype, entryInd);
            this.getModel().setValue("recbasetype", returnData.get("recbasetype"), entryInd);
            this.getModel().setValue("settleorg", (Object)settleorg, entryInd);
            this.getModel().setValue("recviewpayee", returnData.get("recpayee"), entryInd);
            this.getModel().setValue("recpayee", returnData.get("recpayee"), entryInd);
            this.getModel().setValue("recbasepayee", returnData.get("recbasepayee"), entryInd);
            DynamicObject recbasepayee = (DynamicObject)returnData.get("recbasepayee");
            if (CasHelper.isNotEmpty((Object)recbasepayee)) {
                this.getModel().setValue("recpayee", recbasepayee.getPkValue(), entryInd);
            }
        }
    }

    private void importPayEntry(DynamicObject[] claimBills, DynamicObject[] pushClaimBills) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("org", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("claimno", new Object[0]);
        vs.addField("oppunit", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("payamount", new Object[0]);
        vs.addField("unclaimamount", new Object[0]);
        vs.addField("claimedamount", new Object[0]);
        vs.addField("claimstatus", new Object[0]);
        vs.addField("businesstype", new Object[0]);
        vs.addField("tradetime", new Object[0]);
        vs.addField("tradedetailno", new Object[0]);
        vs.addField("detailid", new Object[0]);
        vs.addField("bankdetailno", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("paytypestr", new Object[0]);
        vs.addField("paytype", new Object[0]);
        vs.addField("payeetypestr", new Object[0]);
        vs.addField("payeetype", new Object[0]);
        vs.addField("recbasetype", new Object[0]);
        vs.addField("recbasepayee", new Object[0]);
        vs.addField("recpayee", new Object[0]);
        vs.addField("recviewpayee", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("paysettleorgstr", new Object[0]);
        vs.addField("settleorg", new Object[0]);
        vs.addField("expenseitem", new Object[0]);
        vs.addField("payableamt", new Object[0]);
        vs.addField("paydiscountamt", new Object[0]);
        vs.addField("payactamt", new Object[0]);
        vs.addField("project", new Object[0]);
        vs.addField("fundflowitem", new Object[0]);
        vs.addField("contractnumber", new Object[0]);
        vs.addField("remark", new Object[0]);
        vs.addField("pcostcenter", new Object[0]);
        vs.addField("pproductline", new Object[0]);
        vs.addField("claimtag", new Object[0]);
        vs.addField("claimamount", new Object[0]);
        this.addPayClaimBill(claimBills, vs);
        this.addPayClaimBill(pushClaimBills, vs);
        model.batchCreateNewEntryRow("cas_claim", vs);
        model.endInit();
    }

    private void importEntry(DynamicObject[] claimBills, DynamicObject[] pushClaimBills) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("org", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("claimno", new Object[0]);
        vs.addField("oppunit", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("reamount", new Object[0]);
        vs.addField("unclaimamount", new Object[0]);
        vs.addField("claimedamount", new Object[0]);
        vs.addField("claimstatus", new Object[0]);
        vs.addField("businesstype", new Object[0]);
        vs.addField("tradetime", new Object[0]);
        vs.addField("tradedetailno", new Object[0]);
        vs.addField("drawername", new Object[0]);
        vs.addField("detailid", new Object[0]);
        vs.addField("bankdetailno", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("recpaytypestr", new Object[0]);
        vs.addField("recpaytype", new Object[0]);
        vs.addField("paymenttypestr", new Object[0]);
        vs.addField("paymenttype", new Object[0]);
        vs.addField("paymentbasetype", new Object[0]);
        vs.addField("payerid", new Object[0]);
        vs.addField("recpayer", new Object[0]);
        vs.addField("payer", new Object[0]);
        vs.addField("settleorgstr", new Object[0]);
        vs.addField("settleorg", new Object[0]);
        vs.addField("corebilltypestr", new Object[0]);
        vs.addField("corebilltype", new Object[0]);
        vs.addField("corebillno", new Object[0]);
        vs.addField("corebillid", new Object[0]);
        vs.addField("corebillentryseq", new Object[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("receivableamt", new Object[0]);
        vs.addField("discountamt", new Object[0]);
        vs.addField("fee", new Object[0]);
        vs.addField("actamt", new Object[0]);
        vs.addField("project", new Object[0]);
        vs.addField("fundflowitem", new Object[0]);
        vs.addField("saleman", new Object[0]);
        vs.addField("description", new Object[0]);
        vs.addField("remark", new Object[0]);
        vs.addField("claimtag", new Object[0]);
        vs.addField("accountbank", new Object[0]);
        vs.addField("oppbanknumber", new Object[0]);
        vs.addField("claimamount", new Object[0]);
        this.addClaimBill(claimBills, vs);
        this.addClaimBill(pushClaimBills, vs);
        model.batchCreateNewEntryRow("cas_claim", vs);
        model.endInit();
    }

    private void addPayClaimBill(DynamicObject[] claimBills, TableValueSetter vs) {
        for (DynamicObject claimBill : claimBills) {
            Object[] claimBillCol;
            Object recpayeeId;
            String payeeType;
            Object payee = null;
            Object payTypeStr = null;
            Object payeeTypeValue = null;
            DynamicObject payType = claimBill.getDynamicObject("paytype");
            DynamicObject entryDt = (DynamicObject)claimBill.getDynamicObjectCollection("payentity").get(0);
            if (CasHelper.isNotEmpty((Object)payType)) {
                payTypeStr = payType.get("name");
            }
            if (CasHelper.isNotEmpty((Object)(payeeType = claimBill.getString("payeetype")))) {
                payeeTypeValue = this.getType(payeeType);
            }
            payee = claimBill.getString("recviewpayee");
            long defaultOrgId = 0L;
            Object defaultOrgIdStr = null;
            DynamicObject settleOrg = entryDt.getDynamicObject("e_paysettleorg");
            if (CasHelper.isNotEmpty((Object)settleOrg)) {
                defaultOrgId = (Long)settleOrg.getPkValue();
                defaultOrgIdStr = settleOrg.get("name");
            } else {
                DynamicObject recOrg = (DynamicObject)this.getModel().getValue("org");
                DynamicObject defaultOrg = null;
                if (EmptyUtil.isNoEmpty((DynamicObject)recOrg)) {
                    DynamicObject recAccount;
                    DynamicObject centerOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting");
                    if (EmptyUtil.isNoEmpty((DynamicObject)centerOrg) && centerOrg.getBoolean("fisaccounting")) {
                        defaultOrg = recOrg;
                    }
                    if ((recAccount = claimBill.getDynamicObject("accountbank")) != null) {
                        defaultOrg = recAccount.getDynamicObject("openorg");
                    }
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)recOrg)) {
                    DynamicObject org = (DynamicObject)defaultOrg.get("org");
                    defaultOrgIdStr = org.get("name");
                    defaultOrgId = (Long)defaultOrg.getPkValue();
                }
            }
            String claimNo = claimBill.getString("claimno");
            QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"claimstatus,claimedamount,unclaimamount", (QFilter[])new QFilter[]{claimNoQ});
            Object claimstatus = null;
            BigDecimal claimedamount = new BigDecimal("0");
            BigDecimal unclaimamount = new BigDecimal("0");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
                claimstatus = ((DynamicObject)colls.get(0)).get("claimstatus");
                claimedamount = ((DynamicObject)colls.get(0)).getBigDecimal("claimedamount");
                unclaimamount = ((DynamicObject)colls.get(0)).getBigDecimal("unclaimamount");
            }
            QFilter claimNoQ1 = new QFilter("claimNo", "=", (Object)claimNo);
            claimNoQ1.and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())).and(new QFilter("claimtype", "!=", (Object)ClaimTypeEnum.ADJUST.getValue()));
            Date bizDate = null;
            boolean claimTag = false;
            Object recbasetype = claimBill.get("recbasetype");
            Object recBasePayee = claimBill.get("recbasepayee");
            bizDate = claimBill.getDate("bizdate");
            DynamicObject recpayee = claimBill.getDynamicObject("recbasepayee");
            Object object = recpayeeId = null == recpayee ? null : recpayee.get("id");
            if (CasHelper.isNotEmpty((Object)payeeType) && "other".equals(payeeType)) {
                payee = claimBill.get("recpayee");
                recpayeeId = claimBill.get("recpayee");
            }
            if (CasHelper.isNotEmpty((Object)payeeType) && !"other".equals(payeeType) && null != recpayee) {
                payee = recpayee.get("name");
            }
            if (!EmptyUtil.isEmpty((Object[])(claimBillCol = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"paytype,payeetype,recbasetype,recbasepayee,recpayee,recviewpayee,bizdate", (QFilter[])new QFilter[]{claimNoQ1}, (String)" auditdate asc ")))) {
                claimTag = true;
                Object claimBillAudit = claimBillCol[0];
                payTypeStr = claimBillAudit.getDynamicObject("paytype").get("name");
                payType = claimBillAudit.getDynamicObject("paytype");
                payeeTypeValue = this.getType(claimBillAudit.getString("payeetype"));
                payeeType = claimBillAudit.getString("payeetype");
                recbasetype = claimBillAudit.get("recbasetype");
                recBasePayee = claimBillAudit.get("recbasepayee");
                DynamicObject recpayeeAudit = claimBillAudit.getDynamicObject("recbasepayee");
                Object object2 = recpayeeId = null == recpayeeAudit ? null : recpayeeAudit.get("id");
                if (CasHelper.isNotEmpty((Object)payeeType) && "other".equals(payeeType)) {
                    payee = claimBill.get("recpayee");
                    recpayeeId = claimBill.get("recpayee");
                }
                if (CasHelper.isNotEmpty((Object)payeeType) && !"other".equals(payeeType) && null != recpayee) {
                    payee = recpayeeAudit.get("name");
                }
                bizDate = claimBillAudit.getDate("bizdate");
            }
            vs.addRow(new Object[]{claimBill.getDynamicObject("org").getPkValue(), claimBill.getString("billno"), claimBill.getString("claimno"), claimBill.getString("oppunit"), claimBill.getDynamicObject("currency").getPkValue(), claimBill.getBigDecimal("payamount"), unclaimamount, claimedamount, claimstatus, claimBill.getString("businesstype"), claimBill.getDate("tradetime"), claimBill.getString("tradedetailno"), claimBill.getString("detailid"), claimBill.getString("bankdetailno"), bizDate, payTypeStr, EmptyUtil.isNoEmpty((DynamicObject)payType) ? payType.getPkValue() : null, payeeTypeValue, payeeType, recbasetype, recBasePayee, recpayeeId, payee, entryDt.get("e_paymaterial"), defaultOrgIdStr, defaultOrgId, EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("e_expenseitem")) ? null : entryDt.getDynamicObject("e_expenseitem").getPkValue(), entryDt.get("e_payableamt"), entryDt.get("e_paydiscountamt"), entryDt.get("e_payactamt"), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("project")) ? null : entryDt.getDynamicObject("project").getPkValue(), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("e_payfundflowitem")) ? null : entryDt.getDynamicObject("e_payfundflowitem").getPkValue(), entryDt.get("e_contractnumber"), entryDt.get("e_payremark"), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("pcostcenter")) ? null : entryDt.getDynamicObject("pcostcenter").getPkValue(), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("pproductline")) ? null : entryDt.getDynamicObject("pproductline").getPkValue(), claimTag, claimBill.getBigDecimal("claimamount")});
        }
    }

    private void addClaimBill(DynamicObject[] claimBills, TableValueSetter vs) {
        for (DynamicObject claimBill : claimBills) {
            Object[] claimBillCol;
            String payMenType;
            String coreBillType;
            Object payer = null;
            Object recPayTypeStr = null;
            Object payMenTypeValue = null;
            Object coreBillTypeStr = null;
            DynamicObject recPayType = claimBill.getDynamicObject("recpaytype");
            DynamicObject entryDt = (DynamicObject)claimBill.getDynamicObjectCollection("entryentity").get(0);
            if (CasHelper.isNotEmpty((Object)recPayType)) {
                recPayTypeStr = recPayType.get("name");
            }
            if (CasHelper.isNotEmpty((Object)(coreBillType = entryDt.getString("e_corebilltype")))) {
                coreBillTypeStr = this.getCoreBillType(coreBillType);
            }
            if (CasHelper.isNotEmpty((Object)(payMenType = claimBill.getString("paymenttype")))) {
                payMenTypeValue = this.getType(payMenType);
            }
            payer = claimBill.getString("recviewpayer");
            long accountBankId = 0L;
            DynamicObject accountBank = (DynamicObject)claimBill.get("accountbank");
            if (CasHelper.isNotEmpty((Object)accountBank)) {
                accountBankId = (Long)accountBank.getPkValue();
            }
            long defaultOrgId = 0L;
            Object defaultOrgIdStr = null;
            DynamicObject settleOrg = entryDt.getDynamicObject("e_settleorg");
            if (CasHelper.isNotEmpty((Object)settleOrg)) {
                defaultOrgId = (Long)settleOrg.getPkValue();
                defaultOrgIdStr = settleOrg.get("name");
            } else {
                DynamicObject recOrg = (DynamicObject)this.getModel().getValue("org");
                DynamicObject defaultOrg = null;
                if (EmptyUtil.isNoEmpty((DynamicObject)recOrg)) {
                    DynamicObject recAccount;
                    DynamicObject centerOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting");
                    if (EmptyUtil.isNoEmpty((DynamicObject)centerOrg) && centerOrg.getBoolean("fisaccounting")) {
                        defaultOrg = recOrg;
                    }
                    if ((recAccount = claimBill.getDynamicObject("accountbank")) != null) {
                        defaultOrg = recAccount.getDynamicObject("openorg");
                    }
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)recOrg)) {
                    DynamicObject org = (DynamicObject)defaultOrg.get("org");
                    defaultOrgIdStr = org.get("name");
                    defaultOrgId = (Long)defaultOrg.getPkValue();
                }
            }
            String claimNo = claimBill.getString("claimno");
            QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"claimstatus,claimedamount,unclaimamount", (QFilter[])new QFilter[]{claimNoQ});
            Object claimstatus = null;
            BigDecimal claimedamount = new BigDecimal("0");
            BigDecimal unclaimamount = new BigDecimal("0");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
                claimstatus = ((DynamicObject)colls.get(0)).get("claimstatus");
                claimedamount = ((DynamicObject)colls.get(0)).getBigDecimal("claimedamount");
                unclaimamount = ((DynamicObject)colls.get(0)).getBigDecimal("unclaimamount");
            }
            QFilter claimNoQ1 = new QFilter("claimNo", "=", (Object)claimNo);
            claimNoQ1.and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())).and(new QFilter("claimtype", "!=", (Object)ClaimTypeEnum.ADJUST.getValue()));
            Date bizDate = null;
            boolean claimTag = false;
            Object paymentbasetype = null;
            Object recBasePayer = claimBill.get("recbasepayer");
            bizDate = claimBill.getDate("bizdate");
            Object recpayer = claimBill.get("recpayer");
            if (CasHelper.isNotEmpty((Object)payMenType) && "other".equals(payMenType)) {
                payer = claimBill.get("recpayer");
            }
            if (CasHelper.isNotEmpty((Object)payMenType) && !"other".equals(payMenType) && CasHelper.isNotEmpty((Object)recpayer)) {
                DynamicObject recPayObj = BusinessDataServiceHelper.loadSingle((Object)recpayer, (String)payMenType);
                payer = recPayObj.getString("name");
            }
            if (!EmptyUtil.isEmpty((Object[])(claimBillCol = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"recpaytype,paymenttype,paymentbasetype,recbasepayer,recviewpayer,recpayer,bizdate", (QFilter[])new QFilter[]{claimNoQ1}, (String)" auditdate asc ")))) {
                claimTag = true;
                Object claimBillAudit = claimBillCol[0];
                recPayTypeStr = claimBillAudit.getDynamicObject("recpaytype").get("name");
                recPayType = claimBillAudit.getDynamicObject("recpaytype");
                payMenTypeValue = this.getType(claimBillAudit.getString("paymenttype"));
                payMenType = claimBillAudit.getString("paymenttype");
                paymentbasetype = claimBillAudit.get("paymentbasetype");
                recBasePayer = claimBillAudit.get("recbasepayer");
                payer = claimBillAudit.get("recviewpayer");
                recpayer = claimBillAudit.get("recpayer");
                bizDate = claimBillAudit.getDate("bizdate");
            }
            vs.addRow(new Object[]{claimBill.getDynamicObject("org").getPkValue(), claimBill.getString("billno"), claimBill.getString("claimno"), claimBill.getString("oppunit"), claimBill.getDynamicObject("currency").getPkValue(), claimBill.getBigDecimal("reamount"), unclaimamount, claimedamount, claimstatus, claimBill.getString("businesstype"), claimBill.getDate("tradetime"), claimBill.getString("tradedetailno"), claimBill.getString("drawername"), claimBill.getString("detailid"), claimBill.getString("bankdetailno"), bizDate, recPayTypeStr, EmptyUtil.isNoEmpty((DynamicObject)recPayType) ? recPayType.getPkValue() : null, payMenTypeValue, payMenType, paymentbasetype, recBasePayer, recpayer, payer, defaultOrgIdStr, defaultOrgId, coreBillTypeStr, entryDt.get("e_corebilltype"), entryDt.get("e_corebillno"), entryDt.get("e_corebillid"), entryDt.get("e_corebillentryseq"), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("e_itemname")) ? null : entryDt.getDynamicObject("e_itemname").getPkValue(), entryDt.get("e_material"), entryDt.get("e_receivableamt"), entryDt.get("e_discountamt"), entryDt.get("e_fee"), entryDt.get("e_actamt"), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("e_project")) ? null : entryDt.getDynamicObject("e_project").getPkValue(), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("e_fundflowitem")) ? null : entryDt.getDynamicObject("e_fundflowitem").getPkValue(), EmptyUtil.isEmpty((DynamicObject)entryDt.getDynamicObject("e_saleman")) ? null : entryDt.getDynamicObject("e_saleman").getPkValue(), claimBill.getString("description"), entryDt.get("e_remark"), claimTag, accountBankId, claimBill.getString("oppbanknumber"), claimBill.getBigDecimal("claimamount")});
        }
    }

    private void doBatchInput() {
        EntryGrid entry = (EntryGrid)this.getView().getControl("cas_claim");
        int[] selectRows = entry.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u6279\u91cf\u5f55\u5165\u4f5c", (String)"BatchClaimPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_batchclaim_input");
            showParameter.setAppId("cas");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_batchclaim_input"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void showPayInfo() {
        int entryInd = this.getModel().getEntryCurrentRowIndex("cas_claim");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_batchpayclaim_info");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_batchpayclaim_info"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("paytype", CasHelper.isNotEmpty((Object)this.getModel().getValue("paytype")) ? ((DynamicObject)this.getModel().getValue("paytype", entryInd)).getPkValue() : null);
        showParameter.setCustomParam("payeetype", this.getModel().getValue("payeetype", entryInd));
        showParameter.setCustomParam("recbasetype", this.getModel().getValue("recbasetype", entryInd));
        Object payeeId = this.getModel().getValue("recpayee", entryInd);
        showParameter.setCustomParam("recbasepayee", payeeId);
        showParameter.setCustomParam("recpayee", this.getModel().getValue("recpayee", entryInd));
        DynamicObject settleOrg = (DynamicObject)this.getModel().getValue("settleorg", entryInd);
        if (CasHelper.isNotEmpty((Object)settleOrg)) {
            showParameter.setCustomParam("settleorg", settleOrg.getPkValue());
        }
        showParameter.setCustomParam("claimtag", this.getModel().getValue("claimtag", entryInd));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org", entryInd);
        showParameter.setCustomParam("org", org.getPkValue());
        this.getView().showForm(showParameter);
    }

    private void showRecInfo() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_batchclaim_info");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_batchclaim_info"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("cas_claim");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 1) {
            int entryInd = this.getModel().getEntryCurrentRowIndex("cas_claim");
            showParameter.setCustomParam("recpaytype", CasHelper.isNotEmpty((Object)this.getModel().getValue("recpaytype")) ? ((DynamicObject)this.getModel().getValue("recpaytype", entryInd)).getPkValue() : null);
            showParameter.setCustomParam("paymenttype", this.getModel().getValue("paymenttype", entryInd));
            showParameter.setCustomParam("payerbasetype", this.getModel().getValue("paymentbasetype", entryInd));
            DynamicObject payerIdObj = (DynamicObject)this.getModel().getValue("payerid", entryInd);
            Object payerId = null;
            if (CasHelper.isNotEmpty((Object)payerIdObj)) {
                payerId = payerIdObj.getPkValue();
            }
            DynamicObject accountBankObj = (DynamicObject)this.getModel().getValue("accountbank", entryInd);
            Long accountBankId = 0L;
            if (CasHelper.isNotEmpty((Object)accountBankObj)) {
                accountBankId = (Long)accountBankObj.getPkValue();
            }
            showParameter.setCustomParam("payerid", payerId);
            showParameter.setCustomParam("payer", this.getModel().getValue("payer", entryInd));
            DynamicObject settleOrg = (DynamicObject)this.getModel().getValue("settleorg", entryInd);
            if (CasHelper.isNotEmpty((Object)settleOrg)) {
                showParameter.setCustomParam("settleorg", settleOrg.getPkValue());
            }
            showParameter.setCustomParam("corebilltype", this.getModel().getValue("corebilltype", entryInd));
            showParameter.setCustomParam("corebillno", this.getModel().getValue("corebillno", entryInd));
            showParameter.setCustomParam("oppbanknumber", this.getModel().getValue("oppbanknumber", entryInd));
            showParameter.setCustomParam("accountbank", (Object)accountBankId);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", entryInd);
            showParameter.setCustomParam("org", org.getPkValue());
            showParameter.setCustomParam("claimtag", this.getModel().getValue("claimtag", entryInd));
            showParameter.setCustomParam("recpayer", this.getModel().getValue("recpayer", entryInd));
            showParameter.setCustomParam("businesstype", this.getModel().getValue("businesstype", entryInd));
            showParameter.setCustomParam("currency", this.getModel().getValue("currency", entryInd));
            showParameter.setCustomParam("isbatchedit", (Object)false);
        } else if (selectRows.length > 1) {
            DynamicObjectCollection casClaim = this.getModel().getEntryEntity("cas_claim");
            casClaim = casClaim.stream().filter(claim -> claim.getDynamicObject("accountbank") != null && claim.getDynamicObject("settleorg") != null && claim.getDynamicObject("org") != null).collect(Collectors.toCollection(DynamicObjectCollection::new));
            HashSet<Long> accountSet = new HashSet<Long>(16);
            HashSet<String> oppAccountSet = new HashSet<String>(16);
            HashSet<Long> orgSet = new HashSet<Long>(16);
            HashSet<Long> settleOrgSet = new HashSet<Long>(16);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)casClaim)) {
                for (DynamicObject item : casClaim) {
                    accountSet.add(item.getDynamicObject("accountbank").getLong("id"));
                    oppAccountSet.add(item.getString("oppbanknumber"));
                    orgSet.add(item.getDynamicObject("org").getLong("id"));
                    settleOrgSet.add(item.getDynamicObject("settleorg").getLong("id"));
                }
            }
            if (settleOrgSet.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u6570\u636e\u7684\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u7f16\u8f91\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatchClaimPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setCustomParam("claimtag", this.getModel().getValue("claimtag", selectRows[0]));
            showParameter.setCustomParam("currency", this.getModel().getValue("currency", selectRows[0]));
            showParameter.setCustomParam("businesstype", this.getModel().getValue("businesstype", selectRows[0]));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", selectRows[0]);
            DynamicObject settleOrg = (DynamicObject)this.getModel().getValue("settleorg", selectRows[0]);
            if (CasHelper.isNotEmpty((Object)settleOrg)) {
                showParameter.setCustomParam("settleorg", settleOrg.getPkValue());
            }
            showParameter.setCustomParam("org", orgSet.size() == 1 ? org.getPkValue() : null);
            showParameter.setCustomParam("accountbank", accountSet);
            showParameter.setCustomParam("oppbanknumber", oppAccountSet);
            showParameter.setCustomParam("isbatchedit", (Object)true);
        }
        this.getView().showForm(showParameter);
    }

    private Object getType(String type) {
        String res = "";
        switch (type) {
            case "bos_org": {
                res = ClaimPaymentTypeEnum.ORG.getName();
                break;
            }
            case "bd_supplier": {
                res = ClaimPaymentTypeEnum.SUPPLIER.getName();
                break;
            }
            case "bd_customer": {
                res = ClaimPaymentTypeEnum.CUSTOMER.getName();
                break;
            }
            case "bos_user": {
                res = ClaimPaymentTypeEnum.USER.getName();
                break;
            }
            case "other": {
                res = ClaimPaymentTypeEnum.OTHER.getName();
                break;
            }
        }
        return res;
    }

    private Object getCoreBillType(String type) {
        String res = "";
        switch (type) {
            case "ar_finarbill": {
                res = ClaimCoreBillTypeEnum.FINARBILL.getName();
                break;
            }
            case "sm_salorder": {
                res = ClaimCoreBillTypeEnum.SALORDER.getName();
                break;
            }
            case "conm_salcontract": {
                res = ClaimCoreBillTypeEnum.SALCONTRACT.getName();
                break;
            }
            case "cas_paybill": {
                res = ClaimCoreBillTypeEnum.PAYBILL.getName();
                break;
            }
            case "fr_glreim_paybill": {
                res = ClaimCoreBillTypeEnum.GLREIMBILL.getName();
                break;
            }
            case "fr_glreim_recbill": {
                res = ClaimCoreBillTypeEnum.GLREIMRECBILL.getName();
                break;
            }
        }
        return res;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"claimno", (CharSequence)evt.getFieldName())) {
            Object claimNo = this.getModel().getValue("claimno", this.getModel().getEntryCurrentRowIndex("cas_claim"));
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cas_claimannounce");
            QFilter billno = new QFilter("billno", "=", claimNo);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{billno});
            showParameter.setFormId("cas_claimannounce");
            showParameter.setPkId(ids[0].getPkValue());
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private static DynamicObject[] pushs(DynamicObject[] infos, String TargetEntity) {
        String sourceEntity = infos[0].getDataEntityType().getName();
        String ruleId = BatchClaimPlugin.getDefaultBotpRule(sourceEntity, TargetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(infos.length);
        for (DynamicObject info : infos) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(info.getPkValue());
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(TargetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)TargetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < dynamicresults.size(); ++i) {
            dataEntities[i] = (DynamicObject)dynamicresults.get(i);
            String number = codeRuleService.readNumber(TargetEntity, (DynamicObject)dynamicresults.get(i), ((DynamicObject)dynamicresults.get(i)).getString("org.id"));
            if (kd.bos.util.StringUtils.isEmpty((String)number)) {
                if (DevHelper.isDevEnv()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    number = simpleDateFormat.format(new Date());
                    number = number + String.valueOf(random.nextInt(1000000));
                } else {
                    ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\u3002", (String)"CasBotpHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
            }
            dataEntities[i].set("billno", (Object)number);
        }
        return dataEntities;
    }

    private static String getDefaultBotpRule(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CasBotpHelper_2", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return rules[0].getString("id");
    }

    private void setRecClaimInfo(Map<String, Object> returnData, int rowIdx) {
        Object[] coreBillColl;
        String corebillId;
        DynamicObject recPayType = (DynamicObject)returnData.get("recpaytype");
        String paymentType = (String)returnData.get("paymenttype");
        DynamicObject settleOrg = (DynamicObject)returnData.get("settleorg");
        String coreBillType = (String)returnData.get("corebilltype");
        String coreBillNo = (String)returnData.get("corebillno");
        this.getModel().beginInit();
        if (CasHelper.isNotEmpty((Object)recPayType)) {
            String recPayTypeStr = recPayType.getLocaleString("name").getLocaleValue();
            this.getModel().setValue("recpaytypestr", (Object)recPayTypeStr, rowIdx);
        }
        if (CasHelper.isNotEmpty((Object)paymentType)) {
            String paymenttypestr = (String)this.getType(paymentType);
            this.getModel().setValue("paymenttypestr", (Object)paymenttypestr, rowIdx);
        }
        if (CasHelper.isNotEmpty((Object)settleOrg)) {
            String settleorgstr = settleOrg.getLocaleString("name").getLocaleValue();
            this.getModel().setValue("settleorgstr", (Object)settleorgstr, rowIdx);
        }
        if (CasHelper.isNotEmpty((Object)coreBillType)) {
            String corebilltypestr = (String)this.getCoreBillType(coreBillType);
            this.getModel().setValue("corebilltypestr", (Object)corebilltypestr, rowIdx);
        }
        if (CasHelper.isEmpty((Object)(corebillId = (String)returnData.get("corebillid"))) && CasHelper.isNotEmpty((Object)coreBillNo) && EmptyUtil.isNoEmpty((Object[])(coreBillColl = BusinessDataServiceHelper.load((String)coreBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)coreBillNo)})))) {
            corebillId = String.valueOf(coreBillColl[0].getLong("id"));
        }
        this.getModel().setValue("corebillid", (Object)corebillId, rowIdx);
        this.getModel().setValue("recpaytype", (Object)recPayType, rowIdx);
        this.getModel().setValue("paymenttype", (Object)paymentType, rowIdx);
        this.getModel().setValue("paymentbasetype", returnData.get("payerbasetype"), rowIdx);
        this.getModel().setValue("settleorg", (Object)settleOrg, rowIdx);
        this.getModel().setValue("corebilltype", (Object)coreBillType, rowIdx);
        this.getModel().setValue("corebillno", returnData.get("corebillno"), rowIdx);
        this.getModel().setValue("payer", returnData.get("payer"), rowIdx);
        this.getModel().setValue("payerid", returnData.get("payerid"), rowIdx);
        DynamicObject payerid = (DynamicObject)returnData.get("payerid");
        if (CasHelper.isNotEmpty((Object)payerid)) {
            this.getModel().setValue("recpayer", payerid.getPkValue(), rowIdx);
        }
        this.getModel().endInit();
        this.getView().updateView("cas_claim");
    }
}

