/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimnotice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.recclaim.CommonOperationHandler;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.result.InvokeResult;
import kd.fi.cas.util.EmptyUtil;

public class ClaimNoticeEditPlugin
extends BillEditPlugin
implements HyperLinkClickListener,
EntryGridBindDataListener {
    public void initialize() {
        super.initialize();
        Control entryentity = this.getView().getControl("entryentity");
        EntryGrid entry = (EntryGrid)entryentity;
        entry.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tradedetailno"});
        Control entryentity = this.getView().getControl("entryentity");
        Control entryentity1 = this.getView().getControl("detailentryentity");
        Control entryentity2 = this.getView().getControl("ticketentryentity");
        Control payentity = this.getView().getControl("payentity");
        EntryGrid entry = (EntryGrid)entryentity;
        EntryGrid entry1 = (EntryGrid)entryentity1;
        EntryGrid entry2 = (EntryGrid)entryentity2;
        EntryGrid payentityGrid = (EntryGrid)payentity;
        payentityGrid.addHyperClickListener((HyperLinkClickListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        entry1.addHyperClickListener((HyperLinkClickListener)this);
        entry2.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"tradedetailno", (CharSequence)key)) {
            String businessType = (String)this.getModel().getValue("businesstype");
            String dataSource = (String)this.getModel().getValue("datasource");
            String billNo = (String)this.getModel().getValue("tradedetailno");
            QFilter billNoQf = new QFilter("recticket".equals(businessType) && !"elerecticket".equals(dataSource) ? "draftbillno" : "billno", "=", (Object)billNo);
            String entity = "recticket".equals(businessType) && !"elerecticket".equals(dataSource) ? "cdm_receivablebill" : ("elerecticket".equals(dataSource) ? "cdm_electronic_sign_deal" : "bei_transdetail_cas");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])new QFilter[]{billNoQf});
            if ("recticket".equals(businessType)) {
                if (ids.length < 1 && !"elerecticket".equals(dataSource)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6b64\u5e94\u6536\u7968\u636e\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ids.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_45", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6536\u4ed8\u5904\u7406\u5355\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(entity);
            showParameter.setPkId(this.getModel().getValue("sourceid"));
            showParameter.setCustomParam("onlyView", (Object)"onlyView");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("tradedetailno".equals(key)) {
            String newValue = String.valueOf(changeSet[0].getNewValue());
            if (!this.getView().getPageCache().get("tradedetailno").equals(newValue)) {
                this.getModel().setValue("tradedetailno", (Object)this.getView().getPageCache().get("tradedetailno"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        BigDecimal payAmount;
        super.afterBindData(e);
        IDataModel iDataModel = this.getModel();
        DynamicObject dataEntity = iDataModel.getDataEntity();
        if (dataEntity != null) {
            String claimstatus;
            DynamicObject recType = (DynamicObject)iDataModel.getValue("recpaytype");
            if (recType != null) {
                String bizType = recType.getString("biztype");
                if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccount"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"inneraccountname"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccount"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"inneraccountname"});
                }
                boolean ispartreceivable = recType.getBoolean("ispartreceivable");
                if (!ispartreceivable) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_settleorg", "e_itemname", "e_material", "e_corebillentryseq", "e_discountamt", "e_saleman"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg", "e_itemname", "e_material", "e_corebillentryseq", "e_discountamt", "e_saleman"});
                }
            }
            Boolean flag = false;
            String payment = (String)iDataModel.getValue("paymenttype");
            Object value = iDataModel.getValue("recpayer");
            if (EmptyUtil.isNotEmpty((String)payment) && !StringUtils.equals((CharSequence)payment, (CharSequence)"other")) {
                iDataModel.setValue("paymentbasetype", (Object)payment);
                iDataModel.setValue("recbasepayer", value);
                DynamicObject recbasepayer = (DynamicObject)iDataModel.getValue("recbasepayer");
                if (EmptyUtil.isNoEmpty((DynamicObject)recbasepayer)) {
                    iDataModel.setValue("payertext", (Object)recbasepayer.getString("name"));
                }
                flag = true;
            } else {
                iDataModel.setValue("payertext", value);
            }
            this.getView().setVisible(flag, new String[]{"recbasepayer"});
            this.getView().setVisible(Boolean.valueOf(flag == false), new String[]{"recpayer"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"paymentbasetype", "payertext"});
            Object chargereason = this.getModel().getValue("chargereason");
            if (chargereason != null && !"".equals(chargereason) && this.getPageCache().get("chargereason") == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u5355\uff08%1$s\uff09\u5df2\u9000\u5355\u3002\u9000\u5355\u539f\u56e0: %2$s\u3002", (String)"ClaimNoticeEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), String.valueOf(chargereason));
                this.getView().showMessage(msg);
                this.getPageCache().put("chargereason", "yes");
            }
            Container control = (Container)this.getControl("flexpanelap");
            String addContainerCache = this.getPageCache().get("addContainerCache");
            if (EmptyUtil.isNotEmpty((String)addContainerCache)) {
                control.deleteControls(addContainerCache.split(","));
            }
            if (StringUtils.equals((CharSequence)(claimstatus = (String)iDataModel.getValue("claimstatus")), (CharSequence)ClaimStatusEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claimstatus, (CharSequence)ClaimStatusEnum.CHANGE.getValue())) {
                String claimNo = (String)iDataModel.getValue("billno");
                QFilter qFilter = new QFilter("claimno", "=", (Object)claimNo);
                qFilter.and(new QFilter("claimtype", "in", (Object)new String[]{ClaimTypeEnum.APPEAL.getValue(), ClaimTypeEnum.CHANGE.getValue()}));
                qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                qFilter.and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
                Object[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (EmptyUtil.isNoEmpty((Object[])colls)) {
                    FlexPanelAp flex = null;
                    BillShowParameter showParameter = null;
                    StringBuilder flexNumber = new StringBuilder();
                    ArrayList<String> lst = new ArrayList<String>(colls.length);
                    for (int i = 0; i < colls.length; ++i) {
                        flexNumber.setLength(0);
                        flexNumber.append("flexpanelaptemp").append(i);
                        flex = new FlexPanelAp();
                        flex.setKey(flexNumber.toString());
                        control.addControls(Collections.singletonList(flex.createControl()));
                        showParameter = new BillShowParameter();
                        showParameter.setFormId("cas_claimappeal");
                        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                        showParameter.getOpenStyle().setTargetKey(flexNumber.toString());
                        lst.add(flexNumber.toString());
                        showParameter.setPkId((Object)colls[i].getLong("id"));
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                    this.getPageCache().put("addContainerCache", String.join((CharSequence)",", lst));
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
                ArrayList<Integer> deleteindex = new ArrayList<Integer>(entryEntity.size());
                for (int j = 0; j < entryEntity.size(); ++j) {
                    if (!StringUtils.equals((CharSequence)((DynamicObject)entryEntity.get(j)).getString("e_claimtype"), (CharSequence)ClaimTypeEnum.APPEAL.getValue()) && !StringUtils.equals((CharSequence)((DynamicObject)entryEntity.get(j)).getString("e_claimtype"), (CharSequence)ClaimTypeEnum.CHANGE.getValue()) || ((DynamicObject)entryEntity.get(j)).getBoolean("e_handlestatus")) continue;
                    deleteindex.add(j);
                }
                if (!deleteindex.isEmpty()) {
                    int[] index = new int[deleteindex.size()];
                    for (int i = 0; i < deleteindex.size(); ++i) {
                        index[i] = (Integer)deleteindex.get(i);
                    }
                    this.getModel().deleteEntryRows("entryentity", index);
                }
            }
            this.changeCaption();
            String mergestatus = (String)this.getModel().getValue("mergestatus");
            if (MergeStatusEnum.ALMARGE.getValue().equals(mergestatus)) {
                this.getDataToEntry();
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailentry", "ticketdetail"});
            }
            DynamicObjectCollection detailentryentity = this.getModel().getEntryEntity("detailentryentity");
            Map<String, List<DynamicObject>> oppBankNumberMap = detailentryentity.stream().collect(Collectors.groupingBy(c -> c.getString("e_oppunit")));
            if (oppBankNumberMap.size() > 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"oppunit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"e_oppunit"});
                iDataModel.setValue("recbasepayer", null);
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"oppunit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_oppunit"});
            }
        }
        if (this.getView().getPageCache().get("tradedetailno") == null) {
            this.getView().getPageCache().put("tradedetailno", (String)this.getModel().getValue("tradedetailno"));
        }
        if ((payAmount = (BigDecimal)this.getModel().getValue("payamount")).compareTo(BigDecimal.ZERO) != 0) {
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba4\u9886\u7ed3\u679c", (String)"ClaimAppealEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("flexpanelap1", props);
        }
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] receivingBillType = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,biztype,ispartreceivable", (QFilter[])new QFilter[]{qFilter});
        String businessType = (String)this.getModel().getValue("businesstype");
        if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
            DynamicObjectCollection payentity = this.getModel().getEntryEntity("payentity");
            long disTypeNum = payentity.stream().filter(o -> !o.getBoolean("e_paybillstatus")).map(o -> o.getDynamicObject("e_paymenttype")).distinct().count();
            if (disTypeNum == 1L) {
                this.getModel().setValue("multipaymenttype", (Object)Boolean.FALSE);
                DynamicObject ePaymentType = null;
                for (DynamicObject entry : payentity) {
                    if (entry.getBoolean("e_paybillstatus")) continue;
                    ePaymentType = entry.getDynamicObject("e_paymenttype");
                    break;
                }
                this.getModel().setValue("paytype", ePaymentType);
            } else if (disTypeNum > 1L) {
                this.getModel().setValue("multipaymenttype", (Object)Boolean.TRUE);
                if (paymentBillType != null && paymentBillType.length != 0) {
                    this.getModel().setValue("paytype", (Object)paymentBillType[0]);
                }
            } else if (disTypeNum == 0L) {
                this.getModel().setValue("multipaymenttype", (Object)Boolean.FALSE);
                this.getModel().setValue("paytype", null);
            }
        } else {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            long disTypeNum = entryentity.stream().filter(o -> !o.getBoolean("e_billstatus")).map(o -> o.getDynamicObject("e_receivingtype")).distinct().count();
            if (disTypeNum == 1L) {
                this.getModel().setValue("multireceivingtype", (Object)Boolean.FALSE);
                DynamicObject eReceivingType = null;
                for (DynamicObject entry : entryentity) {
                    if (entry.getBoolean("e_billstatus")) continue;
                    eReceivingType = entry.getDynamicObject("e_receivingtype");
                    break;
                }
                this.getModel().setValue("recpaytype", eReceivingType);
            } else if (disTypeNum > 1L) {
                this.getModel().setValue("multireceivingtype", (Object)Boolean.TRUE);
                if (receivingBillType != null && receivingBillType.length != 0) {
                    this.getModel().setValue("recpaytype", (Object)receivingBillType[0]);
                }
            } else if (disTypeNum == 0L) {
                this.getModel().setValue("multireceivingtype", (Object)Boolean.FALSE);
                this.getModel().setValue("recpaytype", null);
            }
        }
    }

    private void changeCaption() {
        String businesstype = (String)this.getModel().getValue("businesstype");
        if ("recticket".equals(businesstype)) {
            FieldEdit tradedetailno = (FieldEdit)this.getView().getControl("tradedetailno");
            tradedetailno.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7968\u636e\u53f7", (String)"ClaimNoticeEditPlugin_17", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            FieldEdit oppunit = (FieldEdit)this.getView().getControl("oppunit");
            oppunit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u7968\u4eba\u5168\u79f0", (String)"ClaimNoticeEditPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            FieldEdit tradetime = (FieldEdit)this.getView().getControl("tradetime");
            tradetime.setCaption(new LocaleString(ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u671f", (String)"ClaimNoticeEditPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getModel().setValue("registtime", this.getModel().getValue("tradetime"));
            FieldEdit detailid = (FieldEdit)this.getView().getControl("detailid");
            detailid.setCaption(new LocaleString(ResManager.loadKDString((String)"\u627f\u5151\u4eba\u540d\u79f0", (String)"ClaimNoticeEditPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountbank", "bank", "oppbanknumber", "oppbank", "tradetime"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"draftbilltype", "draftbillexpiredate", "drawername"});
        }
    }

    private void getDataToEntry() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedetailno", "accountbank", "bank", "tradetime", "oppbanknumber", "oppbank", "detailid", "datasource", "draftbilltype", "draftbillexpiredate", "drawername", "description"});
        List margeBills = RecClaimHelper.getAllChildNoticeBill((Object)this.getModel().getDataEntity().getPkValue());
        String type = (String)this.getModel().getValue("businesstype");
        if ("rec".equals(type) || "pay".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ticketdetail"});
            DynamicObjectCollection detailentryentity = (DynamicObjectCollection)this.getModel().getValue("detailentryentity");
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = detailentryentity.addNew();
                addNew.set("e_billno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_tracebillno", (Object)margeBill.getString("detailid"));
                addNew.set("e_bankaccount", margeBill.get("accountbank"));
                addNew.set("e_tracedate", (Object)margeBill.getDate("tradetime"));
                String bankName = margeBill.getDynamicObject("bank") == null ? null : margeBill.getDynamicObject("bank").getString("name");
                addNew.set("e_opeanbank", (Object)bankName);
                addNew.set("e_reamount", (Object)("rec".equals(type) ? margeBill.getBigDecimal("reamount") : margeBill.getBigDecimal("payamount")));
                addNew.set("e_oppunit", (Object)margeBill.getString("oppunit"));
                addNew.set("e_oppbanknumber", (Object)margeBill.getString("oppbanknumber"));
                addNew.set("e_oppbank", (Object)margeBill.getString("oppbank"));
                addNew.set("e_datasource", (Object)margeBill.getString("datasource"));
                addNew.set("e_description", (Object)margeBill.getString("description"));
            }
            this.getView().updateView("detailentryentity");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailentry"});
            DynamicObjectCollection detailentryentity = (DynamicObjectCollection)this.getModel().getValue("ticketentryentity");
            BigDecimal sumreamount = BigDecimal.ZERO;
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = detailentryentity.addNew();
                addNew.set("e_ticketbillno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_ticketamount", (Object)margeBill.getBigDecimal("reamount"));
                String name = margeBill.getDynamicObject("draftbilltype") == null ? "" : margeBill.getDynamicObject("draftbilltype").getString("name");
                addNew.set("e_draftbilltype", (Object)name);
                addNew.set("e_ticketdescription", (Object)margeBill.getString("description"));
                addNew.set("e_ticketdate", (Object)margeBill.getDate("tradetime"));
                addNew.set("e_draftbillexpiredate", (Object)margeBill.getDate("draftbillexpiredate"));
                addNew.set("e_drawername", (Object)margeBill.getString("drawername"));
                addNew.set("e_ticketname", (Object)margeBill.getString("detailid"));
                addNew.set("e_ticketsource", (Object)margeBill.getString("datasource"));
                sumreamount = sumreamount.add(margeBill.getBigDecimal("reamount"));
            }
            this.getView().updateView("ticketentryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("close".equals(operateKey)) {
            this.getModel().setDataChanged(false);
        } else if ("mytrackdown".equals(operateKey)) {
            Object primaryKeyValue = this.getModel().getDataEntity().getPkValue();
            DynamicObject claimNoticeBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_claimcenterbill");
            QFilter qFilter = new QFilter("claimno", "=", (Object)claimNoticeBill.getString("billno"));
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u8ba4\u9886\u5355\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ids.length == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("cas_claimbill");
                showParameter.setPkId(ids[0].getPkValue());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("cas_claimbill");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                HashSet<Object> pks = new HashSet<Object>(ids.length);
                for (DynamicObject targetBill : ids) {
                    pks.add(targetBill.getPkValue());
                }
                qFilters.add(new QFilter("id", "in", (Object)pks.toArray()));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("rejectclaim".equals(operateKey)) {
            String claimstatus = (String)this.getModel().getValue("claimstatus");
            if (ClaimStatusEnum.SURE.getValue().equals(claimstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5165\u8d26\u7684\u6570\u636e\u65e0\u6cd5\u6267\u884c\u9a73\u56de\u64cd\u4f5c\u3002", (String)"ClaimNoticeEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("beforeaccount".equals(operateKey)) {
            Object primaryKeyValue = this.getModel().getDataEntity().getPkValue();
            InvokeResult ret = CommonOperationHandler.beforeAccount(primaryKeyValue);
            if (!ret.isSuccess()) {
                if (ret.get("showMessge") != null) {
                    this.getView().showMessage(ret.getMsg());
                    this.getView().invokeOperation("refresh");
                } else if (ret.get("showConfirm") != null) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforeaccount", (IFormPlugin)this);
                    this.getView().showConfirm(ret.getMsg(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                }
                return;
            }
            this.getView().invokeOperation("claimaccount");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("beforeaccount") && e.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("claimaccount");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        switch (operateKey) {
            case "claim": {
                if (!result.isSuccess()) break;
                this.getModel().setValue("claimstatus", (Object)ClaimStatusEnum.SURE.getValue());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "cancelaccount": 
            case "cancelclaim": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "claimaccount": {
                if (!result.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "transpond": {
                if (!result.isSuccess()) break;
                this.userCardAdd();
                break;
            }
            case "rejectclaim": {
                if (!result.isSuccess()) break;
                String billNo = (String)this.getModel().getValue("billno");
                InvokeResult ret = CommonOperationHandler.beforeRejectClaim(billNo);
                if (!ret.isSuccess()) {
                    this.getView().showSuccessNotification(ret.getMsg());
                    return;
                }
                List rejectDataRet = (List)ret.get("rejectData");
                HashMap<String, Object> rejectData = new HashMap<String, Object>(rejectDataRet.size());
                for (Object[] arr : rejectDataRet) {
                    Object e_claimbill = arr[0];
                    Object e_claimperson = arr[1];
                    rejectData.put(e_claimbill + "    " + e_claimperson, e_claimbill);
                }
                String json = SerializationUtils.toJsonString(rejectData);
                this.showForm("cas_rejectclaimres", "cas_rejectclaim", json);
                break;
            }
            case "mytrackdownrec": {
                if (!result.isSuccess()) break;
                this.getView().invokeOperation("trackdown");
            }
        }
    }

    private void userCardAdd() {
        ListShowParameter para = new ListShowParameter();
        para.setHasRight(true);
        para.setLookUp(true);
        para.setBillFormId("bos_user");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setStatus(OperationStatus.ADDNEW);
        para.setShowQuickFilter(true);
        para.setIsolationOrg(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "usercard_add"));
        this.getView().showForm((FormShowParameter)para);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillShowParameter showParameter;
        DynamicObject[] ids;
        QFilter billno;
        String e_billno;
        DynamicObject entryRowEntity;
        boolean temp;
        int rowIndex = evt.getRowIndex();
        String key = evt.getFieldName();
        boolean bl = temp = StringUtils.equals((CharSequence)key, (CharSequence)"e_claimbill") || StringUtils.equals((CharSequence)key, (CharSequence)"e_payclaimbill");
        if (rowIndex > -1 && temp) {
            DynamicObject entryRowEntity2;
            String e_claimbill = null;
            if (StringUtils.equals((CharSequence)key, (CharSequence)"e_claimbill")) {
                entryRowEntity2 = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                e_claimbill = entryRowEntity2.getString(key);
            } else {
                entryRowEntity2 = this.getModel().getEntryRowEntity("payentity", rowIndex);
                e_claimbill = entryRowEntity2.getString(key);
            }
            QFilter billno2 = new QFilter("billno", "=", (Object)e_claimbill);
            DynamicObject[] ids2 = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{billno2});
            if (ids2.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba4\u9886\u5355\u6570\u636e\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter2 = new BillShowParameter();
            showParameter2.setFormId("cas_claimbill");
            showParameter2.setPkId(ids2[0].getPkValue());
            showParameter2.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter2.setCustomParam("onlyView", (Object)"yes");
            this.getView().showForm((FormShowParameter)showParameter2);
        }
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_billno")) {
            entryRowEntity = this.getModel().getEntryRowEntity("detailentryentity", rowIndex);
            e_billno = entryRowEntity.getString("e_billno");
            billno = new QFilter("billno", "=", (Object)e_billno);
            ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{billno});
            if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6536\u4ed8\u5904\u7406\u5355\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter = new BillShowParameter();
            showParameter.setFormId("bei_transdetail_cas");
            showParameter.setCustomParam("onlyView", (Object)"onlyView");
            showParameter.setPkId(ids[0].getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_ticketbillno")) {
            entryRowEntity = this.getModel().getEntryRowEntity("ticketentryentity", rowIndex);
            e_billno = entryRowEntity.getString("e_ticketbillno");
            billno = new QFilter("draftbillno", "=", (Object)e_billno);
            ids = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{billno});
            if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6b64\u5e94\u6536\u7968\u636e\uff0c\u8bf7\u68c0\u67e5\u8be5\u5355\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter = new BillShowParameter();
            showParameter.setFormId("cdm_receivablebill");
            showParameter.setPkId(ids[0].getPkValue());
            showParameter.setCustomParam("onlyView", (Object)"onlyView");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_corebillno")) {
            RecClaimHelper.openCoreBillNo((IFormView)this.getView(), (int)rowIndex);
        }
    }

    private void showForm(String formId, String callBackBtn, String rejectData) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.setCustomParam("rejectData", (Object)rejectData);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackBtn);
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if ("cas_rejectclaim".equals(actionId)) {
            HashMap returnDataMap = (HashMap)args.getReturnData();
            if (CasHelper.isEmpty((Object)returnDataMap)) {
                return;
            }
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            String rejectbill = (String)returnDataMap.get("rejectbill");
            String substring = rejectbill.substring(1, rejectbill.length() - 1);
            returnDataMap.put("rejectbill", substring);
            InvokeResult ret = CommonOperationHandler.rejectClaim(returnDataMap, pkValue);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9a73\u56de\u8ba4\u9886\u7ed3\u679c\u6210\u529f\u3002", (String)"ClaimNoticeEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("usercard_add".equals(actionId)) {
            if (args.getReturnData() == null) {
                return;
            }
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)args.getReturnData();
            HashMap<Object, String> userIdNames = new HashMap();
            if (!EmptyUtil.isEmpty((Collection)returnData)) {
                userIdNames = returnData.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getName, (e1, e2) -> e2));
            }
            Object id = this.getModel().getDataEntity().getPkValue();
            Object[] selectids = new Object[]{id};
            InvokeResult ret = CommonOperationHandler.transpond(userIdNames, selectids);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClaimRecWorkbenchPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            ArrayList<Integer> rowindex = new ArrayList<Integer>(entryEntity.size());
            ArrayList<Integer> norowindex = new ArrayList<Integer>(entryEntity.size());
            for (int j = 0; j < entryEntity.size(); ++j) {
                if (((DynamicObject)entryEntity.get(j)).getBoolean("e_billstatus")) {
                    rowindex.add(j);
                    continue;
                }
                norowindex.add(j);
            }
            if (!rowindex.isEmpty()) {
                int[] index = new int[rowindex.size()];
                for (int i = 0; i < rowindex.size(); ++i) {
                    index[i] = (Integer)rowindex.get(i);
                }
                String redColor = "#EFEFEF";
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                entryGrid.setRowBackcolor(redColor, index);
                int[] noindex = new int[norowindex.size()];
                for (int i = 0; i < norowindex.size(); ++i) {
                    noindex[i] = (Integer)norowindex.get(i);
                }
                entryGrid.setRowBackcolor(null, noindex);
            }
        }
    }
}

