/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimnotice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.util.EmptyUtil;

public class RejectClaimPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object rejectData = this.getView().getFormShowParameter().getCustomParam("rejectData");
        if (rejectData != null) {
            HashMap data = (HashMap)SerializationUtils.fromJsonString((String)String.valueOf(rejectData), Map.class);
            ComboEdit rejectclaimbill = (ComboEdit)this.getControl("rejectclaimbill");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(data.size());
            for (Map.Entry stringStringEntry : data.entrySet()) {
                ComboItem customerCI = new ComboItem();
                customerCI.setCaption(new LocaleString((String)stringStringEntry.getKey()));
                customerCI.setValue((String)stringStringEntry.getValue());
                comboItems.add(customerCI);
            }
            rejectclaimbill.setComboItems(comboItems);
            if (data.size() == 1) {
                for (Map.Entry stringStringEntry : data.entrySet()) {
                    String rejectMsg = "," + (String)stringStringEntry.getValue() + ",";
                    this.getModel().setValue("rejectclaimbill", (Object)rejectMsg);
                    this.getView().updateView("rejectclaimbill");
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String rejectClaimBill;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("bthok".equals(operateKey) && EmptyUtil.isNoEmpty((String)(rejectClaimBill = (String)this.getModel().getValue("rejectclaimbill")))) {
            String[] split = rejectClaimBill.split(",");
            HashSet<String> rejectClaimBillSet = new HashSet<String>(split.length);
            for (String string : split) {
                if (!EmptyUtil.isNoEmpty((String)string)) continue;
                rejectClaimBillSet.add(string);
            }
            QFilter qFilter1 = new QFilter("billno", "in", rejectClaimBillSet);
            Object[] claimBills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimno", (QFilter[])new QFilter[]{qFilter1});
            if (EmptyUtil.isNoEmpty((Object[])claimBills) && claimBills.length > 0) {
                Map map;
                HashSet targetEntityRecIds;
                HashSet<String> claimNoticeBillNos = new HashSet<String>(10);
                for (Object object : claimBills) {
                    claimNoticeBillNos.add(object.getString("claimno"));
                }
                QFilter qFilter = new QFilter("billno", "in", claimNoticeBillNos);
                Object[] ids = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                HashSet<Long> rejectClaimBillIdSet = new HashSet<Long>(10);
                if (EmptyUtil.isNoEmpty((Object[])ids)) {
                    for (Object id : ids) {
                        rejectClaimBillIdSet.add(id.getLong("id"));
                    }
                }
                if (EmptyUtil.isNoEmpty(rejectClaimBillIdSet) && rejectClaimBillIdSet.size() > 0 && !CollectionUtils.isEmpty((Collection)(targetEntityRecIds = (HashSet)(map = BFTrackerServiceHelper.findTargetBills((String)"cas_claimcenterbill", (Long[])rejectClaimBillIdSet.toArray(new Long[0]))).get("cas_recbill")))) {
                    DynamicObject[] recBills = BusinessDataServiceHelper.load((Object[])targetEntityRecIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_recbill"));
                    HashSet<Long> unSetBillId = new HashSet<Long>(10);
                    ArrayList<Long> recBillIds = new ArrayList<Long>(recBills.length);
                    for (DynamicObject recBill : recBills) {
                        if ("1".equals(recBill.getString("hotaccount")) || "2".equals(recBill.getString("hotaccount"))) continue;
                        recBillIds.add((Long)recBill.getPkValue());
                        DynamicObjectCollection entryCol = recBill.getDynamicObjectCollection("entry");
                        for (DynamicObject entry : entryCol) {
                            Boolean matchSellTag = entry.getBoolean("e_matchselltag");
                            if (matchSellTag.booleanValue()) {
                                args.setCancel(Boolean.TRUE.booleanValue());
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a73\u56de\u5931\u8d25\u3002\u539f\u6536\u6b3e\u5355\u5df2\u5339\u914d\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5148\u524d\u5f80\u5408\u540c\u7ba1\u7406/\u9500\u552e\u7ba1\u7406\u53d6\u6d88\u5339\u914d\u518d\u53d1\u8d77\u9a73\u56de\u3002", (String)"ClaimNoticeEditPlugin_47", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            BigDecimal SettledAmt = entry.getBigDecimal("e_settledamt");
                            if (BigDecimal.ZERO.compareTo(SettledAmt) == 0) continue;
                            unSetBillId.add((Long)recBill.getPkValue());
                        }
                    }
                    if (recBillIds.size() > 0) {
                        Set viewSettles = PayBillHepler.getViewSettle(recBillIds, (String)"cas_recbill", (String)"mainbillid", (String)"entry.billid");
                        for (DynamicObject dataEntity : recBills) {
                            Long mainBillId = dataEntity.getLong("id");
                            if (viewSettles == null || !viewSettles.contains(mainBillId)) continue;
                            unSetBillId.add(mainBillId);
                        }
                    }
                    if (EmptyUtil.isNoEmpty(unSetBillId) && unSetBillId.size() > 0) {
                        FormShowParameter showParameter = new FormShowParameter();
                        showParameter.setFormId("cas_unsettleconfirm");
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setCustomParam("unSetBillSet", unSetBillId);
                        showParameter.setCustomParam("operation", (Object)"reject");
                        this.getView().showForm(showParameter);
                        args.setCancel(true);
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("bthok".equals(operateKey) && opResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("rejectbill", dataEntity.get("rejectclaimbill"));
            String rejectreason = ((ILocaleString)dataEntity.get("rejectreason")).getLocaleValue();
            returnData.put("rejectreason", rejectreason);
            this.getView().returnDataToParent(returnData);
        }
    }
}

