/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.coretype;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class ClaimRePaymentBillPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "close"});
    }

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        Object openSource = this.getView().getFormShowParameter().getCustomParam("openSource");
        if (EmptyUtil.isNoEmpty((Object)openSource) && StringUtils.equals((CharSequence)"cas_recbill", (CharSequence)((String)openSource))) {
            list.getListUserOption().setMergeRow(false);
            QFilter qFilter = QFilter.of((String)" repaymententry.orirepayamount > repaymententry.orirecamount ", (Object[])new Object[0]);
            qFilter.and(new QFilter("billstatus", "in", (Object)new String[]{"E", "F"}));
            Object accountcurrency = this.getView().getFormShowParameter().getCustomParam("accountcurrency");
            qFilter.and(new QFilter("repaymententry.accountcurrency", "=", accountcurrency));
            Object payertype = this.getView().getFormShowParameter().getCustomParam("payertype");
            Object payername = this.getView().getFormShowParameter().getCustomParam("payername");
            if ("bd_customer".equals(payertype)) {
                qFilter.and(new QFilter("customer", "=", payername));
                qFilter.and(new QFilter("payertype", "=", payertype));
            } else if ("bd_supplier".equals(payertype)) {
                qFilter.and(new QFilter("supplier", "=", payername));
                qFilter.and(new QFilter("payertype", "=", payertype));
            } else if ("bos_org".equals(payertype)) {
                qFilter.and(new QFilter("casorg", "=", payername));
                qFilter.and(new QFilter("payertype", "=", payertype));
            } else if ("bos_user".equals(payertype)) {
                QFilter isEmployee = new QFilter("payer.isemployee", "=", (Object)Character.valueOf('1')).and(new QFilter("payertype", "=", (Object)"er_payeer")).and(new QFilter("payer.payer", "=", payername));
                qFilter.and(isEmployee);
            } else if ("other".equals(payertype)) {
                QFilter isNotEmployee = new QFilter("payer.isemployee", "=", (Object)Character.valueOf('0')).and(new QFilter("payertype", "=", (Object)"er_payeer")).and(new QFilter("payer.outpayer", "=", payername));
                QFilter isOther = new QFilter("payertype", "=", payertype).and(new QFilter("payername", "=", payername));
                qFilter.and(isOther.or(isNotEmployee));
            } else {
                qFilter.and(new QFilter("id", "=", (Object)0L));
            }
            list.setFilter(qFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection recClaimBillCollection = list.getSelectedRows();
            if (recClaimBillCollection.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ClaimDetailPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)recClaimBillCollection);
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object orgv;
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btnok".equals(key) && (orgv = this.getView().getParentView().getModel().getValue("org")) != null) {
            DynamicObject org = (DynamicObject)orgv;
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection recClaimBillCollection = list.getSelectedRows();
            if (!recClaimBillCollection.isEmpty()) {
                Object[] primaryKeyValues = recClaimBillCollection.getPrimaryKeyValues();
                DynamicObject[] erPayBills = BusinessDataServiceHelper.load((String)"er_repaymentbill", (String)"id,billno,costcompany", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                if (!CasHelper.isEmpty((DynamicObject[])erPayBills)) {
                    for (DynamicObject erPayBill : erPayBills) {
                        if (erPayBill.getDynamicObject("costcompany").getLong("id") == org.getLong("id")) continue;
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u6536\u6b3e\u7ec4\u7ec7\u4e0e\u8fd8\u6b3e\u5355\u201c%s\u201d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u4e00\u81f4,\u786e\u8ba4\u7ee7\u7eed\u5173\u8054\u8be5\u8fd8\u6b3e\u5355\uff1f", (String)"ClaimDetailPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), erPayBill.getString("billno")), MessageBoxOptions.YesNo, new ConfirmCallBackListener("companyok"));
                        evt.setCancel(true);
                        break;
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ClaimDetailPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("companyok".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection recClaimBillCollection = list.getSelectedRows();
            if (recClaimBillCollection.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ClaimDetailPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)recClaimBillCollection);
            this.getView().close();
        }
    }
}

