/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.notifisch;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.util.EmptyUtil;

public class ClaimNoticeAddFeeEditPlguin
extends BillEditPlugin {
    public void beforeBindData(EventObject e) {
        DynamicObject claimcenterbill;
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object claimId = showParameter.getCustomParam("claimId");
        if (EmptyUtil.isNoEmpty((Object)claimId) && EmptyUtil.isNoEmpty((DynamicObject)(claimcenterbill = BusinessDataServiceHelper.loadSingle((Object)claimId, (String)"cas_claimcenterbill")))) {
            this.getModel().setValue("claimid", claimId);
            this.getModel().setValue("currency", (Object)claimcenterbill.getDynamicObject("currency"));
            this.getModel().setValue("tradetime", claimcenterbill.get("tradetime"));
            this.getModel().setValue("payamount", claimcenterbill.get("payamount"));
            this.getModel().setValue("reamount", claimcenterbill.get("reamount"));
            this.getModel().setValue("detailid", claimcenterbill.get("detailid"));
            this.getModel().setValue("oppunit", claimcenterbill.get("oppunit"));
            this.getModel().setValue("oppbanknumber", claimcenterbill.get("oppbanknumber"));
            this.getModel().setValue("oppbank", claimcenterbill.get("oppbank"));
            this.getModel().setValue("description", claimcenterbill.get("description"));
            this.getModel().setValue("fee", claimcenterbill.get("fee"));
            this.getModel().setValue("oldfee", claimcenterbill.get("fee"));
            this.getModel().setValue("mergestatus", claimcenterbill.get("mergestatus"));
            this.getModel().setValue("singlestream", claimcenterbill.get("singlestream"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.beforeAddFee();
        }
    }

    private void beforeAddFee() {
        BigDecimal oldfee;
        IDataModel iDataModel = this.getModel();
        BigDecimal fee = (BigDecimal)iDataModel.getValue("fee");
        if (BigDecimal.ZERO.compareTo(fee) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8865\u5145\u7684\u624b\u7eed\u8d39\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ClaimNoticeAddFeeEditPlguin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        String mergestatus = (String)iDataModel.getValue("mergestatus");
        if (!StringUtils.equals((CharSequence)mergestatus, (CharSequence)MergeStatusEnum.ALMARGE.getValue()) || (oldfee = (BigDecimal)iDataModel.getValue("oldfee")).compareTo(fee) > 0) {
            // empty if block
        }
        BigDecimal payAmount = (BigDecimal)iDataModel.getValue("payamount");
        if (BigDecimal.ZERO.compareTo(fee) == 0 && BigDecimal.ZERO.compareTo(payAmount) == 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforeaddfee", (IFormPlugin)this);
            StringBuilder confirmMessage = new StringBuilder();
            confirmMessage.append(ResManager.loadKDString((String)"\u8865\u5145\u7684\u624b\u7eed\u8d39\u4e3a0\uff0c\u5c06\u5141\u8bb8\u8ba4\u9886\u4eba\u586b\u5145\u624b\u7eed\u8d39\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimNoticeAddFeeEditPlguin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(confirmMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.addFee();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("beforeaddfee") && e.getResult() == MessageBoxResult.Yes) {
            this.addFee();
        }
    }

    private void addFee() {
        Object claimId;
        DynamicObject claimcenterbill;
        IDataModel iDataModel = this.getModel();
        boolean isaddfee = true;
        BigDecimal fee = (BigDecimal)iDataModel.getValue("fee");
        Boolean singleStream = (Boolean)iDataModel.getValue("singlestream");
        if (BigDecimal.ZERO.compareTo(fee) == 0) {
            isaddfee = false;
        }
        if (!EmptyUtil.isEmpty((DynamicObject)(claimcenterbill = BusinessDataServiceHelper.loadSingle((Object)(claimId = iDataModel.getValue("claimid")), (String)"cas_claimcenterbill")))) {
            DynamicObjectCollection claimNoticeEntry;
            claimcenterbill.set("fee", (Object)fee);
            claimcenterbill.set("isaddfee", (Object)isaddfee);
            BigDecimal payAmount = claimcenterbill.getBigDecimal("payamount");
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                claimNoticeEntry = claimcenterbill.getDynamicObjectCollection("payentity");
                BigDecimal unclaimamount = BigDecimal.ZERO;
                BigDecimal payableamt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal payactamt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payactamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                unclaimamount = payAmount.subtract(claimcenterbill.getBigDecimal("fee")).add(payableamt).subtract(payactamt).subtract(payableamt);
                if (singleStream.booleanValue()) {
                    unclaimamount = unclaimamount.add(claimcenterbill.getBigDecimal("fee"));
                }
                claimcenterbill.set("unclaimamount", (Object)unclaimamount);
                claimcenterbill.set("claimedamount", (Object)payableamt);
                if (payableamt.compareTo(BigDecimal.ZERO) == 0) {
                    claimcenterbill.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
                } else if (payableamt.compareTo(BigDecimal.ZERO) > 0 && unclaimamount.compareTo(BigDecimal.ZERO) <= 0) {
                    claimcenterbill.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                } else {
                    claimcenterbill.set("claimstatus", (Object)ClaimStatusEnum.PART.getValue());
                }
                claimcenterbill.set("singlestream", (Object)singleStream);
            } else {
                claimNoticeEntry = claimcenterbill.getDynamicObjectCollection("entryentity");
                BigDecimal oldrec = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal actAmt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal olddis = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_discountamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal oldfee = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal reamount = claimcenterbill.getBigDecimal("reamount");
                BigDecimal unclaimamount = BigDecimal.ZERO;
                unclaimamount = unclaimamount.add(reamount).add(claimcenterbill.getBigDecimal("fee")).subtract(oldfee).add(oldrec).subtract(actAmt).subtract(oldrec);
                reamount = reamount.add(claimcenterbill.getBigDecimal("fee"));
                reamount = reamount.add(olddis);
                BigDecimal claimedamount = oldrec;
                claimcenterbill.set("claimedamount", (Object)claimedamount);
                claimcenterbill.set("unclaimamount", (Object)unclaimamount);
                String oldclaimstatus = claimcenterbill.getString("claimstatus");
                if (StringUtils.equals((CharSequence)ClaimStatusEnum.CLAIMED.getValue(), (CharSequence)oldclaimstatus) || StringUtils.equals((CharSequence)ClaimStatusEnum.PART.getValue(), (CharSequence)oldclaimstatus)) {
                    String claimstatus = oldclaimstatus;
                    if (claimedamount.compareTo(reamount) >= 0) {
                        claimstatus = ClaimStatusEnum.CLAIMED.getValue();
                    } else if (claimedamount.compareTo(BigDecimal.ZERO) > 0 && claimedamount.compareTo(reamount) < 0) {
                        claimstatus = ClaimStatusEnum.PART.getValue();
                    }
                    claimcenterbill.set("claimstatus", (Object)claimstatus);
                }
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{claimcenterbill});
                RecClaimHelper.updateClaimStatus((String)claimcenterbill.getString("billno"), null, (String)claimcenterbill.getString("claimstatus"));
            }
            this.getView().returnDataToParent((Object)"addfee");
            this.getView().close();
        }
    }
}

