/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.recpayrule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BizTypeEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.enums.RecPayRuleBillEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.recclaim.recpayrule.IRevPayRuleEditPlugin;
import kd.fi.cas.formplugin.recclaim.recpayrule.RevPayRuleEditFactory;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class RevPayRuleEditPlugin
extends BillEditPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"e_notifische"});
        this.addClickListeners(new String[]{"e_paymenttypestr"});
        this.addClickListeners(new String[]{"e_payeetypestr"});
        this.addClickListeners(new String[]{"e_fundflowitemstr"});
        this.addClickListeners(new String[]{"e_remark"});
        this.addClickListeners(new String[]{"e_receivingtypestr"});
        this.addClickListeners(new String[]{"e_payertypestr"});
        this.addClickListeners(new String[]{"e_payerstr"});
        this.addClickListeners(new String[]{"e_recerstr"});
    }

    public void beforeBindData(EventObject e) {
        ComboItem comboItem;
        DynamicObjectCollection entrys;
        FieldEdit e_handlescheme;
        super.beforeBindData(e);
        String biztype = this.getModel().getValue("biztype").toString();
        this.setHandleSchemeValue(biztype);
        if (BizTypeEnum.REC.getValue().equals(biztype) || "recticket".equals(biztype) || "electicket".equals(biztype)) {
            String e_handleValue;
            e_handlescheme = (FieldEdit)this.getView().getControl("e_handlescheme");
            e_handlescheme.setMustInput(true);
            Object e_handle = this.getModel().getValue("e_handlescheme");
            String string = e_handleValue = e_handle == null ? null : e_handle.toString();
            if (e_handleValue != null && ("recv".equals(e_handleValue) || "ticket".equals(e_handleValue))) {
                e_handlescheme.setMustInput(true);
                ((FieldEdit)this.getView().getControl("e_receivingtype")).setMustInput(false);
                ((FieldEdit)this.getView().getControl("e_payertype")).setMustInput(false);
            }
            DynamicObjectCollection entrys2 = this.getModel().getEntryEntity("entryentity");
            int index = 0;
            Iterator iterator = entrys2.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                String scheme = row.getString("e_handlescheme");
                row.set("e_handlescheme", (Object)scheme);
                if (CasHelper.isNotEmpty((Object)row.getDynamicObject("e_receivingtype"))) {
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_receivingtypestr", (Object)row.getDynamicObject("e_receivingtype").get("name"), (int)index);
                }
                if (CasHelper.isNotEmpty((Object)row.get("e_payertype"))) {
                    Object value = this.getType(row.get("e_payertype").toString());
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_payertypestr", (Object)value, (int)index);
                    if (CasHelper.isNotEmpty((Object)row.get("e_payerid"))) {
                        ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_payerstr", (Object)row.getDynamicObject("e_payerid").get("name"), (int)index);
                    } else if (CasHelper.isNotEmpty((Object)row.get("e_payer"))) {
                        ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_payerstr", (Object)row.get("e_payer"), (int)index);
                    }
                }
                if (CasHelper.isNotEmpty((Object)row.getDynamicObject("e_fundflowitem"))) {
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_fundflowitemstr", (Object)row.getDynamicObject("e_fundflowitem").get("name"), (int)index);
                }
                ++index;
            }
        } else {
            e_handlescheme = (FieldEdit)this.getView().getControl("e_handlescheme");
            e_handlescheme.setMustInput(false);
            DynamicObjectCollection entrys3 = this.getModel().getEntryEntity("entryentity");
            int index = 0;
            for (DynamicObject row : entrys3) {
                Object value;
                String scheme = row.getString("e_handlescheme");
                row.set("e_handlescheme", (Object)scheme);
                if (CasHelper.isNotEmpty((Object)row.getDynamicObject("e_paymenttype"))) {
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_paymenttypestr", (Object)row.getDynamicObject("e_paymenttype").get("name"), (int)index);
                }
                if (CasHelper.isNotEmpty((Object)row.get("e_payeetype"))) {
                    value = this.getType(row.get("e_payeetype").toString());
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_payeetypestr", (Object)value, (int)index);
                }
                if (CasHelper.isNotEmpty((Object)row.get("e_payeetype"))) {
                    value = this.getType(row.get("e_payeetype").toString());
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_payeetypestr", (Object)value, (int)index);
                    if (CasHelper.isNotEmpty((Object)row.get("e_recerid"))) {
                        ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_recerstr", (Object)row.getDynamicObject("e_recerid").get("name"), (int)index);
                    } else if (CasHelper.isNotEmpty((Object)row.get("e_recer"))) {
                        ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_recerstr", (Object)row.get("e_recer"), (int)index);
                    }
                }
                if (CasHelper.isNotEmpty((Object)row.getDynamicObject("e_fundflowitem"))) {
                    ViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_fundflowitemstr", (Object)row.getDynamicObject("e_fundflowitem").get("name"), (int)index);
                }
                ++index;
            }
        }
        if ((entrys = this.getModel().getEntryEntity("entryentity")).getRowCount() == 0) {
            return;
        }
        ComboEdit handlescheme = (ComboEdit)this.getView().getControl("e_handlebill");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        if ("rec".equals(biztype)) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(RecPayRuleBillEnum.RECVBILL.getName()));
            comboItem.setValue(RecPayRuleBillEnum.RECVBILL.getValue());
            comboItems.add(comboItem);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setCaption(new LocaleString(RecPayRuleBillEnum.UPBILL.getName()));
            comboItem1.setValue(RecPayRuleBillEnum.UPBILL.getValue());
            comboItems.add(comboItem1);
            handlescheme.setComboItems(comboItems);
        } else if ("pay".equals(biztype)) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(RecPayRuleBillEnum.PAYBILL.getName()));
            comboItem.setValue(RecPayRuleBillEnum.PAYBILL.getValue());
            comboItems.add(comboItem);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setCaption(new LocaleString(RecPayRuleBillEnum.DOWNBILL.getName()));
            comboItem1.setValue(RecPayRuleBillEnum.DOWNBILL.getValue());
            comboItems.add(comboItem1);
            handlescheme.setComboItems(comboItems);
        }
        this.setExtFieldEditable(entrys);
    }

    private Object getType(String type) {
        String res = "";
        switch (type) {
            case "bos_org": {
                res = ClaimPaymentTypeEnum.ORG.getName();
                break;
            }
            case "bd_supplier": {
                res = ClaimPaymentTypeEnum.SUPPLIER.getName();
                break;
            }
            case "bd_customer": {
                res = ClaimPaymentTypeEnum.CUSTOMER.getName();
                break;
            }
            case "bos_user": {
                res = ClaimPaymentTypeEnum.USER.getName();
                break;
            }
            case "other": {
                res = ClaimPaymentTypeEnum.OTHER.getName();
                break;
            }
        }
        return res;
    }

    private void controlHandleBill(int index, String handle) {
        String bizType = (String)this.getModel().getValue("biztype");
        ComboEdit handlescheme = (ComboEdit)this.getView().getControl("e_handlebill");
        if (EmptyUtil.isEmpty((String)bizType) || EmptyUtil.isEmpty((String)handle)) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        if ("rule".equals(handle)) {
            if ("rec".equals(bizType)) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(RecPayRuleBillEnum.RECVBILL.getName()));
                comboItem.setValue(RecPayRuleBillEnum.RECVBILL.getValue());
                comboItems.add(comboItem);
                ComboItem comboItem1 = new ComboItem();
                comboItem1.setCaption(new LocaleString(RecPayRuleBillEnum.UPBILL.getName()));
                comboItem1.setValue(RecPayRuleBillEnum.UPBILL.getValue());
                comboItems.add(comboItem1);
                handlescheme.setComboItems(comboItems);
                this.getModel().setValue("e_handlebill", (Object)RecPayRuleBillEnum.RECVBILL.getValue(), index);
            } else if ("pay".equals(bizType)) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(RecPayRuleBillEnum.PAYBILL.getName()));
                comboItem.setValue(RecPayRuleBillEnum.PAYBILL.getValue());
                comboItems.add(comboItem);
                ComboItem comboItem1 = new ComboItem();
                comboItem1.setCaption(new LocaleString(RecPayRuleBillEnum.DOWNBILL.getName()));
                comboItem1.setValue(RecPayRuleBillEnum.DOWNBILL.getValue());
                comboItems.add(comboItem1);
                handlescheme.setComboItems(comboItems);
                this.getModel().setValue("e_handlebill", (Object)RecPayRuleBillEnum.PAYBILL.getValue(), index);
            }
        } else {
            this.getModel().setValue("e_handlebill", (Object)"", index);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        Object newValueObj = e.getChangeSet()[0].getNewValue();
        String newValue = newValueObj == null ? null : newValueObj.toString();
        FieldEdit e_receivingtype = (FieldEdit)this.getView().getControl("e_receivingtype");
        FieldEdit e_payertype = (FieldEdit)this.getView().getControl("e_payertype");
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (newValue != null && "e_handlescheme".equals(proName)) {
            FieldEdit e_handlescheme = (FieldEdit)this.getView().getControl("e_handlescheme");
            switch (newValue) {
                case "rule": {
                    e_receivingtype.setMustInput(true);
                    e_payertype.setMustInput(true);
                    this.getModel().setValue("e_notifische", (Object)"", index);
                    this.getModel().setValue("e_savenotifi", (Object)"", index);
                    this.getModel().setValue("e_savenotifi_TAG", (Object)"", index);
                    this.controlHandleBill(index, newValue);
                    break;
                }
                case "ticket": {
                    e_receivingtype.setMustInput(false);
                    e_payertype.setMustInput(false);
                    break;
                }
                case "recv": {
                    e_receivingtype.setMustInput(false);
                    e_payertype.setMustInput(false);
                }
            }
        } else if ("e_payertype".equals(proName)) {
            if ("other".equals(newValue)) {
                this.getModel().setValue("e_payerbasetype", (Object)"", index);
                this.getModel().setValue("e_payerid", (Object)"", index);
                this.getModel().setValue("e_payer", (Object)"", index);
            } else {
                this.getModel().setValue("e_payerid", (Object)"", index);
                this.getModel().setValue("e_payer", (Object)"", index);
                this.getModel().setValue("e_payerbasetype", (Object)newValue, index);
            }
        } else if ("e_payerid".equals(proName)) {
            Object e_payerid = this.getModel().getValue("e_payerid", index);
            if (e_payerid != null) {
                this.getModel().setValue("e_payer", ((DynamicObject)e_payerid).getPkValue(), index);
            } else {
                this.getModel().setValue("e_payer", (Object)"", index);
            }
        } else if ("biztype".equals(proName)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().createNewEntryRow("entryentity");
            ComboEdit eHandleScheme = (ComboEdit)this.getView().getControl("e_handlescheme");
            int entryEntity = this.getModel().getEntryRowCount("entryentity");
            IRevPayRuleEditPlugin iRevPayRuleEditPlugin = RevPayRuleEditFactory.getInstance().getBean(newValue);
            iRevPayRuleEditPlugin.changeHandleScheme(eHandleScheme, this.getModel(), entryEntity);
        } else if ("e_handlebill".equals(proName)) {
            this.setExtFieldEditable(this.getModel().getEntryEntity("entryentity"));
        }
    }

    private void setHandleSchemeValue(String biztype) {
        if (StringUtils.isEmpty((CharSequence)biztype)) {
            return;
        }
        ComboEdit eHandleScheme = (ComboEdit)this.getView().getControl("e_handlescheme");
        IRevPayRuleEditPlugin iRevPayRuleEditPlugin = RevPayRuleEditFactory.getInstance().getBean(biztype);
        iRevPayRuleEditPlugin.changeHandleScheme(eHandleScheme, null, 0);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        int index = 0;
        String e_handlescheme = this.getModel().getValue("e_handlescheme") == null ? null : this.getModel().getValue("e_handlescheme").toString();
        Object biztype = this.getModel().getValue("biztype");
        if (!CasHelper.isEmpty((Object)biztype) && biztype.equals("pay") && ("e_paymenttypestr".equals(key) || "e_payeetypestr".equals(key) || "e_fundflowitemstr".equals(key) || "e_remark".equals(key)) || "e_recerstr".equals(key)) {
            index = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.showPayInfo(index);
        } else if (!CasHelper.isEmpty((Object)biztype) && (biztype.equals("rec") || biztype.equals("recticket") || "electicket".equals(biztype)) && ("e_receivingtypestr".equals(key) || "e_payertypestr".equals(key) || "e_payerstr".equals(key) || "e_fundflowitemstr".equals(key) || "e_remark".equals(key))) {
            index = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.showRecInfo(index);
        } else if (!"rule".equals(e_handlescheme)) {
            switch (key) {
                case "e_notifische": {
                    index = this.getModel().getEntryCurrentRowIndex("entryentity");
                    String e_savenotifi = this.getModel().getValue("e_savenotifi_TAG", index).toString();
                    this.showNotifiScheme(index, e_savenotifi);
                }
            }
        }
    }

    private void showRecInfo(int index) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_recinfo");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recinfo"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("e_handlescheme", this.getModel().getValue("e_handlescheme"));
        showParameter.setCustomParam("e_receivingtype", CasHelper.isNotEmpty((Object)this.getModel().getValue("e_receivingtype")) ? ((DynamicObject)this.getModel().getValue("e_receivingtype")).getPkValue() : null);
        showParameter.setCustomParam("e_payertype", this.getModel().getValue("e_payertype"));
        showParameter.setCustomParam("e_payer", this.getModel().getValue("e_payer"));
        showParameter.setCustomParam("e_fundflowitem", CasHelper.isNotEmpty((Object)this.getModel().getValue("e_fundflowitem")) ? ((DynamicObject)this.getModel().getValue("e_fundflowitem")).getPkValue() : null);
        showParameter.setCustomParam("e_remark", this.getModel().getValue("e_remark"));
        showParameter.setCustomParam("e_handlebill", this.getModel().getValue("e_handlebill"));
        this.getView().showForm(showParameter);
        this.getPageCache().put("recindex", String.valueOf(index));
    }

    private void showPayInfo(int index) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_payinfo");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "payinfo"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("e_paymenttype", CasHelper.isNotEmpty((Object)this.getModel().getValue("e_paymenttype")) ? ((DynamicObject)this.getModel().getValue("e_paymenttype")).getPkValue() : null);
        showParameter.setCustomParam("e_payeetype", this.getModel().getValue("e_payeetype"));
        showParameter.setCustomParam("e_recer", this.getModel().getValue("e_recer"));
        showParameter.setCustomParam("e_fundflowitem", CasHelper.isNotEmpty((Object)this.getModel().getValue("e_fundflowitem")) ? ((DynamicObject)this.getModel().getValue("e_fundflowitem")).getPkValue() : null);
        showParameter.setCustomParam("e_remark", this.getModel().getValue("e_remark"));
        showParameter.setCustomParam("e_handlebill", this.getModel().getValue("e_handlebill"));
        this.getView().showForm(showParameter);
        this.getPageCache().put("payindex", String.valueOf(index));
    }

    private void showNotifiScheme(int index, String e_savenotifi) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_notifischemes");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "notifischeme"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection org_entry = this.getModel().getEntryEntity("org_entry");
        if (org_entry.size() > 0) {
            List collect = org_entry.stream().filter(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy) && EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("u_org"))).map(or -> or.getDynamicObject("u_org").getPkValue()).collect(Collectors.toList());
            showParameter.setCustomParam("orgId", collect);
        } else {
            showParameter.setCustomParam("orgId", new ArrayList());
        }
        showParameter.setCustomParam("e_handlescheme", this.getModel().getValue("e_handlescheme"));
        showParameter.setCustomParam("e_savenotifi", (Object)e_savenotifi);
        this.getView().showForm(showParameter);
        this.getPageCache().put("index", String.valueOf(index));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("notifischeme".equals(e.getActionId())) {
            String res;
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            List usernames = (List)returnData.get("usergroupnames");
            List orgnames = (List)returnData.get("orgnames");
            List rolenames = (List)returnData.get("rolenames");
            List users = (List)returnData.get("usernames");
            int index = Integer.parseInt(this.getPageCache().get("index"));
            if (usernames != null && usernames.size() > 0) {
                res = StringUtils.join((Iterable)usernames, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            } else if (orgnames != null && orgnames.size() > 0 || rolenames != null && rolenames.size() > 0) {
                res = orgnames != null ? StringUtils.join((Iterable)orgnames, (String)",") + (rolenames != null ? "," + StringUtils.join((Iterable)rolenames, (String)",") : "") : StringUtils.join((Iterable)rolenames, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            } else if (users != null && users.size() > 0) {
                res = StringUtils.join((Iterable)users, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            }
            String jsonString = SerializationUtils.toJsonString((Object)returnData);
            this.getModel().setValue("e_savenotifi_TAG", (Object)jsonString, Integer.parseInt(this.getPageCache().get("index")));
        } else if ("payinfo".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            int index = Integer.parseInt(this.getPageCache().get("payindex"));
            DynamicObject e_paymenttype = (DynamicObject)returnData.get("e_paymenttype");
            Object e_payeetype = returnData.get("e_payeetype");
            Object e_fundflowitem = returnData.get("e_fundflowitem");
            Object e_remark = returnData.get("e_remark");
            if (CasHelper.isNotEmpty((Object)e_paymenttype)) {
                this.getModel().setValue("e_paymenttype", e_paymenttype.getPkValue(), index);
            }
            if (CasHelper.isNotEmpty((Object)e_paymenttype)) {
                this.getModel().setValue("e_paymenttypestr", e_paymenttype.get("name"), index);
            }
            if (CasHelper.isNotEmpty(e_payeetype)) {
                this.getModel().setValue("e_payeetype", e_payeetype, index);
            }
            if (CasHelper.isNotEmpty(e_payeetype)) {
                this.getModel().setValue("e_payeetypestr", this.getType(e_payeetype.toString()), index);
            } else {
                this.getModel().setValue("e_payeetypestr", (Object)"", index);
            }
            if (CasHelper.isNotEmpty(e_fundflowitem)) {
                this.getModel().setValue("e_fundflowitem", ((DynamicObject)e_fundflowitem).getPkValue(), index);
                this.getModel().setValue("e_fundflowitemstr", ((DynamicObject)e_fundflowitem).get("name"), index);
            } else {
                this.getModel().setValue("e_fundflowitem", (Object)"", index);
                this.getModel().setValue("e_fundflowitemstr", (Object)"", index);
            }
            Object e_recer = returnData.get("e_recer");
            if (CasHelper.isNotEmpty(e_payeetype)) {
                if ("other".equals(e_payeetype)) {
                    this.setValue("e_recer", e_recer, index);
                    this.setValue("e_recerstr", e_recer, index);
                    this.setValue("e_recerid", null, index);
                }
            } else {
                this.setValue("e_recer", "", index);
                this.setValue("e_recerstr", "", index);
            }
            if (CasHelper.isNotEmpty(e_payeetype) && !"other".equals(e_payeetype) && CasHelper.isNotEmpty(e_recer)) {
                this.setValue("e_recer", ((DynamicObject)e_recer).getPkValue(), index);
                this.setValue("e_recerstr", ((DynamicObject)e_recer).get("name"), index);
                this.setValue("e_recerbasetype", e_payeetype, index);
                this.setValue("e_recerid", ((DynamicObject)e_recer).getPkValue(), index);
            } else if (CasHelper.isEmpty(e_recer) && !"other".equals(e_recer)) {
                this.setValue("e_recer", null, index);
                this.setValue("e_recerstr", null, index);
                this.setValue("e_recerbasetype", e_payeetype, index);
                this.setValue("e_recerid", null, index);
            }
            if (CasHelper.isNotEmpty(e_remark)) {
                this.getModel().setValue("e_remark", e_remark, index);
            } else {
                this.getModel().setValue("e_remark", (Object)"", index);
            }
        } else if ("recinfo".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            int index = Integer.parseInt(this.getPageCache().get("recindex"));
            Object e_receivingtype = returnData.get("e_receivingtype");
            if (CasHelper.isNotEmpty(e_receivingtype)) {
                this.getModel().setValue("e_receivingtype", ((DynamicObject)e_receivingtype).getPkValue(), index);
                this.getModel().setValue("e_receivingtypestr", ((DynamicObject)e_receivingtype).get("name"), index);
            } else {
                this.getModel().setValue("e_receivingtype", (Object)"", index);
                this.getModel().setValue("e_receivingtypestr", (Object)"", index);
            }
            Object e_payertype = returnData.get("e_payertype");
            this.getModel().setValue("e_payertype", e_payertype, index);
            Object e_payer = returnData.get("e_payer");
            if (CasHelper.isNotEmpty(e_payertype)) {
                this.getModel().setValue("e_payertypestr", this.getType(e_payertype.toString()), index);
                if ("other".equals(e_payertype)) {
                    this.setValue("e_payer", e_payer, index);
                    this.setValue("e_payerstr", e_payer, index);
                }
            } else {
                this.getModel().setValue("e_payertypestr", (Object)"", index);
                this.setValue("e_payer", "", index);
                this.setValue("e_payerstr", "", index);
            }
            if (CasHelper.isNotEmpty(e_payertype) && !"other".equals(e_payertype) && CasHelper.isNotEmpty(e_payer)) {
                this.setValue("e_payer", ((DynamicObject)e_payer).getPkValue(), index);
                this.setValue("e_payerstr", ((DynamicObject)e_payer).get("name"), index);
                this.setValue("e_payerbasetype", e_payertype, index);
                this.setValue("e_payerid", ((DynamicObject)e_payer).getPkValue(), index);
            } else if (CasHelper.isEmpty(e_payer) && !"other".equals(e_payertype)) {
                this.setValue("e_payer", null, index);
                this.setValue("e_payerstr", null, index);
                this.setValue("e_payerbasetype", e_payertype, index);
                this.setValue("e_payerid", null, index);
            }
            Object e_fundflowitem = returnData.get("e_fundflowitem");
            Object e_remark = returnData.get("e_remark");
            if (CasHelper.isNotEmpty(e_fundflowitem)) {
                this.getModel().setValue("e_fundflowitem", ((DynamicObject)e_fundflowitem).getPkValue(), index);
                this.getModel().setValue("e_fundflowitemstr", ((DynamicObject)e_fundflowitem).get("name"), index);
            } else {
                this.getModel().setValue("e_fundflowitem", (Object)"", index);
                this.getModel().setValue("e_fundflowitemstr", (Object)"", index);
            }
            if (CasHelper.isNotEmpty(e_remark)) {
                this.getModel().setValue("e_remark", e_remark, index);
            } else {
                this.getModel().setValue("e_remark", (Object)"", index);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String bizType = (String)this.getModel().getValue("biztype");
        if ("recticket".equals(bizType)) {
            int rowIndex = this.getModel().getEntryRowCount("entryentity") - 1;
            this.getModel().setValue("e_handlescheme", (Object)"ticket", rowIndex);
        }
    }

    private void setExtFieldEditable(DynamicObjectCollection entrys) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cas_billconvertfieldcfg", (String)"billtype, datatype, extendname, tarfieldname", null);
        Set<String> lockKeys = query.stream().map(dynamicObject -> dynamicObject.getString("extendname")).collect(Collectors.toSet());
        this.lockCell(entryGrid, entrys, lockKeys);
        Map<String, List<DynamicObject>> billConFieldConfigMap = query.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("billtype")));
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entityRow = (DynamicObject)entrys.get(i);
            String billtype = entityRow.getString("e_handlebill");
            List<DynamicObject> billConfigs = billConFieldConfigMap.get(billtype);
            if (!EmptyUtil.isNoEmpty(billConfigs)) continue;
            Set<String> extendNames = billConfigs.stream().filter(dynamicObject -> entityRow.containsProperty(dynamicObject.getString("extendname"))).map(dynamicObject -> dynamicObject.getString("extendname")).collect(Collectors.toSet());
            this.setEntityCellEnable(entryGrid, true, i, extendNames);
        }
    }

    private void lockCell(EntryGrid entryGrid, DynamicObjectCollection entrys, Collection<String> lockKeys) {
        ArrayList<String> needLocks = new ArrayList<String>();
        for (int i = 0; i < entrys.size(); ++i) {
            if (i == 0) {
                DynamicObject entryRow = (DynamicObject)entrys.get(i);
                for (String lockKey : lockKeys) {
                    if (!entryRow.containsProperty(lockKey)) continue;
                    needLocks.add(lockKey);
                }
            }
            this.setEntityCellEnable(entryGrid, false, i, needLocks);
        }
    }

    private void setEntityCellEnable(EntryGrid entryGrid, boolean value, int rowIndex, Collection<String> ctlKeys) {
        String policy = "";
        for (String k : ctlKeys) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(4);
            fieldMap.put("o", policy);
            fieldMap.put("k", k);
            fieldMap.put("r", rowIndex);
            fieldMap.put("l", value);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setLockState(entryGrid.getKey(), fieldMap);
        }
    }
}

