/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recsupdivide;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.cas.business.opservice.impl.ValidateReclateOperation;
import kd.fi.cas.enums.DivideStatusEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class ReceiveSupDivideEditPlugin
extends BillEditPlugin
implements ClickListener {
    private static final String IS_CANCElCONTRACT_CALLBACK = "is_cancelcontract_callback";
    private static final String IS_CANCELDIVIDE_CALLBACK = "is_canceldivide_callback";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object supcontractOrOrgsdivide = billShowParameter.getCustomParam("supcontractOrOrgsdivide");
        if (!CasHelper.isEmpty((Object)supcontractOrOrgsdivide)) {
            if ("supplecontract".equals(supcontractOrOrgsdivide)) {
                this.getModel().setValue("issupplecontract", (Object)true);
                this.setBottonVisiable(true);
            }
            if ("orgsdivide".equals(supcontractOrOrgsdivide)) {
                this.getModel().setValue("isorgsdivide", (Object)true);
                this.setBottonVisiable(false);
            }
            this.getPageCache().put("opType", String.valueOf(supcontractOrOrgsdivide));
        }
    }

    private void setBottonVisiable(boolean issupplecontract) {
        this.getView().setVisible(Boolean.valueOf(issupplecontract), new String[]{"supplecontract"});
        this.getView().setVisible(Boolean.valueOf(issupplecontract), new String[]{"cancelcontract"});
        this.getView().setVisible(Boolean.valueOf(!issupplecontract), new String[]{"orgsdivide"});
        this.getView().setVisible(Boolean.valueOf(!issupplecontract), new String[]{"canceldivide"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        if (arg.getOperationResult() != null && arg.getOperationResult().isSuccess()) {
            HashMap<String, Object> formPOJO = new HashMap<String, Object>(16);
            IDataModel model = this.getModel();
            DynamicObject recBill = this.getModel().getDataEntity();
            formPOJO.put("currency", recBill.getDynamicObject("currency").getLong("id"));
            int entryCount = model.getEntryCurrentRowIndex("entry");
            DynamicObject rowInfo = model.getEntryRowEntity("entry", entryCount);
            DynamicObject openorg = (DynamicObject)model.getValue("openorg");
            DynamicObject e_settleorg = rowInfo.getDynamicObject("e_settleorg");
            String e_dividestatus = rowInfo.getString("e_dividestatus");
            formPOJO.put("e_receivableamt", rowInfo.getBigDecimal("e_receivableamt"));
            formPOJO.put("e_actamt", rowInfo.getBigDecimal("e_actamt"));
            formPOJO.put("e_unlockamt", rowInfo.getBigDecimal("e_unlockamt"));
            formPOJO.put("e_fee", rowInfo.getBigDecimal("e_fee"));
            formPOJO.put("e_discountamt", rowInfo.getBigDecimal("e_discountamt"));
            DynamicObject e_fundflowitem = rowInfo.getDynamicObject("e_fundflowitem");
            if (CasHelper.isNotEmpty((Object)e_fundflowitem)) {
                formPOJO.put("e_fundflowitem", e_fundflowitem.getPkValue());
            }
            formPOJO.put("e_remark", rowInfo.get("e_remark"));
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
            switch (arg.getOperateKey()) {
                case "supplecontract": {
                    if (!this.isOnlyChooseOneRow()) {
                        return;
                    }
                    if (!this.isPassSupContractValid()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u672a\u7ed3\u7b97\u91d1\u989d>0\u4e14\u672a\u9501\u5b9a\u91d1\u989d>0\uff0c\u4e14\u5408\u540c\u53f7\u3001\u6838\u5fc3\u5355\u636e\u53f7\u3001\u6838\u5fc3\u5355\u636e\u884c\u53f7\u90fd\u4e3a\u7a7a,\u624d\u80fd\u64cd\u4f5c\u8865\u5145\u5408\u540c\u53f7\u3002", (String)"ReceiveSupDivideEditPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String e_orgsdividebatch = rowInfo.getString("e_orgsdividebatch");
                    if (entrys.size() > 0 && CasHelper.isNotEmpty((Object)e_orgsdividebatch) && !e_orgsdividebatch.startsWith("src") && !this.isEqualTwoOrgs(e_settleorg, openorg)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e05\u5206\u64cd\u4f5c\u751f\u6210\u7684\u5206\u5f55,\u65e0\u6cd5\u518d\u8fdb\u884c\u6302\u5408\u540c\u64cd\u4f5c\u3002", (String)"ReceiveSupDivideEditPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    formPOJO.put("org", recBill.getDynamicObject("org").getLong("id"));
                    formPOJO.put("uuid", rowInfo.get("e_contractbatch"));
                    this.showForm("cas_supplecontract", formPOJO);
                    break;
                }
                case "cancelcontract": {
                    if (!this.isOnlyChooseOneRow()) {
                        return;
                    }
                    BigDecimal e_unsettledamt = rowInfo.getBigDecimal("e_unsettledamt");
                    if (CasHelper.isEmpty((Object)e_unsettledamt) || BigDecimal.ZERO.compareTo(e_unsettledamt) == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u7ed3\u7b97\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u64a4\u5408\u540c\u3002", (String)"ReceiveSupDivideEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5bf9\u672a\u7ed3\u7b97\u91d1\u989d\u8fdb\u884c\u64a4\u9500\u5408\u540c\u53f7\u64cd\u4f5c\uff0c\u786e\u5b9a\u8981\u64a4\u9500\u5408\u540c\u53f7\u5417\uff1f", (String)"ReceiveSupDivideEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_CANCElCONTRACT_CALLBACK, (IFormPlugin)this));
                    break;
                }
                case "orgsdivide": {
                    if (!this.isOnlyChooseOneRow()) {
                        return;
                    }
                    if (CasHelper.isEmpty((Object)openorg) || CasHelper.isEmpty((Object)e_settleorg) || !openorg.getPkValue().equals(e_settleorg.getPkValue())) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u884c\u7ed3\u7b97\u7ec4\u7ec7\u4e0e\u6536\u6b3e\u5355\u7684\u6838\u7b97\u7ec4\u7ec7\u4e00\u81f4\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c,\u8bf7\u68c0\u67e5\u3002", (String)"ReceiveSupDivideEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BigDecimal e_unlockamt = rowInfo.getBigDecimal("e_unlockamt");
                    if (CasHelper.isEmpty((Object)e_unlockamt) || BigDecimal.ZERO.compareTo(e_unlockamt) == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u672a\u9501\u5b9a\u91d1\u989d\u4e3a\u96f6,\u53ea\u6709\u672a\u9501\u5b9a\u91d1\u989d\u5927\u4e8e\u96f6,\u624d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c,\u8bf7\u68c0\u67e5\u3002", (String)"ReceiveSupDivideEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String e_contractbatch = rowInfo.getString("e_contractbatch");
                    if (entrys.size() > 0 && CasHelper.isNotEmpty((Object)e_contractbatch) && !this.isPassSupContractValid()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6302\u5408\u540c\u6240\u751f\u6210\u7684\u5206\u5f55\u65e0\u6cd5\u518d\u8fdb\u884c\u6e05\u5206,\u8bf7\u68c0\u67e5\u3002", (String)"ReceiveSupDivideEditPlugin_2_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    formPOJO.put("settleorg", rowInfo.getDynamicObject("e_settleorg").getPkValue());
                    formPOJO.put("uuid", rowInfo.getString("e_orgsdividebatch"));
                    this.showForm("cas_orgsdivide", formPOJO);
                    break;
                }
                case "cancelorgsdivide": {
                    if (!this.isOnlyChooseOneRow()) {
                        return;
                    }
                    if (CasHelper.isEmpty((Object)openorg) || CasHelper.isEmpty((Object)e_settleorg)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u7ec4\u7ec7\u6216\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u64a4\u9500\u6e05\u5206", (String)"ReceiveSupDivideEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (openorg.getPkValue().equals(e_settleorg.getPkValue())) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5206\u5f55\u884c\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u7b49\u4e8e\u6536\u6b3e\u5355\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u624d\u80fd\u64a4\u9500\u6e05\u5206\u3002", (String)"ReceiveSupDivideEditPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!(DivideStatusEnum.NORMAL.getValue().equals(e_dividestatus) || DivideStatusEnum.YETDIVIDE.getValue().equals(e_dividestatus) || DivideStatusEnum.WAITDIVIDE.getValue().equals(e_dividestatus))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u672a\u5b8c\u6210\u6e05\u5206\u64cd\u4f5c\uff0c\u65e0\u6cd5\u64a4\u9500\u6e05\u5206\u3002", (String)"ReceiveSupDivideEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u6e05\u5206\u9700\u786e\u4fdd\u6ca1\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u6216\u5355\u636e\u4ecd\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u5b9a\u8981\u64a4\u9500\u6e05\u5206\u5417\uff1f", (String)"ReceiveSupDivideEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_CANCELDIVIDE_CALLBACK, (IFormPlugin)this));
                }
            }
        }
    }

    private boolean isEqualTwoOrgs(DynamicObject e_settleorg, DynamicObject openorg) {
        return !CasHelper.isEmpty((Object)openorg) && !CasHelper.isEmpty((Object)e_settleorg) && openorg.getPkValue().equals(e_settleorg.getPkValue());
    }

    private String getCorrectUuid(String e_orgsdividebatch) {
        if (CasHelper.isNotEmpty((Object)e_orgsdividebatch) && e_orgsdividebatch.startsWith("src")) {
            e_orgsdividebatch = e_orgsdividebatch.substring(3);
        }
        return e_orgsdividebatch;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && callBackId.equals(IS_CANCElCONTRACT_CALLBACK)) {
            this.confirmCancelContract();
        }
        if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && callBackId.equals(IS_CANCELDIVIDE_CALLBACK)) {
            this.confirmcancelOrgDivide();
        }
    }

    private void confirmcancelOrgDivide() {
        Integer divideMainData;
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("entry");
        int entryCount = model.getEntryCurrentRowIndex("entry");
        DynamicObject cancelData = (DynamicObject)entry.get(entryCount);
        String e_orgsdividebatch = cancelData.getString("e_orgsdividebatch");
        DynamicObject recBill = this.getModel().getDataEntity();
        List<String> targetStrings = Arrays.asList("cas_recbill", "ap_finapbill");
        try {
            new ValidateReclateOperation(recBill).targetBillReverseOpValidate(targetStrings);
        }
        catch (KDException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        DynamicObject openorg = (DynamicObject)this.getModel().getValue("openorg");
        DynamicObject mainData = null;
        Boolean useOldEntry = false;
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        String quotation = this.getString("quotation");
        DynamicObject currency = this.getDynamicObject("currency");
        int round = currency.getInt("amtprecision");
        Boolean flag = false;
        if (CasHelper.isNotEmpty((Object)e_orgsdividebatch) && CasHelper.isNotEmpty((Object)(divideMainData = this.getMainDiviedData(entry, e_orgsdividebatch, openorg.getPkValue()))) && divideMainData.compareTo(entryCount) == 0) {
            flag = true;
        }
        if (CasHelper.isEmpty((Object)e_orgsdividebatch) || flag.booleanValue()) {
            model.setValue("e_settleorg", openorg.getPkValue(), entryCount);
            model.beginInit();
            if (!flag.booleanValue()) {
                model.setValue("e_orgsdividebatch", (Object)this.generateUUIDShort(cancelData.getPkValue()));
            }
            model.setValue("e_dividestatus", (Object)DivideStatusEnum.NORMAL.getValue());
            model.endInit();
        } else {
            divideMainData = this.getMainDiviedData(entry, e_orgsdividebatch, openorg.getPkValue());
            if (CasHelper.isEmpty((Object)divideMainData)) {
                DynamicObject[] recregisterRecoreds;
                if (CasHelper.isEmpty((Object)e_orgsdividebatch) || !e_orgsdividebatch.contains("_")) {
                    return;
                }
                QFilter recbillidQf = new QFilter("recbillid", "=", this.getModel().getDataEntity().getPkValue());
                QFilter recregisterQf = new QFilter("optype", "=", (Object)"positive_recregister");
                String substring = e_orgsdividebatch.substring(e_orgsdividebatch.indexOf("_") + 1);
                QFilter entryidQf = new QFilter("entryid", "=", (Object)Long.valueOf(substring));
                QFilter detailinfoQf = new QFilter("entrydetailinfo", "is not null", null);
                for (DynamicObject recregisterRecored : recregisterRecoreds = BusinessDataServiceHelper.load((String)"cas_recoplogbill", (String)"entryid,entrydetailinfo,entrydetailinfo_TAG", (QFilter[])new QFilter[]{recbillidQf, recregisterQf, entryidQf, detailinfoQf})) {
                    MainEntityType mainEntityType;
                    DynamicCollectionProperty entryProp;
                    Object[] mainDatas;
                    String mainDataStr = recregisterRecored.getString("entrydetailinfo_TAG");
                    if (!CasHelper.isNotEmpty((Object)mainDataStr) || CasHelper.isEmpty((Object)(mainDatas = DynamicObjectSerializeUtil.deserialize((String)mainDataStr, (DynamicObjectType)(entryProp = (DynamicCollectionProperty)(mainEntityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill")).getProperty("entry")).getDynamicCollectionItemPropertyType()))) || mainDatas.length == 0) continue;
                    mainData = (DynamicObject)mainDatas[0];
                    divideMainData = entryCount;
                    useOldEntry = true;
                    break;
                }
                if (CasHelper.isEmpty((Object)mainData)) {
                    model.setValue("e_settleorg", openorg.getPkValue(), entryCount);
                    model.setValue("e_dividestatus", (Object)DivideStatusEnum.NORMAL.getValue());
                    model.getEntryEntity("entry");
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("thisRecOptype", "cancelOrgsDivide");
                    operateOption.setVariableValue("beforeOpselectEntryId", cancelData.getPkValue().toString());
                    this.invokeSaveOp(operateOption, ResManager.loadKDString((String)"\u53d6\u6d88\u6e05\u5206", (String)"ReceiveSupDivideEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                mainData = model.getEntryRowEntity("entry", divideMainData.intValue());
            }
            BigDecimal e_actamt = this.getBigDecimalProp(cancelData, "e_actamt");
            BigDecimal e_fee = this.getBigDecimalProp(cancelData, "e_fee");
            BigDecimal e_discountamt = this.getBigDecimalProp(cancelData, "e_discountamt");
            BigDecimal mainDataactamt = BigDecimal.ZERO;
            BigDecimal mainDatafee = BigDecimal.ZERO;
            BigDecimal mainDatadiscountamt = BigDecimal.ZERO;
            BigDecimal mainDatalockamt = BigDecimal.ZERO;
            BigDecimal mainDatasettledamt = BigDecimal.ZERO;
            if (!useOldEntry.booleanValue()) {
                mainDataactamt = mainData == null ? BigDecimal.ZERO : this.getBigDecimalProp(mainData, "e_actamt");
                mainDatafee = mainData == null ? BigDecimal.ZERO : this.getBigDecimalProp(mainData, "e_fee");
                mainDatadiscountamt = mainData == null ? BigDecimal.ZERO : this.getBigDecimalProp(mainData, "e_discountamt");
                mainDatalockamt = mainData == null ? BigDecimal.ZERO : this.getBigDecimalProp(mainData, "e_lockamt");
                mainDatasettledamt = mainData == null ? BigDecimal.ZERO : this.getBigDecimalProp(mainData, "e_settledamt");
            } else {
                model.setValue("e_settleorg", mainData.get("e_settleorg"), divideMainData.intValue());
                Set entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry");
                model.beginInit();
                for (String fileName : entryFileName) {
                    if (fileName.equals("e_settleorg") || fileName.equals("recorg")) continue;
                    model.setValue(fileName, mainData.get(fileName), divideMainData.intValue());
                }
                model.setValue("e_orgsdividebatch", (Object)(e_orgsdividebatch.startsWith("src") ? e_orgsdividebatch : "src" + e_orgsdividebatch), divideMainData.intValue());
                model.endInit();
            }
            mainDataactamt = mainDataactamt.add(e_actamt);
            mainDatafee = mainDatafee.add(e_fee);
            mainDatadiscountamt = mainDatadiscountamt.add(e_discountamt);
            BigDecimal mainDatareceivableamt = mainDataactamt.add(mainDatafee).add(mainDatadiscountamt);
            BigDecimal mainDataUnlockamt = mainDatareceivableamt.subtract(mainDatalockamt);
            BigDecimal mainDataUnsettledamt = mainDatareceivableamt.subtract(mainDatasettledamt);
            model.beginInit();
            model.setValue("e_actamt", (Object)mainDataactamt, divideMainData.intValue());
            model.setValue("e_fee", (Object)mainDatafee, divideMainData.intValue());
            model.setValue("e_discountamt", (Object)mainDatadiscountamt, divideMainData.intValue());
            model.setValue("e_receivableamt", (Object)mainDatareceivableamt, divideMainData.intValue());
            model.setValue("e_unlockamt", (Object)mainDataUnlockamt, divideMainData.intValue());
            model.setValue("e_unsettledamt", (Object)mainDataUnsettledamt, divideMainData.intValue());
            model.setValue("e_dividestatus", (Object)DivideStatusEnum.NORMAL.getValue(), divideMainData.intValue());
            model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)mainDatareceivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round), divideMainData.intValue());
            model.setValue("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)mainDatadiscountamt, (BigDecimal)exchangerate, (String)quotation, (int)round), divideMainData.intValue());
            model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)mainDataactamt, (BigDecimal)exchangerate, (String)quotation, (int)round), divideMainData.intValue());
            if (!useOldEntry.booleanValue()) {
                model.deleteEntryRow("entry", entryCount);
            }
            model.endInit();
        }
        this.getView().updateView("entry");
        model.getEntryEntity("entry");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("thisRecOptype", "cancelOrgsDivide");
        operateOption.setVariableValue("beforeOpselectEntryId", cancelData.getPkValue().toString());
        this.invokeSaveOp(operateOption, ResManager.loadKDString((String)"\u53d6\u6d88\u6e05\u5206", (String)"ReceiveSupDivideEditPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    private Integer getMainDiviedData(DynamicObjectCollection entrys, String e_orgsdividebatch, Object pkValue) {
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject e_settleorg = entry.getDynamicObject("e_settleorg");
            String mainorgsdividebatch = e_orgsdividebatch;
            if (!e_orgsdividebatch.startsWith("src")) {
                mainorgsdividebatch = "src" + e_orgsdividebatch;
            }
            String e_orgsdividebatchEntry = entry.getString("e_orgsdividebatch");
            if (CasHelper.isEmpty((Object)e_settleorg) || CasHelper.isEmpty((Object)e_orgsdividebatchEntry) || !e_orgsdividebatchEntry.equals(mainorgsdividebatch)) continue;
            return i;
        }
        return null;
    }

    private boolean isOnlyChooseOneRow() {
        EntryGrid entryCtr = (EntryGrid)this.getControl("entry");
        int[] selectRows = entryCtr.getSelectRows();
        if (!EmptyUtil.isEmpty((Object)selectRows) && selectRows.length != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ReceiveSupDivideEditPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isPassSupContractValid() {
        IDataModel model = this.getModel();
        DynamicObject rowInfo = model.getEntryRowEntity("entry", model.getEntryCurrentRowIndex("entry"));
        BigDecimal unSettledAmt = rowInfo.getBigDecimal("e_unsettledamt");
        BigDecimal unLockAmt = rowInfo.getBigDecimal("e_unlockamt");
        String contractNumber = rowInfo.getString("contractnumber");
        String coreBillNo = rowInfo.getString("e_corebillno");
        int coreEntrySeq = rowInfo.getInt("e_corebillentryseq");
        return unSettledAmt != null && unLockAmt != null && BigDecimal.ZERO.compareTo(unSettledAmt) < 0 && BigDecimal.ZERO.compareTo(unLockAmt) < 0 && EmptyUtil.isEmpty((String)contractNumber) && EmptyUtil.isEmpty((String)coreBillNo) && (EmptyUtil.isEmpty((Integer)coreEntrySeq) || !EmptyUtil.isEmpty((Integer)coreEntrySeq) && coreEntrySeq == 0);
    }

    private void showForm(String formId, Map<String, Object> formPOJO) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId + "_callback"));
        fsp.setCustomParam("formPOJO", formPOJO);
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    private void confirmCancelContract() {
        BigDecimal e_settledamt;
        IDataModel model = this.getModel();
        int entry = model.getEntryCurrentRowIndex("entry");
        DynamicObjectCollection entryData = model.getEntryEntity("entry");
        DynamicObject cancelContractData = (DynamicObject)entryData.get(entry);
        String contractbatch = cancelContractData.getString("e_contractbatch");
        String dividestatus = cancelContractData.getString("contractnumber");
        String corebilltype = cancelContractData.getString("e_corebilltype");
        if (CasHelper.isEmpty((Object)contractbatch) || "".equals(contractbatch) || CasHelper.isEmpty((Object)dividestatus) && CasHelper.isEmpty((Object)corebilltype)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\u3002\u6b64\u6570\u636e\u4e0d\u7b26\u5408\u5408\u540c\u751f\u6210\u8981\u6c42\uff0c\u65e0\u6cd5\u8fdb\u884c\u64a4\u9500\u5408\u540c\u64cd\u4f5c\u3002", (String)"ReceiveSupDivideEditPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Integer mainDataCount = this.getMainData(entryData, contractbatch);
        DynamicObject mainData = null;
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        String quotation = this.getString("quotation");
        DynamicObject currency = this.getDynamicObject("currency");
        int round = 10;
        if (currency != null) {
            round = currency.getInt("amtprecision");
        }
        boolean dataDelete = false;
        boolean oldEntryDelete = false;
        String comeFromSource = null;
        if (CasHelper.isEmpty((Object)mainDataCount)) {
            if (contractbatch.contains("_")) {
                DynamicObject[] recregisterRecoreds;
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                QFilter recbillidQf = new QFilter("recbillid", "=", (Object)(pkValue == null ? 0L : Long.parseLong(pkValue.toString())));
                QFilter recregisterQf = new QFilter("optype", "=", (Object)"positive_recregister");
                String substring = contractbatch.substring(contractbatch.indexOf("_") + 1);
                QFilter entryidQf = new QFilter("entryid", "=", (Object)(StringUtils.isEmpty((String)substring) ? 0L : Long.parseLong(substring)));
                QFilter detailinfoQf = new QFilter("entrydetailinfo", "is not null", null);
                for (DynamicObject recregisterRecored : recregisterRecoreds = BusinessDataServiceHelper.load((String)"cas_recoplogbill", (String)"entryid,entrydetailinfo,entrydetailinfo_TAG", (QFilter[])new QFilter[]{recbillidQf, recregisterQf, entryidQf, detailinfoQf})) {
                    MainEntityType mainEntityType;
                    DynamicCollectionProperty entryProp;
                    Object[] mainDatas;
                    String mainDataStr = recregisterRecored.getString("entrydetailinfo_TAG");
                    if (!CasHelper.isNotEmpty((Object)mainDataStr) || CasHelper.isEmpty((Object)(mainDatas = DynamicObjectSerializeUtil.deserialize((String)mainDataStr, (DynamicObjectType)(entryProp = (DynamicCollectionProperty)(mainEntityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill")).getProperty("entry")).getDynamicCollectionItemPropertyType()))) || mainDatas.length == 0) continue;
                    mainData = (DynamicObject)mainDatas[0];
                    dataDelete = true;
                    break;
                }
            }
            if (CasHelper.isEmpty(mainData)) {
                dataDelete = false;
                mainData = cancelContractData;
                e_settledamt = cancelContractData.getBigDecimal("e_settledamt");
                comeFromSource = CasHelper.isEmpty((Object)e_settledamt) || e_settledamt.compareTo(BigDecimal.ZERO) == 0 ? "unSettleSelf" : "alSettleSelf";
            }
        } else {
            mainData = (DynamicObject)entryData.get(mainDataCount.intValue());
        }
        e_settledamt = this.getBigDecimalProp(cancelContractData, "e_settledamt");
        BigDecimal e_receivableamt = this.getBigDecimalProp(cancelContractData, "e_receivableamt");
        BigDecimal e_discountamt = this.getBigDecimalProp(cancelContractData, "e_discountamt");
        BigDecimal e_fee = this.getBigDecimalProp(cancelContractData, "e_fee");
        BigDecimal e_actamt = this.getBigDecimalProp(cancelContractData, "e_actamt");
        BigDecimal e_lockamt = this.getBigDecimalProp(cancelContractData, "e_lockamt");
        BigDecimal e_unlockamt = this.getBigDecimalProp(cancelContractData, "e_unlockamt");
        BigDecimal e_unsettledamt = this.getBigDecimalProp(cancelContractData, "e_unsettledamt");
        BigDecimal receivableamt = BigDecimal.ZERO;
        BigDecimal discountamt = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal actamt = BigDecimal.ZERO;
        BigDecimal unlockamt = BigDecimal.ZERO;
        BigDecimal unsettledamt = BigDecimal.ZERO;
        if (!dataDelete) {
            receivableamt = this.getBigDecimalProp(mainData, "e_receivableamt");
            discountamt = this.getBigDecimalProp(mainData, "e_discountamt");
            fee = this.getBigDecimalProp(mainData, "e_fee");
            actamt = this.getBigDecimalProp(mainData, "e_actamt");
            unlockamt = this.getBigDecimalProp(mainData, "e_unlockamt");
            unsettledamt = this.getBigDecimalProp(mainData, "e_unsettledamt");
        }
        if (!contractbatch.contains("_")) {
            for (DynamicObject entryDatum : entryData) {
                String[] arr;
                String e_contractbatch = entryDatum.getString("e_contractbatch");
                if (!CasHelper.isNotEmpty((Object)e_contractbatch) || !e_contractbatch.contains("_") || !contractbatch.equals((arr = e_contractbatch.split("_"))[0])) continue;
                contractbatch = e_contractbatch;
                break;
            }
            String string = contractbatch = contractbatch.contains("_") ? contractbatch : contractbatch + "_" + mainData.getPkValue();
        }
        if (comeFromSource != null) {
            DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"cas_recbill");
            Set entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry");
            DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
            DynamicObject entrytum = (DynamicObject)entrys.get(entry);
            entrytum.set("contractnumber", null);
            entrytum.set("e_corebillno", null);
            entrytum.set("e_corebillentryseq", null);
            entrytum.set("e_corebilltype", null);
            entrytum.set("e_contractbatch", (Object)contractbatch);
            if ("alSettleSelf".equals(comeFromSource)) {
                DynamicObject addNew = entrys.addNew();
                for (String fileName : entryFileName) {
                    addNew.set(fileName, cancelContractData.get(fileName));
                }
                e_receivableamt = e_receivableamt.subtract(e_settledamt);
                e_actamt = e_actamt.subtract(e_settledamt);
                entrytum.set("e_receivableamt", (Object)e_receivableamt);
                entrytum.set("e_actamt", (Object)e_actamt);
                entrytum.set("e_settledamt", (Object)BigDecimal.ZERO);
                if (e_lockamt.compareTo(e_settledamt) > 0) {
                    entrytum.set("e_lockamt", (Object)e_lockamt.subtract(e_settledamt));
                } else {
                    entrytum.set("e_lockamt", (Object)BigDecimal.ZERO);
                }
                entrytum.set("e_unlockamt", (Object)e_receivableamt.subtract(entrytum.getBigDecimal("e_lockamt")));
                entrytum.set("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_receivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round));
                entrytum.set("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_actamt, (BigDecimal)exchangerate, (String)quotation, (int)round));
                addNew.set("e_receivableamt", (Object)e_settledamt);
                addNew.set("e_fee", (Object)BigDecimal.ZERO);
                addNew.set("e_discountamt", (Object)BigDecimal.ZERO);
                addNew.set("e_actamt", (Object)e_settledamt);
                if (e_lockamt.compareTo(e_settledamt) <= 0) {
                    addNew.set("e_lockamt", (Object)e_lockamt);
                } else {
                    addNew.set("e_lockamt", (Object)e_settledamt);
                }
                addNew.set("e_unlockamt", (Object)e_settledamt.subtract(addNew.getBigDecimal("e_lockamt")));
                addNew.set("e_settledamt", (Object)e_settledamt);
                addNew.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                addNew.set("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_settledamt, (BigDecimal)exchangerate, (String)quotation, (int)round));
                addNew.set("e_discountlocamt", (Object)BigDecimal.ZERO);
                addNew.set("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_settledamt, (BigDecimal)exchangerate, (String)quotation, (int)round));
                addNew.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                addNew.set("e_contractbatch", (Object)contractbatch);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
            this.getView().invokeOperation("refresh");
            return;
        }
        unsettledamt = unsettledamt.add(e_unsettledamt);
        fee = fee.add(e_fee);
        unlockamt = unlockamt.add(e_unlockamt);
        discountamt = discountamt.add(e_discountamt);
        if (BigDecimal.ZERO.compareTo(e_settledamt) == 0) {
            receivableamt = receivableamt.add(e_receivableamt);
            actamt = actamt.add(e_actamt);
            if (mainDataCount == null && dataDelete) {
                mainDataCount = entry;
            } else {
                oldEntryDelete = true;
            }
        } else {
            if (mainDataCount == null && dataDelete) {
                model.beginInit();
                mainDataCount = this.getModel().createNewEntryRow("entry");
                model.endInit();
            }
            actamt = actamt.add(e_actamt.subtract(e_settledamt));
            receivableamt = receivableamt.add(e_receivableamt.subtract(e_settledamt));
            model.beginInit();
            model.setValue("e_fee", (Object)BigDecimal.ZERO, entry);
            model.setValue("e_unlockamt", (Object)e_settledamt.subtract(e_lockamt), entry);
            model.setValue("e_unsettledamt", (Object)BigDecimal.ZERO, entry);
            model.setValue("e_discountamt", (Object)BigDecimal.ZERO, entry);
            model.setValue("e_actamt", (Object)e_settledamt, entry);
            model.setValue("e_receivableamt", (Object)e_settledamt, entry);
            model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_settledamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
            model.setValue("e_discountlocamt", (Object)BigDecimal.ZERO, entry);
            model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_settledamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
            comeFromSource = "hasSettle";
            model.endInit();
        }
        if (dataDelete) {
            if (null != mainData) {
                model.setValue("e_settleorg", mainData.get("e_settleorg"), mainDataCount.intValue());
                Set entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry");
                model.beginInit();
                for (String fileName : entryFileName) {
                    if (fileName.equals("e_settleorg")) continue;
                    model.setValue(fileName, mainData.get(fileName), mainDataCount.intValue());
                }
            }
            model.setValue("e_contractbatch", (Object)contractbatch, mainDataCount.intValue());
            model.endInit();
        }
        model.beginInit();
        if (CasHelper.isNotEmpty((Object)mainDataCount)) {
            model.setValue("e_fee", (Object)fee, mainDataCount.intValue());
            model.setValue("e_unlockamt", (Object)unlockamt, mainDataCount.intValue());
            model.setValue("e_unsettledamt", (Object)unsettledamt, mainDataCount.intValue());
            model.setValue("e_discountamt", (Object)discountamt, mainDataCount.intValue());
            model.setValue("e_actamt", (Object)actamt, mainDataCount.intValue());
            model.setValue("e_receivableamt", (Object)receivableamt, mainDataCount.intValue());
            model.setValue("e_lockamt", (Object)receivableamt.subtract(unlockamt), mainDataCount.intValue());
            model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)receivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round), mainDataCount.intValue());
            model.setValue("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)discountamt, (BigDecimal)exchangerate, (String)quotation, (int)round), mainDataCount.intValue());
            model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)actamt, (BigDecimal)exchangerate, (String)quotation, (int)round), mainDataCount.intValue());
            if ("hasSettle".equals(comeFromSource)) {
                model.setValue("contractnumber", null, mainDataCount.intValue());
                model.setValue("e_corebillno", null, mainDataCount.intValue());
                model.setValue("e_corebillentryseq", null, mainDataCount.intValue());
                model.setValue("e_corebilltype", null, mainDataCount.intValue());
                model.setValue("e_settledamt", (Object)BigDecimal.ZERO, mainDataCount.intValue());
            }
        }
        if (oldEntryDelete) {
            model.deleteEntryRow("entry", entry);
        }
        model.endInit();
        this.getView().updateView("entry");
        model.getEntryEntity("entry");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("thisRecOptype", "cancelContract");
        operateOption.setVariableValue("beforeOpselectEntryId", cancelContractData.getPkValue().toString());
        this.invokeSaveOp(operateOption, ResManager.loadKDString((String)"\u64a4\u9500\u5408\u540c\u53f7", (String)"ReceiveSupDivideEditPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    private Integer getMainData(DynamicObjectCollection entryData, String uuid) {
        for (int i = 0; i < entryData.size(); ++i) {
            DynamicObject rowInfo = (DynamicObject)entryData.get(i);
            String contractNumber = rowInfo.getString("contractnumber");
            String coreBillNo = rowInfo.getString("e_corebillno");
            String e_contractbatch = rowInfo.getString("e_contractbatch");
            if (!uuid.contains("_") && CasHelper.isNotEmpty((Object)e_contractbatch) && e_contractbatch.contains("_")) {
                String[] arr = e_contractbatch.split("_");
                e_contractbatch = arr[0];
            }
            if (!EmptyUtil.isEmpty((String)contractNumber) || !EmptyUtil.isEmpty((String)coreBillNo) || !uuid.equals(e_contractbatch)) continue;
            return i;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "cas_supplecontract_callback": {
                HashMap returnData = (HashMap)evt.getReturnData();
                if (CasHelper.isEmpty((Object)returnData)) break;
                Object contractnumber = returnData.get("contractnumber");
                Object corebilltype = returnData.get("corebilltype");
                Object corebillno = returnData.get("corebillno");
                Object corebillentryseq = returnData.get("corebillentryseq");
                BigDecimal receivableamt = (BigDecimal)returnData.get("receivableamt");
                BigDecimal e_discountamt = (BigDecimal)returnData.get("e_discountamt");
                BigDecimal discountamt = (BigDecimal)returnData.get("discountamt");
                BigDecimal e_fee = (BigDecimal)returnData.get("e_fee");
                BigDecimal fee = (BigDecimal)returnData.get("fee");
                BigDecimal actamt = (BigDecimal)returnData.get("actamt");
                Object remark = returnData.get("remark");
                String uuid = (String)returnData.get("uuid");
                Object sourcebillid = returnData.get("sourcebillid");
                Object fundflowitem = returnData.get("fundflowitem");
                Boolean isWriteActAmt = (Boolean)returnData.get("isWriteActAmt");
                if (CasHelper.isEmpty((Object)isWriteActAmt)) {
                    isWriteActAmt = false;
                }
                IDataModel model = this.getModel();
                this.getModel().beginInit();
                int entryCount = model.getEntryCurrentRowIndex("entry");
                DynamicObjectCollection entrys = model.getEntryEntity("entry");
                DynamicObject rowInfo = (DynamicObject)entrys.get(entryCount);
                BigDecimal e_actamt = rowInfo.getBigDecimal("e_actamt");
                BigDecimal e_receivableamt = rowInfo.getBigDecimal("e_receivableamt");
                if (!uuid.contains("_")) {
                    String e_orgsdividebatch = rowInfo.getString("e_orgsdividebatch");
                    if (CasHelper.isNotEmpty((Object)e_orgsdividebatch) && e_orgsdividebatch.contains("_")) {
                        String substring = e_orgsdividebatch.substring(e_orgsdividebatch.indexOf("_") + 1);
                        uuid = uuid + "_" + substring;
                    } else {
                        uuid = uuid + "_" + rowInfo.getPkValue();
                    }
                }
                int entry = this.getModel().createNewEntryRow("entry");
                Set entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry");
                for (String fileName : entryFileName) {
                    if (fileName.equals("e_settleorg") || fileName.equals("e_contractbatch") || fileName.equals("e_dividestatus") || fileName.equals("e_orgsdividebatch") || fileName.equals("recorg") || fileName.equals("e_corebilltype") || fileName.equals("e_corebillno") || fileName.equals("e_corebillentryseq") || fileName.equals("e_lockamt") || fileName.equals("e_unlockamt") || fileName.equals("e_settledamt")) continue;
                    model.setValue(fileName, rowInfo.get(fileName), entry);
                }
                BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
                String quotation = this.getString("quotation");
                DynamicObject currency = this.getDynamicObject("currency");
                int round = 10;
                if (currency != null) {
                    round = currency.getInt("amtprecision");
                }
                this.getModel().endInit();
                model.setValue("e_settleorg", rowInfo.get("e_settleorg"), entry);
                this.getModel().beginInit();
                if (isWriteActAmt.booleanValue()) {
                    receivableamt = actamt.add(discountamt).add(fee);
                } else {
                    actamt = receivableamt.subtract(discountamt).subtract(fee);
                }
                model.setValue("e_receivableamt", (Object)receivableamt, entry);
                model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)receivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                model.setValue("e_discountamt", (Object)discountamt, entry);
                model.setValue("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)discountamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                model.setValue("e_fee", (Object)fee, entry);
                model.setValue("e_actamt", (Object)actamt, entry);
                model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)actamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                model.setValue("e_lockamt", (Object)BigDecimal.ZERO, entry);
                model.setValue("e_unlockamt", (Object)receivableamt, entry);
                model.setValue("e_settledamt", (Object)BigDecimal.ZERO, entry);
                model.setValue("e_unsettledamt", (Object)receivableamt, entry);
                model.setValue("e_remark", remark, entry);
                model.setValue("contractnumber", contractnumber, entry);
                model.setValue("e_corebilltype", corebilltype, entry);
                model.setValue("e_corebillno", corebillno, entry);
                model.setValue("e_corebillentryseq", corebillentryseq, entry);
                model.setValue("e_contractbatch", (Object)uuid, entry);
                model.setValue("e_sourcebillid", sourcebillid, entry);
                model.setValue("e_fundflowitem", fundflowitem, entry);
                this.getModel().endInit();
                BigDecimal e_lockamt = rowInfo.getBigDecimal("e_lockamt");
                BigDecimal e_settledamt = rowInfo.getBigDecimal("e_settledamt");
                e_actamt = e_actamt.subtract(actamt);
                if (e_actamt.compareTo(BigDecimal.ZERO) == 0 && e_discountamt.compareTo(BigDecimal.ZERO) == 0 && e_fee.compareTo(BigDecimal.ZERO) == 0 && e_lockamt.compareTo(BigDecimal.ZERO) == 0 && e_settledamt.compareTo(BigDecimal.ZERO) == 0) {
                    model.deleteEntryRow("entry", entryCount);
                } else {
                    e_receivableamt = e_receivableamt.subtract(receivableamt);
                    model.beginInit();
                    model.setValue("e_contractbatch", (Object)uuid, entryCount);
                    model.setValue("e_actamt", (Object)e_actamt, entryCount);
                    model.setValue("e_fee", (Object)e_fee, entryCount);
                    model.setValue("e_discountamt", (Object)e_discountamt, entryCount);
                    model.setValue("e_unlockamt", (Object)e_receivableamt.subtract(e_lockamt), entryCount);
                    model.setValue("e_unsettledamt", (Object)e_receivableamt.subtract(e_settledamt), entryCount);
                    model.setValue("e_receivableamt", (Object)e_receivableamt, entryCount);
                    model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_receivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                    model.setValue("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_discountamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                    model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_actamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                    model.endInit();
                }
                this.getView().updateView("entry");
                model.getEntryEntity("entry");
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("thisRecOptype", "suppleContract");
                operateOption.setVariableValue("beforeOpselectEntryId", rowInfo.getPkValue().toString());
                this.invokeSaveOp(operateOption, ResManager.loadKDString((String)"\u8865\u5145\u5408\u540c\u53f7", (String)"ReceiveSupDivideEditPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cas_orgsdivide_callback": {
                HashMap divideOrgData = (HashMap)evt.getReturnData();
                if (CasHelper.isEmpty((Object)divideOrgData)) break;
                IDataModel model = this.getModel();
                BigDecimal discountamt = (BigDecimal)divideOrgData.get("discountamt");
                BigDecimal fee = (BigDecimal)divideOrgData.get("fee");
                BigDecimal actamt = (BigDecimal)divideOrgData.get("actamt");
                Object settleorg = divideOrgData.get("settleorg");
                String uuid = (String)divideOrgData.get("uuid");
                Object remark = divideOrgData.get("remark");
                Object fundflowitem = divideOrgData.get("fundflowitem");
                int entryCount = model.getEntryCurrentRowIndex("entry");
                DynamicObjectCollection entrys = model.getEntryEntity("entry");
                DynamicObject rowInfo = (DynamicObject)entrys.get(entryCount);
                if (CasHelper.isNotEmpty((Object)uuid) && !uuid.contains("_")) {
                    String e_contractbatch = rowInfo.getString("e_contractbatch");
                    if (CasHelper.isNotEmpty((Object)e_contractbatch) && e_contractbatch.contains("_")) {
                        String substring = e_contractbatch.substring(e_contractbatch.indexOf("_") + 1);
                        uuid = uuid + "_" + substring;
                    } else {
                        uuid = uuid + "_" + rowInfo.getPkValue();
                    }
                }
                BigDecimal e_discountamt = this.getBigDecimalProp(rowInfo, "e_discountamt");
                BigDecimal e_fee = this.getBigDecimalProp(rowInfo, "e_fee");
                BigDecimal e_actamt = this.getBigDecimalProp(rowInfo, "e_actamt");
                this.getModel().beginInit();
                int entry = this.getModel().createNewEntryRow("entry");
                Set entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry");
                for (String fileName : entryFileName) {
                    if (fileName.equals("e_settleorg") || fileName.equals("e_contractbatch") || fileName.equals("e_dividestatus") || fileName.equals("e_orgsdividebatch") || fileName.equals("recorg") || fileName.equals("e_corebilltype") || fileName.equals("e_corebillno") || fileName.equals("e_corebillentryseq") || fileName.equals("e_lockamt") || fileName.equals("e_unlockamt") || fileName.equals("e_settledamt")) continue;
                    model.setValue(fileName, rowInfo.get(fileName), entry);
                }
                BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
                String quotation = this.getString("quotation");
                DynamicObject currency = this.getDynamicObject("currency");
                int round = currency.getInt("amtprecision");
                this.getModel().endInit();
                model.setValue("e_settleorg", settleorg, entry);
                model.beginInit();
                model.setValue("e_actamt", (Object)actamt, entry);
                model.setValue("e_remark", remark, entry);
                String correctUuid = this.getCorrectUuid(uuid);
                model.setValue("e_orgsdividebatch", (Object)correctUuid, entry);
                e_discountamt = e_discountamt.subtract(discountamt);
                e_fee = e_fee.subtract(fee);
                model.setValue("e_fee", (Object)fee, entry);
                model.setValue("e_discountamt", (Object)discountamt, entry);
                BigDecimal receivableamt = actamt.add(fee).add(discountamt);
                model.setValue("e_receivableamt", (Object)receivableamt, entry);
                long id = (Long)this.getModel().getDataEntity().getDynamicObject("org").getPkValue();
                boolean isCS089 = SystemParameterHelper.getParameterBoolean((long)id, (String)"cs118");
                if (isCS089) {
                    model.setValue("e_lockamt", (Object)receivableamt, entry);
                } else {
                    model.setValue("e_unlockamt", (Object)receivableamt, entry);
                }
                model.setValue("e_unsettledamt", (Object)receivableamt, entry);
                model.setValue("e_dividestatus", (Object)DivideStatusEnum.WAITDIVIDE.getValue(), entry);
                model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)receivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                model.setValue("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)discountamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)actamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entry);
                e_actamt = e_actamt.subtract(actamt);
                BigDecimal e_lockamt = this.getBigDecimalProp(rowInfo, "e_lockamt");
                BigDecimal e_settledamt = this.getBigDecimalProp(rowInfo, "e_settledamt");
                if (e_actamt.compareTo(BigDecimal.ZERO) == 0 && e_discountamt.compareTo(BigDecimal.ZERO) == 0 && e_fee.compareTo(BigDecimal.ZERO) == 0 && e_lockamt.compareTo(BigDecimal.ZERO) == 0 && e_settledamt.compareTo(BigDecimal.ZERO) == 0) {
                    model.deleteEntryRow("entry", entryCount);
                } else {
                    BigDecimal e_receivableamt = e_actamt.add(e_fee).add(e_discountamt);
                    model.setValue("e_receivableamt", (Object)e_receivableamt, entryCount);
                    model.setValue("e_unlockamt", (Object)e_receivableamt.subtract(e_lockamt), entryCount);
                    model.setValue("e_unsettledamt", (Object)e_receivableamt.subtract(e_settledamt), entryCount);
                    model.setValue("e_actamt", (Object)e_actamt, entryCount);
                    model.setValue("e_fee", (Object)e_fee, entryCount);
                    model.setValue("e_discountamt", (Object)e_discountamt, entryCount);
                    model.setValue("e_orgsdividebatch", (Object)uuid, entryCount);
                    model.setValue("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_receivableamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entryCount);
                    model.setValue("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_discountamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entryCount);
                    model.setValue("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)e_actamt, (BigDecimal)exchangerate, (String)quotation, (int)round), entryCount);
                }
                model.endInit();
                this.getView().updateView("entry");
                model.getEntryEntity("entry");
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("thisRecOptype", "orgsDivideOp");
                operateOption.setVariableValue("beforeOpselectEntryId", rowInfo.getPkValue().toString());
                this.invokeSaveOp(operateOption, ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u6e05\u5206", (String)"ReceiveSupDivideEditPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void invokeSaveOp(OperateOption operateOption, String opType) {
        DynamicObject recBillDO = this.getModel().getDataEntity(true);
        DynamicObject beforeSaveRecBill = BusinessDataServiceHelper.loadSingle((Object)recBillDO.getPkValue(), (String)recBillDO.getDynamicObjectType().getName());
        String entityName = recBillDO.getDataEntityType().getName();
        OperationResult result = OperateServiceHelper.execOperateWithoutThrow((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{recBillDO}, (OperateOption)operateOption);
        if (result != null && !result.isSuccess()) {
            if ("orgsDivideOp".equals(operateOption.getVariableValue("thisRecOptype"))) {
                DynamicObjectCollection beforeEntry = beforeSaveRecBill.getDynamicObjectCollection("entry");
                DynamicObject afterSaveRecBill = BusinessDataServiceHelper.loadSingle((Object)recBillDO.getPkValue(), (String)recBillDO.getDynamicObjectType().getName());
                DynamicObjectCollection afterEntry = afterSaveRecBill.getDynamicObjectCollection("entry");
                Iterator iterator = afterEntry.iterator();
                Set entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry");
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    Boolean flag = false;
                    for (DynamicObject before : beforeEntry) {
                        if (!before.getPkValue().toString().equals(next.getPkValue().toString())) continue;
                        for (String fileName : entryFileName) {
                            next.set(fileName, before.get(fileName));
                        }
                        flag = true;
                        break;
                    }
                    if (flag.booleanValue()) continue;
                    iterator.remove();
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{afterSaveRecBill});
            }
            this.showOperationResultMulti(result, "orgsdivide");
        } else if (result != null && result.isSuccess()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u6210\u529f!", (String)"ReceiveSupDivideEditPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), opType), Integer.valueOf(4000));
        }
        this.getView().invokeOperation("refresh");
    }

    private void showOperationResultMulti(OperationResult operationResult, String operateName) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap(16);
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            String lowerCaseBuf = ((IOperateInfo)errorInfos.get(i)).getMessage().toLowerCase();
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        this.getView().showForm(parameters);
    }

    private BigDecimal getBigDecimalProp(DynamicObject data, String prop) {
        BigDecimal value = data.getBigDecimal(prop);
        if (CasHelper.isEmpty((Object)value)) {
            value = BigDecimal.ZERO;
        }
        return value;
    }

    private String generateUUIDShort(Object entryId) {
        String currTime = DateUtils.formatString((Date)new Date(), (String)"yyyyMMddHHmmss");
        return currTime + UUID.randomUUID().toString().replace("-", "").substring(0, 10) + "_" + entryId;
    }
}

