/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.refund;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.formplugin.refund.RefundCommonFormPlugin;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.pojo.ReceiptRefund;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RefundTransDetailFormPlugin
extends RefundCommonFormPlugin {
    private static final String TRANS_DETAIL_PROS = "id,billno,oppbanknumber,oppunit,oppbank,creditamount,debitamount,bizdate,accountbank.id,company.id,bank.id,currency.id";
    private static final String CONFIRM_REFUND = "confirm_refund";

    public void afterCreateNewData(EventObject e) {
        this.loadBills(null, null, true);
    }

    @Override
    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields;
        String searchText = searchEnterEvent.getText();
        Set searchKeys = null;
        if (StringUtils.isNotEmpty((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)(searchFields = searchEnterEvent.getSearchFields()))) {
            searchKeys = searchFields.stream().flatMap(searchField -> ((List)searchField.get("fieldName")).stream()).collect(Collectors.toSet());
        }
        this.loadBills(searchKeys, searchText, false);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (ArrayUtils.isEmpty((int[])selectRows)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c", (String)"RefundReleBillPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("cas_renote_confirm");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIRM_REFUND));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        if (CONFIRM_REFUND.equals(event.getActionId()) && Boolean.TRUE.equals(returnData = event.getReturnData())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            DynamicObject selectObj = (DynamicObject)entryList.get(selectRows[0]);
            OperateOption option = OperateOption.create();
            option.setVariableValue("billId", selectObj.getString("id"));
            option.setVariableValue("billType", selectObj.getString("billtype"));
            option.setVariableValue("entryId", selectObj.getString("entryid"));
            Long detailId = (Long)this.getCustomParam("detailId");
            option.setVariableValue("detailId", String.valueOf(detailId));
            OperationResult result = this.getView().invokeOperation("detailrenote", option);
            if (result.isSuccess()) {
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
        }
    }

    public void loadBills(Set<String> searchKeys, String searchText, boolean init) {
        DynamicObject transDetailBill = this.getTransDetailBill();
        QFilter payBillFilter = RefundHelper.buildPayBillFilterByTransBill((DynamicObject)transDetailBill);
        QFilter agentBillFilter = RefundHelper.buildAgentBillFilterByTransBill((DynamicObject)transDetailBill);
        String transOppbankNo = transDetailBill.getString("oppbanknumber");
        if (init && StringUtils.isNotBlank((CharSequence)transOppbankNo)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("recacctno", transOppbankNo);
            clientViewProxy.invokeControlMethod("searchap", "setSearchCondition", new Object[]{map});
            payBillFilter.and(new QFilter("payeebanknum", "=", (Object)transOppbankNo));
            agentBillFilter.and(new QFilter("entry.payeeacctbank", "=", (Object)transOppbankNo));
        } else if (!init && searchKeys != null && StringUtils.isNotBlank((CharSequence)searchText)) {
            if (searchKeys.size() > 1) {
                QFilter paySubFilter = new QFilter("billno", "=", (Object)searchText).or("payeebanknum", "=", (Object)transOppbankNo);
                payBillFilter.and(paySubFilter);
                QFilter agentSubFilter = new QFilter("billno", "=", (Object)searchText).or("entry.payeeacctbank", "=", (Object)transOppbankNo);
                agentBillFilter.and(agentSubFilter);
            } else if (searchKeys.contains("billno")) {
                payBillFilter.and(new QFilter("billno", "=", (Object)searchText));
                agentBillFilter.and(new QFilter("billno", "=", (Object)searchText));
            } else if (searchKeys.contains("recacctno")) {
                payBillFilter.and("payeebanknum", "=", (Object)transOppbankNo);
                agentBillFilter.and("entry.payeeacctbank", "=", (Object)transOppbankNo);
            }
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)String.join((CharSequence)",", PAY_BILL_FIELDS), (QFilter[])payBillFilter.toArray());
        DynamicObjectCollection agentBills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)String.join((CharSequence)",", AGENT_BILL_FIELDS), (QFilter[])agentBillFilter.toArray());
        List finalAgentBills = RefundHelper.filterAgentAmtByTransDetail((List)agentBills, (DynamicObject)transDetailBill);
        List<ReceiptRefund> dataList = payBills.stream().map(payBill -> new ReceiptRefund(payBill, "cas_paybill")).collect(Collectors.toList());
        List agentBillDataList = finalAgentBills.stream().map(ReceiptRefund::new).collect(Collectors.toList());
        dataList.addAll(agentBillDataList);
        if (dataList.isEmpty()) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        this.addRows(dataList);
    }

    private DynamicObject getTransDetailBill() {
        Object detailId = this.getCustomParam("detailId");
        QFilter filter = new QFilter("id", "=", detailId);
        return QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)TRANS_DETAIL_PROS, (QFilter[])filter.toArray());
    }
}

