/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BadgeInfo;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.dao.ManualMatchCheck;
import kd.fi.cas.dao.MatchRangeInfo;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.formplugin.smartmatch.PartAmtAllotPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ManualMatchPlugin
extends AbstractListPlugin
implements TabSelectListener,
ItemClickListener,
SetFilterListener,
BeforeF7SelectListener {
    private static final String CURR_TAB_NAME_KEY = "currTabName";
    private static final String BIZ_BILL_NO_QUERY = "bizBillNoQuery";
    private static final String TRANS_DETAIL_NO_QUERY = "transDetailNoQuery";
    private static final String MULTIPLESELECTEDDETAIL = "multipleSelectedDetail";
    private static final String MULTIPLESELECTEDBIZBILL = "multipleSelectedBizBill";
    private static final String PREFIX_DATE = "date_";
    private static final String PREFIX_RANGE_QFILTER = "range_qfilter_";
    private static final String DETAIL_DATE = "date_list_bei_transdetail_cas_";
    private static final String AGENTSELECTEDTYPE = "agent_selected_type";
    private static final String SUM_AMT_PAY = "sumamtpay_";
    private static final String SUM_AMT_REC = "sumamtrec_";
    private static final String SUM_CNY_REC = "sumcnyrec_";
    private static final String SUM_CNY_PAY = "sumcnypay_";
    public static final Map<String, List<String>> billListFieldMap = new LinkedHashMap<String, List<String>>(16);
    public static final Map<String, Pair<List<String>, String>> matchFieldMap = new LinkedHashMap<String, Pair<List<String>, String>>(16);
    private static final Set<String> REC_FLOW_DIRECTION_SAME = Stream.of("list_cas_recbill", "list_fca_transupbill", "list_cas_exchangebill", "list_cas_paybill").collect(Collectors.toSet());
    private static final Set<String> REC_FLOW_DIRECTION_DIFF = Stream.of("list_cas_paybill", "list_cas_agentpaybill", "list_ifm_transhandlebill", "list_fca_transdownbill", "list_cas_exchangebill").collect(Collectors.toSet());
    private static final Set<String> PAY_FLOW_DIRECTION_SAME = Stream.of("list_cas_paybill", "list_cas_agentpaybill", "list_ifm_transhandlebill", "list_fca_transdownbill", "list_cas_exchangebill", "list_cas_recbill").collect(Collectors.toSet());
    private static final Set<String> PAY_FLOW_DIRECTION_DIFF = Stream.of("list_cas_recbill", "list_fca_transupbill", "list_cas_exchangebill").collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_reset", "btn_query", "btn_filter"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        for (String listBill : billListFieldMap.keySet()) {
            BillList billList = (BillList)this.getControl(listBill);
            billList.addSetFilterListener((SetFilterListener)this);
            billList.addListRowClickListener((ListRowClickListener)this);
        }
        BasedataEdit accountBankCtrl = (BasedataEdit)this.getControl("filter_accountbank");
        accountBankCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currencyBankCtrl = (BasedataEdit)this.getControl("filter_currency");
        currencyBankCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object currencyParam;
        super.afterCreateNewData(e);
        this.initFilterOrgF7();
        this.getPageCache().put(AGENTSELECTEDTYPE, "true");
        String currTabName = "tab_cas_paybill";
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        this.getModel().setValue("filter_org", customParams.get("filter_org"));
        Object acctBankParam = customParams.get("filter_accountbank");
        if (acctBankParam != null) {
            Object[] acctBankId = ((JSONArray)acctBankParam).toArray();
            this.getModel().setValue("filter_accountbank", (Object)acctBankId);
        }
        if ((currencyParam = customParams.get("filter_currency")) != null) {
            Object[] currencyId = ((JSONArray)currencyParam).toArray();
            this.getModel().setValue("filter_currency", (Object)currencyId);
        }
        this.getModel().setValue("bizstartdate", customParams.get("bizstartdate"));
        this.getModel().setValue("bizenddate", customParams.get("bizenddate"));
        String bizBillName = (String)customParams.get("bizbillname");
        Object transDetailParam = customParams.get("transdetailid");
        if (StringUtils.isEmpty((String)bizBillName) && transDetailParam == null) {
            this.queryNoDataList();
            this.getPageCache().put(CURR_TAB_NAME_KEY, currTabName);
            return;
        }
        String errorMsg = this.validateFilterField();
        if ((StringUtils.isNotEmpty((String)bizBillName) || transDetailParam != null) && StringUtils.isNotEmpty((String)errorMsg)) {
            this.getPageCache().put(CURR_TAB_NAME_KEY, currTabName);
            this.queryNoDataList();
            return;
        }
        currTabName = this.fromBillToHere(customParams, currTabName);
        this.fromTransDetail(customParams);
        this.getPageCache().put(CURR_TAB_NAME_KEY, currTabName);
        ((Tab)this.getControl("tabap")).activeTab(currTabName);
    }

    private String fromBillToHere(Map<String, Object> customParams, String currTabName) {
        String curListKey = null;
        Object[] bizBillId = null;
        String bizBillName = (String)customParams.get("bizbillname");
        if (StringUtils.isNotEmpty((String)bizBillName)) {
            Object bizBillIdParam;
            curListKey = "list_" + bizBillName;
            if (matchFieldMap.containsKey(curListKey)) {
                currTabName = "tab_" + bizBillName;
            }
            if ((bizBillIdParam = customParams.get("bizbillid")) != null) {
                bizBillId = ((JSONArray)bizBillIdParam).toArray();
            }
            this.getModel().setValue("autofilter", (Object)"bizbill");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filter_org", "filter_accountbank", "filter_currency", "autofilter"});
            HashMap<String, Object[]> noQueryBizBillMap = new HashMap<String, Object[]>();
            noQueryBizBillMap.put(curListKey, bizBillId);
            this.getPageCache().put(BIZ_BILL_NO_QUERY, JSON.toJSONString(noQueryBizBillMap));
            for (String listKey : billListFieldMap.keySet()) {
                QFilter qFilter = "list_bei_transdetail_cas".equals(listKey) && StringUtils.isNotEmpty((String)bizBillName) ? null : (listKey.equals(curListKey) && bizBillId != null && bizBillId.length > 0 ? new QFilter("id", "in", (Object)bizBillId) : new QFilter("id", "=", (Object)0));
                this.queryBillListByQFilter(listKey, qFilter, null);
            }
        }
        return currTabName;
    }

    private void fromTransDetail(Map<String, Object> customParams) {
        Object[] transDetailId = null;
        Object transDetailParam = customParams.get("transdetailid");
        if (transDetailParam != null) {
            transDetailId = ((JSONArray)transDetailParam).toArray();
            this.getModel().setValue("autofilter", (Object)"transdetail");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filter_org", "filter_accountbank", "filter_currency", "autofilter"});
            this.getPageCache().put(TRANS_DETAIL_NO_QUERY, JSON.toJSONString((Object)transDetailId));
            if (transDetailId.length > 0) {
                BillList billList = (BillList)this.getControl("list_bei_transdetail_cas");
                QFilter qFilter = new QFilter("id", "in", (Object)transDetailId);
                billList.setFilter(qFilter);
                billList.refresh();
            }
            this.queryBizBillList();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String f7Name = evt.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("filter_org");
        QFilter qFilter = null;
        switch (f7Name) {
            case "filter_accountbank": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"ManualMatchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                qFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)org.getLong("id")).and("isvirtual", "=", (Object)"0");
                break;
            }
            case "filter_currency": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"ManualMatchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection accountBank = (DynamicObjectCollection)this.getModel().getValue("filter_accountbank");
                if (accountBank == null || accountBank.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u53f7\u3002", (String)"ManualMatchPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Set<Long> currencyIdSet = this.getAcctBankCurrencyId(accountBank);
                qFilter = new QFilter("id", "in", currencyIdSet);
                break;
            }
        }
        if (qFilter != null) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void setFilter(SetFilterEvent evt) {
        QFilter queryFilter;
        String listKey = ((BillList)evt.getSource()).getKey();
        List qFilters = evt.getQFilters();
        String errorMsg = this.validateFilterField();
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            queryFilter = new QFilter("id", "=", (Object)0);
        } else {
            String bizBillNoQuery = this.getPageCache().get(BIZ_BILL_NO_QUERY);
            String transDetailNoQuery = this.getPageCache().get(TRANS_DETAIL_NO_QUERY);
            if (StringUtils.isNotEmpty((String)bizBillNoQuery) && !"list_bei_transdetail_cas".equals(listKey)) {
                Map map = (Map)JSON.parseObject((String)bizBillNoQuery, Map.class);
                String key = null;
                Object[] value = null;
                for (Map.Entry m : map.entrySet()) {
                    key = (String)m.getKey();
                    value = ((JSONArray)m.getValue()).toArray();
                }
                queryFilter = listKey.equals(key) ? new QFilter("id", "in", value) : new QFilter("id", "=", (Object)0);
            } else if (StringUtils.isNotEmpty((String)transDetailNoQuery) && "list_bei_transdetail_cas".equals(listKey)) {
                List transDetailId = (List)JSON.parseObject((String)transDetailNoQuery, List.class);
                queryFilter = new QFilter("id", "in", (Object)transDetailId);
            } else {
                queryFilter = this.getBillListQFilter(listKey, null, null);
            }
        }
        qFilters.add(queryFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "filter_org": {
                this.getModel().setValue("filter_accountbank", null);
                this.getModel().setValue("filter_currency", null);
                break;
            }
            case "filter_accountbank": {
                this.filterAccountBankChg();
                break;
            }
            case "autofilter": {
                ChangeData[] changeData = e.getChangeSet();
                Object newValue = changeData[0].getNewValue();
                if ("bizbill".equals(newValue)) {
                    this.filterByBizBillByMultipleChg();
                    break;
                }
                if (!"transdetail".equals(newValue)) break;
                this.filterByTransDetailByMultipleChg();
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_query": {
                String errorMsg = this.validateFilterField();
                if (StringUtils.isNotEmpty((String)errorMsg)) {
                    evt.setCancel(true);
                }
                this.beforeQueryAndRefresh();
                break;
            }
            case "btn_filter": {
                String autoFilter = (String)this.getModel().getValue("autofilter");
                if ("transdetail".equals(autoFilter)) {
                    this.filterByTransDetail();
                    break;
                }
                if (!"bizbill".equals(autoFilter)) break;
                this.filterByBizBill();
                break;
            }
        }
    }

    private void beforeQueryAndRefresh() {
        BillList billList = (BillList)this.getControl("list_cas_agentpaybill");
        Boolean headSelected = !new HashSet(billList.getCachedListFields()).contains("entry.id");
        this.getPageCache().put(AGENTSELECTEDTYPE, headSelected.toString());
        this.clearAllBizBillSelected();
        BillList listBizBill = (BillList)this.getControl("list_bei_transdetail_cas");
        listBizBill.clearSelection();
        this.getModel().setValue("unmatchrecamtsum", (Object)"");
        this.getModel().setValue("unmatchpayamtsum", (Object)"");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"amtprecisematch", "agentamtfilter", "bizdateprecisematch", "targetacctprecisematch"});
    }

    private void afterQueryAndRefresh() {
        String bizBillNoQuery = this.getPageCache().get(BIZ_BILL_NO_QUERY);
        String transDetailNoQuery = this.getPageCache().get(TRANS_DETAIL_NO_QUERY);
        if (StringUtils.isNotEmpty((String)bizBillNoQuery)) {
            this.queryBillListByQFilter("list_bei_transdetail_cas", null, null);
        } else if (StringUtils.isNotEmpty((String)transDetailNoQuery)) {
            this.queryBizBillList();
        } else {
            this.queryBillList();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_reset": {
                List<String> filterField = Arrays.asList("filter_org", "filter_accountbank", "filter_currency", "bizstartdate", "bizenddate");
                for (String ff : filterField) {
                    this.getModel().setValue(ff, null);
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"filter_org", "filter_accountbank", "filter_currency", "autofilter"});
                this.getPageCache().remove(BIZ_BILL_NO_QUERY);
                this.getPageCache().remove(TRANS_DETAIL_NO_QUERY);
                this.getModel().setValue("unmatchrecamtsum", (Object)"");
                this.getModel().setValue("unmatchpayamtsum", (Object)"");
                break;
            }
            case "btn_query": {
                this.afterQueryAndRefresh();
                break;
            }
            case "btn_filter": {
                String autoFilter = (String)this.getModel().getValue("autofilter");
                if ("transdetail".equals(autoFilter)) {
                    this.clearAllBizBillSelected();
                    break;
                }
                if (!"bizbill".equals(autoFilter)) break;
                BillList billList = (BillList)this.getControl("list_bei_transdetail_cas");
                billList.clearSelection();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put(CURR_TAB_NAME_KEY, tabKey);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)evt.getSource();
        int size = billList.getSelectedRows().size();
        String listKey = billList.getKey();
        if (matchFieldMap.containsKey(listKey)) {
            String tabKey = listKey.replace("list_", "tab_");
            TabPage tabPage = (TabPage)this.getControl(tabKey);
            BadgeInfo badgeInfo = new BadgeInfo();
            badgeInfo.setShowZero(false);
            badgeInfo.setCount(Integer.valueOf(size));
            tabPage.setBadgeInfo(badgeInfo);
            this.sumSelectedBizBillAmt(billList);
        }
        String autoFilter = (String)this.getModel().getValue("autofilter");
        if ("list_bei_transdetail_cas".equals(listKey) && "transdetail".equals(autoFilter)) {
            this.filterByTransDetailByMultipleChg();
        } else if ("bizbill".equals(autoFilter)) {
            this.filterByBizBillByMultipleChg();
        }
    }

    private void sumSelectedBizBillAmt(BillList billList) {
        String value;
        DynamicObject currency;
        Set cnySet;
        Set<String> recCnySet;
        String listKey = billList.getKey();
        DynamicObjectCollection data = this.getBizBillSelectedData(listKey, null);
        BigDecimal recAmtSum = BigDecimal.ZERO;
        HashSet<String> recSumCnySet = new HashSet<String>(5);
        BigDecimal payAmtSum = BigDecimal.ZERO;
        HashSet<String> paySumCnySet = new HashSet<String>(5);
        String currencyField = billListFieldMap.get(listKey).get(2);
        if ("list_cas_paybill".equals(listKey)) {
            payAmtSum = data.stream().map(d -> d.getBigDecimal("unmatchamountpay")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            recAmtSum = data.stream().filter(d -> d.getBoolean("relateotherflow")).map(d -> d.getBigDecimal("unmatchamountrec")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            Set payCnySet = data.stream().map(d -> d.getString(currencyField)).collect(Collectors.toSet());
            paySumCnySet.addAll(payCnySet);
            recSumCnySet.addAll(payCnySet);
        } else if ("list_cas_recbill".equals(listKey)) {
            recAmtSum = data.stream().map(d -> d.getBigDecimal("unmatchamountrec")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            payAmtSum = data.stream().filter(d -> d.getBoolean("relateotherflow")).map(d -> d.getBigDecimal("unmatchamountpay")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            recCnySet = data.stream().map(d -> d.getString(currencyField)).collect(Collectors.toSet());
            recSumCnySet.addAll(recCnySet);
            paySumCnySet.addAll(recCnySet);
        } else if ("list_cas_agentpaybill".equals(listKey)) {
            cnySet = data.stream().map(d -> d.getString(currencyField)).collect(Collectors.toSet());
            paySumCnySet.addAll(cnySet);
            payAmtSum = data.stream().map(d -> d.getBigDecimal("entry.entryunmatchamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        } else if ("list_fca_transupbill".equals(listKey)) {
            cnySet = data.stream().map(d -> d.getString(currencyField)).collect(Collectors.toSet());
            recSumCnySet.addAll(cnySet);
            recAmtSum = data.stream().map(d -> d.getBigDecimal("entrys.entryunmatchamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        } else if ("list_fca_transdownbill".equals(listKey)) {
            cnySet = data.stream().map(d -> d.getString(currencyField)).collect(Collectors.toSet());
            paySumCnySet.addAll(cnySet);
            payAmtSum = data.stream().map(d -> d.getBigDecimal("entrys.entryunmatchamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        } else if ("list_ifm_transhandlebill".equals(listKey)) {
            cnySet = data.stream().map(d -> d.getString(currencyField)).collect(Collectors.toSet());
            paySumCnySet.addAll(cnySet);
            payAmtSum = data.stream().map(d -> d.getBigDecimal("unmatchamountpay")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        } else if ("list_cas_exchangebill".equals(listKey)) {
            recCnySet = data.stream().map(d -> d.getString("buyingcurrency")).collect(Collectors.toSet());
            Set PayCnySet = data.stream().map(d -> d.getString("sellingcurrency")).collect(Collectors.toSet());
            recSumCnySet.addAll(recCnySet);
            paySumCnySet.addAll(PayCnySet);
            recAmtSum = data.stream().map(d -> d.getBigDecimal("buyunmatchamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            payAmtSum = data.stream().map(d -> d.getBigDecimal("sellunmatchamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        this.setUnMatchAmtSum(recSumCnySet, "unmatchrecamtsum");
        this.setUnMatchAmtSum(paySumCnySet, "unmatchpayamtsum");
        if (recSumCnySet.size() > 1 && paySumCnySet.size() > 1) {
            return;
        }
        this.getPageCache().put(SUM_CNY_PAY + listKey, JSON.toJSONString(paySumCnySet));
        this.getPageCache().put(SUM_CNY_REC + listKey, JSON.toJSONString(recSumCnySet));
        recCnySet = new HashSet(8);
        HashSet<String> payCnySet = new HashSet<String>(8);
        this.getPageCache().put(SUM_AMT_PAY + listKey, payAmtSum.toString());
        this.getPageCache().put(SUM_AMT_REC + listKey, recAmtSum.toString());
        ArrayList<BigDecimal> payAmtList = new ArrayList<BigDecimal>(8);
        ArrayList<BigDecimal> recAmtList = new ArrayList<BigDecimal>(8);
        for (String key : matchFieldMap.keySet()) {
            String sumPayAmt = this.getPageCache().get(SUM_AMT_PAY + key);
            String sumRecAmt = this.getPageCache().get(SUM_AMT_REC + key);
            if (StringUtils.isNotEmpty((String)sumPayAmt)) {
                payAmtList.add(new BigDecimal(sumPayAmt));
            }
            if (StringUtils.isNotEmpty((String)sumRecAmt)) {
                recAmtList.add(new BigDecimal(sumRecAmt));
            }
            Set<String> sumPayCny = this.getJsonToSet(SUM_CNY_PAY + key, String.class);
            Set<String> sumRecCny = this.getJsonToSet(SUM_CNY_REC + key, String.class);
            if (sumPayCny != null) {
                payCnySet.addAll(sumPayCny);
            }
            if (sumRecCny == null) continue;
            recCnySet.addAll(sumRecCny);
        }
        Map<Object, Object> currencyMap = new HashMap(5);
        if (recCnySet.size() == 1 || payCnySet.size() == 1) {
            HashSet cnySet2 = new HashSet();
            cnySet2.addAll(recCnySet.stream().map(Long::valueOf).collect(Collectors.toSet()));
            cnySet2.addAll(payCnySet.stream().map(Long::valueOf).collect(Collectors.toSet()));
            QFilter cnyFilter = new QFilter("id", "in", cnySet2);
            DynamicObjectCollection bdCurrency = QueryServiceHelper.query((String)"bd_currency", (String)"id,amtprecision,sign", (QFilter[])new QFilter[]{cnyFilter});
            currencyMap = bdCurrency.stream().collect(Collectors.groupingBy(c -> c.getString("id")));
        }
        if (recCnySet.size() > 1) {
            this.setUnMatchAmtSum(recCnySet, "unmatchrecamtsum");
        } else if (recCnySet.size() == 1) {
            String recCnyId = recCnySet.toArray()[0].toString();
            currency = (DynamicObject)((List)currencyMap.get(recCnyId)).get(0);
            BigDecimal unRecAmtSum = recAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
            value = currency.getString("sign") + unRecAmtSum;
            this.getModel().setValue("unmatchrecamtsum", (Object)value);
        } else {
            this.getModel().setValue("unmatchrecamtsum", (Object)"");
        }
        if (payCnySet.size() > 1) {
            this.setUnMatchAmtSum(payCnySet, "unmatchpayamtsum");
        } else if (payCnySet.size() == 1) {
            String payCnyId = payCnySet.toArray()[0].toString();
            currency = (DynamicObject)((List)currencyMap.get(payCnyId)).get(0);
            BigDecimal unPayAmtSum = payAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
            value = currency.getString("sign") + unPayAmtSum;
            this.getModel().setValue("unmatchpayamtsum", (Object)value);
        } else {
            this.getModel().setValue("unmatchpayamtsum", (Object)"");
        }
    }

    private void setUnMatchAmtSum(Set<String> sumCnySet, String amtSum) {
        if (sumCnySet.size() > 1) {
            this.getModel().setValue(amtSum, (Object)ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u591a\u5e01\u79cd\uff0c\u65e0\u6cd5\u7edf\u8ba1", (String)"ManualMatchPlugin_31", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private <T> Set<T> getJsonToSet(String cacheKey, Class<T> clazz) {
        String listStr = this.getPageCache().get(cacheKey);
        return (Set)JSON.parseObject((String)listStr, Set.class);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("beforesinglematch".equals(key)) {
            BillList detailList = (BillList)this.getControl("list_bei_transdetail_cas");
            ListSelectedRowCollection detailSelectedRows = detailList.getSelectedRows();
            Map<String, Integer> bizBillIdMap = this.getBizBillSelectedCountMap();
            if (bizBillIdMap.size() > 0 && detailSelectedRows.size() == 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u5355\u8fb9\u5339\u914d\u7684\u6570\u636e\u5747\u4e3a\u4e1a\u52a1\u5355\u636e\uff0c\u4e1a\u52a1\u5355\u636e\u5355\u8fb9\u5339\u914d\u540e\u6682\u4e0d\u652f\u6301\u53d6\u6d88\u5339\u914d\uff0c\u8bf7\u52a1\u5fc5\u8c28\u614e\u64cd\u4f5c\u3002\u5982\u786e\u8ba4\u65e0\u8bef\u70b9\u51fb\u786e\u5b9a\uff0c\u5982\u8fd4\u56de\u68c0\u67e5\u70b9\u51fb\u53d6\u6d88\u3002", (String)"ManualMatchPlugin_40", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("singlematchconfirm"));
            } else {
                this.getView().invokeOperation("singlematch");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if ("singlematchconfirm".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("singlematch");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "routinematch": {
                boolean cancel = this.routineMatch(operate);
                args.setCancel(cancel);
                break;
            }
            case "reversematch": {
                boolean cancel = this.reverseMatch(operate);
                args.setCancel(cancel);
                break;
            }
            case "differmatch": {
                boolean cancel = this.differMatch(operate);
                args.setCancel(cancel);
                break;
            }
            case "singlematch": {
                boolean cancel = this.singleMatch(operate);
                args.setCancel(cancel);
                break;
            }
            case "refresh": {
                String errorMsg = this.validateFilterField();
                if (StringUtils.isNotEmpty((String)errorMsg)) {
                    args.setCancel(true);
                }
                this.beforeQueryAndRefresh();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = args.getOperateKey()) {
            case "routinematch": 
            case "reversematch": 
            case "differmatch": 
            case "singlematch": {
                OperationResult opResult = args.getOperationResult();
                if (operate.getOption().containsVariable("refreshBizList")) {
                    String refreshBizListStr = operate.getOption().getVariableValue("refreshBizList");
                    List bizListArr = JSON.parseArray((String)refreshBizListStr, String.class);
                    this.successCallBackRefresh(bizListArr.toArray(new String[0]));
                    break;
                }
                opResult.setShowMessage(false);
                break;
            }
            case "automatch": {
                this.matchEnter();
                break;
            }
            case "matchrulesetting": {
                ListShowParameter showPara = new ListShowParameter();
                showPara.setBillFormId("cas_smartmatch");
                showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showPara);
                break;
            }
            case "refresh": {
                this.afterQueryAndRefresh();
                break;
            }
        }
    }

    private void matchEnter() {
        String direction;
        List<String> bizTypeList;
        BillList billList = (BillList)this.getControl("list_bei_transdetail_cas");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u3002", (String)"ManualMatchPlugin_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelrec", (String)"id,billno,currency,claimnoticebillno,creditamount,debitamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedPks)});
        Set directionSet = transDetails.stream().map(o -> {
            BigDecimal creditAmount = o.getBigDecimal("creditamount");
            BigDecimal debitAmount = o.getBigDecimal("debitamount");
            if (creditAmount != null && creditAmount.compareTo(BigDecimal.ZERO) != 0) {
                return "r";
            }
            if (debitAmount != null && debitAmount.compareTo(BigDecimal.ZERO) != 0) {
                return "p";
            }
            return "";
        }).collect(Collectors.toSet());
        if (directionSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u8bc1\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u65b9\u5411\u552f\u4e00\uff0c\u8981\u4e48\u5168\u90e8\u662f\u6536\u6b3e\u6d41\u6c34\uff0c\u8981\u4e48\u5168\u90e8\u662f\u4ed8\u6b3e\u6d41\u6c34\u3002", (String)"ManualMatchPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (transDetails.size() > 0) {
            for (DynamicObject transDetail : transDetails) {
                if (!StringUtils.isNotEmpty((String)transDetail.getString("claimnoticebillno"))) continue;
                selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.get("id")));
            }
        }
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6240\u6709\u4ea4\u6613\u660e\u7ec6\u90fd\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u540e\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"ManualMatchPlugin_27", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean recFlag = "r".equals(directionSet.toArray()[0].toString());
        String thisOpnumber = DB.genGlobalLongId() + "";
        if (recFlag) {
            bizTypeList = Arrays.asList("transup", "rec", "pay", "exchange");
            direction = "rec";
        } else {
            bizTypeList = Arrays.asList("transdown", "pay", "rec", "exchange", "transhandle", "agentpay");
            direction = "pay";
        }
        boolean isHasMatch = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelper", (String)"autoMatchByBizType", (Object[])new Object[]{selectedRows, bizTypeList, thisOpnumber, direction});
        if (!isHasMatch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5339\u914d\u7ed3\u679c\u3002\u53ef\u80fd\u662f\u672a\u914d\u7f6e\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u6216\u6839\u636e\u89c4\u5219\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5355\u636e\u3002", (String)"ManualMatchPlugin_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("cas_automatchresult");
            fsp.setCustomParam("thisOpnumber", (Object)thisOpnumber);
            fsp.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "automatch_callback");
            fsp.setCloseCallBack(callBack);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    private void initFilterOrgF7() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("filter_org");
        List recOrgIdList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"bei").getId(), (String)"bei_intelrec", (String)"43IS9F077KJM");
        List payOrgIdList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)"bei").getId(), (String)"bei_intelpay", (String)"43IS9F077KJM");
        HashSet allOrgIdList = new HashSet(recOrgIdList);
        allOrgIdList.addAll(payOrgIdList);
        QFilter qFilter = new QFilter("id", "in", allOrgIdList);
        orgCtrl.setQFilter(qFilter);
    }

    private void filterAccountBankChg() {
        DynamicObjectCollection accountBank = (DynamicObjectCollection)this.getModel().getValue("filter_accountbank");
        if (accountBank != null && !accountBank.isEmpty()) {
            Set<Long> currencyIdSet = this.getAcctBankCurrencyId(accountBank);
            BasedataEdit currencyCtrl = (BasedataEdit)this.getControl("filter_currency");
            currencyCtrl.setQFilter(new QFilter("id", "in", currencyIdSet));
            if (currencyIdSet.size() == 1) {
                this.getModel().setValue("filter_currency", (Object)currencyIdSet.toArray());
                return;
            }
            DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("filter_currency");
            Set frontCurrencySet = currency.stream().map(a -> ((DynamicObject)a.get("fbasedataid")).getLong("id")).collect(Collectors.toSet());
            if (currencyIdSet.size() > 1 && frontCurrencySet.size() > 0 && !currencyIdSet.containsAll(frontCurrencySet)) {
                HashSet retainCurrencyIdSet = new HashSet(frontCurrencySet);
                retainCurrencyIdSet.retainAll(currencyIdSet);
                this.getModel().setValue("filter_currency", (Object)retainCurrencyIdSet.toArray());
            }
        }
    }

    private Set<Long> getAcctBankCurrencyId(DynamicObjectCollection accountBank) {
        Set accountBankSet = accountBank.stream().map(a -> (DynamicObject)a.get("fbasedataid")).collect(Collectors.toSet());
        Set acctBankCurrencySet = accountBankSet.stream().map(a -> a.getDynamicObjectCollection("currency")).collect(Collectors.toSet());
        HashSet allCurrencySet = new HashSet(16);
        for (DynamicObjectCollection acctBankCurrency : acctBankCurrencySet) {
            Set currencySet = acctBankCurrency.stream().map(a -> (DynamicObject)a.get("fbasedataid")).collect(Collectors.toSet());
            allCurrencySet.addAll(currencySet);
        }
        return allCurrencySet.stream().map(c -> c.getLong("id")).collect(Collectors.toSet());
    }

    private String validateFilterField() {
        DynamicObjectCollection currency;
        DynamicObjectCollection accountBank;
        String errorMsg = null;
        ArrayList<String> errorMsgList = new ArrayList<String>(4);
        DynamicObject filterOrg = (DynamicObject)this.getModel().getValue("filter_org");
        if (filterOrg == null) {
            errorMsgList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"ManualMatchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if ((accountBank = (DynamicObjectCollection)this.getModel().getValue("filter_accountbank")) == null || accountBank.isEmpty()) {
            errorMsgList.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u53f7\u3002", (String)"ManualMatchPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if ((currency = (DynamicObjectCollection)this.getModel().getValue("filter_currency")) == null || currency.isEmpty()) {
            errorMsgList.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"ManualMatchPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (errorMsgList.size() > 0) {
            errorMsg = String.join((CharSequence)"\r\n", errorMsgList);
            this.getView().showTipNotification(errorMsg);
        }
        return errorMsg;
    }

    private void filterByTransDetail() {
        BillList billList = (BillList)this.getControl("list_bei_transdetail_cas");
        int detailSize = billList.getSelectedRows().size();
        if (detailSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4ea4\u6613\u660e\u7ec6\u3002", (String)"ManualMatchPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            String multipleSelected = this.getView().getPageCache().get(MULTIPLESELECTEDDETAIL);
            if (detailSize == 1 || StringUtils.isNotEmpty((String)multipleSelected)) {
                Object[] pkValue = billList.getSelectedRows().getPrimaryKeyValues();
                this.filterByTransDetailBySelected(pkValue, billList.getEntityId());
            }
        }
    }

    private void filterByTransDetailBySelected(Object[] pkValue, String entityId) {
        DynamicObjectCollection beiTransDetail = QueryServiceHelper.query((String)entityId, (String)"id,bizdate,creditamount,debitamount,oppunit,oppbanknumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValue)});
        if (!beiTransDetail.isEmpty()) {
            Map<String, QFilter> diff;
            Map<String, QFilter> same;
            Long orgId = ((DynamicObject)this.getModel().getValue("filter_org")).getLong("id");
            BigDecimal creditAmount = beiTransDetail.stream().map(b -> b.getBigDecimal("creditamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal debitAmount = beiTransDetail.stream().map(b -> b.getBigDecimal("debitamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            Boolean recFlag = null;
            if (creditAmount.compareTo(BigDecimal.ZERO) != 0) {
                recFlag = true;
            } else if (debitAmount.compareTo(BigDecimal.ZERO) != 0) {
                recFlag = false;
            }
            if (Boolean.TRUE.equals(recFlag)) {
                same = this.getBizBillFlowQFilter(REC_FLOW_DIRECTION_SAME, creditAmount, true, recFlag);
                diff = this.getBizBillFlowQFilter(REC_FLOW_DIRECTION_DIFF, creditAmount, false, recFlag);
            } else {
                same = this.getBizBillFlowQFilter(PAY_FLOW_DIRECTION_SAME, debitAmount, true, recFlag);
                diff = this.getBizBillFlowQFilter(PAY_FLOW_DIRECTION_DIFF, debitAmount, false, recFlag);
            }
            for (Map.Entry<String, Pair<List<String>, String>> entry : matchFieldMap.entrySet()) {
                QFilter filter;
                String listKey = entry.getKey();
                Pair<List<String>, String> pairValue = entry.getValue();
                QFilter sameFilter = same.get(listKey);
                QFilter diffFilter = diff.get(listKey);
                if (sameFilter != null && diffFilter != null) {
                    filter = sameFilter.or(diffFilter);
                } else if (sameFilter != null) {
                    filter = sameFilter;
                } else {
                    if (diffFilter == null) continue;
                    filter = diffFilter;
                }
                List fieldList = (List)pairValue.getLeft();
                Date bizDate = ((DynamicObject)beiTransDetail.get(0)).getDate("bizdate");
                this.bizDateMatchByTransDetail(filter, listKey, bizDate, orgId);
                String oppUnit = ((DynamicObject)beiTransDetail.get(0)).getString("oppunit");
                String oppBankNumber = ((DynamicObject)beiTransDetail.get(0)).getString("oppbanknumber");
                this.targetAcctMatchByTransDetail(filter, listKey, recFlag, oppUnit, oppBankNumber, (String)fieldList.get(1), (String)fieldList.get(2));
                this.queryBillListByQFilter(listKey, filter, null);
            }
        }
    }

    private Map<String, QFilter> getBizBillFlowQFilter(Set<String> bizList, BigDecimal amt, Boolean same, Boolean recFlag) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        HashMap<String, QFilter> map = new HashMap<String, QFilter>(4);
        for (String listKey : bizList) {
            Boolean amtMatch;
            String cp;
            List fieldList = (List)matchFieldMap.get(listKey).getLeft();
            boolean rec = recFlag;
            if (("list_cas_paybill".equals(listKey) || "list_cas_recbill".equals(listKey) || "list_cas_exchangebill".equals(listKey)) && !same.booleanValue()) {
                rec = recFlag == false;
            }
            String bizAmtField = ManualMatchPlugin.getRecFlowBizAmtField(listKey, (String)fieldList.get(0), rec, false);
            if (amt.compareTo(BigDecimal.ZERO) > 0) {
                cp = same != false ? ">" : "<";
                qFilter = new QFilter(bizAmtField, cp, (Object)0);
            }
            if (amt.compareTo(BigDecimal.ZERO) < 0) {
                cp = same != false ? "<" : ">";
                qFilter = new QFilter(bizAmtField, cp, (Object)0);
            }
            if ((amtMatch = (Boolean)this.getModel().getValue("amtprecisematch")).booleanValue()) {
                BigDecimal bizAmt;
                BigDecimal bigDecimal = bizAmt = same != false ? amt : BigDecimal.ZERO.subtract(amt);
                if ("list_cas_agentpaybill".equals(listKey)) {
                    String agentAmtFilter = (String)this.getModel().getValue("agentamtfilter");
                    boolean agentEntry = "entry".equals(agentAmtFilter);
                    String agentAmtField = ManualMatchPlugin.getRecFlowBizAmtField(listKey, (String)fieldList.get(0), recFlag, agentEntry);
                    qFilter.and(agentAmtField, "=", (Object)bizAmt);
                    if (agentEntry) {
                        qFilter.and("isencryption", "=", (Object)false);
                        qFilter.and("ismatchbyhead", "=", (Object)false);
                    }
                } else {
                    qFilter.and(bizAmtField, "=", (Object)bizAmt);
                }
            }
            if (qFilter != null && same.booleanValue() && ("list_cas_paybill".equals(listKey) && recFlag.booleanValue() || "list_cas_recbill".equals(listKey) && !recFlag.booleanValue())) {
                qFilter.and("relateotherflow", "=", (Object)true);
            }
            map.put(listKey, qFilter);
        }
        return map;
    }

    public static String getRecFlowBizAmtField(String listKey, String amtField, Boolean recFlag, boolean agentEntry) {
        String bizAmtField = "list_cas_paybill".equals(listKey) || "list_cas_recbill".equals(listKey) || "list_cas_exchangebill".equals(listKey) ? (recFlag != false ? amtField.split("#")[0] : amtField.split("#")[1]) : ("list_cas_agentpaybill".equals(listKey) ? (agentEntry ? amtField.split("#")[0] : amtField.split("#")[1]) : ("list_fca_transupbill".equals(listKey) || "list_fca_transdownbill".equals(listKey) ? amtField.split("#")[0] : amtField));
        return bizAmtField;
    }

    private QFilter bizDateMatchByTransDetail(QFilter qFilter, String listKey, Date bizDate, Long orgId) {
        Boolean bizDateMatch = (Boolean)this.getModel().getValue("bizdateprecisematch");
        if (bizDateMatch.booleanValue()) {
            String bizDatePro = PREFIX_DATE + listKey + orgId;
            String dateField = this.getPageCache().get(bizDatePro);
            qFilter.and(dateField, "=", (Object)bizDate);
        }
        return qFilter;
    }

    private void targetAcctMatchByTransDetail(QFilter qFilter, String listKey, Boolean recFlag, String oppUnit, String oppBankNumber, String targetNameField, String targetNumberField) {
        Boolean targetAcctMatch = (Boolean)this.getModel().getValue("targetacctprecisematch");
        if (targetAcctMatch.booleanValue()) {
            QFilter acct;
            QFilter targetFilter = null;
            if ("list_cas_paybill".equals(listKey) || "list_ifm_transhandlebill".equals(listKey)) {
                String[] split = targetNameField.split("#");
                targetFilter = new QFilter(split[0], "=", (Object)oppUnit).or(split[1], "=", (Object)oppUnit);
            } else if ("list_cas_agentpaybill".equals(listKey)) {
                Boolean amtMatch = (Boolean)this.getModel().getValue("amtprecisematch");
                String agentAmtFilter = (String)this.getModel().getValue("agentamtfilter");
                if (Boolean.FALSE.equals(amtMatch) || Boolean.TRUE.equals(amtMatch) && "entry".equals(agentAmtFilter)) {
                    String[] split = targetNameField.split("#");
                    targetFilter = new QFilter(split[0], "=", (Object)oppUnit);
                }
            } else {
                targetFilter = new QFilter(targetNameField, "=", (Object)oppUnit);
            }
            if (!"list_cas_exchangebill".equals(listKey) && targetFilter != null) {
                targetFilter.or(targetNumberField, "=", (Object)oppBankNumber);
            }
            if (recFlag.booleanValue() && "list_cas_paybill".equals(listKey)) {
                QFilter pay = new QFilter("relateotherflow", "=", (Object)true);
                acct = new QFilter("org.name", "=", (Object)oppUnit).or("payeracctbank.bankaccountnumber", "=", (Object)oppBankNumber);
                QFilter payAcctFilter = pay.and(acct);
                targetFilter = targetFilter != null ? targetFilter.or(payAcctFilter) : payAcctFilter;
            } else if (!recFlag.booleanValue() && "list_cas_recbill".equals(listKey)) {
                QFilter rec = new QFilter("relateotherflow", "=", (Object)true);
                acct = new QFilter("org.name", "=", (Object)oppUnit).or("accountbank.bankaccountnumber", "=", (Object)oppBankNumber);
                QFilter recAcctFilter = rec.and(acct);
                QFilter qFilter2 = targetFilter = targetFilter != null ? targetFilter.or(recAcctFilter) : recAcctFilter;
            }
            if (targetFilter != null) {
                qFilter.and(targetFilter);
            }
        }
    }

    private void filterByTransDetailByMultipleChg() {
        BillList billList = (BillList)this.getControl("list_bei_transdetail_cas");
        if (billList.getSelectedRows().size() > 1) {
            boolean directDiff;
            Object[] pkValues = billList.getSelectedRows().getPrimaryKeyValues();
            DynamicObjectCollection selectRows = QueryServiceHelper.query((String)billList.getEntityId(), (String)"id,creditamount,debitamount,oppunit,oppbanknumber,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
            List creditAmtList = selectRows.stream().filter(r -> r.getBigDecimal("creditamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            List debitAmtList = selectRows.stream().filter(r -> r.getBigDecimal("debitamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            Set groupKey = selectRows.stream().map(r -> r.getString("oppunit") + "#" + r.getString("oppbanknumber") + "#" + DateUtils.formatString((Date)r.getDate("bizdate"), (String)"yyyyMMdd")).collect(Collectors.toSet());
            boolean bl = directDiff = creditAmtList.size() > 0 && debitAmtList.size() > 0;
            if (directDiff || groupKey.size() > 1) {
                this.filterMultipleChg();
                this.getView().getPageCache().remove(MULTIPLESELECTEDDETAIL);
            } else {
                this.getModel().setValue("agentamtfilter", (Object)"entry");
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"amtprecisematch", "agentamtfilter", "bizdateprecisematch", "targetacctprecisematch"});
                this.getView().getPageCache().put(MULTIPLESELECTEDDETAIL, "true");
            }
        } else {
            this.getModel().setValue("agentamtfilter", (Object)"entry");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"amtprecisematch", "agentamtfilter", "bizdateprecisematch", "targetacctprecisematch"});
            this.getView().getPageCache().remove(MULTIPLESELECTEDDETAIL);
        }
    }

    private void filterByBizBillByMultipleChg() {
        Set<String> selectedBizBill = this.getBizBillSelectedCountMap().keySet();
        if (selectedBizBill.size() == 1) {
            String listKey = (String)selectedBizBill.toArray()[0];
            BillList billList = (BillList)this.getControl(listKey);
            Object[] pkValues = billList.getSelectedRows().getPrimaryKeyValues();
            if (matchFieldMap.containsKey(listKey) && pkValues.length > 1) {
                Set billTypeSet;
                List fieldList = (List)matchFieldMap.get(listKey).getLeft();
                String queryField = (String)matchFieldMap.get(listKey).getRight();
                Long orgId = ((DynamicObject)this.getModel().getValue("filter_org")).getLong("id");
                String dateField = this.getPageCache().get(PREFIX_DATE + listKey + orgId);
                DynamicObjectCollection selectRows = QueryServiceHelper.query((String)billList.getEntityId(), (String)(queryField + "," + dateField), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
                if ("list_cas_paybill".equals(listKey) && (billTypeSet = selectRows.stream().map(s -> s.get("billtype")).collect(Collectors.toSet())).size() > 1) {
                    this.filterMultipleChg();
                    return;
                }
                Map<Pair<Boolean, String>, String> amtMap = this.bizBillAmtField(listKey, (String)fieldList.get(0));
                HashSet<Object> amtFieldSet = new HashSet<Object>(amtMap.size());
                for (Pair<Boolean, String> pair : amtMap.keySet()) {
                    amtFieldSet.add(pair.getRight());
                }
                HashSet<Boolean> directDiffSet = new HashSet<Boolean>(4);
                for (String string : amtFieldSet) {
                    List amtList = selectRows.stream().filter(r -> r.getBigDecimal(field).compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
                    if (amtList.size() != selectRows.size()) {
                        directDiffSet.add(true);
                        continue;
                    }
                    directDiffSet.add(false);
                }
                Set set = selectRows.stream().map(r -> {
                    String payeeName = ((String)fieldList.get(1)).split("#")[0];
                    String oppBankNumber = StringUtils.isNotEmpty((String)((String)fieldList.get(2))) ? r.getString((String)fieldList.get(2)) : "";
                    String bizDate = DateUtils.formatString((Date)r.getDate(dateField), (String)"yyyyMMdd");
                    return r.getString(payeeName) + "#" + oppBankNumber + "#" + bizDate;
                }).collect(Collectors.toSet());
                if (directDiffSet.contains(true) || set.size() > 1) {
                    this.filterMultipleChg();
                    this.getView().getPageCache().remove(MULTIPLESELECTEDBIZBILL);
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"amtprecisematch", "agentamtfilter", "bizdateprecisematch", "targetacctprecisematch"});
                    this.getView().getPageCache().put(MULTIPLESELECTEDBIZBILL, "true");
                }
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"amtprecisematch", "agentamtfilter", "bizdateprecisematch", "targetacctprecisematch"});
                this.getView().getPageCache().remove(MULTIPLESELECTEDBIZBILL);
            }
        } else if (selectedBizBill.size() > 1) {
            this.filterMultipleChg();
            this.getView().getPageCache().remove(MULTIPLESELECTEDBIZBILL);
        }
    }

    private void filterMultipleChg() {
        this.getModel().setValue("amtprecisematch", null);
        this.getModel().setValue("agentamtfilter", null);
        this.getModel().setValue("bizdateprecisematch", null);
        this.getModel().setValue("targetacctprecisematch", null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"amtprecisematch", "agentamtfilter", "bizdateprecisematch", "targetacctprecisematch"});
    }

    private void filterByBizBill() {
        Map<String, Integer> bizBillCnt = this.getBizBillSelectedCountMap();
        int bizBillSize = bizBillCnt.values().stream().reduce(Integer::sum).orElse(0);
        if (bizBillSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e1a\u52a1\u5355\u636e\u3002", (String)"ManualMatchPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            String multipleSelected = this.getView().getPageCache().get(MULTIPLESELECTEDBIZBILL);
            if (bizBillSize == 1 || StringUtils.isNotEmpty((String)multipleSelected)) {
                String listKey = (String)bizBillCnt.keySet().toArray()[0];
                this.filterByBizBillBySelected(listKey);
            }
        }
    }

    private void filterByBizBillBySelected(String listKey) {
        Pair<List<String>, String> bizBillPair = matchFieldMap.get(listKey);
        List fieldList = (List)bizBillPair.getLeft();
        Map<Pair<Boolean, String>, String> amtMatchMap = this.amtMatchByBizBill(listKey, (String)fieldList.get(0));
        String dateField = this.bizDateMatchByBizBill(listKey);
        Map<String, String> targetAcctMap = this.targetAcctMatchByBizBill(listKey, (String)fieldList.get(1), (String)fieldList.get(2));
        DynamicObjectCollection bizBillList = this.getBizBillSelectedData(listKey, dateField);
        QFilter qFilter = null;
        ArrayList<QFilter> amtFilterList = null;
        if (amtMatchMap != null && !bizBillList.isEmpty()) {
            amtFilterList = new ArrayList<QFilter>(amtMatchMap.size());
            Object[] pkValues = null;
            Iterator<Object> entryPkValues = null;
            ListSelectedRowCollection listSelectedRowCollection = ((BillList)this.getControl(listKey)).getSelectedRows();
            if ("list_fca_transupbill".equals(listKey) || "list_fca_transdownbill".equals(listKey)) {
                pkValues = listSelectedRowCollection.getPrimaryKeyValues();
                entryPkValues = listSelectedRowCollection.getEntryPrimaryKeyValues();
            }
            for (Map.Entry<Pair<Boolean, String>, String> entry : amtMatchMap.entrySet()) {
                String bizField = (String)entry.getKey().getRight();
                BigDecimal amt = null;
                if ("list_cas_agentpaybill".equals(listKey)) {
                    if (bizField.startsWith("entry")) {
                        List noEncrypt = bizBillList.stream().filter(b -> !b.getBoolean("isencryption")).collect(Collectors.toList());
                        if (noEncrypt.isEmpty()) continue;
                        amt = noEncrypt.stream().map(b -> b.getBigDecimal(bizField)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    } else {
                        Map<Long, List<DynamicObject>> idAgentBillMap = bizBillList.stream().collect(Collectors.groupingBy(b -> b.getLong("id")));
                        amt = idAgentBillMap.values().stream().map(b -> ((DynamicObject)b.get(0)).getBigDecimal(bizField)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                } else {
                    if (("list_fca_transupbill".equals(listKey) || "list_fca_transdownbill".equals(listKey)) && pkValues != null && pkValues.length == 1 && entryPkValues != null && entryPkValues[0] == null && bizBillList.size() > 1) continue;
                    amt = bizBillList.stream().map(b -> b.getBigDecimal(bizField)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                }
                BigDecimal amtValue = (Boolean)entry.getKey().getLeft() != false ? amt : BigDecimal.ZERO.subtract(amt);
                String detailField = entry.getValue();
                QFilter amtFilter = new QFilter(detailField, "=", (Object)amtValue);
                amtFilterList.add(amtFilter);
            }
        }
        ArrayList<QFilter> targetFilterList = null;
        if (targetAcctMap != null && !bizBillList.isEmpty()) {
            targetFilterList = new ArrayList<QFilter>(targetAcctMap.size());
            for (Map.Entry entry : targetAcctMap.entrySet()) {
                DynamicObject bizBillData;
                String bizBillField = (String)entry.getKey();
                if ("list_cas_agentpaybill".equals(listKey) && bizBillField.startsWith("entry")) {
                    List noEncrypt = bizBillList.stream().filter(b -> !b.getBoolean("isencryption")).collect(Collectors.toList());
                    if (noEncrypt.isEmpty()) continue;
                    bizBillData = (DynamicObject)noEncrypt.get(0);
                } else {
                    bizBillData = (DynamicObject)bizBillList.get(0);
                }
                String bizValue = bizBillData.getString(bizBillField);
                String detailField = (String)entry.getValue();
                QFilter targetFilter = new QFilter(detailField, "=", (Object)bizValue);
                targetFilterList.add(targetFilter);
            }
        }
        if (amtFilterList != null && !amtFilterList.isEmpty()) {
            for (QFilter qFilter2 : amtFilterList) {
                qFilter = qFilter == null ? qFilter2 : qFilter.or(qFilter2);
            }
        }
        if (targetFilterList != null && !targetFilterList.isEmpty()) {
            QFilter targetFilter = null;
            for (QFilter filter : targetFilterList) {
                targetFilter = targetFilter == null ? filter : targetFilter.or(filter);
            }
            QFilter qFilter3 = this.getSpecialByBizBill(listKey, bizBillList);
            if (qFilter3 != null) {
                targetFilter = targetFilter == null ? qFilter3 : targetFilter.or(qFilter3);
            }
            QFilter qFilter4 = qFilter = qFilter == null ? targetFilter : qFilter.and(targetFilter);
        }
        if (dateField != null && !bizBillList.isEmpty()) {
            QFilter dateFilter = new QFilter("bizdate", "=", (Object)((DynamicObject)bizBillList.get(0)).getDate(dateField));
            qFilter = qFilter == null ? dateFilter : qFilter.and(dateFilter);
        }
        this.queryBillListByQFilter("list_bei_transdetail_cas", qFilter, null);
    }

    private Map<Pair<Boolean, String>, String> amtMatchByBizBill(String listKey, String amtField) {
        Boolean amtMatch = (Boolean)this.getModel().getValue("amtprecisematch");
        Map<Pair<Boolean, String>, String> result = null;
        if (amtMatch.booleanValue()) {
            result = this.bizBillAmtField(listKey, amtField);
        }
        return result;
    }

    private Map<Pair<Boolean, String>, String> bizBillAmtField(String listKey, String amtField) {
        String RecStr = "creditamount";
        String payStr = "debitamount";
        boolean payFlag = true;
        String field = null;
        HashMap<Pair<Boolean, String>, String> result = new HashMap<Pair<Boolean, String>, String>(8);
        if ("list_cas_recbill".equals(listKey)) {
            field = amtField.split("#")[0];
            payFlag = false;
        } else if ("list_cas_paybill".equals(listKey)) {
            field = amtField.split("#")[1];
        } else if ("list_ifm_transhandlebill".equals(listKey)) {
            field = amtField;
        } else if ("list_cas_agentpaybill".equals(listKey)) {
            BillList billList = (BillList)this.getControl(listKey);
            Object[] entryPkValues = billList.getSelectedRows().getEntryPrimaryKeyValues();
            field = entryPkValues.length == 1 && entryPkValues[0] == null ? amtField.split("#")[1] : amtField.split("#")[0];
        } else if ("list_fca_transupbill".equals(listKey)) {
            field = amtField.split("#")[0];
            payFlag = false;
        } else if ("list_fca_transdownbill".equals(listKey)) {
            field = amtField.split("#")[0];
        }
        if ("list_cas_exchangebill".equals(listKey)) {
            String[] split = amtField.split("#");
            result.put(Pair.of((Object)true, (Object)split[0]), RecStr);
            result.put((Pair<Boolean, String>)Pair.of((Object)false, (Object)split[0]), payStr);
            result.put((Pair<Boolean, String>)Pair.of((Object)true, (Object)split[1]), payStr);
            result.put((Pair<Boolean, String>)Pair.of((Object)false, (Object)split[1]), RecStr);
        } else if (payFlag) {
            result.put(Pair.of((Object)false, (Object)field), RecStr);
            result.put(Pair.of((Object)true, (Object)field), payStr);
        } else {
            result.put(Pair.of((Object)true, (Object)field), RecStr);
            result.put(Pair.of((Object)false, (Object)field), payStr);
        }
        return result;
    }

    private String bizDateMatchByBizBill(String listKey) {
        Boolean bizDateMatch = (Boolean)this.getModel().getValue("bizdateprecisematch");
        if (bizDateMatch.booleanValue()) {
            Long orgId = ((DynamicObject)this.getModel().getValue("filter_org")).getLong("id");
            String bizDatePro = PREFIX_DATE + listKey + orgId;
            return this.getPageCache().get(bizDatePro);
        }
        return null;
    }

    private Map<String, String> targetAcctMatchByBizBill(String listKey, String targetNameField, String targetNumberField) {
        Boolean targetAcctMatch = (Boolean)this.getModel().getValue("targetacctprecisematch");
        HashMap<String, String> result = null;
        if (targetAcctMatch.booleanValue()) {
            String oppUnit = "oppunit";
            String oppBankNumber = "oppbanknumber";
            result = new HashMap<String, String>(4);
            if ("list_cas_paybill".equals(listKey) || "list_ifm_transhandlebill".equals(listKey)) {
                String[] split = targetNameField.split("#");
                result.put(split[0], oppUnit);
                result.put(split[1], oppUnit);
                result.put(targetNumberField, oppBankNumber);
            } else if ("list_cas_agentpaybill".equals(listKey)) {
                BillList billList = (BillList)this.getControl(listKey);
                Object[] entryPkValues = billList.getSelectedRows().getEntryPrimaryKeyValues();
                if (entryPkValues.length > 0 && entryPkValues[0] != null) {
                    String[] split = targetNameField.split("#");
                    result.put(split[0], oppUnit);
                    result.put(targetNumberField, oppBankNumber);
                }
            } else {
                result.put(targetNameField, oppUnit);
                if (StringUtils.isNotEmpty((String)targetNumberField)) {
                    result.put(targetNumberField, oppBankNumber);
                }
            }
        }
        return result;
    }

    private QFilter getSpecialByBizBill(String listKey, DynamicObjectCollection bizBillList) {
        Set bankAcctNumber;
        Set orgName;
        List relateOtherFlow;
        QFilter qFilter = null;
        String oppUnit = "oppunit";
        String oppBankNumber = "oppbanknumber";
        if ("list_cas_paybill".equals(listKey) && !(relateOtherFlow = bizBillList.stream().filter(b -> b.getBoolean("relateotherflow")).collect(Collectors.toList())).isEmpty()) {
            orgName = relateOtherFlow.stream().map(r -> r.getString("org.name")).collect(Collectors.toSet());
            bankAcctNumber = relateOtherFlow.stream().map(r -> r.getString("payeracctbank.bankaccountnumber")).collect(Collectors.toSet());
            qFilter = new QFilter(oppUnit, "in", orgName).or(oppBankNumber, "in", bankAcctNumber);
        }
        if ("list_cas_recbill".equals(listKey) && !(relateOtherFlow = bizBillList.stream().filter(b -> b.getBoolean("relateotherflow")).collect(Collectors.toList())).isEmpty()) {
            orgName = relateOtherFlow.stream().map(r -> r.getString("org.name")).collect(Collectors.toSet());
            bankAcctNumber = relateOtherFlow.stream().map(r -> r.getString("accountbank.bankaccountnumber")).collect(Collectors.toSet());
            qFilter = new QFilter(oppUnit, "in", orgName).or(oppBankNumber, "in", bankAcctNumber);
        }
        return qFilter;
    }

    private void queryNoDataList() {
        for (String listKey : billListFieldMap.keySet()) {
            QFilter qFilter = new QFilter("id", "=", (Object)0);
            BillList billList = (BillList)this.getControl(listKey);
            billList.setFilter(qFilter);
            billList.refresh();
        }
    }

    private void queryBizBillList() {
        for (String listKey : matchFieldMap.keySet()) {
            this.queryBillListByQFilter(listKey, null, null);
        }
    }

    private void queryBillList() {
        for (String listKey : billListFieldMap.keySet()) {
            this.queryBillListByQFilter(listKey, null, null);
        }
    }

    private void queryBillListByQFilter(String listKey, QFilter and, QFilter or) {
        QFilter qFilter = this.getBillListQFilter(listKey, and, or);
        BillList billList = (BillList)this.getControl(listKey);
        billList.setFilter(qFilter);
        billList.refresh();
    }

    private QFilter getBillListQFilter(String listKey, QFilter and, QFilter or) {
        Long orgId = ((DynamicObject)this.getModel().getValue("filter_org")).getLong("id");
        Set acctBankSet = ((DynamicObjectCollection)this.getModel().getValue("filter_accountbank")).stream().map(a -> (DynamicObject)a.get("fbasedataid")).collect(Collectors.toSet());
        Set acctBankIdSet = acctBankSet.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        Set currencyIdSet = ((DynamicObjectCollection)this.getModel().getValue("filter_currency")).stream().map(a -> ((DynamicObject)a.get("fbasedataid")).getLong("id")).collect(Collectors.toSet());
        Date bizStartDate = (Date)this.getModel().getValue("bizstartdate");
        Date bizEndDate = (Date)this.getModel().getValue("bizenddate");
        List<String> filterField = billListFieldMap.get(listKey);
        QFilter qFilter = null;
        if ("list_bei_transdetail_cas".equals(listKey)) {
            qFilter = new QFilter(filterField.get(1), "in", acctBankIdSet);
            qFilter.and(filterField.get(2), "in", currencyIdSet);
            qFilter.and("claimnoticebillno", "=", (Object)" ");
            qFilter.and("receredtype", "not in", Arrays.asList("1", "3", "4"));
        } else if ("list_cas_exchangebill".equals(listKey)) {
            qFilter = new QFilter("matchflag", "in", Arrays.asList("0", "2"));
            QFilter sellCurrency = new QFilter("sellingcurrency", "in", currencyIdSet);
            QFilter sellAccount = new QFilter("sellingaccount", "in", acctBankIdSet);
            QFilter sellMatchFlag = new QFilter("sellmatchflag", "in", Arrays.asList("0", "2"));
            QFilter sellFilter = sellAccount.and(sellCurrency).and(sellMatchFlag);
            QFilter buyAccount = new QFilter("buyingaccount", "in", acctBankIdSet);
            QFilter buyCurrency = new QFilter("buyingcurrency", "in", currencyIdSet);
            QFilter buyMatchFlag = new QFilter("buymatchflag", "in", Arrays.asList("0", "2"));
            QFilter buyFilter = buyAccount.and(buyCurrency).and(buyMatchFlag);
            QFilter exchange = sellFilter.or(buyFilter);
            qFilter.and(exchange);
        } else {
            Set acctBankNumSet;
            qFilter = new QFilter(filterField.get(1), "in", acctBankIdSet);
            if ("list_cas_paybill".equals(listKey)) {
                acctBankNumSet = acctBankSet.stream().map(a -> a.getString("bankaccountnumber")).collect(Collectors.toSet());
                qFilter.or(new QFilter("payeebanknum", "in", acctBankNumSet).and("relateotherflow", "=", (Object)true));
            } else if ("list_cas_recbill".equals(listKey)) {
                acctBankNumSet = acctBankSet.stream().map(a -> a.getString("bankaccountnumber")).collect(Collectors.toSet());
                qFilter.or(new QFilter("payeracctbanknum", "in", acctBankNumSet).and("relateotherflow", "=", (Object)true));
            }
            qFilter.and(filterField.get(2), "in", currencyIdSet);
            QFilter status = this.getBizBillStatusFilter(listKey);
            qFilter.and(status);
            qFilter.and("matchflag", "in", Arrays.asList("0", "2"));
            if ("list_cas_agentpaybill".equals(listKey)) {
                String headSelected = this.getPageCache().get(AGENTSELECTEDTYPE);
                if ("false".equals(headSelected)) {
                    qFilter.and("entry.entrymatchflag", "in", Arrays.asList("0", "2"));
                }
            } else if ("list_fca_transupbill".equals(listKey) || "list_fca_transdownbill".equals(listKey)) {
                qFilter.and("entrys.entrymatchflag", "in", Arrays.asList("0", "2"));
            }
        }
        String dateField = this.getDateFieldAndRangeFilter(listKey, qFilter, orgId, filterField.get(3));
        if (bizStartDate != null || bizEndDate != null) {
            if (bizStartDate != null) {
                qFilter.and(dateField, ">=", (Object)bizStartDate);
            }
            if (bizEndDate != null) {
                qFilter.and(dateField, "<=", (Object)bizEndDate);
            }
        }
        if (and != null) {
            qFilter.and(and);
        }
        if (or != null) {
            qFilter.or(or);
        }
        return qFilter;
    }

    private String getDateFieldAndRangeFilter(String listKey, QFilter qFilter, Long orgId, String defaultDateField) {
        String dateField;
        String entryName = listKey.substring(5);
        String enableDateCacheKey = DETAIL_DATE + orgId;
        if (matchFieldMap.containsKey(listKey)) {
            QFilter rangeQFilter = null;
            String rangeQFilterKey = PREFIX_RANGE_QFILTER + listKey + orgId;
            String dateFieldKey = PREFIX_DATE + listKey + orgId;
            String bizBillDateField = this.getPageCache().get(dateFieldKey);
            if (StringUtils.isEmpty((String)bizBillDateField)) {
                String headSelected = this.getPageCache().get(AGENTSELECTEDTYPE);
                Boolean headMatch = Boolean.valueOf(headSelected);
                MatchRangeInfo rangeInfo = ManualMatchHelper.getBizBillQFilter((Long)orgId, (String)entryName, (Boolean)headMatch);
                String field = rangeInfo.getDateField();
                dateField = field == null ? defaultDateField : field;
                this.getPageCache().put(dateFieldKey, dateField);
                rangeQFilter = rangeInfo.getRangeQFilter();
                if (rangeQFilter != null) {
                    this.getPageCache().put(rangeQFilterKey, rangeQFilter.toSerializedString());
                }
                if (field != null) {
                    String enableDateCache = this.getPageCache().get(enableDateCacheKey);
                    Date enableDate = rangeInfo.getEnableDate();
                    String enableDateStr = enableDate != null ? DateUtils.formatString((Date)enableDate, (String)"yyyy-MM-dd HH:mm:ss") : "null";
                    String dateStr = StringUtils.isNotEmpty((String)enableDateCache) ? enableDateCache + "," + enableDateStr : enableDateStr;
                    this.getPageCache().put(enableDateCacheKey, dateStr);
                }
            } else {
                dateField = bizBillDateField;
                String rangeFilterStr = this.getPageCache().get(rangeQFilterKey);
                if (StringUtils.isNotEmpty((String)rangeFilterStr)) {
                    rangeQFilter = QFilter.fromSerializedString((String)rangeFilterStr);
                }
            }
            if (rangeQFilter != null) {
                qFilter.and(rangeQFilter);
            }
        } else {
            dateField = defaultDateField;
            String enableDateStr = this.getPageCache().get(enableDateCacheKey);
            if (StringUtils.isNotEmpty((String)enableDateStr)) {
                Set enableDateStrSet = Stream.of(enableDateStr.split(",")).collect(Collectors.toSet());
                if (!enableDateStr.contains("null")) {
                    Set enableDateSet = enableDateStrSet.stream().map(d -> DateUtils.stringToDate((String)d, (String)"yyyy-MM-dd HH:mm:ss")).collect(Collectors.toSet());
                    Date minEnableDate = (Date)Collections.min(enableDateSet);
                    qFilter.and(dateField, ">=", (Object)minEnableDate);
                }
            }
        }
        return dateField;
    }

    private QFilter getBizBillStatusFilter(String listKey) {
        QFilter filter = null;
        switch (listKey) {
            case "list_cas_recbill": {
                filter = new QFilter("billstatus", "not in", Collections.singletonList(BillStatusEnum.CHARGEBANK.getValue()));
                break;
            }
            case "list_cas_paybill": {
                filter = new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue(), BillStatusEnum.DRAFTING.getValue()));
                break;
            }
            case "list_cas_agentpaybill": {
                filter = new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue()));
                break;
            }
            case "list_fca_transupbill": 
            case "list_fca_transdownbill": {
                filter = new QFilter("billstatus", "!=", (Object)"S");
                break;
            }
            case "list_ifm_transhandlebill": {
                filter = new QFilter("paidstatus", "!=", (Object)"C");
                break;
            }
        }
        return filter;
    }

    private void clearAllBizBillSelected() {
        for (String listKey : matchFieldMap.keySet()) {
            this.clearBizBillSelected(listKey);
        }
    }

    private void clearBizBillSelected(String listKey) {
        BillList listBizBill = (BillList)this.getControl(listKey);
        listBizBill.clearSelection();
        this.setBizBillTabCnt(listKey);
    }

    private void setBizBillTabCnt(String listKey) {
        String billTabName = listKey.replace("list_", "tab_");
        TabPage tabPage = (TabPage)this.getControl(billTabName);
        if (null != tabPage) {
            BadgeInfo badgeInfo = new BadgeInfo();
            badgeInfo.setShowZero(false);
            badgeInfo.setCount(Integer.valueOf(0));
            tabPage.setBadgeInfo(badgeInfo);
            this.getPageCache().remove(SUM_AMT_PAY + listKey);
            this.getPageCache().remove(SUM_AMT_REC + listKey);
            this.getPageCache().remove(SUM_CNY_REC + listKey);
            this.getPageCache().remove(SUM_CNY_PAY + listKey);
        }
    }

    private boolean singleMatch(AbstractOperate operate) {
        ArrayList<String> bizBIllKeyList = new ArrayList<String>(10);
        BillList detailList = (BillList)this.getControl("list_bei_transdetail_cas");
        ListSelectedRowCollection detailSelectedRows = detailList.getSelectedRows();
        Map<String, Integer> bizBillIdMap = this.getBizBillSelectedCountMap();
        if (detailSelectedRows.size() == 0 && bizBillIdMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u6613\u660e\u7ec6\u6216\u4e1a\u52a1\u5355\u636e\u3002", (String)"ManualMatchPlugin_41", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (detailSelectedRows.size() > 0 && bizBillIdMap.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u6240\u9009\u6570\u636e\u8981\u4e48\u5168\u90e8\u662f\u6d41\u6c34\u3001\u8981\u4e48\u5168\u90e8\u662f\u5355\u636e\u3002", (String)"ManualMatchPlugin_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        String thisOpnumber = DB.genGlobalLongId() + "";
        if (detailSelectedRows.size() > 0) {
            bizBIllKeyList.add("list_bei_transdetail_cas");
            List transDetailIdList = detailSelectedRows.stream().map(r -> (Long)r.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,billno,currency,creditamount,debitamount,bankcheckflag,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", transDetailIdList)});
            BigDecimal creditAmtSum = transDetails.stream().map(v -> v.getBigDecimal("creditamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal debitAmtSum = transDetails.stream().map(v -> v.getBigDecimal("debitamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (creditAmtSum.compareTo(debitAmtSum) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u6536\u6b3e\u91d1\u989d\u5408\u8ba1=\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u3002", (String)"ManualMatchPlugin_33", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return true;
            }
            ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(transDetails.size());
            for (DynamicObject transDetail : transDetails) {
                String tDataEntityType = EmptyUtil.isNoEmpty((BigDecimal)transDetail.getBigDecimal("creditamount")) ? "bei_intelrec" : "bei_intelpay";
                List others = transDetails.stream().filter(v -> v.getLong("id") != transDetail.getLong("id")).collect(Collectors.toList());
                for (DynamicObject otherDetail : others) {
                    tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), "bei_transdetail", otherDetail.getString("billno"), Long.valueOf(otherDetail.getLong("id")), Long.valueOf(0L), Long.valueOf(transDetail.getLong("currency")), "", BigDecimal.ZERO, transDetail.getString("bankcheckflag"), transDetail.getDate("bizdate"), thisOpnumber, ""));
                }
            }
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.SINGLEMATCH.getValue(), null, true, null});
            CasFlowConfirmLogHelper.saveSingleMatchLog(tAutoMatchInfoList);
            operate.getOption().setVariableValue("refreshBizList", JSON.toJSONString(bizBIllKeyList));
            return false;
        }
        BigDecimal recUnMatchAmtSum = BigDecimal.ZERO;
        BigDecimal payUnMatchAmtSum = BigDecimal.ZERO;
        HashMap<String, DynamicObjectCollection> selectedBizBillMap = new HashMap<String, DynamicObjectCollection>(bizBillIdMap.size());
        HashMap<String, Map> selectedRecUnMatchMap = new HashMap<String, Map>(bizBillIdMap.size());
        HashMap<String, Map> selectedpayUnMatchMap = new HashMap<String, Map>(bizBillIdMap.size());
        if (bizBillIdMap.size() > 0) {
            for (String bizBillListKey : bizBillIdMap.keySet()) {
                DynamicObjectCollection bizBills = this.getBizBillSelectedData(bizBillListKey, null);
                selectedBizBillMap.put(bizBillListKey, bizBills);
                String unMatchAmtField = (String)((List)matchFieldMap.get(bizBillListKey).getLeft()).get(0);
                BillList bizBillList = (BillList)this.getControl(bizBillListKey);
                ListSelectedRowCollection bizBillSelectedRows = bizBillList.getSelectedRows();
                Object[] entryPKValues = bizBillSelectedRows.getEntryPrimaryKeyValues();
                boolean entrySelected = entryPKValues[0] != null;
                Map recUnMatchAmtMap = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillListKey, (boolean)true, (String)unMatchAmtField, (boolean)entrySelected);
                selectedRecUnMatchMap.put(bizBillListKey, recUnMatchAmtMap);
                Map payUnMatchAmtMap = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillListKey, (boolean)false, (String)unMatchAmtField, (boolean)entrySelected);
                selectedpayUnMatchMap.put(bizBillListKey, payUnMatchAmtMap);
                recUnMatchAmtSum = recUnMatchAmtSum.add(recUnMatchAmtMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                payUnMatchAmtSum = payUnMatchAmtSum.add(payUnMatchAmtMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
        }
        if (recUnMatchAmtSum.compareTo(payUnMatchAmtSum) != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5408\u8ba1=\u672a\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u3002", (String)"ManualMatchPlugin_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        HashSet autoRecPayBizBillIdSet = new HashSet(16);
        boolean autoConfirm = (Boolean)this.getModel().getValue("matchautoconfirm");
        ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(10);
        for (Map.Entry entry : selectedBizBillMap.entrySet()) {
            String bizBillKey = (String)entry.getKey();
            bizBIllKeyList.add(bizBillKey);
            String bizBillType = bizBillKey.substring(5);
            Map recUnMatchAmtMap = (Map)selectedRecUnMatchMap.get(bizBillKey);
            Map payUnMatchAmtMap = (Map)selectedpayUnMatchMap.get(bizBillKey);
            if (autoConfirm) {
                autoRecPayBizBillIdSet.addAll(((DynamicObjectCollection)entry.getValue()).stream().map(v -> v.get("id")).collect(Collectors.toSet()));
            }
            for (DynamicObject bizBill : (DynamicObjectCollection)entry.getValue()) {
                String traceType = "";
                BigDecimal recUnMatchAmt = (BigDecimal)recUnMatchAmtMap.get(bizBill.getString("id"));
                BigDecimal payUnMatchAmt = (BigDecimal)payUnMatchAmtMap.get(bizBill.getString("id"));
                if ("list_cas_exchangebill".equals(bizBillKey)) {
                    traceType = EmptyUtil.isNoEmpty((BigDecimal)recUnMatchAmt) ? "buy" : "sell";
                }
                BigDecimal amount = EmptyUtil.isNoEmpty((BigDecimal)recUnMatchAmt) ? recUnMatchAmt : payUnMatchAmt;
                String tDataEntityType = EmptyUtil.isNoEmpty((BigDecimal)recUnMatchAmt) ? "bei_intelrec" : "bei_intelpay";
                tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, bizBill.getString("billno"), Long.valueOf(bizBill.getLong("id")), bizBillType, bizBill.getString("billno"), Long.valueOf(bizBill.getLong("id")), Long.valueOf(0L), Long.valueOf(0L), traceType, amount, "", new Date(), thisOpnumber, ""));
            }
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.SINGLEMATCH.getValue(), null, true, autoRecPayBizBillIdSet});
        CasFlowConfirmLogHelper.saveSingleMatchLog(tAutoMatchInfoList);
        operate.getOption().setVariableValue("refreshBizList", JSON.toJSONString(bizBIllKeyList));
        return false;
    }

    private boolean differMatch(AbstractOperate operate) {
        boolean bizBillSameExsit;
        ManualMatchCheck selectCheck = this.selectValidate();
        if (selectCheck.isCheckFail()) {
            return true;
        }
        Map bizBillIdMap = selectCheck.getBizBillIdMap();
        ListSelectedRowCollection detailSelectedRows = selectCheck.getDetailSelectedRows();
        List transDetailIdList = detailSelectedRows.stream().map(r -> (Long)r.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,billno,currency,creditamount,debitamount,bankcheckflag,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", transDetailIdList)});
        int creditNotNullCnt = 0;
        int debitNotNullCnt = 0;
        BigDecimal creditAmtSum = BigDecimal.ZERO;
        BigDecimal debitAmtSum = BigDecimal.ZERO;
        for (DynamicObject transDetail : transDetails) {
            BigDecimal creditAmount = transDetail.getBigDecimal("creditamount");
            BigDecimal debitAmount = transDetail.getBigDecimal("debitamount");
            if (EmptyUtil.isNoEmpty((BigDecimal)creditAmount)) {
                creditAmtSum = creditAmtSum.add(creditAmount);
                ++creditNotNullCnt;
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)debitAmount)) continue;
            debitAmtSum = debitAmtSum.add(debitAmount);
            ++debitNotNullCnt;
        }
        boolean transDetailSameExsit = creditNotNullCnt > 0 && debitNotNullCnt > 0;
        int recUnMatchAmtCnt = 0;
        int payUnMatchAmtCnt = 0;
        BigDecimal recUnMatchAmtSum = BigDecimal.ZERO;
        BigDecimal payUnMatchAmtSum = BigDecimal.ZERO;
        boolean isExsitRecAndPayAmt = false;
        HashMap<String, DynamicObjectCollection> allSelectBills = new HashMap<String, DynamicObjectCollection>(bizBillIdMap.size());
        for (String bizBillListKey : bizBillIdMap.keySet()) {
            DynamicObjectCollection bizBills = this.getBizBillSelectedData(bizBillListKey, null);
            String unMatchAmtField = (String)((List)matchFieldMap.get(bizBillListKey).getLeft()).get(0);
            BillList bizBillList = (BillList)this.getControl(bizBillListKey);
            ListSelectedRowCollection bizBillSelectedRows = bizBillList.getSelectedRows();
            Object[] entryPKValues = bizBillSelectedRows.getEntryPrimaryKeyValues();
            boolean entrySelected = entryPKValues[0] != null;
            Map recUnMatchAmtMap = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillListKey, (boolean)true, (String)unMatchAmtField, (boolean)entrySelected);
            Map payUnMatchAmtMap = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillListKey, (boolean)false, (String)unMatchAmtField, (boolean)entrySelected);
            int recUnMatchAmtSize = (int)recUnMatchAmtMap.values().stream().filter(EmptyUtil::isNoEmpty).count();
            recUnMatchAmtCnt += recUnMatchAmtSize;
            recUnMatchAmtSum = recUnMatchAmtSum.add(recUnMatchAmtMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            int payUnMatchAmtSize = (int)payUnMatchAmtMap.values().stream().filter(EmptyUtil::isNoEmpty).count();
            payUnMatchAmtCnt += payUnMatchAmtSize;
            payUnMatchAmtSum = payUnMatchAmtSum.add(payUnMatchAmtMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            Map<String, BigDecimal> recFiltedData = recUnMatchAmtMap.entrySet().stream().filter(entry -> ((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, BigDecimal> payFiltedData = payUnMatchAmtMap.entrySet().stream().filter(entry -> ((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            long exsitRecAndPayAmt = recFiltedData.keySet().stream().filter(v -> payFiltedData.containsKey(v)).count();
            if (!isExsitRecAndPayAmt) {
                isExsitRecAndPayAmt = exsitRecAndPayAmt > 0L;
            }
            allSelectBills.put(bizBillListKey, bizBills);
        }
        boolean bl = bizBillSameExsit = recUnMatchAmtCnt > 0 && payUnMatchAmtCnt > 0;
        if (!transDetailSameExsit && !bizBillSameExsit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u5dee\u989d\u5339\u914d\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u540c\u65f6\u5b58\u5728\u6536\u6b3e\u6d41\u6c34\u4ee5\u53ca\u4ed8\u6b3e\u6d41\u6c34 \u6216\u4fdd\u8bc1 \u4e1a\u52a1\u5355\u636e\u4e2d\u540c\u65f6\u5b58\u5728\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u4ee5\u53ca\u672a\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"ManualMatchPlugin_35", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (isExsitRecAndPayAmt) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("cas_differmatch");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("transdetails", (Object)SerializationUtils.serializeToBase64((Object)transDetails));
            fsp.setCustomParam("bizBills", (Object)SerializationUtils.serializeToBase64(allSelectBills));
            boolean autoConfirm = (Boolean)this.getModel().getValue("matchautoconfirm");
            fsp.setCustomParam("autoConfirm", (Object)autoConfirm);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "differMatchConfirm");
            fsp.setCloseCallBack(callBack);
            this.getView().showForm(fsp);
            return false;
        }
        if (creditAmtSum.subtract(debitAmtSum).compareTo(recUnMatchAmtSum.subtract(payUnMatchAmtSum)) != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u4ea4\u6613\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1-\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1=\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5408\u8ba1-\u672a\u5339\u914d\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u3002", (String)"ManualMatchPlugin_36", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        this.differAmtConfirmToAcct(transDetails, allSelectBills, operate);
        return false;
    }

    private boolean routineMatch(AbstractOperate operate) {
        List<ManualMatchCheck> checkInfoList = this.matchValidate(operate.getOperateKey());
        if (checkInfoList.stream().anyMatch(ManualMatchCheck::isCheckFail)) {
            return true;
        }
        BigDecimal transDetailAmtSum = checkInfoList.get(0).getTransDetailAmtSum();
        List idToUnMatchAmtList = checkInfoList.stream().map(ManualMatchCheck::getIdToUnMatchAmtMap).collect(Collectors.toList());
        BigDecimal unMatchBizAmtSum = BigDecimal.ZERO;
        for (Map idToUnMatchAmtMap : idToUnMatchAmtList) {
            for (Map.Entry entry : idToUnMatchAmtMap.entrySet()) {
                unMatchBizAmtSum = unMatchBizAmtSum.add((BigDecimal)entry.getValue());
            }
        }
        if (transDetailAmtSum.compareTo(BigDecimal.ZERO) > 0 && unMatchBizAmtSum.compareTo(BigDecimal.ZERO) < 0 || transDetailAmtSum.compareTo(BigDecimal.ZERO) < 0 && unMatchBizAmtSum.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u5e38\u89c4\u5339\u914d\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u5355\u636e\u672a\u5339\u914d\u91d1\u989d\u5408\u8ba1\u4e0e\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u91d1\u989d\u5408\u8ba1\u6b63\u8d1f\u6570\u65b9\u5411\u4e00\u81f4\u3002\r\n\u793a\u4f8b\uff1a\u5982\u679c\u9009\u62e9\u6536\u6b3e\u6d41\u6c34\u91d1\u989d\u5408\u8ba1\u4e3a\u6b63\u6570\uff0c\u90a3\u4e48\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e5f\u5fc5\u987b\u662f\u6b63\u6570\u3002", (String)"ManualMatchPlugin_39", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        double transDetailAmtSumAbs = Math.abs(transDetailAmtSum.doubleValue());
        double unMatchBizAmtSumAbs = Math.abs(unMatchBizAmtSum.doubleValue());
        if (checkInfoList.size() > 1 && unMatchBizAmtSumAbs != transDetailAmtSumAbs) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u8de8\u5355\u636e\u5339\u914d\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u4e00\u6b21\u6027\u5168\u989d\u5339\u914d\u5b8c\u6bd5\uff0c\u4e0d\u652f\u6301\u90e8\u5206\u5339\u914d\u3002", (String)"ManualMatchPlugin_42", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (unMatchBizAmtSumAbs < transDetailAmtSumAbs) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u5e38\u89c4\u5339\u914d\u65f6\uff0c\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u5408\u8ba1\u91d1\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u5c0f\u4e8e\u4ea4\u6613\u660e\u7ec6\u91d1\u989d\u5408\u8ba1\u7edd\u5bf9\u503c\u3002", (String)"ManualMatchPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        String bizBillListKey = checkInfoList.get(0).getBizBillListKey();
        boolean recFlag = checkInfoList.get(0).isRecFlag();
        DynamicObjectCollection transDetails = checkInfoList.get(0).getTransDetails();
        if (unMatchBizAmtSumAbs > transDetailAmtSumAbs) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("cas_partamtallotconfirm");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("transDetailType", (Object)recFlag);
            Set transDetailIdSet = transDetails.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            fsp.setCustomParam("transDetailId", transDetailIdSet);
            Set bizBillIdSet = checkInfoList.get(0).getIdToUnMatchAmtMap().keySet();
            fsp.setCustomParam("bizBillId", bizBillIdSet);
            fsp.setCustomParam("bizBillKey", (Object)bizBillListKey);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "partAmtAllotConfirm");
            fsp.setCloseCallBack(callBack);
            this.getView().showForm(fsp);
            return false;
        }
        checkInfoList.forEach(v -> v.setReceredWay(ReceredWayEnum.HANDMATCH.getValue()));
        this.equalAmtMatch(checkInfoList, operate, ReceredWayEnum.HANDMATCH.getValue());
        return false;
    }

    private boolean reverseMatch(AbstractOperate operate) {
        double unMatchBizAmtSumAbs;
        List<ManualMatchCheck> checkInfoList = this.matchValidate(operate.getOperateKey());
        if (checkInfoList.get(0).isCheckFail()) {
            return checkInfoList.get(0).isCheckFail();
        }
        BigDecimal transDetailAmtSum = checkInfoList.get(0).getTransDetailAmtSum();
        Map idToUnMatchAmtMap = checkInfoList.get(0).getIdToUnMatchAmtMap();
        BigDecimal unMatchBizAmtSum = idToUnMatchAmtMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        double transDetailAmtSumAbs = Math.abs(transDetailAmtSum.doubleValue());
        if (transDetailAmtSumAbs != (unMatchBizAmtSumAbs = Math.abs(unMatchBizAmtSum.doubleValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u53cd\u5411\u5339\u914d\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u91d1\u989d\u4e0e\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u91d1\u989d\u7edd\u5bf9\u503c\u76f8\u7b49\u3002", (String)"ManualMatchPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        checkInfoList.forEach(v -> v.setReceredWay(ReceredWayEnum.REVERSEMATCH.getValue()));
        this.equalAmtMatch(checkInfoList, operate, ReceredWayEnum.REVERSEMATCH.getValue());
        return false;
    }

    private void equalAmtMatch(List<ManualMatchCheck> checkInfoList, AbstractOperate operate, String receredWay) {
        List<Object> paramList = new ArrayList(10);
        ArrayList<Map<String, Object>> bizBills = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> bizBillListKeys = new ArrayList<String>(checkInfoList.size());
        boolean recFlag = false;
        DynamicObjectCollection transDetails = new DynamicObjectCollection();
        String direction = "pay";
        for (ManualMatchCheck checkInfo : checkInfoList) {
            DynamicObjectCollection bizBill = checkInfo.getBizBills();
            String bizBillListKey = checkInfo.getBizBillListKey();
            bizBillListKeys.add(bizBillListKey);
            Map idToUnMatchAmtMap = checkInfo.getIdToUnMatchAmtMap();
            recFlag = checkInfo.isRecFlag();
            boolean entrySelected = checkInfo.isEntrySelected();
            List<Map<String, Object>> dynObjList = ManualMatchPlugin.bizBillToSameDynObj(bizBill, bizBillListKey, idToUnMatchAmtMap, recFlag, entrySelected);
            bizBills.addAll(dynObjList);
            transDetails = checkInfo.getTransDetails();
            direction = checkInfo.getDirection();
        }
        paramList = this.equalAmtConfirmToAcct(recFlag, (DynamicObject[])transDetails.toArray((Object[])new DynamicObject[0]), bizBills, receredWay, direction);
        Set autoRecPayBizBillIdSet = null;
        if (((Boolean)this.getModel().getValue("matchautoconfirm")).booleanValue()) {
            autoRecPayBizBillIdSet = bizBills.stream().map(b -> b.get("billid")).collect(Collectors.toSet());
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{paramList, receredWay, null, true, autoRecPayBizBillIdSet});
        CasFlowConfirmLogHelper.saveMatchLog(paramList, (String)receredWay);
        operate.getOption().setVariableValue("refreshBizList", JSON.toJSONString(bizBillListKeys));
    }

    private List<AutoMatchInfoParam> equalAmtConfirmToAcct(boolean recFlag, DynamicObject[] details, List<Map<String, Object>> bizBills, String receredWay, String direction) {
        Set CheckCollect = bizBills.stream().map(o -> String.join((CharSequence)",", o.get("billid").toString(), o.get("billentryid") != null ? o.get("billentryid").toString() : null, (String)o.get("tracetype"))).collect(Collectors.toSet());
        String thisOpnumber = DB.genGlobalLongId() + "";
        boolean reverse = ReceredWayEnum.REVERSEMATCH.getValue().equals(receredWay);
        String tDataEntityType = reverse ? (recFlag ? "bei_intelpay" : "bei_intelrec") : (recFlag ? "bei_intelrec" : "bei_intelpay");
        AtomicBoolean reverseAmtDirect = new AtomicBoolean(true);
        ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(details.length * CheckCollect.size());
        if (details.length > 1 || reverse) {
            if (CheckCollect.size() > 1 || reverse) {
                String amountProp = reverse ? (recFlag ? "debitamount" : "creditamount") : (recFlag ? "creditamount" : "debitamount");
                Map<String, BigDecimal> detailAmtMap = Arrays.stream(details).collect(Collectors.toMap(d -> d.getString("id"), d -> {
                    BigDecimal tmpAmt = d.getBigDecimal(amountProp);
                    if (reverse && tmpAmt.compareTo(BigDecimal.ZERO) < 0) {
                        tmpAmt = BigDecimal.ZERO.subtract(tmpAmt);
                    }
                    return tmpAmt;
                }));
                Map<String, BigDecimal> bizBillAmtMap = bizBills.stream().collect(Collectors.toMap(b -> String.join((CharSequence)",", b.get("billid").toString(), b.get("billentryid") != null ? b.get("billentryid").toString() : null), b -> {
                    BigDecimal tmpAmt = (BigDecimal)b.get("matchamount");
                    if (reverse && tmpAmt.compareTo(BigDecimal.ZERO) < 0) {
                        tmpAmt = BigDecimal.ZERO.subtract(tmpAmt);
                        if (reverseAmtDirect.get()) {
                            reverseAmtDirect.set(false);
                        }
                    }
                    return tmpAmt;
                }));
                Map<String, BigDecimal> idToRecMatchAmt = PartAmtAllotPlugin.getRecMatchAmtMap(detailAmtMap, bizBillAmtMap);
                for (Map<String, Object> bizBill : bizBills) {
                    for (DynamicObject detail2 : details) {
                        String idStr = String.join((CharSequence)",", detail2.getString("id"), bizBill.get("billid").toString(), bizBill.get("billentryid") != null ? bizBill.get("billentryid").toString() : null);
                        BigDecimal matchAmount = idToRecMatchAmt.get(idStr);
                        if (reverse && !reverseAmtDirect.get()) {
                            matchAmount = BigDecimal.ZERO.subtract(matchAmount);
                        }
                        if (BigDecimal.ZERO.compareTo(matchAmount) == 0) continue;
                        tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, detail2.getString("billno"), Long.valueOf(detail2.getLong("id")), (String)bizBill.get("billtype"), (String)bizBill.get("billno"), (Long)bizBill.get("billid"), (Long)bizBill.get("billentryid"), Long.valueOf(detail2.getLong("currency")), (String)bizBill.get("tracetype"), matchAmount, detail2.getString("bankcheckflag"), detail2.getDate("bizdate"), thisOpnumber, direction));
                    }
                }
            } else if (CheckCollect.size() == 1 && bizBills.get(0).get("billno") != null) {
                String billtype = (String)bizBills.get(0).get("billtype");
                String billno = (String)bizBills.get(0).get("billno");
                Long billid = (Long)bizBills.get(0).get("billid");
                Long billEntryId = (Long)bizBills.get(0).get("billentryid");
                String tracetype = (String)bizBills.get(0).get("tracetype");
                Date traceDate = Arrays.stream(details).map(o -> o.getDate("bizdate")).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
                String amountProp = recFlag ? "creditamount" : "debitamount";
                Arrays.stream(details).forEach(detail -> tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, detail.getString("billno"), Long.valueOf(detail.getLong("id")), billtype, billno, billid, billEntryId, Long.valueOf(detail.getLong("currency")), tracetype, detail.getBigDecimal(amountProp), detail.getString("bankcheckflag"), traceDate, thisOpnumber, direction)));
            }
        } else {
            List<Map> entryEntityList = bizBills.stream().filter(dynObj -> {
                String billtype = (String)dynObj.get("billtype");
                if (billtype == null || billtype.length() < 1) {
                    return false;
                }
                if ((Long)dynObj.get("billid") <= 0L) {
                    return false;
                }
                return BigDecimal.ZERO.compareTo((BigDecimal)dynObj.get("matchamount")) != 0;
            }).collect(Collectors.toList());
            String bankcheckflag = details[0].getString("bankcheckflag");
            Date traceDate = details[0].getDate("bizdate");
            entryEntityList.forEach(entryEntity -> tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, details[0].getString("billno"), Long.valueOf(details[0].getLong("id")), (String)entryEntity.get("billtype"), (String)entryEntity.get("billno"), (Long)entryEntity.get("billid"), (Long)entryEntity.get("billentryid"), Long.valueOf(details[0].getLong("currency")), (String)entryEntity.get("tracetype"), (BigDecimal)entryEntity.get("matchamount"), bankcheckflag, traceDate, thisOpnumber, direction)));
        }
        return tAutoMatchInfoList;
    }

    private void differAmtConfirmToAcct(DynamicObjectCollection transDetails, Map<String, DynamicObjectCollection> allSelectBills, AbstractOperate operate) {
        ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(transDetails.size() * allSelectBills.size());
        ArrayList<String> bizBIllKeyList = new ArrayList<String>(10);
        String thisOpnumber = DB.genGlobalLongId() + "";
        HashSet autoRecPayBizBillIdSet = new HashSet(16);
        boolean autoConfirm = (Boolean)this.getModel().getValue("matchautoconfirm");
        for (DynamicObject transDetail : transDetails) {
            String differMatchEntityType = EmptyUtil.isNoEmpty((BigDecimal)transDetail.getBigDecimal("creditamount")) ? "bei_intelrec" : "bei_intelpay";
            for (Map.Entry<String, DynamicObjectCollection> entry : allSelectBills.entrySet()) {
                String bizBillListKey = entry.getKey();
                bizBIllKeyList.add(bizBillListKey);
                DynamicObjectCollection bizBills = entry.getValue();
                if (autoConfirm) {
                    autoRecPayBizBillIdSet.addAll(bizBills.stream().map(v -> v.get("id")).collect(Collectors.toSet()));
                }
                String unMatchAmtField = (String)((List)matchFieldMap.get(bizBillListKey).getLeft()).get(0);
                BillList bizBillList = (BillList)this.getControl(bizBillListKey);
                ListSelectedRowCollection bizBillSelectedRows = bizBillList.getSelectedRows();
                Object[] entryPKValues = bizBillSelectedRows.getEntryPrimaryKeyValues();
                boolean entrySelected = entryPKValues[0] != null;
                Map recUnMatchAmtMap = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillListKey, (boolean)true, (String)unMatchAmtField, (boolean)entrySelected);
                Map payUnMatchAmtMap = ManualMatchHelper.getUnMatchAmtMap((DynamicObjectCollection)bizBills, (String)bizBillListKey, (boolean)false, (String)unMatchAmtField, (boolean)entrySelected);
                for (DynamicObject bizBill : bizBills) {
                    String bizBillType = bizBillListKey.substring(5);
                    long entryId = 0L;
                    if ("list_cas_agentpaybill".equals(bizBillListKey) || "list_fca_transupbill".equals(bizBillListKey) || "list_fca_transdownbill".equals(bizBillListKey)) {
                        String entryIdField = "list_cas_agentpaybill".equals(bizBillListKey) ? "entry.id" : "entrys.id";
                        entryId = bizBill.getLong(entryIdField);
                    }
                    String traceType = "";
                    BigDecimal recUnMatchAmt = (BigDecimal)recUnMatchAmtMap.get(bizBill.getString("id"));
                    BigDecimal payUnMatchAmt = (BigDecimal)payUnMatchAmtMap.get(bizBill.getString("id"));
                    String tDataEntityType = "bei_intelpay";
                    if (Arrays.asList("list_cas_paybill", "list_ifm_transhandlebill", "list_cas_agentpaybill", "list_fca_transdownbill").contains(bizBillListKey)) {
                        tDataEntityType = "bei_intelpay";
                    } else if (Arrays.asList("list_cas_recbill", "list_fca_transupbill").contains(bizBillListKey)) {
                        tDataEntityType = "bei_intelrec";
                    }
                    if ("list_cas_exchangebill".equals(bizBillListKey)) {
                        traceType = EmptyUtil.isNoEmpty((BigDecimal)recUnMatchAmt) ? "buy" : "sell";
                    }
                    BigDecimal amount = EmptyUtil.isNoEmpty((BigDecimal)recUnMatchAmt) ? recUnMatchAmt : payUnMatchAmt;
                    AutoMatchInfoParam autoMatchInfoParam = new AutoMatchInfoParam(tDataEntityType, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), bizBillType, (String)bizBill.get("billno"), Long.valueOf(bizBill.getLong("id")), Long.valueOf(entryId), Long.valueOf(transDetail.getLong("currency")), traceType, amount, transDetail.getString("bankcheckflag"), transDetail.getDate("bizdate"), thisOpnumber, "");
                    autoMatchInfoParam.setDifferMatchSourceEntity(differMatchEntityType);
                    tAutoMatchInfoList.add(autoMatchInfoParam);
                }
            }
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.DIFFERMATCH.getValue(), null, true, autoRecPayBizBillIdSet});
        CasFlowConfirmLogHelper.saveDifferMatchLog(tAutoMatchInfoList);
        operate.getOption().setVariableValue("refreshBizList", JSON.toJSONString(bizBIllKeyList));
    }

    public static List<Map<String, Object>> bizBillToSameDynObj(DynamicObjectCollection bizBills, String listKey, Map<String, BigDecimal> idToUnMatchAmtMap, boolean recFlag, boolean entrySelected) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(bizBills.size());
        for (DynamicObject bizBill : bizBills) {
            HashMap<String, Object> dynObj = new HashMap<String, Object>();
            Long id = bizBill.getLong("id");
            dynObj.put("billid", id);
            dynObj.put("billno", bizBill.getString("billno"));
            dynObj.put("billtype", listKey.substring(5));
            String idStr = id.toString();
            if ("list_cas_agentpaybill".equals(listKey) || "list_fca_transupbill".equals(listKey) || "list_fca_transdownbill".equals(listKey)) {
                if (entrySelected) {
                    String entryIdField = "list_cas_agentpaybill".equals(listKey) ? "entry.id" : "entrys.id";
                    Long entryId = bizBill.getLong(entryIdField);
                    dynObj.put("billentryid", entryId);
                    idStr = idStr + "," + entryId;
                }
            } else if ("list_cas_exchangebill".equals(listKey)) {
                String traceType = recFlag ? "buy" : "sell";
                dynObj.put("tracetype", traceType);
            }
            if (idToUnMatchAmtMap != null) {
                BigDecimal matchAmt = idToUnMatchAmtMap.get(idStr);
                dynObj.put("matchamount", matchAmt);
            }
            resultList.add(dynObj);
        }
        return resultList;
    }

    private ManualMatchCheck selectValidate() {
        ManualMatchCheck selectCheck = new ManualMatchCheck(false);
        BillList detailList = (BillList)this.getControl("list_bei_transdetail_cas");
        ListSelectedRowCollection detailSelectedRows = detailList.getSelectedRows();
        if (detailSelectedRows == null || detailSelectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u4e24\u4e2a\u5217\u8868\u4e2d\u5206\u522b\u9009\u62e9\u9700\u8981\u5339\u914d\u7684\u6570\u636e\u3002", (String)"ManualMatchPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            selectCheck.setCheckFail(true);
            return selectCheck;
        }
        Map<String, Integer> bizBillIdMap = this.getBizBillSelectedCountMap();
        int bizBillSizeSum = bizBillIdMap.values().stream().reduce(Integer::sum).orElse(0);
        if (bizBillSizeSum == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u4e24\u4e2a\u5217\u8868\u4e2d\u5206\u522b\u9009\u62e9\u9700\u8981\u5339\u914d\u7684\u6570\u636e\u3002", (String)"ManualMatchPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            selectCheck.setCheckFail(true);
            return selectCheck;
        }
        selectCheck.setBizBillIdMap(bizBillIdMap);
        selectCheck.setDetailSelectedRows(detailSelectedRows);
        return selectCheck;
    }

    private List<ManualMatchCheck> matchValidate(String opKey) {
        ManualMatchCheck selectCheck = this.selectValidate();
        if (selectCheck.isCheckFail()) {
            return Collections.singletonList(selectCheck);
        }
        Map bizBillIdMap = selectCheck.getBizBillIdMap();
        ArrayList<ManualMatchCheck> checkInfoList = new ArrayList<ManualMatchCheck>(bizBillIdMap.size());
        ListSelectedRowCollection detailSelectedRows = selectCheck.getDetailSelectedRows();
        for (Map.Entry bizBillIdEntry : bizBillIdMap.entrySet()) {
            boolean detailBizBillAcctCnyDiff;
            Set<String> bizBill;
            ManualMatchCheck checkInfo = new ManualMatchCheck(true);
            checkInfoList.add(checkInfo);
            String bizBillListKey = (String)bizBillIdEntry.getKey();
            BillList bizBillList = (BillList)this.getControl(bizBillListKey);
            ListSelectedRowCollection bizBillSelectedRows = bizBillList.getSelectedRows();
            checkInfo.setBizBillListKey(bizBillListKey);
            Set billTypeSet = null;
            if (bizBillIdMap.size() == 1 && bizBillIdMap.containsKey("list_cas_paybill") && (Integer)bizBillIdMap.get("list_cas_paybill") > 1) {
                DynamicObjectCollection payBillList = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bizBillSelectedRows.getPrimaryKeyValues())});
                billTypeSet = payBillList.stream().map(o -> o.getLong("billtype")).collect(Collectors.toSet());
            }
            ArrayList<String> tipsList = new ArrayList<String>(5);
            if ("routinematch".equals(opKey)) {
                tipsList.add(ResManager.loadKDString((String)"\u5e38\u89c4\u5339\u914d", (String)"ManualMatchPlugin_17", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                tipsList.add(ResManager.loadKDString((String)"\u65b9\u5411\u4e00\u81f4", (String)"ManualMatchPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                tipsList.add(ResManager.loadKDString((String)"\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d", (String)"ManualMatchPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if ("reversematch".equals(opKey)) {
                tipsList.add(ResManager.loadKDString((String)"\u53cd\u5411\u5339\u914d", (String)"ManualMatchPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                tipsList.add(ResManager.loadKDString((String)"\u65b9\u5411\u76f8\u53cd", (String)"ManualMatchPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                tipsList.add(ResManager.loadKDString((String)"\u672a\u5339\u914d\u4ed8\u6b3e\u91d1\u989d", (String)"ManualMatchPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if ("reversematch".equals(opKey) && (bizBillIdMap.size() > 1 || billTypeSet != null && billTypeSet.size() > 1)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002%1$s\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4e1a\u52a1\u5355\u636e\u5747\u5c5e\u4e8e\u540c\u4e00\u5355\u636e\u7c7b\u578b\u3002\r\n\u793a\u4f8b\uff1a\u6240\u9009\u5355\u636e\u5168\u90e8\u90fd\u662f\u6536\u6b3e\u5355\u6216\u8005\u5168\u90e8\u90fd\u662f\u540c\u540d\u8f6c\u8d26\u5355\u3002", (String)"ManualMatchPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                return checkInfoList;
            }
            List transDetailIdList = detailSelectedRows.stream().map(r -> (Long)r.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,billno,bizdate,currency,accountbank,bankcheckflag,creditamount,debitamount", (QFilter[])new QFilter[]{new QFilter("id", "in", transDetailIdList)});
            ArrayList unMatchDetailAmtList = new ArrayList(transDetails.size());
            Set acctBankCurrencySet = transDetails.stream().map(o -> {
                String type = null;
                BigDecimal creditAmount = o.getBigDecimal("creditamount");
                BigDecimal debitAmount = o.getBigDecimal("debitamount");
                if (creditAmount != null && creditAmount.compareTo(BigDecimal.ZERO) != 0) {
                    type = "r";
                    unMatchDetailAmtList.add(creditAmount);
                } else if (debitAmount != null && debitAmount.compareTo(BigDecimal.ZERO) != 0) {
                    type = "p";
                    unMatchDetailAmtList.add(debitAmount);
                }
                return String.join((CharSequence)"#", type, o.get("accountbank").toString(), o.get("currency").toString());
            }).collect(Collectors.toSet());
            if (acctBankCurrencySet.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002%1$s\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u7684\u94f6\u884c\u8d26\u6237\u76f8\u540c\u3001\u5e01\u79cd\u76f8\u540c\u3001\u65b9\u5411\u552f\u4e00\uff0c\u8981\u4e48\u5168\u90e8\u662f\u6536\u6b3e\u6d41\u6c34\uff0c\u8981\u4e48\u5168\u90e8\u662f\u4ed8\u6b3e\u6d41\u6c34\u3002", (String)"ManualMatchPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                return checkInfoList;
            }
            String acctBankCurrencyStr = acctBankCurrencySet.toArray()[0].toString();
            String[] acctBankCurrencyArr = acctBankCurrencyStr.split("#");
            String detailDirect = acctBankCurrencyArr[0];
            String detailBank = acctBankCurrencyArr[1];
            String detailCurrency = acctBankCurrencyArr[2];
            Boolean recFlag = false;
            Set<Object> detailAmtDirectSet = new HashSet(2);
            if ("routinematch".equals(opKey)) {
                recFlag = "r".equals(detailDirect);
            } else if ("reversematch".equals(opKey)) {
                detailAmtDirectSet = unMatchDetailAmtList.stream().map(a -> a.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toSet());
                if (detailAmtDirectSet.size() > 1) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u53cd\u5411\u5339\u914d\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u6b63\u8d1f\u6570\u552f\u4e00\uff0c\u8981\u4e48\u5168\u90e8\u662f\u6b63\u6570\uff0c\u8981\u4e48\u5168\u90e8\u662f\u8d1f\u6570\u3002", (String)"ManualMatchPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                    return checkInfoList;
                }
                recFlag = "p".equals(detailDirect);
            }
            Set<String> set = bizBill = recFlag != false ? REC_FLOW_DIRECTION_SAME : PAY_FLOW_DIRECTION_SAME;
            if (bizBill != null && !bizBill.contains(bizBillListKey)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002%1$s\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4e1a\u52a1\u5355\u636e\u4e0e\u4ea4\u6613\u660e\u7ec6%2$s\u3002\r\n\u793a\u4f8b\uff1a\u5982\u679c\u9009\u62e9\u6536\u6b3e\u6d41\u6c34\u8fdb\u884c%1$s\uff0c\u90a3\u4e48\u53ea\u6709%3$s\u22600 \u7684\u4e1a\u52a1\u5355\u636e\u624d\u80fd\u53c2\u4e0e\u5339\u914d\u3002", (String)"ManualMatchPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0), tipsList.get(1), tipsList.get(2)));
                return checkInfoList;
            }
            Object[] entryPKValues = bizBillSelectedRows.getEntryPrimaryKeyValues();
            boolean entrySelected = entryPKValues.length > 0 && entryPKValues[0] != null;
            String unMatchAmtField = (String)((List)matchFieldMap.get(bizBillListKey).getLeft()).get(0);
            DynamicObjectCollection bizBills = this.getBizBillSelectedData(bizBillListKey, null);
            Boolean finalRecFlag = recFlag;
            Set bizBillAcctCurrency = bizBills.stream().map(b -> {
                String acctField = billListFieldMap.get(bizBillListKey).get(1);
                String currencyField = billListFieldMap.get(bizBillListKey).get(2);
                if ("list_cas_exchangebill".equals(bizBillListKey)) {
                    acctField = finalRecFlag != false ? "buyingaccount" : "sellingaccount";
                    currencyField = finalRecFlag != false ? "buyingcurrency" : "sellingcurrency";
                }
                return String.join((CharSequence)"#", b.get(acctField).toString(), b.get(currencyField).toString());
            }).collect(Collectors.toSet());
            if (bizBillAcctCurrency.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002%1$s\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4e1a\u52a1\u5355\u636e\u7684\u94f6\u884c\u8d26\u6237\u76f8\u540c\u3001\u5e01\u79cd\u76f8\u540c\u3002", (String)"ManualMatchPlugin_29", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                return checkInfoList;
            }
            String bizBillAcctCurrencyStr = bizBillAcctCurrency.toArray()[0].toString();
            String[] bizBillAcctCurrencyArr = bizBillAcctCurrencyStr.split("#");
            if (bizBillListKey.equals("list_cas_paybill") && recFlag.booleanValue() || bizBillListKey.equals("list_cas_recbill") && !recFlag.booleanValue()) {
                Long acctBankId = ((DynamicObject)transDetails.get(0)).getLong("accountbank");
                Iterator acctBank = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acctBankId)});
                String bankAcctNumber = acctBank.getString("bankaccountnumber");
                String oppBankAcctNumberPro = recFlag != false ? "payeebanknum" : "payeracctbanknum";
                detailBizBillAcctCnyDiff = bizBills.stream().anyMatch(p -> !p.getBoolean("relateotherflow") || !bankAcctNumber.equals(p.getString(oppBankAcctNumberPro)) || !detailCurrency.equals(bizBillAcctCurrencyArr[1]));
            } else {
                boolean bl = detailBizBillAcctCnyDiff = !detailBank.equals(bizBillAcctCurrencyArr[0]) || !detailCurrency.equals(bizBillAcctCurrencyArr[1]);
            }
            if (detailBizBillAcctCnyDiff) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002%1$s\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u7684\u94f6\u884c\u8d26\u6237\u76f8\u540c\u3001\u5e01\u79cd\u76f8\u540c\u3002", (String)"ManualMatchPlugin_30", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                return checkInfoList;
            }
            List<String> errMsg = null;
            for (DynamicObject dynObj : bizBills) {
                errMsg = this.checkSelectBill(bizBillList.getEntityId(), dynObj, entrySelected);
            }
            if (errMsg != null && errMsg.size() > 0) {
                this.getView().showErrorNotification((String)errMsg.stream().distinct().reduce((s1, s2) -> String.join((CharSequence)"\n", s1, s2)).get());
                return checkInfoList;
            }
            Map<String, BigDecimal> idToUnMatchAmtMap = this.getUnMatchBizAmtList(bizBills, bizBillListKey, recFlag, unMatchAmtField, entrySelected, checkInfo);
            boolean haveZeroAmt = idToUnMatchAmtMap.values().stream().anyMatch(amt -> amt.compareTo(BigDecimal.ZERO) == 0);
            if (haveZeroAmt) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002%1$s\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4e1a\u52a1\u5355\u636e\u4e0e\u4ea4\u6613\u660e\u7ec6%2$s\u3002\r\n\u793a\u4f8b\uff1a\u5982\u679c\u9009\u62e9\u6536\u6b3e\u6d41\u6c34\u8fdb\u884c%1$s\uff0c\u90a3\u4e48\u53ea\u6709%3$s\u22600 \u7684\u4e1a\u52a1\u5355\u636e\u624d\u80fd\u53c2\u4e0e\u5339\u914d\u3002", (String)"ManualMatchPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0), tipsList.get(1), tipsList.get(2)));
                return checkInfoList;
            }
            if ("reversematch".equals(opKey)) {
                Set<Boolean> unMatchAmtDirectSet = idToUnMatchAmtMap.values().stream().map(a -> a.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toSet());
                if (unMatchAmtDirectSet.size() > 1) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u3002\u53cd\u5411\u5339\u914d\u65f6\uff0c\u8bf7\u4fdd\u8bc1\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u91d1\u989d\u6b63\u8d1f\u6570\u552f\u4e00\u3002\u793a\u4f8b\uff1a\u5982\u679c\u4ea4\u6613\u660e\u7ec6\u4ed8\u6b3e\u91d1\u989d= -100\uff0c\u90a3\u4e48\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5168\u90e8\u662f\u6b63\u6570\uff1b\u53cd\u4e4b\uff0c\u5982\u679c\u4ea4\u6613\u660e\u7ec6\u4ed8\u6b3e\u91d1\u989d=100\uff0c\u90a3\u4e48\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5168\u90e8\u662f\u8d1f\u6570\u3002", (String)"ManualMatchPlugin_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                    return checkInfoList;
                }
                Boolean detailAmtDirect = detailAmtDirectSet.toArray(new Boolean[0])[0];
                Boolean unMatchAmtDirect = unMatchAmtDirectSet.toArray(new Boolean[0])[0];
                if (detailAmtDirect.booleanValue() && unMatchAmtDirect.booleanValue() || !detailAmtDirect.booleanValue() && !unMatchAmtDirect.booleanValue()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u4e0e\u4e1a\u52a1\u5355\u636e\u4e0d\u6ee1\u8db3\u53cd\u5411\u5339\u914d\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\r\n\u793a\u4f8b\uff1a\u4ea4\u6613\u660e\u7ec6\u4ed8\u6b3e\u91d1\u989d= -100\uff0c\u90a3\u4e48\u4e0e\u4e4b\u53cd\u5411\u5339\u914d\u7684\u5355\u636e\u7684\u672a\u5339\u914d\u6536\u6b3e\u91d1\u989d=100\u3002", (String)"ManualMatchPlugin_38", (String)"fi-cas-formplugin", (Object[])new Object[0]), tipsList.get(0)));
                    return checkInfoList;
                }
            }
            checkInfo.setIdToUnMatchAmtMap(idToUnMatchAmtMap);
            checkInfo.setRecFlag(recFlag.booleanValue());
            BigDecimal transDetailAmtSum = unMatchDetailAmtList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            checkInfo.setTransDetailAmtSum(transDetailAmtSum);
            if ("list_cas_agentpaybill".equals(bizBillListKey) && !entrySelected) {
                ArrayList<DynamicObject> reDynObj = new ArrayList<DynamicObject>(5);
                HashSet<Long> idSet = new HashSet<Long>(5);
                for (DynamicObject agentBill : bizBills) {
                    long agentId = agentBill.getLong("id");
                    if (idSet.contains(agentId)) {
                        reDynObj.add(agentBill);
                        continue;
                    }
                    idSet.add(agentId);
                }
                bizBills.removeAll(reDynObj);
            }
            checkInfo.setBizBills(bizBills);
            checkInfo.setTransDetails(transDetails);
            checkInfo.setEntrySelected(entrySelected);
            checkInfo.setCheckFail(false);
        }
        return checkInfoList;
    }

    private List<String> checkSelectBill(String billtype, DynamicObject busnessBill, boolean fieldInEntry) {
        ArrayList<String> errMsg = new ArrayList<String>(2);
        if ((SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) && busnessBill.getBoolean("ismatchbyhead") && fieldInEntry) {
            errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u5df2\u7ecf\u6309\u5934\u5339\u914d\uff0c\u4e0d\u652f\u6301\u6309\u5206\u5f55\u5339\u914d\u3002", (String)"ManualMatchPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
        }
        if (fieldInEntry && (SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) && !"normal".equals(busnessBill.getString("entrys.state"))) {
            errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u6240\u9009\u5206\u5f55\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u5206\u5f55\u72b6\u6001\u3002", (String)"ManualMatchPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
        }
        if (fieldInEntry && SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            if (busnessBill.getBoolean("isencryption")) {
                errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u6240\u9009\u5206\u5f55\u91d1\u989d\u52a0\u5bc6\uff0c\u4e0d\u652f\u6301\u6309\u5206\u5f55\u5339\u914d\u3002", (String)"ManualMatchPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
            }
            if (busnessBill.getBoolean("isdiffcur")) {
                errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u4e3a\u5f02\u5e01\u79cd\u4ed8\u6b3e\u5355\u636e\uff0c\u4e0d\u652f\u6301\u6309\u5206\u5f55\u5339\u914d\u3002", (String)"ManualMatchPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
            }
        }
        return errMsg;
    }

    private Map<String, Integer> getBizBillSelectedCountMap() {
        HashMap<String, Integer> bizBillCnt = new HashMap<String, Integer>(16);
        for (String listKey : matchFieldMap.keySet()) {
            BillList listBizBill = (BillList)this.getControl(listKey);
            int size = listBizBill.getSelectedRows().getPrimaryKeyValues().length;
            if (size <= 0) continue;
            bizBillCnt.put(listKey, size);
        }
        return bizBillCnt;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, BigDecimal> getUnMatchBizAmtList(DynamicObjectCollection bizBills, String bizBillListKey, boolean recFlag, String unMatchAmtField, boolean entrySelected, ManualMatchCheck checkInfo) {
        HashMap<String, BigDecimal> idToAmtMap = new HashMap<String, BigDecimal>(bizBills.size());
        String bizAmtFieldDir = null;
        for (DynamicObject bill : bizBills) {
            String bizAmtField;
            String id;
            block21: {
                block23: {
                    block22: {
                        id = bill.getString("id");
                        if (!"list_cas_paybill".equals(bizBillListKey)) break block22;
                        boolean relateOtherFlow = bill.getBoolean("relateotherflow");
                        if (!recFlag) {
                            bizAmtField = unMatchAmtField.split("#")[1];
                            break block21;
                        } else if (recFlag && relateOtherFlow) {
                            bizAmtField = unMatchAmtField.split("#")[0];
                            break block21;
                        } else {
                            idToAmtMap.put(id, BigDecimal.ZERO);
                            continue;
                        }
                    }
                    if (!"list_cas_recbill".equals(bizBillListKey)) break block23;
                    boolean relateOtherFlow = bill.getBoolean("relateotherflow");
                    if (recFlag) {
                        bizAmtField = unMatchAmtField.split("#")[0];
                        break block21;
                    } else if (!recFlag && relateOtherFlow) {
                        bizAmtField = unMatchAmtField.split("#")[1];
                        break block21;
                    } else {
                        idToAmtMap.put(id, BigDecimal.ZERO);
                        continue;
                    }
                }
                if ("list_cas_agentpaybill".equals(bizBillListKey)) {
                    String string = bizAmtField = entrySelected ? unMatchAmtField.split("#")[0] : unMatchAmtField.split("#")[1];
                    if (entrySelected) {
                        String entryId = bill.getString("entry.id");
                        id = id + "," + entryId;
                    }
                } else if ("list_fca_transupbill".equals(bizBillListKey) || "list_fca_transdownbill".equals(bizBillListKey)) {
                    bizAmtField = unMatchAmtField.split("#")[0];
                    String entryId = bill.getString("entrys.id");
                    id = id + "," + entryId;
                } else {
                    bizAmtField = "list_cas_exchangebill".equals(bizBillListKey) ? (recFlag ? unMatchAmtField.split("#")[0] : unMatchAmtField.split("#")[1]) : unMatchAmtField;
                }
            }
            bizAmtFieldDir = bizAmtField;
            BigDecimal unMatchAmt = bill.getBigDecimal(bizAmtField);
            idToAmtMap.put(id, unMatchAmt);
        }
        String direction = "";
        if ("list_cas_paybill".equals(bizBillListKey) || "list_cas_recbill".equals(bizBillListKey)) {
            direction = "unmatchamountrec".equals(bizAmtFieldDir) ? "rec" : "pay";
        } else if ("list_cas_exchangebill".equals(bizBillListKey)) {
            direction = "buyunmatchamount".equals(bizAmtFieldDir) ? "rec" : "pay";
        } else if ("list_cas_agentpaybill".equals(bizBillListKey) || "list_fca_transdownbill".equals(bizBillListKey) || "list_ifm_transhandlebill".equals(bizBillListKey)) {
            direction = "pay";
        } else if ("list_fca_transupbill".equals(bizBillListKey)) {
            direction = "rec";
        }
        checkInfo.setDirection(direction);
        return idToAmtMap;
    }

    private DynamicObjectCollection getBizBillSelectedData(String listKey, String dateField) {
        String queryField = (String)matchFieldMap.get(listKey).getRight();
        if (dateField != null) {
            queryField = queryField + "," + dateField;
        }
        String entityId = listKey.substring(5);
        BillList billList = (BillList)this.getControl(listKey);
        Object[] pkValues = billList.getSelectedRows().getPrimaryKeyValues();
        QFilter queryFilter = new QFilter("id", "in", (Object)pkValues);
        Object[] entryPkValues = billList.getSelectedRows().getEntryPrimaryKeyValues();
        if (entryPkValues.length > 0 && entryPkValues[0] != null) {
            String entryId = "entry.id";
            if ("list_fca_transupbill".equals(listKey) || "list_fca_transdownbill".equals(listKey)) {
                entryId = "entrys.id";
            }
            queryFilter.and(entryId, "in", (Object)entryPkValues);
        }
        return QueryServiceHelper.query((String)entityId, (String)queryField, (QFilter[])new QFilter[]{queryFilter});
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if ("partAmtAllotConfirm".equals(actionId) && StringUtils.isNotEmpty((String)((String)args.getReturnData()))) {
            String refreshBizList = (String)args.getReturnData();
            this.successCallBackRefresh(refreshBizList);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5339\u914d\uff08\u5e38\u89c4\u5339\u914d\uff09\u6210\u529f\u3002", (String)"ManualMatchPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
        } else if ("differMatchConfirm".equals(actionId) && EmptyUtil.isNoEmpty((Object)args.getReturnData())) {
            List refreshBizListStr = (List)args.getReturnData();
            this.successCallBackRefresh(refreshBizListStr.toArray(new String[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5339\u914d\uff08\u5dee\u989d\u5339\u914d\uff09\u6210\u529f\u3002", (String)"ManualMatchPlugin_37", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
        } else if ("automatch_callback".equals(actionId)) {
            BillList detailList = (BillList)this.getControl("list_bei_transdetail_cas");
            detailList.clearSelection();
            this.queryBillListByQFilter("list_bei_transdetail_cas", null, null);
            this.clearAllBizBillSelected();
            this.queryBizBillList();
        }
    }

    private void successCallBackRefresh(String ... bizListKey) {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String transDetailNoQuery = this.getPageCache().get(TRANS_DETAIL_NO_QUERY);
        QFilter detailAnd = null;
        if (StringUtils.isNotEmpty((String)transDetailNoQuery)) {
            List transDetailId = (List)JSON.parseObject((String)transDetailNoQuery, List.class);
            detailAnd = new QFilter("id", "in", (Object)transDetailId);
        }
        BillList detailList = (BillList)this.getControl("list_bei_transdetail_cas");
        detailList.clearSelection();
        this.queryBillListByQFilter("list_bei_transdetail_cas", detailAnd, null);
        String bizBillNoQuery = this.getPageCache().get(BIZ_BILL_NO_QUERY);
        Map bizIdMap = new HashMap(5);
        if (StringUtils.isNotEmpty((String)bizBillNoQuery)) {
            bizIdMap = (Map)JSON.parseObject((String)bizBillNoQuery, Map.class);
        }
        for (String listKey : bizListKey) {
            JSONArray idArr = (JSONArray)bizIdMap.get(listKey);
            QFilter bizAnd = null;
            if (idArr != null) {
                bizAnd = new QFilter("id", "in", (Object)idArr.toArray());
            }
            this.clearBizBillSelected(listKey);
            this.queryBillListByQFilter(listKey, bizAnd, null);
        }
        this.getModel().setValue("unmatchrecamtsum", (Object)"");
        this.getModel().setValue("unmatchpayamtsum", (Object)"");
        this.getView().getPageCache().remove(MULTIPLESELECTEDDETAIL);
        this.getView().getPageCache().remove(MULTIPLESELECTEDBIZBILL);
    }

    static {
        billListFieldMap.put("list_cas_paybill", Arrays.asList("org", "payeracctbank", "dpcurrency", "bizdate"));
        billListFieldMap.put("list_cas_recbill", Arrays.asList("org", "accountbank", "currency", "bizdate"));
        billListFieldMap.put("list_cas_agentpaybill", Arrays.asList("org", "payeracctbank", "dpcurrency", "bizdate"));
        billListFieldMap.put("list_fca_transupbill", Arrays.asList("company", "accountbank", "currency", "transbilldate"));
        billListFieldMap.put("list_fca_transdownbill", Arrays.asList("company", "accountbank", "currency", "transbilldate"));
        billListFieldMap.put("list_ifm_transhandlebill", Arrays.asList("org", "agentpayeraccount", "currency", "bizdate"));
        billListFieldMap.put("list_cas_exchangebill", Arrays.asList("org", "", "", "bizdate"));
        billListFieldMap.put("list_bei_transdetail_cas", Arrays.asList("company", "accountbank", "currency", "bizdate"));
        matchFieldMap.put("list_cas_paybill", (Pair<List<String>, String>)Pair.of(Arrays.asList("unmatchamountrec#unmatchamountpay", "payeename#recaccbankname", "payeebanknum"), (Object)"id, billno, dpcurrency, payeracctbank, billtype, unmatchamountrec, unmatchamountpay, payeename, recaccbankname, payeebanknum, relateotherflow, org.name, payeracctbank.bankaccountnumber"));
        matchFieldMap.put("list_cas_recbill", (Pair<List<String>, String>)Pair.of(Arrays.asList("unmatchamountrec#unmatchamountpay", "payername", "payeracctbanknum"), (Object)"id, billno, currency, accountbank, unmatchamountrec, unmatchamountpay, payername, payeracctbanknum, relateotherflow, org.name,accountbank.bankaccountnumber"));
        matchFieldMap.put("list_cas_agentpaybill", (Pair<List<String>, String>)Pair.of(Arrays.asList("entry.entryunmatchamount#unmatchamount", "entry.payeename#entry.payee", "entry.payeeacctbank"), (Object)"id, billno, dpcurrency, payeracctbank, ismatchbyhead, isdiffcur, entry.id, entry.seq, isencryption, entry.entryunmatchamount, unmatchamount, entry.payeename, entry.payee, entry.payeeacctbank"));
        matchFieldMap.put("list_fca_transupbill", (Pair<List<String>, String>)Pair.of(Arrays.asList("entrys.entryunmatchamount#unmatchamount", "entrys.subacct_company.name", "entrys.subacct.bankaccountnumber"), (Object)"id, billno, currency, accountbank, ismatchbyhead, entrys.id, entrys.seq, entrys.state, entrys.entryunmatchamount,unmatchamount, entrys.subacct_company.name, entrys.subacct.bankaccountnumber"));
        matchFieldMap.put("list_fca_transdownbill", (Pair<List<String>, String>)Pair.of(Arrays.asList("entrys.entryunmatchamount#unmatchamount", "entrys.subacct_company.name", "entrys.subacct.bankaccountnumber"), (Object)"id, billno, currency, accountbank, ismatchbyhead, entrys.id, entrys.seq, entrys.state, entrys.entryunmatchamount, unmatchamount, entrys.subacct_company.name, entrys.subacct.bankaccountnumber"));
        matchFieldMap.put("list_ifm_transhandlebill", (Pair<List<String>, String>)Pair.of(Arrays.asList("unmatchamountpay", "payeename#recaccbankname", "payeebanknum"), (Object)"id, billno, unmatchamountpay, payeename, recaccbankname, currency, payeracctbank, agentpayeraccount, payeebanknum"));
        matchFieldMap.put("list_cas_exchangebill", (Pair<List<String>, String>)Pair.of(Arrays.asList("buyunmatchamount#sellunmatchamount", "org.name", ""), (Object)"id, billno, buyingcurrency, sellingcurrency, buyingaccount,sellingaccount, buyunmatchamount, sellunmatchamount, org.name"));
    }
}

