/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.transferapply;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.TransferBatchEnum;
import kd.fi.cas.enums.TransferTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.util.EmptyUtil;

public class BatchFillInputEdit
extends AbstractFormPlugin {
    private JSONArray jsonArray = null;
    private IDataModel model = null;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setBatchFieldVisible(TransferBatchEnum.PAYORG.getValue());
    }

    public static void addF7Filter(IFormView view, String prop, ViewInputHelper.F7FilterBuilder builder) {
        BasedataEdit f7 = (BasedataEdit)view.getControl(prop);
        f7.addBeforeF7SelectListener(e -> {
            ListShowParameter sp = (ListShowParameter)e.getFormShowParameter();
            QFilter qFilter = builder.build(e);
            sp.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        IFormView view = this.getView().getParentView();
        this.model = view.getModel();
        String isSame = (String)this.model.getValue("transfertype");
        if (TransferTypeEnum.SAME_TRANSFER.getValue().equals(isSame)) {
            this.setBatchFieldVisible(true);
        } else {
            this.setBatchFieldVisible(false);
        }
        Map selected = this.getView().getFormShowParameter().getCustomParams();
        if (selected != null) {
            this.jsonArray = (JSONArray)selected.get("selected");
        }
        this.payOrg();
        QFilter payEeQFilter = new QFilter("fisbankroll", "=", (Object)"1");
        BatchFillInputEdit.addF7Filter(this.getView(), "e_payee", evt -> payEeQFilter);
        QFilter settlementTypeQf = new QFilter("settlementtype", "not in", Arrays.asList(SettleMentTypeEnum.MONEY.getValue(), SettleMentTypeEnum.VIRTUAL.getValue()));
        BatchFillInputEdit.addF7Filter(this.getView(), "e_settlementtype", evt -> settlementTypeQf);
        this.ePayeeAccBank(this.model);
        this.setPayerAccBankListener(this.model);
    }

    private void setPayerAccBankListener(IDataModel model) {
        BasedataEdit payerAccBankBillEdit = (BasedataEdit)this.getControl("e_payeraccbank");
        payerAccBankBillEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject payCurrency = (DynamicObject)model.getValue("paycurrency");
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "=", (Object)"normal");
            if (payCurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u5e01\u79cd\u3002", (String)"BatchFillInputEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            qFilter.and(new QFilter("currency.fbasedataid.id", "in", payCurrency.getPkValue()));
            qFilter.and(VisibleVirtualAcctHelper.virtualAcctQfNew());
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("cas_transferapply_entry");
            DynamicObject payOrg = (DynamicObject)((DynamicObject)dynamicObjects.get(0)).get("e_payorg");
            if (payOrg != null) {
                QFilter useOrgFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)payOrg.getPkValue()));
                qFilter.and(useOrgFilter);
            }
            parameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void ePayeeAccBank(IDataModel model) {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("e_payeeaccbank");
        DynamicObject currency = (DynamicObject)model.getValue("payeecurrency");
        if (currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6536\u6b3e\u5e01\u79cd\u3002", (String)"BatchFillInputEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal"});
            qFilter.and(VisibleVirtualAcctHelper.virtualAcctQfNew());
            showPara.getListFilterParameter().setFilter(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("cas_transferapply_entry");
            DynamicObject payee = (DynamicObject)((DynamicObject)dynamicObjects.get(0)).get("e_payee");
            if (payee != null) {
                QFilter useOrgFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)((Long)payee.getPkValue()));
                qFilter.and(useOrgFilter);
            }
            showPara.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void payOrg() {
        BasedataEdit payOrgF7 = (BasedataEdit)this.getControl("e_payorg");
        payOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List authOrgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_transferapply", (String)"47156aff000000ac");
            QFilter filter = ExtendConfigHelper.isInitOnlySet() ? new QFilter("standardcurrency", "is not null", null) : new QFilter("isfinishinit", "=", (Object)"1");
            DynamicObject[] finishInitArrays = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id, org", (QFilter[])filter.toArray());
            List finishInitOrgIds = Arrays.stream(finishInitArrays).filter(f -> f.getDynamicObject("org") != null).map(f -> f.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
            List list = finishInitOrgIds.stream().filter(authOrgList::contains).collect(Collectors.toList());
            showPara.getListFilterParameter().setFilter(new QFilter("id", "in", list));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView().getParentView();
        this.model = view.getModel();
        Map selected = this.getView().getFormShowParameter().getCustomParams();
        if (selected != null) {
            this.jsonArray = (JSONArray)selected.get("selected");
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if ("batchfield".equals(fieldKey)) {
            String fillType;
            if (newValue == oldValue) {
                return;
            }
            this.setBatchFieldVisible((String)newValue);
            switch (fillType = (String)this.getModel().getValue("batchfield")) {
                case "e_payeraccbank": {
                    this.checkPayAcc();
                    break;
                }
                case "e_payeeaccbank": {
                    this.checkPayeeAcc();
                    break;
                }
                case "e_paymentchannel": {
                    this.checkPayCh();
                    break;
                }
                default: {
                    return;
                }
            }
        } else if ("whichchoose".equals(fieldKey)) {
            String fillType;
            if (newValue == oldValue) {
                return;
            }
            switch (fillType = (String)this.getModel().getValue("batchfield")) {
                case "e_payeraccbank": {
                    this.checkPayAcc();
                    break;
                }
                case "e_payeeaccbank": {
                    this.checkPayeeAcc();
                    break;
                }
                case "e_paymentchannel": {
                    this.checkPayCh();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void checkPayCh() {
        block4: {
            String chooseType = (String)this.getModel().getValue("whichchoose");
            DynamicObjectCollection dynamicObjects = this.model.getEntryEntity("cas_transferapply_entry");
            if (dynamicObjects == null || dynamicObjects.size() <= 0) break block4;
            if ("selectedrows".equals(chooseType)) {
                for (int i = 0; i < this.jsonArray.size(); ++i) {
                    DynamicObject acc = ((DynamicObject)dynamicObjects.get(this.jsonArray.getInteger(i).intValue())).getDynamicObject("e_payeraccbank");
                    if (acc != null) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf\u5f55\u5165\uff0c\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u8d26\u53f7\u5fc5\u987b\u5168\u90e8\u5f55\u5165\u624d\u53ef\u586b\u5145\u652f\u4ed8\u6e20\u9053\u3002", (String)"BatchFillInputEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.innit();
                    return;
                }
            } else {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject acc = dynamicObject.getDynamicObject("e_payeraccbank");
                    if (acc != null) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf\u5f55\u5165\uff0c\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u8d26\u53f7\u5fc5\u987b\u5168\u90e8\u5f55\u5165\u624d\u53ef\u586b\u5145\u652f\u4ed8\u6e20\u9053\u3002", (String)"BatchFillInputEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.innit();
                    return;
                }
            }
        }
    }

    private void checkPayeeAcc() {
        block7: {
            String chooseType = (String)this.getModel().getValue("whichchoose");
            DynamicObjectCollection dynamicObjects = this.model.getEntryEntity("cas_transferapply_entry");
            if (dynamicObjects == null || dynamicObjects.size() <= 0) break block7;
            DynamicObject oOrg = null;
            if ("selectedrows".equals(chooseType)) {
                for (int i = 0; i < this.jsonArray.size(); ++i) {
                    DynamicObject org = ((DynamicObject)dynamicObjects.get(this.jsonArray.getInteger(i).intValue())).getDynamicObject("e_payee");
                    if (org == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u4fe1\u606f\u3002", (String)"BatchFillInputEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    if (oOrg == null || org.getLong("id") == oOrg.getLong("id")) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u7684\u6536\u6b3e\u4eba\u5fc5\u987b\u76f8\u540c\u624d\u80fd\u6279\u91cf\u5f55\u5165\u3002", (String)"BatchFillInputEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    this.innit();
                    return;
                }
            } else {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject org = dynamicObject.getDynamicObject("e_payee");
                    if (org == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u4fe1\u606f\u3002", (String)"BatchFillInputEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    if (oOrg != null && org.getLong("id") != oOrg.getLong("id")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u7684\u6536\u6b3e\u4eba\u5fc5\u987b\u76f8\u540c\u624d\u80fd\u6279\u91cf\u5f55\u5165\u3002", (String)"BatchFillInputEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    oOrg = org;
                }
            }
        }
    }

    private void checkPayAcc() {
        block11: {
            String chooseType = (String)this.getModel().getValue("whichchoose");
            DynamicObject currency = (DynamicObject)this.model.getValue("paycurrency");
            if (currency == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5e01\u79cd\uff0c\u4ee5\u53ca\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"BatchFillInputEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dynamicObjects = this.model.getEntryEntity("cas_transferapply_entry");
            if (dynamicObjects == null || dynamicObjects.size() <= 0) break block11;
            DynamicObject oOrg = null;
            DynamicObject oType = null;
            if ("selectedrows".equals(chooseType)) {
                for (int i = 0; i < this.jsonArray.size(); ++i) {
                    DynamicObject org = ((DynamicObject)dynamicObjects.get(this.jsonArray.getInteger(i).intValue())).getDynamicObject("e_payorg");
                    DynamicObject type = ((DynamicObject)dynamicObjects.get(this.jsonArray.getInteger(i).intValue())).getDynamicObject("e_settlementtype");
                    if (org == null || type == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5e01\u79cd\uff0c\u4ee5\u53ca\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"BatchFillInputEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    if (oOrg != null && org.getLong("id") != oOrg.getLong("id")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u5fc5\u987b\u76f8\u540c\u624d\u80fd\u6279\u91cf\u5f55\u5165\u3002", (String)"BatchFillInputEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    oOrg = org;
                    if (oType != null && type.getLong("id") != oType.getLong("id")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u5fc5\u987b\u76f8\u540c\u624d\u80fd\u6279\u91cf\u5f55\u5165\u3002", (String)"BatchFillInputEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    oType = type;
                }
            } else {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObject org = dynamicObject.getDynamicObject("e_payorg");
                    DynamicObject type = dynamicObject.getDynamicObject("e_settlementtype");
                    if (org == null || type == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5e01\u79cd\uff0c\u4ee5\u53ca\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"BatchFillInputEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    if (oOrg != null && org.getLong("id") != oOrg.getLong("id")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u5fc5\u987b\u76f8\u540c\u624d\u80fd\u6279\u91cf\u5f55\u5165\u3002", (String)"BatchFillInputEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    oOrg = org;
                    if (oType != null && type.getLong("id") != oType.getLong("id")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f\u5fc5\u987b\u76f8\u540c\u624d\u80fd\u6279\u91cf\u5f55\u5165\u3002", (String)"BatchFillInputEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        this.innit();
                        return;
                    }
                    oType = type;
                }
            }
        }
    }

    private void innit() {
        this.setBatchFieldVisible("e_payorg");
        this.getModel().setValue("batchfield", (Object)"e_payorg");
    }

    private void setBatchFieldVisible(String fillType) {
        this.getModel().setValue(TransferBatchEnum.SETTLEMENTTYPE.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.PAYERACCBANK.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.PAYMENTCHANNEL.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.PAYEE.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.PAYEEACCBANK.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.USAGE.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.REMARK.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.EXPECTDATE.getValue(), null);
        this.getModel().setValue(TransferBatchEnum.PAYORG.getValue(), null);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TransferBatchEnum.PAYORG.getValue(), TransferBatchEnum.SETTLEMENTTYPE.getValue(), TransferBatchEnum.PAYERACCBANK.getValue(), TransferBatchEnum.PAYMENTCHANNEL.getValue(), TransferBatchEnum.PAYEE.getValue(), TransferBatchEnum.PAYEEACCBANK.getValue(), TransferBatchEnum.USAGE.getValue(), TransferBatchEnum.REMARK.getValue(), TransferBatchEnum.EXPECTDATE.getValue()});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{fillType});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            IDataModel model = this.getModel();
            HashMap<String, Object> returnData = new HashMap<String, Object>(8);
            String returnBatchFieId = (String)model.getValue("batchfield");
            String whichChoose = (String)model.getValue("whichchoose");
            Object returnBatchContent = model.getValue(returnBatchFieId);
            if (returnBatchContent == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6216\u9009\u62e9\u5185\u5bb9\u3002", (String)"BatchFillInputEdit_0", (String)"tmc-fca-common", (Object[])new Object[0]));
                return;
            }
            if (!"e_expectdate".equals(returnBatchFieId) && "e_paymentchannel".equals(returnBatchFieId)) {
                String msg;
                IFormView view = this.getView().getParentView();
                model = view.getModel();
                Map selected = this.getView().getFormShowParameter().getCustomParams();
                if (selected != null) {
                    this.jsonArray = (JSONArray)selected.get("selected");
                }
                if ((msg = this.checkPayWay(returnBatchContent)) != null) {
                    this.getView().showErrorNotification(msg);
                    return;
                }
            }
            returnData.put("key", "btnok");
            returnData.put("batchfield", returnBatchFieId);
            returnData.put("fillContent", returnBatchContent);
            returnData.put("whichchoose", whichChoose);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private String checkPayWay(Object returnBatchContent) {
        block7: {
            ArrayList<DynamicObject> list;
            String payWay;
            block6: {
                DynamicObject payAcc;
                int i;
                String chooseType = (String)this.getModel().getValue("whichchoose");
                DynamicObjectCollection dynamicObjects = this.model.getEntryEntity("cas_transferapply_entry");
                payWay = (String)returnBatchContent;
                list = null;
                if ("selectedrows".equals(chooseType)) {
                    list = new ArrayList(this.jsonArray.size());
                    for (i = 0; i < this.jsonArray.size(); ++i) {
                        payAcc = ((DynamicObject)dynamicObjects.get(this.jsonArray.getInteger(i).intValue())).getDynamicObject("e_payeraccbank");
                        list.add(payAcc);
                    }
                } else {
                    list = new ArrayList<DynamicObject>(dynamicObjects.size());
                    for (i = 0; i < dynamicObjects.size(); ++i) {
                        payAcc = ((DynamicObject)dynamicObjects.get(i)).getDynamicObject("e_payeraccbank");
                        list.add(payAcc);
                    }
                }
                if (!PaymentChannelEnum.ONLINEBANK.getValue().equals(payWay)) break block6;
                for (DynamicObject dynamicObject : list) {
                    if (dynamicObject.getBoolean("isopenbank")) continue;
                    return ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf\u5f55\u5165\uff0c\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u8d26\u53f7\u5fc5\u987b\u90fd\u5f00\u901a\u7f51\u94f6\uff0c\u624d\u80fd\u9009\u62e9\u652f\u4ed8\u6e20\u9053\u4e3a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"BatchFillInputEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
                break block7;
            }
            if (!PaymentChannelEnum.BEI.getValue().equals(payWay)) break block7;
            for (DynamicObject dynamicObject : list) {
                if (dynamicObject.getBoolean("issetbankinterface")) continue;
                return ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf\u5f55\u5165\uff0c\u6240\u9009\u5206\u5f55\u7684\u4ed8\u6b3e\u8d26\u53f7\u5fc5\u987b\u90fd\u5f00\u901a\u94f6\u4f01\u4e92\u8054\uff0c\u624d\u80fd\u9009\u62e9\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u3002", (String)"BatchFillInputEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void setBatchFieldVisible(boolean flag) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit batchfield = (ComboEdit)this.getControl("batchfield");
        ComboItem comboItem0 = new ComboItem();
        comboItem0.setCaption(new LocaleString(TransferBatchEnum.PAYORG.getName()));
        comboItem0.setValue(TransferBatchEnum.PAYORG.getValue());
        comboItems.add(comboItem0);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(TransferBatchEnum.SETTLEMENTTYPE.getName()));
        comboItem1.setValue(TransferBatchEnum.SETTLEMENTTYPE.getValue());
        comboItems.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setCaption(new LocaleString(TransferBatchEnum.PAYERACCBANK.getName()));
        comboItem2.setValue(TransferBatchEnum.PAYERACCBANK.getValue());
        comboItems.add(comboItem2);
        ComboItem comboItem3 = new ComboItem();
        comboItem3.setCaption(new LocaleString(TransferBatchEnum.PAYMENTCHANNEL.getName()));
        comboItem3.setValue(TransferBatchEnum.PAYMENTCHANNEL.getValue());
        comboItems.add(comboItem3);
        ComboItem comboItem4 = new ComboItem();
        comboItem4.setCaption(new LocaleString(TransferBatchEnum.EXPECTDATE.getName()));
        comboItem4.setValue(TransferBatchEnum.EXPECTDATE.getValue());
        comboItems.add(comboItem4);
        ComboItem comboItem5 = new ComboItem();
        comboItem5.setCaption(new LocaleString(TransferBatchEnum.PAYEEACCBANK.getName()));
        comboItem5.setValue(TransferBatchEnum.PAYEEACCBANK.getValue());
        comboItems.add(comboItem5);
        ComboItem comboItem6 = new ComboItem();
        comboItem6.setCaption(new LocaleString(TransferBatchEnum.REMARK.getName()));
        comboItem6.setValue(TransferBatchEnum.REMARK.getValue());
        comboItems.add(comboItem6);
        ComboItem comboItem7 = new ComboItem();
        comboItem7.setCaption(new LocaleString(TransferBatchEnum.USAGE.getName()));
        comboItem7.setValue(TransferBatchEnum.USAGE.getValue());
        comboItems.add(comboItem7);
        ComboItem comboItem8 = new ComboItem();
        comboItem8.setCaption(new LocaleString(TransferBatchEnum.PAYEE.getName()));
        comboItem8.setValue(TransferBatchEnum.PAYEE.getValue());
        if (!flag) {
            comboItems.add(comboItem8);
        }
        batchfield.setComboItems(comboItems);
    }
}

