/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.util.Collection;
import java.util.Date;
import java.util.function.Function;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.formplugin.workbench.BillSummaryInfo;
import kd.fi.cas.util.AutoSumableDataProvider;
import kd.fi.cas.util.DateUtils;

public class RecWorkbenchDataCenter {
    private Collection<Long> accountPks;
    private Date beginDate;
    private Date endDate;
    private AutoSumableDataProvider transdetailDataProvider;
    private AutoSumableDataProvider recDataProvider;

    public RecWorkbenchDataCenter(Collection<Long> accountPks, Date beginDate, Date endDate) {
        this.accountPks = accountPks;
        this.beginDate = DateUtils.truncateDate((Date)beginDate);
        this.endDate = DateUtils.truncateDate((Date)endDate);
        this.loadRecBill();
        this.loadTansdetail();
    }

    private void loadRecBill() {
        QFilter acctFilter = new QFilter("accountbank", "in", this.accountPks);
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)this.beginDate).and("bizdate", "<=", (Object)this.endDate);
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), BillStatusEnum.BEING.getValue()});
        QFilter sourceFilter = new QFilter("sourcebilltype", "=", (Object)"bei_transdetail");
        this.recDataProvider = new AutoSumableDataProvider("cas_recbill");
        this.recDataProvider.filter(new QFilter[]{acctFilter, dateFilter, statusFilter, sourceFilter}).groupBy(new String[]{"1 as groupField"}).sum(new String[]{"1 as count", "localamt"}).query();
    }

    private void loadTansdetail() {
        QFilter acctFilter = new QFilter("accountbank", "in", this.accountPks);
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)this.beginDate).and("bizdate", "<=", (Object)this.endDate);
        QFilter typeFilter = new QFilter("creditamount", ">", (Object)0);
        QFilter isTransUp = new QFilter("istransup", "=", (Object)false);
        QFilter isTransDown = new QFilter("istransdown", "=", (Object)false);
        QFilter recedTypeFilter = new QFilter("receredtype", "in", (Object)new String[]{ReceredtypeEnum.Pending.getValue(), ReceredtypeEnum.ACCOUNTED.getValue()});
        this.transdetailDataProvider = new AutoSumableDataProvider("bei_transdetail_cas");
        this.transdetailDataProvider.filter(new QFilter[]{acctFilter, dateFilter, typeFilter, isTransUp, isTransDown, recedTypeFilter}).groupBy(new String[]{"case when receredtype='3' then 1 else 0 end as accounted"}).sum(new String[]{"creditamount", "1 as count"}).query();
    }

    public BillSummaryInfo getRecBillInfo() {
        BillSummaryInfo result = (BillSummaryInfo)this.recDataProvider.compute(row -> new BillSummaryInfo(row.getBigDecimal("localamt"), row.getInteger("count")));
        return result == null ? new BillSummaryInfo() : result;
    }

    public BillSummaryInfo getRecedTransdetailInfo() {
        Function<Row, BillSummaryInfo> vFunc = row -> {
            if (row.getBoolean("accounted").booleanValue()) {
                return new BillSummaryInfo(row.getBigDecimal("creditamount"), row.getInteger("count"));
            }
            return new BillSummaryInfo();
        };
        BillSummaryInfo result = (BillSummaryInfo)this.transdetailDataProvider.compute(vFunc);
        return result == null ? new BillSummaryInfo() : result;
    }

    public BillSummaryInfo getUnrecedTransdetailInfo() {
        Function<Row, BillSummaryInfo> vFunc = row -> {
            if (!row.getBoolean("accounted").booleanValue()) {
                return new BillSummaryInfo(row.getBigDecimal("creditamount"), row.getInteger("count"));
            }
            return new BillSummaryInfo();
        };
        BillSummaryInfo result = (BillSummaryInfo)this.transdetailDataProvider.compute(vFunc);
        return result == null ? new BillSummaryInfo() : result;
    }

    public BillSummaryInfo getAllTransdetailInfo() {
        BillSummaryInfo result = (BillSummaryInfo)this.transdetailDataProvider.compute(row -> new BillSummaryInfo(row.getBigDecimal("creditamount"), row.getInteger("count")));
        return result == null ? new BillSummaryInfo() : result;
    }
}

