/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.IBaseColumn;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.report.CapitalSumSet;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;

public class CapitalSumFormRpt
extends AbstractReportFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.timeTypeChange(this.getModel().getValue("timetype"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.defaultOrg();
    }

    private void defaultOrg() {
        Object org = this.getModel().getValue("org");
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List orgList = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_capitalsumrpt", (String)"47150e89000000ac");
        Long fisBankRollOrg = this.getFisBankRollOrg();
        if (org == null && orgList.size() > 0) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgList), new QFilter("isfinishinit", "=", (Object)"1")}, null);
            if (fisBankRollOrg != null) {
                DynamicObjectCollection queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (queryFisBankRollOrg.size() > 0) {
                    this.getModel().setValue("org", (Object)new Object[]{fisBankRollOrg});
                    long periodTypeId = PeriodHelper.getPeriodTypeId((long)fisBankRollOrg);
                    this.getModel().setValue("periodtype", (Object)periodTypeId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
                    DynamicObject currentPeriod = initObj.getDynamicObject("currentperiod");
                    if (currentPeriod != null) {
                        this.getModel().setValue("periodfrom", currentPeriod.getPkValue());
                        this.getModel().setValue("periodto", currentPeriod.getPkValue());
                        this.getModel().setValue("datefrom", (Object)currentPeriod.getDate("begindate"));
                        this.getModel().setValue("dateto", (Object)currentPeriod.getDate("enddate"));
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{"periodfrom"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"periodto"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
                    Object baseCurrency = initObj.getDynamicObject("standardcurrency").getPkValue();
                    this.getModel().setValue("calccurrency", baseCurrency);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                } else if (coll.size() > 0) {
                    long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                    Object[] arrObj = new Object[]{orgId};
                    this.getModel().setValue("org", (Object)arrObj);
                    long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                    this.getModel().setValue("periodtype", (Object)periodTypeId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
                    DynamicObject currentPeriod = initObj.getDynamicObject("currentperiod");
                    if (currentPeriod != null) {
                        this.getModel().setValue("periodfrom", currentPeriod.getPkValue());
                        this.getModel().setValue("periodto", currentPeriod.getPkValue());
                        this.getModel().setValue("datefrom", (Object)currentPeriod.getDate("begindate"));
                        this.getModel().setValue("dateto", (Object)currentPeriod.getDate("enddate"));
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{"periodfrom"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"periodto"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
                    Object baseCurrency = initObj.getDynamicObject("standardcurrency").getPkValue();
                    this.getModel().setValue("calccurrency", baseCurrency);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                }
            }
        }
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(requestContext.getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (authorizedBankOrgId != null && authorizedBankOrgId.size() > 0) {
            return (Long)authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    private void initF7() {
        boolean isTrue = true;
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (orgCtrl.getQFilter() == null) {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)}, null);
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                F7FilterUtil.bankrollOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)"cas_capitalsumrpt", (String)"47150e89000000ac", (List)OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        });
        BasedataEdit bankNum = (BasedataEdit)this.getControl("filter_bankaccountnumber");
        bankNum.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            if (null != orgColl && orgColl.size() == 0) {
                QFilter qFilter = new QFilter("org.id", "in", new ArrayList());
                new LspWapper(beforeF7SelectEvent).setFilters(new QFilter[]{qFilter});
            } else {
                new LspWapper(beforeF7SelectEvent).setFilters(this.getAcctFilter(this.getIdList(orgColl)));
            }
        });
        BasedataEdit accountcash = (BasedataEdit)this.getControl("filter_accountcash");
        accountcash.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection filter_company = (DynamicObjectCollection)this.getModel().getValue("org");
            QFilter qFilter = new QFilter("org.id", "in", filter_company.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList()));
            lsp.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit bankCtrl = (BasedataEdit)this.getControl("bank");
        bankCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter notVirtualBankQf = VisibleVirtualAcctHelper.notVirtualBankQf();
            if (CasHelper.isNotEmpty((Object)notVirtualBankQf)) {
                lsp.getListFilterParameter().setFilter(notVirtualBankQf);
            }
        });
        BasedataEdit currencyCtrl = (BasedataEdit)this.getControl("currency");
        currencyCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            if (orgColl.size() > 0) {
                if (this.getModel().getValue("category").equals("1")) {
                    DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_accountcash", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "in", this.getIdList(orgColl))});
                    Set cashList = coll.stream().map(cash -> cash.getLong("id")).collect(Collectors.toSet());
                    if (cashList != null && cashList.size() > 0) {
                        List currencyIdSet = AccountCashHelper.getCurrencys(cashList);
                        QFilter qFilter = new QFilter("id", "in", (Object)currencyIdSet);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    } else {
                        showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
                    }
                } else if (this.getModel().getValue("category").equals("0")) {
                    Set currencyIds = AccountBankHelper.getCurrencyPksByOrg(this.getIdList(orgColl));
                    if (currencyIds != null && currencyIds.size() > 0) {
                        QFilter qFilter = new QFilter("id", "in", (Object)currencyIds);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    } else {
                        showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
                    }
                }
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
            }
        });
        BasedataEdit periodfromCtrl = (BasedataEdit)this.getControl("periodfrom");
        periodfromCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.getModel().getValue("periodtype") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"CapitalSumFormRpt_0", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                beforeF7SelectEvent.setCancel(isTrue);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", this.getprdIDs());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit periodtoCtrl = (BasedataEdit)this.getControl("periodto");
        periodtoCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (this.getModel().getValue("periodtype") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"CapitalSumFormRpt_0", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                beforeF7SelectEvent.setCancel(isTrue);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", this.getprdIDs());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        bankCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            QFilter notVirtualBankQf = VisibleVirtualAcctHelper.notVirtualBankQf();
            if (orgColl.size() > 0 && this.getModel().getValue("category").equals("2")) {
                Set bankIdSet = AccountBankHelper.getBanksByOrg(this.getIdList(orgColl));
                if (bankIdSet != null && bankIdSet.size() > 0) {
                    QFilter qFilter = new QFilter("id", "in", (Object)bankIdSet);
                    showParameter.getListFilterParameter().setFilter(qFilter);
                } else {
                    QFilter qFilter = new QFilter("id", "=", null);
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            }
            if (CasHelper.isNotEmpty((Object)notVirtualBankQf)) {
                showParameter.getListFilterParameter().setFilter(notVirtualBankQf);
            }
        });
        BasedataEdit pTypeCtrl = (BasedataEdit)this.getControl("periodtype");
        pTypeCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            List<Long> periodTypeList = this.getPeriodTypeList(orgColl);
            if (periodTypeList.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", periodTypeList);
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
            }
        });
    }

    protected QFilter[] getAcctFilter(List<Long> orgPks) {
        QFilter[] accountFilter = new QFilter[]{AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        boolean defaulttime;
        super.initDefaultQueryParam(queryParam);
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_capitalsumrpt", (String)"47150e89000000ac");
        Long fisBankRollOrg = this.getFisBankRollOrg();
        if (orgList.size() > 0) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgList), new QFilter("isfinishinit", "=", (Object)"1")}, null);
            if (fisBankRollOrg != null) {
                DynamicObjectCollection queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (queryFisBankRollOrg.size() > 0) {
                    String type;
                    this.getModel().setValue("org", (Object)new Object[]{fisBankRollOrg});
                    long periodTypeId = PeriodHelper.getPeriodTypeId((long)fisBankRollOrg);
                    this.getModel().setValue("periodtype", (Object)periodTypeId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
                    DynamicObject currentPeriod = initObj.getDynamicObject("currentperiod");
                    if (currentPeriod != null) {
                        this.getModel().setValue("periodfrom", currentPeriod.getPkValue());
                        this.getModel().setValue("periodto", currentPeriod.getPkValue());
                        this.getModel().setValue("datefrom", (Object)currentPeriod.getDate("begindate"));
                        this.getModel().setValue("dateto", (Object)currentPeriod.getDate("enddate"));
                    }
                    if ("1".equals(type = this.getModel().getValue("timetype").toString())) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"periodfrom"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"periodto"});
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
                    Object baseCurrency = initObj.getDynamicObject("standardcurrency").getPkValue();
                    this.getModel().setValue("calccurrency", baseCurrency);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                } else if (coll.size() > 0) {
                    long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                    Object[] arrObj = new Object[]{orgId};
                    this.getModel().setValue("org", (Object)arrObj);
                    long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                    this.getModel().setValue("periodtype", (Object)periodTypeId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
                    DynamicObject currentPeriod = initObj.getDynamicObject("currentperiod");
                    if (currentPeriod != null) {
                        this.getModel().setValue("periodfrom", currentPeriod.getPkValue());
                        this.getModel().setValue("periodto", currentPeriod.getPkValue());
                        this.getModel().setValue("datefrom", (Object)currentPeriod.getDate("begindate"));
                        this.getModel().setValue("dateto", (Object)currentPeriod.getDate("enddate"));
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{"periodfrom"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"periodto"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
                    Object baseCurrency = initObj.getDynamicObject("standardcurrency").getPkValue();
                    this.getModel().setValue("calccurrency", baseCurrency);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                }
            }
        }
        if (defaulttime = ((Boolean)this.getModel().getValue("defaulttime")).booleanValue()) {
            this.getModel().setValue("timetype", (Object)2);
        }
    }

    private Set<Long> getprdIDs() {
        HashSet<Long> periodIDs = new HashSet<Long>(16);
        DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgColl != null && orgColl.size() > 0) {
            long selPeriodtype = ((DynamicObject)this.getModel().getValue("periodtype")).getLong("id");
            DynamicObjectCollection periodColl = PeriodHelper.getPeriodList((long)selPeriodtype);
            for (int k = 0; k < orgColl.size(); ++k) {
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)Long.parseLong(((DynamicObject)orgColl.get(k)).getDynamicObject("fbasedataid").getPkValue().toString()));
                if (periodTypeId != selPeriodtype) continue;
                DynamicObject initObj = PeriodHelper.getCasInitInfo((long)Long.parseLong(((DynamicObject)orgColl.get(k)).getDynamicObject("fbasedataid").getPkValue().toString()));
                DynamicObject beginPeriod = initObj.getDynamicObject("startperiod");
                DynamicObject endPeriod = initObj.getDynamicObject("currentperiod");
                for (DynamicObject period : periodColl) {
                    if (!PeriodHelper.after((DynamicObject)period, (DynamicObject)beginPeriod) && !PeriodHelper.equal((DynamicObject)period, (DynamicObject)beginPeriod) || !PeriodHelper.before((DynamicObject)period, (DynamicObject)endPeriod) && !PeriodHelper.equal((DynamicObject)period, (DynamicObject)endPeriod) || periodIDs.contains(period.getLong("id"))) continue;
                    periodIDs.add(period.getLong("id"));
                }
            }
        }
        return periodIDs;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object oldValue = valueSet[0].getOldValue();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "org": {
                DynamicObjectCollection orgColl = (DynamicObjectCollection)propValue;
                this.orgChange(orgColl);
                this.getModel().setValue("filter_bankaccountnumber", null);
                this.getModel().setValue("filter_accountcash", null);
                break;
            }
            case "timetype": {
                this.timeTypeChange(propValue);
                break;
            }
            case "category": {
                this.categoryChange(propValue);
                break;
            }
            case "periodtype": {
                this.periodtypeChange(oldValue, propValue);
                break;
            }
            case "datefrom": {
                this.dateFromChange((Date)propValue);
                break;
            }
            case "dateto": {
                this.dateToChange((Date)propValue);
                break;
            }
        }
    }

    private void dateFromChange(Date dateFrom) {
        Date dateTo = (Date)this.getModel().getValue("dateto");
        if (dateFrom != null && dateTo != null && dateFrom.after(dateTo)) {
            this.getModel().setValue("dateto", (Object)dateFrom);
        }
    }

    private void dateToChange(Date dateTo) {
        Date dateFrom = (Date)this.getModel().getValue("datefrom");
        if (dateFrom != null && dateTo != null && dateFrom.after(dateTo)) {
            this.getModel().setValue("datefrom", (Object)dateTo);
        }
    }

    private void orgChange(DynamicObjectCollection orgColl) {
        boolean isTrue = true;
        if (orgColl == null || orgColl.size() == 0) {
            return;
        }
        long selFirstOrg = Long.parseLong(((DynamicObject)orgColl.get(0)).getDynamicObject("fbasedataid").getPkValue().toString());
        long periodTypeId = PeriodHelper.getPeriodTypeId((long)selFirstOrg);
        List<Long> periodTypeList = this.getPeriodTypeList(orgColl);
        if (orgColl.size() == 1) {
            this.getModel().setValue("periodtype", (Object)periodTypeId);
            this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
        } else if (periodTypeList.size() == 1) {
            this.getModel().setValue("periodtype", (Object)periodTypeList.get(0));
            this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
        } else if (periodTypeList.size() > 1 && this.getModel().getValue("timetype").toString().equals("1")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"periodtype"});
            this.getModel().setValue("periodtype", null);
            ((FieldEdit)this.getView().getControl("periodtype")).setMustInput(isTrue);
        } else {
            this.getModel().setValue("periodtype", null);
        }
        if (orgColl.size() == 1 || periodTypeList.size() == 1) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)((Long)((DynamicObject)orgColl.get(0)).getDynamicObject("fbasedataid").getPkValue()));
            if (initObj != null) {
                DynamicObject currentPeriod = initObj.getDynamicObject("currentperiod");
                if (currentPeriod != null) {
                    this.getModel().setValue("periodfrom", currentPeriod.getPkValue());
                    this.getModel().setValue("periodto", currentPeriod.getPkValue());
                    this.getModel().setValue("datefrom", (Object)currentPeriod.getDate("begindate"));
                    this.getModel().setValue("dateto", (Object)currentPeriod.getDate("enddate"));
                }
                Object baseCurrency = initObj.getDynamicObject("standardcurrency").getPkValue();
                this.getModel().setValue("calccurrency", baseCurrency);
                this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
            }
        } else {
            this.getModel().setValue("periodfrom", null);
            this.getModel().setValue("periodto", null);
        }
        this.getModel().setValue("bank", null);
    }

    private List<Long> getPeriodTypeList(DynamicObjectCollection orgColl) {
        ArrayList<Long> periodTypeList = new ArrayList<Long>();
        if (orgColl != null && orgColl.size() > 0) {
            for (int i = 0; i < orgColl.size(); ++i) {
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)Long.parseLong(((DynamicObject)orgColl.get(i)).getDynamicObject("fbasedataid").getPkValue().toString()));
                if (periodTypeList.contains(periodTypeId)) continue;
                periodTypeList.add(periodTypeId);
            }
        }
        return periodTypeList;
    }

    private void timeTypeChange(Object propValue) {
        if (propValue == null || StringUtils.isBlank((Object)propValue)) {
            return;
        }
        boolean isTrue = true;
        boolean isFalse = false;
        if (1 == Integer.parseInt(propValue.toString())) {
            ((FieldEdit)this.getView().getControl("datefrom")).setMustInput(isFalse);
            ((FieldEdit)this.getView().getControl("dateto")).setMustInput(isFalse);
            ((FieldEdit)this.getView().getControl("periodfrom")).setMustInput(isTrue);
            ((FieldEdit)this.getView().getControl("periodto")).setMustInput(isTrue);
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            List<Long> prdTypeList = this.getPeriodTypeList(orgColl);
            if (prdTypeList.size() > 1) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"periodtype"});
            }
        } else {
            ((FieldEdit)this.getView().getControl("periodfrom")).setMustInput(isFalse);
            ((FieldEdit)this.getView().getControl("periodto")).setMustInput(isFalse);
            this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
            ((FieldEdit)this.getView().getControl("datefrom")).setMustInput(isTrue);
            ((FieldEdit)this.getView().getControl("dateto")).setMustInput(isTrue);
        }
    }

    private void categoryChange(Object propValue) {
        if (propValue.equals("1")) {
            this.getModel().setValue("seldimension", (Object)1);
            this.getModel().setValue("accountproperty", (Object)new Object[]{"183705600155241472"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bank"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_bankaccountnumber"});
        } else if (propValue.equals("2")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
            this.getModel().setValue("accountproperty", (Object)new Object[0]);
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_bankaccountnumber"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
            this.getModel().setValue("accountproperty", (Object)new Object[0]);
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_bankaccountnumber"});
        }
    }

    private void periodtypeChange(Object oldValue, Object propValue) {
        if (oldValue == null && propValue != null || oldValue != null && propValue == null || oldValue != null && propValue != null && ((DynamicObject)oldValue).getPkValue() != ((DynamicObject)propValue).getPkValue()) {
            this.getModel().setValue("periodfrom", null);
            this.getModel().setValue("periodto", null);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isFalse = false;
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("org");
            if (org == null || org.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalDayFormListPlugin_3", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            int timetype = filterInfo.getInt("timetype");
            if (timetype == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_15", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (timetype == 1) {
                DynamicObject beginPeriod = filterInfo.getDynamicObject("periodfrom");
                DynamicObject endPeriod = filterInfo.getDynamicObject("periodto");
                if (beginPeriod == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u671f\u95f4\u3002", (String)"CapitalSumFormRpt_2", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return isFalse;
                }
                if (endPeriod == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_3", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return isFalse;
                }
                if (endPeriod.getLong("id") < beginPeriod.getLong("id")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"CapitalSumFormRpt_4", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return isFalse;
                }
            } else {
                Date beginDate = filterInfo.getDate("datefrom");
                Date endDate = filterInfo.getDate("dateto");
                if (beginDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_5", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return isFalse;
                }
                if (endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u675f\u65e5\u671f\u3002", (String)"CapitalSumFormRpt_6", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return isFalse;
                }
                if (beginDate.after(endDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"CapitalSumFormRpt_7", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return isFalse;
                }
            }
            DynamicObjectCollection currency = (DynamicObjectCollection)filterInfo.getValue("currency");
            DynamicObject exratetable = (DynamicObject)filterInfo.getValue("exratetable");
            if (exratetable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_9", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return isFalse;
            }
            DynamicObject calccurrency = (DynamicObject)filterInfo.getValue("calccurrency");
            if (calccurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u79cd\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_10", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return isFalse;
            }
            ArrayList<String> noCurList = new ArrayList<String>();
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
                try (DataSet currencyDataSet = CapitalSumSet.getCurExr(exratetable.getLong("id"), calccurrency.getLong("id"));){
                    HashMap<Long, Long> curRelation = new HashMap<Long, Long>();
                    if (currencyDataSet != null) {
                        for (Row row : currencyDataSet) {
                            curRelation.put(row.getLong("orgcurid"), row.getLong("curid"));
                        }
                        for (int i = 0; i < currency.size(); ++i) {
                            if (curRelation.containsKey(((DynamicObject)currency.get(i)).getLong("id"))) continue;
                            noCurList.add(((DynamicObject)currency.get(i)).getLocaleString("name").getLocaleValue());
                        }
                    }
                }
            }
            if (noCurList.size() > 0) {
                String msg = ResManager.loadKDString((String)"\u4e3a\u4e86\u80fd\u8ba1\u7b97\u6570\u636e\u51c6\u786e\uff0c\u7edf\u8ba1\u65e0\u8bef\u3002", (String)"CapitalSumFormRpt_11", (String)"fi-cas-report", (Object[])new Object[0]);
                StringBuilder strMsg = new StringBuilder(msg);
                for (int j = 0; j < noCurList.size(); ++j) {
                    strMsg.append(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6c47\u7387\u8868", (String)"CapitalSumFormRpt_12", (String)"fi-cas-report", (Object[])new Object[0])).append((String)noCurList.get(j)).append(ResManager.loadKDString((String)"\u6c47\u7387\u3002", (String)"CapitalSumFormRpt_13", (String)"fi-cas-report", (Object[])new Object[0]));
                }
                this.getView().showTipNotification(strMsg.toString(), Integer.valueOf(3000));
                return isFalse;
            }
            return super.verifyQuery(queryParam);
        }
        return isFalse;
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idList.add((Long)((DynamicObject)coll.get(i)).getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        ReportColumnGroup column;
        int i;
        List columns;
        ReportQueryParam queryParam = event.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        this.removeColumn(event.getColumns(), filterInfo.getInt("timetype"));
        if (filterInfo.getInt("timetype") == 2) {
            columns = event.getColumns();
            for (i = columns.size() - 1; i >= 0; --i) {
                if (columns.get(i) instanceof ReportColumnGroup) {
                    column = (ReportColumnGroup)columns.get(i);
                    if (!"yearstart3".equals(column.getFieldKey()) && !"monthstart3".equals(column.getFieldKey()) && !"debitamount3".equals(column.getFieldKey()) && !"creditamount3".equals(column.getFieldKey()) && !"yeardebit3".equals(column.getFieldKey()) && !"yearcredit3".equals(column.getFieldKey()) && !"monthbalance3".equals(column.getFieldKey())) continue;
                    columns.remove(columns.get(i));
                    continue;
                }
                column = (ReportColumn)columns.get(i);
                if (!"period".equals(column.getFieldKey()) && !"unit".equals(column.getFieldKey()) && !"level".equals(column.getFieldKey()) && !"sumlevel".equals(column.getFieldKey()) && !"calccurrency1".equals(column.getFieldKey())) continue;
                columns.remove(columns.get(i));
            }
        } else {
            columns = event.getColumns();
            for (i = columns.size() - 1; i >= 0; --i) {
                if (columns.get(i) instanceof ReportColumnGroup) {
                    column = (ReportColumnGroup)columns.get(i);
                    if (!"daystart3".equals(column.getFieldKey()) && !"daydebitamount3".equals(column.getFieldKey()) && !"daycreditamount3".equals(column.getFieldKey()) && !"daybalance3".equals(column.getFieldKey())) continue;
                    columns.remove(columns.get(i));
                    continue;
                }
                column = (ReportColumn)columns.get(i);
                if (!"unit".equals(column.getFieldKey()) && !"calccurrency1".equals(column.getFieldKey())) continue;
                columns.remove(columns.get(i));
            }
        }
        if (filterInfo.getString("category").equals("1")) {
            columns = event.getColumns();
            for (i = columns.size() - 1; i >= 0; --i) {
                if (filterInfo.getInt("timetype") == 1) {
                    ReportColumn column2;
                    IBaseColumn _column = (IBaseColumn)columns.get(i);
                    if (!(_column instanceof ReportColumn) || !"accountbank".equals((column2 = (ReportColumn)columns.get(i)).getFieldKey()) && !"acctpurpose".equals(column2.getFieldKey()) && !"acctstyle".equals(column2.getFieldKey()) && !"accttype".equals(column2.getFieldKey()) && !"bankid".equals(column2.getFieldKey())) continue;
                    columns.remove(columns.get(i));
                    continue;
                }
                if (!(columns.get(i) instanceof ReportColumn) || !"accountbank".equals((column = (ReportColumn)columns.get(i)).getFieldKey()) && !"acctpurpose".equals(column.getFieldKey()) && !"acctstyle".equals(column.getFieldKey()) && !"accttype".equals(column.getFieldKey()) && !"bankid".equals(column.getFieldKey())) continue;
                columns.remove(columns.get(i));
            }
        } else {
            columns = event.getColumns();
            for (i = columns.size() - 1; i >= 0; --i) {
                if (columns.get(i) instanceof ReportColumnGroup) {
                    column = (ReportColumnGroup)columns.get(i);
                    if (!"accountcash".equals(column.getFieldKey())) continue;
                    columns.remove(columns.get(i));
                    continue;
                }
                column = (ReportColumn)columns.get(i);
                if (filterInfo.getString("category").equals("3")) {
                    String fieldKey = column.getFieldKey();
                    if (!"accountcash".equals(fieldKey)) continue;
                    columns.remove(columns.get(i));
                    continue;
                }
                if (!"accountcash".equals(column.getFieldKey())) continue;
                columns.remove(columns.get(i));
            }
        }
        super.afterCreateColumn(event);
    }

    private void removeColumn(List<AbstractReportColumn> columns, int timetype) {
        HashSet remove_fields = null;
        remove_fields = Sets.newHashSet((Object[])new String[]{"orgid", "period", "currencyid"});
        for (int i = columns.size() - 1; i >= 0; --i) {
            if (!(columns.get(i) instanceof ReportColumn)) continue;
            ReportColumn column = (ReportColumn)columns.get(i);
            if (remove_fields.contains(column.getFieldKey())) {
                columns.remove(columns.get(i));
            }
            if (timetype != 2 || !"periodname".equalsIgnoreCase(column.getFieldKey())) continue;
            columns.remove(columns.get(i));
        }
    }
}

