/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.report.CapitalSumParam;
import kd.fi.cas.report.capitalreport.report.CapitalDataSum;
import kd.fi.cas.util.EmptyUtil;

public class CapitalSumListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(CapitalSumListDataRpt.class);

    public DataSet query(ReportQueryParam arg0, Object info) throws Throwable {
        return new CapitalDataSum().query(arg0, info, false);
    }

    public static List<QFilter> qFilterAccs(CapitalSumParam param, Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        List orgList = new ArrayList(param.getOrgs().size());
        orgList = OrgHelper.getIdList((DynamicObjectCollection)param.getOrgs());
        QFilter currencyFilter = new QFilter("currency", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)param.getCurrencys()));
        if (orgId != null) {
            filters.add(AccountBankHelper.getAccountBankFilterByOrg((Long)orgId));
        } else {
            filters.add(AccountBankHelper.getAccountBankFilterByOrg(orgList));
        }
        filters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        DynamicObjectCollection accts = param.getBankaccounts();
        if (accts != null && accts.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", (Object)accts.stream().map(o -> o.getLong("id")).toArray());
            filters.add(qFilter);
        }
        return filters;
    }

    public static CapitalSumParam getCapitalSumParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        CapitalSumParam param = new CapitalSumParam();
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("org");
        param.setShowsubtotal(filterInfo.getBoolean("showsubtotal"));
        param.setDefaulttime(filterInfo.getBoolean("defaulttime"));
        param.setExchangedate(filterInfo.getDate("exchangedate"));
        param.setBanktypes(filterInfo.getDynamicObjectCollection("banktype"));
        param.setDatasource(filterInfo.getInt("datasource"));
        param.setAccountcashs(filterInfo.getDynamicObjectCollection("filter_accountcash"));
        param.setBankaccounts(filterInfo.getDynamicObjectCollection("filter_bankaccountnumber"));
        int category = filterInfo.getInt("category");
        Date dateFrom = filterInfo.getDate("datefrom");
        Date dateTo = filterInfo.getDate("dateto");
        int timeType = filterInfo.getInt("timetype");
        DynamicObjectCollection banks = filterInfo.getDynamicObjectCollection("bank");
        DynamicObjectCollection accountPropertys = filterInfo.getDynamicObjectCollection("accountproperty");
        DynamicObjectCollection currencys = filterInfo.getDynamicObjectCollection("currency");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
            currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        }
        int selDimension = filterInfo.getInt("seldimension");
        String statisticUnit = filterInfo.getString("statisticunit");
        DynamicObject exrateTable = filterInfo.getDynamicObject("exratetable");
        DynamicObject calcCurrency = filterInfo.getDynamicObject("calccurrency");
        boolean notShowZero = filterInfo.getBoolean("notshowzero");
        boolean showCloseAcct = filterInfo.getBoolean("showcloseacct");
        param.setOrgs(orgs);
        param.setCategory(category);
        param.setTimeType(timeType);
        if (param.getTimeType() == 1) {
            DynamicObject prdType = filterInfo.getDynamicObject("periodtype");
            DynamicObject prdFrom = filterInfo.getDynamicObject("periodfrom");
            DynamicObject prdTo = filterInfo.getDynamicObject("periodto");
            if (PeriodHelper.before((DynamicObject)prdTo, (DynamicObject)prdFrom)) {
                return null;
            }
            param.setPeriodType(prdType);
            param.setPeriodFrom(prdFrom);
            param.setPeriodTo(prdTo);
        }
        param.setDateFrom(dateFrom);
        param.setDateTo(dateTo);
        param.setBanks(banks);
        param.setAccountPropertys(accountPropertys);
        param.setCurrencys(currencys);
        param.setSelDimension(selDimension);
        param.setStatisticUnit(statisticUnit);
        param.setExrateTable(exrateTable);
        param.setCalcCurrency(calcCurrency);
        param.setNotShowZero(notShowZero);
        param.setShowCloseAcct(showCloseAcct);
        return param;
    }
}

