/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.fi.cas.enums.CategoryEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.report.capitalreport.report.CapitalDataSum;
import kd.fi.cas.util.EmptyUtil;

public class CapitalSumPrintPlugin
extends AbstractPrintServicePlugin {
    private static final String[] CURR_FILED = new String[]{"monthstart", "monthstartcalc", "debitamount", "debitamountcalc", "creditamount", "creditamountcalc", "monthbalance", "monthbalancecalc"};
    private static final String[] CURR_FILED_CALC = new String[]{"daystart", "daystartcalc", "daydebitamount", "daydebitamountcalc", "daycreditamount", "daycreditamountcalc", "daybalance", "daybalancecalc"};

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        ReportDataProvider o = (ReportDataProvider)e.getSource();
        ReportQueryParam queryParam = o.getQueryParam();
        int size = queryParam.getFilter().getFilterItems().size();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(size);
        for (FilterItemInfo filterItem : queryParam.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        StringBuilder periodName = new StringBuilder();
        String timeType = paramMap.get("timetype").toString();
        if (StringUtils.equals((CharSequence)timeType, (CharSequence)"1")) {
            DynamicObject periodfrom = (DynamicObject)paramMap.get("periodfrom");
            DynamicObject periodto = (DynamicObject)paramMap.get("periodto");
            periodName.append(periodfrom.getString("name"));
            periodName.append("-");
            periodName.append(periodto.getString("name"));
        } else if (StringUtils.equals((CharSequence)timeType, (CharSequence)"2")) {
            Date datefrom = (Date)paramMap.get("datefrom");
            Date dateto = (Date)paramMap.get("dateto");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/dd");
            periodName.append(sdf.format(datefrom));
            periodName.append("\n-\n");
            periodName.append(sdf.format(dateto));
        }
        DynamicObjectType customDT = new DynamicObjectType();
        if ("capitalsumhead".equals(e.getDataSourceName())) {
            customDT.registerProperty("period", String.class, (Object)"", false);
            customDT.registerProperty("bdcurrency", String.class, (Object)"", false);
            customDT.registerProperty("currorg", String.class, (Object)"", false);
            DynamicObject capitalsumhead = new DynamicObject(customDT);
            StringBuilder period = new StringBuilder();
            if (StringUtils.equals((CharSequence)timeType, (CharSequence)"1")) {
                period.append(ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"CapitalSumPrintPlugin_0", (String)"fi-cas-report", (Object[])new Object[0]));
            } else {
                period.append(ResManager.loadKDString((String)"\u65e5\u671f\uff1a", (String)"CapitalSumPrintPlugin_9", (String)"fi-cas-report", (Object[])new Object[0]));
            }
            period.append((CharSequence)periodName);
            capitalsumhead.set("period", (Object)period.toString());
            StringBuilder bdcurrency = new StringBuilder();
            bdcurrency.append(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\uff1a", (String)"CapitalSumPrintPlugin_1", (String)"fi-cas-report", (Object[])new Object[0]));
            bdcurrency.append(((DynamicObject)paramMap.get("calccurrency")).getString("name"));
            capitalsumhead.set("bdcurrency", (Object)bdcurrency.toString());
            StringBuilder currorg = new StringBuilder();
            currorg.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a", (String)"CapitalSumPrintPlugin_2", (String)"fi-cas-report", (Object[])new Object[0]));
            String statisticunit = paramMap.get("statisticunit").toString();
            if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"1")) {
                statisticunit = ResManager.loadKDString((String)"\u5143", (String)"CapitalSumPrintPlugin_3", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"1000")) {
                statisticunit = ResManager.loadKDString((String)"\u5343\u5143", (String)"CapitalSumPrintPlugin_4", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"10000")) {
                statisticunit = ResManager.loadKDString((String)"\u4e07\u5143", (String)"CapitalSumPrintPlugin_5", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"1000000")) {
                statisticunit = ResManager.loadKDString((String)"\u767e\u4e07\u5143", (String)"CapitalSumPrintPlugin_6", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"10000000")) {
                statisticunit = ResManager.loadKDString((String)"\u5343\u4e07\u5143", (String)"CapitalSumPrintPlugin_7", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"100000000")) {
                statisticunit = ResManager.loadKDString((String)"\u4ebf\u5143", (String)"CapitalSumPrintPlugin_8", (String)"fi-cas-report", (Object[])new Object[0]);
            }
            currorg.append(statisticunit);
            capitalsumhead.set("currorg", (Object)currorg.toString());
            dyns.add(capitalsumhead);
        } else if ("capitalsumbody".equals(e.getDataSourceName())) {
            customDT.registerProperty("period", String.class, (Object)"", false);
            customDT.registerProperty("org", String.class, (Object)"", false);
            customDT.registerProperty("fundtype", String.class, (Object)"", false);
            customDT.registerProperty("account", String.class, (Object)"", false);
            customDT.registerProperty("acctpurpose", String.class, (Object)"", false);
            customDT.registerProperty("bankno", String.class, (Object)"", false);
            customDT.registerProperty("bank", String.class, (Object)"", false);
            customDT.registerProperty("startcurr", String.class, (Object)"", false);
            customDT.registerProperty("startbdcurr", String.class, (Object)"", false);
            customDT.registerProperty("reccurr", String.class, (Object)"", false);
            customDT.registerProperty("recbdcurr", String.class, (Object)"", false);
            customDT.registerProperty("paycurr", String.class, (Object)"", false);
            customDT.registerProperty("paybdcurr", String.class, (Object)"", false);
            customDT.registerProperty("endcurr", String.class, (Object)"", false);
            customDT.registerProperty("endbdcurr", String.class, (Object)"", false);
            DataSet dataSet = new CapitalDataSum().query(queryParam, null, false);
            Row row = null;
            DynamicObject capitalsumbody = null;
            String[] currFiled = null;
            StringBuilder periodNameFiled = new StringBuilder();
            if (StringUtils.equals((CharSequence)timeType, (CharSequence)"1")) {
                currFiled = CURR_FILED;
            } else {
                currFiled = CURR_FILED_CALC;
                dataSet = dataSet.addField(periodNameFiled.append("'").append((CharSequence)periodName).append("'").toString(), "periodname");
            }
            String[] currValue = new String[currFiled.length];
            Object currObject = null;
            Integer category = Integer.valueOf((String)paramMap.get("category"));
            String description = "";
            String calcCurr = ((DynamicObject)paramMap.get("calccurrency")).getString("sign");
            Integer calcPrecision = ((DynamicObject)paramMap.get("calccurrency")).getInt("amtprecision");
            DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("currency");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
                currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,sign,amtprecision", null);
            }
            Map<Long, String> currencySign = currencys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("sign")));
            Map<Long, Integer> currencyPrecision = currencys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getInt("amtprecision")));
            while (dataSet.hasNext()) {
                row = dataSet.next();
                capitalsumbody = new DynamicObject(customDT);
                capitalsumbody.set("period", row.get("periodname"));
                capitalsumbody.set("org", row.get("orgname"));
                if (CategoryEnum.CASHANDBANK.getValue().compareTo(category) == 0) {
                    capitalsumbody.set("fundtype", row.get("capitaltype"));
                } else if (CategoryEnum.CASH.getValue().compareTo(category) == 0) {
                    description = (String)row.get("accountnumber");
                    if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CapitalDayDataListPlugin_10", (String)"fi-cas-report", (Object[])new Object[0]), (CharSequence)description)) {
                        capitalsumbody.set("fundtype", (Object)description);
                    }
                }
                capitalsumbody.set("account", row.get("accountbank"));
                if (CategoryEnum.CASH.getValue().compareTo(category) != 0) {
                    capitalsumbody.set("acctpurpose", row.get("acctpurpose"));
                    capitalsumbody.set("bankno", row.get("accountnumber"));
                    capitalsumbody.set("bank", row.get("bankid"));
                }
                for (int i = 0; i < currFiled.length; ++i) {
                    currObject = row.get(currFiled[i]);
                    if (!EmptyUtil.isEmpty((Object)currObject)) {
                        if (currObject instanceof Integer) {
                            currObject = "0";
                        } else if (((BigDecimal)currObject).compareTo(BigDecimal.ZERO) == 0) {
                            currObject = "0";
                        } else {
                            Integer precision = calcPrecision;
                            if (i % 2 == 0) {
                                precision = currencyPrecision.get(row.get("currencyid"));
                            }
                            currObject = CasHelper.formatDecimal((BigDecimal)((BigDecimal)currObject), (int)precision);
                        }
                    } else {
                        currObject = "0";
                    }
                    if (!"0".equals(currObject)) {
                        currObject = i % 2 == 0 ? currencySign.get(row.get("currencyid")) + currObject : calcCurr + currObject;
                    }
                    currValue[i] = currObject;
                }
                capitalsumbody.set("startcurr", (Object)currValue[0]);
                capitalsumbody.set("startbdcurr", (Object)currValue[1]);
                capitalsumbody.set("reccurr", (Object)currValue[2]);
                capitalsumbody.set("recbdcurr", (Object)currValue[3]);
                capitalsumbody.set("paycurr", (Object)currValue[4]);
                capitalsumbody.set("paybdcurr", (Object)currValue[5]);
                capitalsumbody.set("endcurr", (Object)currValue[6]);
                capitalsumbody.set("endbdcurr", (Object)currValue[7]);
                dyns.add(capitalsumbody);
            }
            if (EmptyUtil.isNoEmpty((Object)dataSet)) {
                dataSet.close();
            }
        }
    }
}

