/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.utils.LogOperactionListutils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.fi.cas.cache.CacheHelper;
import kd.fi.cas.cache.CacheModule;
import kd.fi.cas.cache.DistributeCache;
import kd.fi.cas.consts.closeperiod.ClosePeriodResultInfo;
import kd.fi.cas.consts.closeperiod.Tuple;
import kd.fi.cas.report.helper.ReportHelper;

public class CasClosePeriodQueryRpt
extends AbstractReportListDataPlugin {
    private static final String CLOSE_SUCC = "b";
    private static final String CLOSE_FAIL = "c";
    private static final String CHECK_SUCC = "d";
    private static final String CHECK_FAIL = "e";
    private static final Map<String, kd.bos.dataentity.Tuple<String, Class<?>>> cloumMap = new HashMap();
    private String queryType;
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        Long org;
        QFilter orgQfilter = new QFilter("org.fisbankroll", "=", (Object)"1");
        FilterInfo filterInfo = param.getFilter();
        if (filterInfo.getDynamicObjectCollection("periodcloseorg") != null) {
            DynamicObjectCollection dyns = filterInfo.getDynamicObjectCollection("periodcloseorg");
            List orgs = dyns.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            orgQfilter = new QFilter("org", "in", orgs);
        } else {
            Long currentOrgId = RequestContext.get().getOrgId();
            orgQfilter = new QFilter("org", "=", (Object)currentOrgId);
        }
        QFilter checkStatusFilter = new QFilter("checkoutstatus", "in", Arrays.asList("1", "2", "4"));
        DataSet booksTypesDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_finalcheckout", (String)"id booktype,org,period as curperiod", (QFilter[])new QFilter[]{orgQfilter, checkStatusFilter}, null);
        String pageId = param.getCustomParam().get("pageid").toString();
        HashMap<String, String> dealInfo = new HashMap<String, String>();
        List closeRsult = null;
        Map checkPeriod = new HashMap();
        String closeResultCache = this.cache.get(pageId + "closeresult");
        String checkPeriodCache = this.cache.get(pageId + "checkperiod");
        if (StringUtils.isNotEmpty((CharSequence)closeResultCache)) {
            closeRsult = (List)JSONUtils.cast((String)closeResultCache, List.class);
            if (!CollectionUtils.isEmpty((Collection)closeRsult)) {
                for (String string : closeRsult) {
                    ClosePeriodResultInfo info = (ClosePeriodResultInfo)SerializationUtils.deSerializeFromBase64((String)string);
                    String key = info.getOrg() + "_";
                    dealInfo.put(key, info.isSuccess() ? CLOSE_SUCC : CLOSE_FAIL);
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)checkPeriodCache)) {
            checkPeriod = (Map)SerializationUtils.deSerializeFromBase64((String)checkPeriodCache);
            for (Map.Entry entry : checkPeriod.entrySet()) {
                Tuple value = (Tuple)entry.getValue();
                dealInfo.put((String)entry.getKey(), (Boolean)value.item1 != false ? CHECK_SUCC : CHECK_FAIL);
            }
            this.queryType = "checkperiod";
        }
        AtomicLong rowId = new AtomicLong(1111L);
        RowMeta rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)booksTypesDataSet.getRowMeta(), (String)"pid", (DataType)DataType.LongType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"rowid", (DataType)DataType.LongType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"isgroupnode", (DataType)DataType.LongType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"status", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"checkitem", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"dealfail", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"formquery", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"formnumber", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"message", (DataType)DataType.StringType);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (Object row : booksTypesDataSet.copy()) {
            Row row2 = RowUtil.persist((Row)row);
            Long org2 = row.getLong("org");
            String status = (String)dealInfo.get(org2 + "_");
            boolean isSucc = StringUtils.isEmpty((CharSequence)status) || CLOSE_SUCC.equals(status) || CHECK_SUCC.equals(status);
            Object[] rowValues = RowUtil.toArray((Row)row2);
            int len = rowValues.length;
            Object[] newValues = new Object[len + 9];
            System.arraycopy(rowValues, 0, newValues, 0, len);
            newValues[len] = 0L;
            newValues[len + 1] = rowId.getAndAdd(1L);
            newValues[len + 2] = isSucc ? 0L : 1L;
            newValues[len + 3] = status;
            if (!isSucc && StringUtils.isEmpty((CharSequence)this.cache.get(pageId + "viewall"))) {
                newValues[len + 4] = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CasClosePeriodQueryRpt_3", (String)"fi-cas-report", (Object[])new Object[0]);
            }
            rows.add(newValues);
        }
        booksTypesDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(rows.iterator(), rowMeta9);
        DataSet result = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(Collections.emptyIterator(), booksTypesDataSet.getRowMeta());
        if (null != closeRsult && !CollectionUtils.isEmpty((Collection)closeRsult)) {
            for (String string : closeRsult) {
                DynamicObject sd;
                DynamicObjectCollection checkItemColl;
                ClosePeriodResultInfo info = (ClosePeriodResultInfo)SerializationUtils.deSerializeFromBase64((String)string);
                org = info.getOrg();
                String orgAndBook = org + "_";
                String requestId = info.getRequestId();
                if (info.isSuccess()) continue;
                String closeKey = "CLOSE_PERIOD." + requestId + "_" + orgAndBook;
                DataSet filterDs = booksTypesDataSet.copy().filter("org=" + org);
                String s = this.cache.get(closeKey);
                if (!StringUtils.isNotBlank((CharSequence)s) || (checkItemColl = (sd = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)s, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem"))).getDynamicObjectCollection("entryentity")).size() == 0) continue;
                result = result.union(this.getResultDs(filterDs, checkItemColl, rowId));
            }
        } else if (!CollectionUtils.isEmpty(checkPeriod)) {
            for (Map.Entry entry : checkPeriod.entrySet()) {
                String org2bookstype = (String)entry.getKey();
                org = Long.parseLong(org2bookstype.split("_")[0]);
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)((Tuple)entry.getValue()).item2))) continue;
                DynamicObjectCollection entryEntity = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)((String)((Tuple)entry.getValue()).item2));
                DataSet filterDs = booksTypesDataSet.copy().filter("org=" + org);
                result = result.union(this.getResultDs(filterDs, entryEntity, rowId));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cache.get(pageId + "viewall"))) {
            List<QFilter> qFilters = ReportHelper.tableHeadFilter2QFilters(filterInfo.getTableHeadFilterItems(), cloumMap);
            for (QFilter qFilter : qFilters) {
                result = result.filter(qFilter.toString());
            }
        }
        booksTypesDataSet = booksTypesDataSet.union(result).orderBy(new String[]{"booktype", "rowid"});
        return booksTypesDataSet;
    }

    private String getFailUrl(String menuid) {
        String rootUrl = UrlService.getDomainContextUrl();
        if (rootUrl.endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        menuid = menuid.startsWith("/") ? rootUrl + menuid : rootUrl + "/" + menuid;
        return menuid;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if ("checkperiod".equals(this.queryType)) {
            for (ReportColumn reportColumn : columns) {
                if (!"status".equals(reportColumn.getFieldKey())) continue;
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c", (String)"CasClosePeriodQueryRpt_0", (String)"fi-cas-report", (Object[])new Object[0])));
            }
        }
        return columns;
    }

    private Map<String, Integer> getAllColumnIndex(RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            indexs.put(fields[i].getAlias(), i);
        }
        return indexs;
    }

    private DataSet getResultDs(DataSet filterDs, DynamicObjectCollection entryentity, AtomicLong rowid) {
        ArrayList<Object[]> seqRows = new ArrayList<Object[]>();
        int length = filterDs.getRowMeta().getFields().length;
        List entityList = entryentity.stream().sorted(Comparator.comparing(entity -> {
            if ("1".equals(entity.getString("checkstate"))) {
                return 1;
            }
            return 0;
        })).collect(Collectors.toList());
        Map<String, Integer> allIndex = this.getAllColumnIndex(filterDs.getRowMeta());
        for (DynamicObject dyn : entityList) {
            Object[] newValues = new Object[length];
            for (Row row : filterDs.copy()) {
                Object[] rowValues = RowUtil.toArray((Row)row);
                int len = rowValues.length;
                System.arraycopy(rowValues, 0, newValues, 0, len);
                newValues[allIndex.get((Object)"checkitem").intValue()] = dyn.getString("checkitem");
                newValues[allIndex.get((Object)"dealfail").intValue()] = this.getFailUrl(dyn.getString("menuid"));
                newValues[allIndex.get((Object)"pid").intValue()] = row.getLong("rowid");
                newValues[allIndex.get((Object)"isgroupnode").intValue()] = 0;
                newValues[allIndex.get((Object)"rowid").intValue()] = rowid.getAndAdd(1L);
                newValues[allIndex.get((Object)"formquery").intValue()] = dyn.getString("formquery");
                newValues[allIndex.get((Object)"formnumber").intValue()] = dyn.getString("formnumber");
                newValues[allIndex.get((Object)"message").intValue()] = dyn.getString("message");
                newValues[allIndex.get((Object)"dealfail").intValue()] = "1".equals(dyn.getString("checkstate")) ? ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"CasClosePeriodQueryRpt_1", (String)"fi-cas-report", (Object[])new Object[0]) : (StringUtils.isEmpty((CharSequence)dyn.getString("message")) ? ResManager.loadKDString((String)"\u5904\u7406", (String)"CasClosePeriodQueryRpt_2", (String)"fi-cas-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CasClosePeriodQueryRpt_3", (String)"fi-cas-report", (Object[])new Object[0]));
                newValues[allIndex.get((Object)"status").intValue()] = "";
                newValues[allIndex.get((Object)"org").intValue()] = 0L;
                newValues[allIndex.get((Object)"curperiod").intValue()] = 0L;
                seqRows.add(newValues);
            }
        }
        DataSet ds = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(seqRows.iterator(), filterDs.getRowMeta());
        return ds;
    }

    static {
        cloumMap.put("status", kd.bos.dataentity.Tuple.create((Object)"status", String.class));
        cloumMap.put("checkitem", kd.bos.dataentity.Tuple.create((Object)"checkitem", String.class));
        cloumMap.put("dealfail", kd.bos.dataentity.Tuple.create((Object)"dealfail", String.class));
    }
}

