/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.CategoryEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;

public class CapitalDayFormListPlugin
extends AbstractReportFormPlugin {
    private static final String ACCOUNTSIC = "org.name,id,name,org.id,openorg,openorg.id,openorg.name,bank.finorgtype.name,bank.bank_cate.name,bank.name,acctproperty,bankaccountnumber accountnumber";
    private static Map<String, String> filterInfoMap = new HashMap<String, String>();

    public void afterCreateColumn(CreateColumnEvent event) {
        ReportQueryParam queryParam = event.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String queryorgtype = filterInfo.getString("queryorgtype");
        if (filterInfoMap.containsKey(queryorgtype)) {
            String delFiledColumn = filterInfoMap.get(queryorgtype);
            List columns = event.getColumns();
            for (int i = columns.size() - 1; i >= 0; --i) {
                ReportColumn column;
                if (!(columns.get(i) instanceof ReportColumn) || !delFiledColumn.equals((column = (ReportColumn)columns.get(i)).getFieldKey())) continue;
                columns.remove(columns.get(i));
            }
        }
    }

    private DynamicObjectCollection getDyobj(FilterInfo filterInfo, String field) {
        Object fieldValue = filterInfo.getValue(field);
        if (fieldValue instanceof DynamicObjectCollection) {
            return filterInfo.getDynamicObjectCollection(field);
        }
        List orgIds = (List)filterInfo.getValue(field);
        return this.queryDyCols("bos_org", orgIds);
    }

    private DynamicObjectCollection queryDyCols(String formId, List<Long> pkIds) {
        if (pkIds == null || pkIds.size() == 0) {
            return new DynamicObjectCollection();
        }
        QFilter filter = new QFilter("id", "in", pkIds);
        return QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])filter.toArray());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        String queryorgtype = (String)this.getModel().getValue("queryorgtype");
        if (filterInfo != null) {
            DynamicObject exratetable;
            DynamicObjectCollection org = this.getDyobj(filterInfo, "filter_company");
            DynamicObjectCollection openOrg = this.getDyobj(filterInfo, "openorg");
            if ((org == null || org.isEmpty()) && "org".equals(queryorgtype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalDayFormListPlugin_3", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if ((openOrg == null || openOrg.isEmpty()) && "openorg".equals(queryorgtype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u6237\u516c\u53f8\u201d\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalDayFormListPlugin_4", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object date = filterInfo.getValue("filter_date");
            if (date == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u6761\u4ef6\u3002", (String)"CapitalDayFormListPlugin_1", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (org != null && "org".equals(queryorgtype)) {
                List orgIdList = org.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                Map periodDateMap = PeriodHelper.geBatchPeriodByDate(orgIdList, (Date)((Date)date));
                for (Map.Entry entry : periodDateMap.entrySet()) {
                    if (entry.getValue() != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CapitalDayFormListPlugin_2", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            } else {
                DynamicObjectCollection coll;
                DynamicObjectCollection coll2;
                DynamicObjectCollection coll3;
                HashSet useOrgIds = new HashSet();
                ArrayList<QFilter> accountFilter = new ArrayList<QFilter>(10);
                ArrayList<Long> comListOpenOrg = new ArrayList<Long>();
                Map<String, Object> paramMap = this.transQueryParam(queryParam);
                DynamicObjectCollection openorgs = (DynamicObjectCollection)paramMap.get("openorg");
                if (openorgs != null) {
                    for (DynamicObject openorg : openorgs) {
                        comListOpenOrg.add(openorg.getLong("id"));
                    }
                }
                QFilter openOrgIdFilter = null;
                if (!comListOpenOrg.isEmpty()) {
                    openOrgIdFilter = new QFilter("openorg.id", "in", comListOpenOrg);
                }
                accountFilter.add(openOrgIdFilter);
                QFilter bankFilter = null;
                if (paramMap.get("filter_bankaccountnumber") != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(coll3 = (DynamicObjectCollection)paramMap.get("filter_bankaccountnumber")))) {
                    bankFilter = new QFilter("id", "in", (Object)coll3.stream().map(DataEntityBase::getPkValue).toArray());
                }
                accountFilter.add(bankFilter);
                QFilter acctpropertyFilter = null;
                if (paramMap.get("accountproperty") != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(coll2 = (DynamicObjectCollection)paramMap.get("accountproperty")))) {
                    acctpropertyFilter = new QFilter("acctproperty", "in", (Object)coll2.stream().map(DataEntityBase::getPkValue).toArray());
                }
                accountFilter.add(acctpropertyFilter);
                QFilter bankidFilter = null;
                if (paramMap.get("bank") != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(coll = (DynamicObjectCollection)paramMap.get("bank")))) {
                    bankidFilter = new QFilter("bank", "in", (Object)coll.stream().map(DataEntityBase::getPkValue).toArray());
                }
                accountFilter.add(bankidFilter);
                accountFilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                DataSet accountBankDataSet = this.queryBankDataByOrgIds(accountFilter.toArray(new QFilter[accountFilter.size()]));
                for (Row row : accountBankDataSet) {
                    long acctId = row.getLong("id");
                    useOrgIds.addAll(AccountBankHelper.getUserAuthorityOrgs((Long)acctId));
                }
                List orgIdList = useOrgIds.stream().map(d -> Long.getLong("id")).filter(Objects::nonNull).collect(Collectors.toList());
                Map periodDateMap = PeriodHelper.geBatchPeriodByDate(orgIdList, (Date)((Date)date));
                for (Map.Entry entry : periodDateMap.entrySet()) {
                    if (entry.getValue() != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CapitalDayFormListPlugin_2", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            }
            if ((exratetable = (DynamicObject)filterInfo.getValue("exratetable")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_9", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            DynamicObject currency = (DynamicObject)filterInfo.getValue("filter_currency");
            if (currency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_90", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    private DataSet queryBankDataByOrgIds(QFilter[] filter) {
        DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)"AccountBank", (String)"bd_accountbanks", (String)ACCOUNTSIC, (QFilter[])filter, null);
        DataSet acctpurposeSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_acctpurpose", (String)"id,name as acctpurpose", null, (String)"");
        return accountDataSet.join(acctpurposeSet, JoinType.LEFT).on("acctproperty", "id").select(accountDataSet.getRowMeta().getFieldNames(), new String[]{"acctpurpose"}).finish();
    }

    private void queryOrgTypeChange(String queryOrgType) {
        if ("org".equals(queryOrgType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_company"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"openorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_accountcash"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"openorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_company"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_accountcash"});
        }
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idList.add((Long)((DynamicObject)coll.get(i)).getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String queryorgtype = (String)this.getModel().getValue("queryorgtype");
        this.queryOrgTypeChange(queryorgtype);
        if ("org".equals(queryorgtype)) {
            this.defaultOrg();
        } else {
            this.defaultOpenOrg();
        }
        this.initNotBalanceModel();
    }

    protected void defaultOrg() {
        DynamicObject baseCurrency;
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("filter_company");
        Long fisBankRollOrg = this.getFisBankRollOrg();
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List orgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankjournalformrpt", (String)"47150e89000000ac");
        Object[] arrObj = new Object[]{};
        if (org.isEmpty() && !orgList.isEmpty()) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgList), new QFilter("isfinishinit", "=", (Object)"1")}, null);
            if (fisBankRollOrg != null) {
                DynamicObjectCollection queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (!queryFisBankRollOrg.isEmpty()) {
                    this.getModel().setValue("filter_company", (Object)new Object[]{fisBankRollOrg});
                    arrObj = new Object[]{fisBankRollOrg};
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                } else if (!coll.isEmpty()) {
                    long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                    arrObj = new Object[]{orgId};
                    this.getModel().setValue("filter_company", (Object)arrObj);
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                }
            }
        }
        if (!CasHelper.isEmpty((Object)arrObj) && arrObj.length > 0 && (baseCurrency = OrgHelper.getBaseCurrency((long)((Long)arrObj[0]))) != null) {
            this.getModel().setValue("filter_currency", baseCurrency.getPkValue());
        }
    }

    private void defaultOpenOrg() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("openorg");
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set openOrgList = OrgHelper.getAuthAcctOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankjournalformrpt", (String)"47150e89000000ac");
        if (org.isEmpty() && !openOrgList.isEmpty()) {
            long currentOrgId = RequestContext.get().getOrgId();
            Long openOrgId = (Long)openOrgList.toArray()[0];
            if (openOrgList.contains(currentOrgId)) {
                openOrgId = currentOrgId;
            }
            Object[] arrObj1 = new Object[]{openOrgId};
            this.getModel().setValue("openorg", (Object)arrObj1);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7("cas_bankjournalformrpt");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        if ("filter_company".equals(pro) && (CasHelper.isEmpty((Object)this.getModel().getValue("filter_company")) || !Objects.equals(oldValue, newValue))) {
            this.getModel().setValue("filter_bankaccountnumber", null);
            this.getModel().setValue("filter_accountcash", null);
            this.initSelectedBox(true);
            return;
        }
        if ("openorg".equals(pro) && (CasHelper.isEmpty((Object)this.getModel().getValue("openorg")) || !Objects.equals(oldValue, newValue))) {
            this.getModel().setValue("filter_bankaccountnumber", null);
            this.getModel().setValue("filter_accountcash", null);
            this.initSelectedBox(false);
            return;
        }
        if ("queryorgtype".equals(pro)) {
            String orgType = (String)this.getModel().getValue("queryorgtype");
            this.queryOrgTypeChange(orgType);
            if ("org".equals(orgType)) {
                this.getModel().setValue("openorg", null);
                this.defaultOrg();
            } else if ("openorg".equals(orgType)) {
                this.getModel().setValue("filter_company", null);
                this.defaultOpenOrg();
            }
            this.getModel().setValue("filter_bankaccountnumber", null);
            this.getModel().setValue("filter_accountcash", null);
        }
        if ("category".equals(pro)) {
            this.categoryChange(newValue);
        }
    }

    private void initSelectedBox(boolean showCash) {
        ComboEdit seldimensionBox = (ComboEdit)this.getView().getControl("category");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (showCash) {
            items.add(new ComboItem(new LocaleString(CategoryEnum.CASHANDBANK.getName()), CategoryEnum.CASHANDBANK.getValue().toString()));
        }
        items.add(new ComboItem(new LocaleString(CategoryEnum.BANK.getName()), CategoryEnum.BANK.getValue().toString()));
        if (showCash) {
            items.add(new ComboItem(new LocaleString(CategoryEnum.CASH.getName()), CategoryEnum.CASH.getValue().toString()));
        }
        seldimensionBox.setComboItems(items);
        this.getModel().setValue("category", (Object)((ComboItem)items.get(0)).getValue());
    }

    private void categoryChange(Object propValue) {
        String queryOrgType = (String)this.getModel().getValue("queryorgtype");
        boolean isOrg = "org".equals(queryOrgType);
        if (propValue.equals("1")) {
            this.getModel().setValue("seldimension", (Object)1);
            this.getModel().setValue("accountproperty", (Object)new Object[]{"183705600155241472"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bank"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_bankaccountnumber"});
        } else if (propValue.equals("2")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
            this.getModel().setValue("accountproperty", (Object)new Object[0]);
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_bankaccountnumber"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"accountproperty"});
            this.getModel().setValue("accountproperty", (Object)new Object[0]);
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountproperty"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bank"});
            this.getView().setVisible(Boolean.valueOf(isOrg), new String[]{"filter_accountcash"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filter_bankaccountnumber"});
        }
    }

    public void beforeQuery(ReportQueryParam param) {
        Long orgId;
        DynamicObjectCollection companys;
        Map<String, Object> map;
        if (param.getFilter().getFilterItem("filter_company") != null && param.getFilter().getFilterItem("filter_company").getValue() == null) {
            RequestContext context = RequestContext.get();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgs = OrgHelper.getAuthBankOrgIds((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (orgs.size() > 0) {
                param.getFilter().getFilterItem("filter_company").setValue((Object)orgs);
            }
        }
        DynamicObject filterCurrencyObj = (DynamicObject)this.getModel().getValue("filter_currency");
        Long currency = null;
        if (filterCurrencyObj != null) {
            currency = (Long)filterCurrencyObj.getPkValue();
        }
        param.getFilter().addFilterItem("currency", (Object)currency);
        DynamicObject baseCurrencySel = null;
        if (currency == null && param.getFilter().getFilterItem("currency") != null && param.getFilter().getFilterItem("currency").getValue() == null && (map = this.transQueryParam(param)).get("filter_company") != null && map.get("filter_company") != "" && !(companys = (DynamicObjectCollection)map.get("filter_company")).isEmpty() && (baseCurrencySel = OrgHelper.getBaseCurrency((long)(orgId = Long.valueOf(((DynamicObject)companys.get(0)).getLong("id"))))) != null) {
            param.getFilter().getFilterItem("currency").setValue(baseCurrencySel.getPkValue());
            this.getModel().setValue("filter_currency", baseCurrencySel.getPkValue());
        }
        Date date = CasHelper.isEmpty((Object)this.getModel().getValue("filter_date")) ? null : (Date)this.getModel().getValue("filter_date");
        param.getFilter().addFilterItem("filter_date", (Object)date);
        param.getFilter().getFilterItem("filter_date").setValue((Object)date);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        param.getFilter().addFilterItem("currencyunit", (Object)currencyUnit);
        super.beforeQuery(param);
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)requestContext.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (authorizedBankOrgId != null && !authorizedBankOrgId.isEmpty()) {
            return (Long)authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    protected QFilter[] getAcctFilter(List<Long> orgPks) {
        String queryOrgType = (String)this.getModel().getValue("queryorgtype");
        QFilter[] accountFilter = null;
        accountFilter = "org".equals(queryOrgType) ? new QFilter[]{AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgPks)} : new QFilter[]{new QFilter("openorg", "in", orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    private void initF7(String rptEntity) {
        boolean isTrue = true;
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("filter_company");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (orgCtrl.getQFilter() == null) {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)(isTrue ? "1" : "0"))}, null);
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                F7FilterUtil.bankrollOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)rptEntity, (String)"47150e89000000ac", (List)OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        });
        BasedataEdit openOrgCtrl = (BasedataEdit)this.getControl("openorg");
        openOrgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (openOrgCtrl.getQFilter() == null) {
                String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
                F7FilterUtil.accountingOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)rptEntity, (String)"47150e89000000ac", null);
            }
        });
        BasedataEdit bankNum = (BasedataEdit)this.getControl("filter_bankaccountnumber");
        bankNum.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String queryOrgType = (String)this.getModel().getValue("queryorgtype");
            String orgFilter = "";
            orgFilter = "org".equals(queryOrgType) ? "filter_company" : "openorg";
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue(orgFilter);
            if (null != orgColl && orgColl.size() == 0) {
                QFilter qFilter = new QFilter("org.id", "in", new ArrayList());
                new LspWapper(beforeF7SelectEvent).setFilters(new QFilter[]{qFilter});
            } else {
                new LspWapper(beforeF7SelectEvent).setFilters(this.getAcctFilter(this.getIdList(orgColl)));
            }
        });
        BasedataEdit accountcash = (BasedataEdit)this.getControl("filter_accountcash");
        accountcash.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter;
            ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String queryOrgType = (String)this.getModel().getValue("queryorgtype");
            if (CasHelper.isEmpty((Object)this.getModel().getValue("filter_company")) || "openorg".equals(queryOrgType)) {
                qFilter = new QFilter("id", "=", (Object)0);
            } else {
                DynamicObjectCollection filterCompany = (DynamicObjectCollection)this.getModel().getValue("filter_company");
                qFilter = new QFilter("org.id", "in", filterCompany.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList()));
            }
            lsp.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit bankCtrl = (BasedataEdit)this.getControl("bank");
        bankCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter notVirtualBankQf = VisibleVirtualAcctHelper.notVirtualBankQf();
            if (CasHelper.isNotEmpty((Object)notVirtualBankQf)) {
                lsp.getListFilterParameter().setFilter(notVirtualBankQf);
            }
        });
    }

    protected Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    private void initNotBalanceModel() {
        if (ExtendConfigHelper.useBalanceModel()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"queryorgtype"});
        }
    }

    static {
        filterInfoMap.put("org", "openorgfield");
        filterInfoMap.put("openorg", "company");
    }
}

