/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.qing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.report.qing.AbstractCasQingAnlsListPlugin;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;

public class CapitalDayQingAnlsListPlugin
extends AbstractCasQingAnlsListPlugin {
    public void afterCreateNewData(EventObject e) {
        DynamicObject baseCurrency;
        super.afterCreateNewData(e);
        Long fisBankRollOrg = this.getFisBankRollOrg();
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankjournalformrpt", (String)"47150e89000000ac");
        Object[] arrObj = null;
        if (orgList.size() > 0) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgList), new QFilter("isfinishinit", "=", (Object)"1")}, null);
            if (fisBankRollOrg != null) {
                DynamicObjectCollection queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null);
                if (queryFisBankRollOrg.size() > 0) {
                    arrObj = new Object[]{fisBankRollOrg};
                    this.getModel().setValue("filter_company", (Object)arrObj);
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                } else if (coll.size() > 0) {
                    long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                    arrObj = new Object[]{orgId};
                    this.getModel().setValue("filter_company", (Object)arrObj);
                    DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
                    this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
                }
            }
        }
        if (!EmptyUtil.isEmpty(arrObj) && (baseCurrency = OrgHelper.getBaseCurrency((long)((Long)arrObj[0]))) != null) {
            this.getModel().setValue("filter_currency", baseCurrency.getPkValue());
        }
    }

    @Override
    protected void verifyQueryParam(Map<String, Object> paramMap) {
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("filter_company");
            if (org == null || org.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d44\u91d1\u7ec4\u7ec7\u6761\u4ef6\u3002", (String)"CapitalDayQingAnlsListPlugin_0", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object date = filterInfo.getValue("filter_date");
            if (date == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u6761\u4ef6\u3002", (String)"CapitalDayQingAnlsListPlugin_1", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            for (DynamicObject o : org) {
                if (PeriodHelper.getPeriodByDate((long)o.getLong("id"), (Date)((Date)date)) != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CapitalDayQingAnlsListPlugin_2", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            DynamicObject exratetable = (DynamicObject)filterInfo.getValue("exratetable");
            if (exratetable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_9", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            DynamicObject calccurrency = (DynamicObject)filterInfo.getValue("filter_currency");
            if (calccurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u79cd\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapitalSumFormRpt_10", (String)"fi-cas-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(requestContext.getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (authorizedBankOrgId != null && authorizedBankOrgId.size() > 0) {
            return (Long)authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    @Override
    protected void initOtherQueryParam(Map<String, Object> paramMap) {
        ArrayList<String> comIdList = new ArrayList<String>();
        if (paramMap.get("filter_company") != null && paramMap.get("filter_company") != "") {
            DynamicObjectCollection companys = (DynamicObjectCollection)paramMap.get("filter_company");
            for (Object company : companys) {
                String comID = company.get("id").toString();
                comIdList.add(comID);
            }
        }
        paramMap.put("filter_company", comIdList);
        ArrayList<String> bankAccIdList = new ArrayList<String>();
        if (paramMap.get("filter_bankaccountnumber") != null && paramMap.get("filter_bankaccountnumber") != "") {
            DynamicObjectCollection bankAccs = (DynamicObjectCollection)paramMap.get("filter_bankaccountnumber");
            for (Object bankAcc : bankAccs) {
                String bankAccID = bankAcc.get("id").toString();
                bankAccIdList.add(bankAccID);
            }
        }
        paramMap.put("filter_bankaccountnumber", bankAccIdList);
        ArrayList<String> accCashIdList = new ArrayList<String>();
        if (paramMap.get("filter_accountcash") != null && paramMap.get("filter_accountcash") != "") {
            DynamicObjectCollection accCashs = (DynamicObjectCollection)paramMap.get("filter_accountcash");
            for (DynamicObject accCash : accCashs) {
                String accCashID = accCash.get("id").toString();
                accCashIdList.add(accCashID);
            }
        }
        paramMap.put("filter_accountcash", accCashIdList);
        if (paramMap.get("filter_currency") != null && paramMap.get("filter_currency") != "") {
            DynamicObject repCurrency = (DynamicObject)paramMap.get("filter_currency");
            paramMap.put("filter_currency", repCurrency.getLong("id"));
        }
        Date date = CasHelper.isEmpty((Object)this.getModel().getValue("filter_date")) ? null : (Date)this.getModel().getValue("filter_date");
        paramMap.put("filter_date", date);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        paramMap.put("filter_currencyunit", currencyUnit);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        if ("filter_company".equals(pro)) {
            String userId = RequestContext.get().getUserId();
            if (!CasHelper.isEmpty((Object)this.getModel().getValue("filter_company"))) {
                HashSet<Long> orgIdSet = new HashSet<Long>(this.getIdList((DynamicObjectCollection)newValue));
                DynamicObjectCollection filterBankAcct = (DynamicObjectCollection)this.getModel().getValue("filter_bankaccountnumber");
                for (DynamicObject acct : filterBankAcct) {
                    Long orgId = (Long)acct.getDynamicObject("fbasedataid").getDynamicObject("org").getPkValue();
                    if (orgIdSet.contains(orgId)) continue;
                    this.getModel().setValue("filter_bankaccountnumber", null);
                    break;
                }
                DynamicObjectCollection filterBankAcctCash = (DynamicObjectCollection)this.getModel().getValue("filter_accountcash");
                for (DynamicObject acct : filterBankAcctCash) {
                    Long orgId = (Long)acct.getDynamicObject("fbasedataid").getDynamicObject("org").getPkValue();
                    if (orgIdSet.contains(orgId)) continue;
                    this.getModel().setValue("filter_accountcash", null);
                    break;
                }
            } else if (CasHelper.isEmpty((Object)this.getModel().getValue("filter_company")) || !oldValue.equals(newValue)) {
                this.getModel().setValue("filter_bankaccountnumber", null);
                this.getModel().setValue("filter_accountcash", null);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7("cas_bankjournalformrpt");
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (DynamicObject org : coll) {
            idList.add((Long)org.getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    protected QFilter[] getAcctFilter(List<Long> orgPks) {
        QFilter[] accountFilter = null;
        accountFilter = new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    private void initF7(String rptEntity) {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("filter_company");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (orgCtrl.getQFilter() == null) {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)"1")}, null);
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                F7FilterUtil.bankrollOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)rptEntity, (String)"47150e89000000ac", (List)OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        });
        BasedataEdit bankNum = (BasedataEdit)this.getControl("filter_bankaccountnumber");
        bankNum.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("filter_company");
            if (null != orgColl && orgColl.size() == 0) {
                QFilter qFilter = new QFilter("org.id", "in", new ArrayList());
                new LspWapper(beforeF7SelectEvent).setFilters(new QFilter[]{qFilter});
            } else {
                new LspWapper(beforeF7SelectEvent).setFilters(this.getAcctFilter(this.getIdList(orgColl)));
            }
        });
        BasedataEdit accountcash = (BasedataEdit)this.getControl("filter_accountcash");
        accountcash.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter;
            ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (CasHelper.isEmpty((Object)this.getModel().getValue("filter_company"))) {
                qFilter = new QFilter("id", "=", (Object)0);
            } else {
                DynamicObjectCollection filter_company = (DynamicObjectCollection)this.getModel().getValue("filter_company");
                qFilter = new QFilter("org.id", "in", filter_company.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList()));
            }
            lsp.getListFilterParameter().setFilter(qFilter);
        });
    }
}

