/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;

public class AccountCashOpenOrgUpdateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("org.fisaccounting");
        e.getFieldKeys().add("org.orgpattern");
        e.getFieldKeys().add("openorg");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] infos;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : infos = e.getDataEntities()) {
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject accountOrg = OrgHelper.getAccountOrgByFundsOrg((DynamicObject)org);
            if (accountOrg != null) {
                DynamicObjectHelper.setValue((DynamicObject)info, (String)"openorg", (Object)accountOrg);
                continue;
            }
            OperateErrorInfo error = new OperateErrorInfo();
            error.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u627e\u5230\u8d44\u91d1\u7ec4\u7ec7\u5bf9\u5e94\u7684\u5f00\u6237\u7ec4\u7ec7\u3002", (String)"AccountCashOpenOrgUpdateOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), info.getString("number")));
            error.setLevel(ErrorLevel.Error);
            this.getOperationResult().addErrorInfo(error);
            this.getOperationResult().getSuccessPkIds().remove(info.getPkValue());
        }
        SaveServiceHelper.save((DynamicObject[])infos);
    }
}

