/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.book.jourrnalbook.book.BookJournalService;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.business.pojo.PayEntryStatusInfo;
import kd.fi.cas.business.pojo.PayStatusInfo;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.AgentPayBillIsFreezeValidator;
import kd.fi.cas.validator.AgentPayBillWriteValidator;
import kd.fi.cas.validator.AgentPayValidator;
import kd.sdk.fi.cas.extpoint.recbill.IAgentPayField;

public class AgentPayPayOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(AgentPayServiceHelper.getSelectors());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] agentPayBillDts = e.getDataEntities();
        List agentIdList = Arrays.stream(agentPayBillDts).map(o -> o.getLong("id")).collect(Collectors.toList());
        Set sourceBillNoList = Arrays.stream(agentPayBillDts).filter(o -> !StringUtils.isBlank((String)o.getString("sourcebillnumber"))).map(o -> o.getString("sourcebillnumber")).collect(Collectors.toSet());
        ArrayList<DynamicObject> agentPayBillList = new ArrayList<DynamicObject>(10);
        DynamicObject[] agentPaySourceBillList = AgentPayServiceHelper.getSourceAgentBillList(agentIdList);
        List agentErrSourceBillIdList = Arrays.stream(agentPaySourceBillList).filter(o -> !"repay".equals(o.getString("sourcebilltype"))).map(o -> o.getLong("id")).collect(Collectors.toList());
        for (DynamicObject agentPaySourceBill : agentPaySourceBillList) {
            if (!sourceBillNoList.contains(agentPaySourceBill.getString("billno"))) continue;
            agentPayBillList.add(agentPaySourceBill);
        }
        Set<Long> orgIds = ((Stream)Arrays.stream(agentPayBillDts).parallel()).filter(d -> CasHelper.isNotEmpty((Object)d.getDynamicObject("org")) && CasHelper.isNotEmpty((Object)d.getDynamicObject("org").getLong("id"))).map(d -> d.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map pushMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs088");
        ArrayList<DynamicObject> pushBills = new ArrayList<DynamicObject>();
        DynamicObject[] agentPaySourceBills = BusinessDataServiceHelper.load((Object[])agentIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_agentpaybill"));
        agentPayBillList.addAll(Arrays.asList(agentPaySourceBills));
        for (DynamicObject info : e.getDataEntities()) {
            boolean isPush;
            if (!AgentPayBillHelper.isDelegPush((DynamicObject)info)) continue;
            String orgId = info.getDynamicObject("org").getString("id");
            boolean bl = isPush = EmptyUtil.isEmpty((String)orgId) ? false : (Boolean)pushMap.get(orgId);
            if (!isPush) continue;
            pushBills.add(info);
        }
        Map params = this.getOption().getVariables();
        for (DynamicObject info : agentPayBillList) {
            Object agreeRate;
            if (info.getBoolean("isdiffcur") && (agreeRate = params.get("agreedrate")) != null) {
                BigDecimal dpAmt = new BigDecimal((String)params.get("dpamt"));
                BigDecimal fee = new BigDecimal((String)params.get("fee"));
                info.set("dpamt", (Object)dpAmt);
                info.set("agreedrate", agreeRate);
                info.set("fee", (Object)fee);
                BigDecimal dpExchangeRate = info.getBigDecimal("dpexchangerate");
                DynamicObject basecurrency = info.getDynamicObject("basecurrency");
                String dppayquotation = info.getString("dppayquotation");
                String agreedquotation = info.getString("agreedquotation");
                BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)basecurrency.getInt("amtprecision"));
                BigDecimal localAmt = info.getBigDecimal("localamt");
                info.set("dplocalamt", (Object)dpLocalAmt);
                info.set("lossamt", (Object)localAmt.subtract(dpLocalAmt));
                BigDecimal payAmount = info.getBigDecimal("payamount");
                BigDecimal agreedrate = info.getBigDecimal("agreedrate");
                DynamicObject dpcurrency = info.getDynamicObject("dpcurrency");
                BigDecimal sumDpamt = BigDecimal.ZERO;
                BigDecimal sumDpLocalamt = BigDecimal.ZERO;
                BigDecimal sumEFee = BigDecimal.ZERO;
                DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
                for (int i = 0; i < entry.size(); ++i) {
                    DynamicObject row = (DynamicObject)entry.get(i);
                    BigDecimal edpamt = BigDecimal.ZERO;
                    BigDecimal edplocalamt = BigDecimal.ZERO;
                    BigDecimal efee = BigDecimal.ZERO;
                    if (i == entry.size() - 1) {
                        edpamt = dpAmt.subtract(sumDpamt);
                        edplocalamt = dpLocalAmt.subtract(sumDpLocalamt);
                        efee = fee.subtract(sumEFee);
                    } else {
                        String encryptAmt = row.getString("e_encryptamount");
                        BigDecimal eamount = AgentPayBillHelper.decodeAmount((String)encryptAmt);
                        edpamt = dpcurrency != null ? QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)dpcurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)10);
                        sumDpamt = sumDpamt.add(edpamt);
                        edplocalamt = QuotationHelper.callToCurrency((BigDecimal)edpamt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)basecurrency.getInt("amtprecision"));
                        sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
                        if (dpcurrency != null) {
                            efee = fee.multiply(eamount.divide(payAmount, 10, 4)).setScale(dpcurrency.getInt("amtprecision"), 4);
                        }
                        sumEFee = sumEFee.add(efee);
                    }
                    row.set("e_dpamt", (Object)edpamt);
                    row.set("e_dplocalamt", (Object)edplocalamt);
                    row.set("e_fee", (Object)efee);
                    row.set("e_paytime", (Object)new Date());
                }
            }
            PayStatusInfo payStatus = new PayStatusInfo();
            payStatus.setId(((Long)info.getPkValue()).longValue());
            payStatus.setPayMode(PayStatusInfo.PayMode.OffLine);
            ArrayList<PayEntryStatusInfo> entryStatus = new ArrayList<PayEntryStatusInfo>();
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                entryStatus.add(new PayEntryStatusInfo(((Long)row.getPkValue()).longValue(), true, null));
            }
            payStatus.setEntryStatus(entryStatus);
            AgentPayBillHelper.decodeAmount((DynamicObject)info);
            AgentPayServiceHelper.updateAgentPayBill((PayStatusInfo)payStatus, (DynamicObject)info);
            this.setAgentPayField(info);
            boolean isencryption = info.getBoolean("isencryption");
            for (DynamicObject r : entry) {
                if (!isencryption) continue;
                r.set("e_amount", null);
                r.set("e_localamt", null);
            }
        }
        this.batchUpdatePayDate(agentPayBillList, orgIds);
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])agentPayBillList.toArray(new DynamicObject[0]), (String)"cas_agentpaybill");
        SaveServiceHelper.save((DynamicObject[])agentPayBillList.toArray(new DynamicObject[0]));
        List agentPayBillBookList = agentPayBillList.stream().filter(o -> !agentErrSourceBillIdList.contains(o.getLong("id"))).collect(Collectors.toList());
        List results = BookJournalService.getInstance().doBook(agentPayBillBookList);
        if (results != null && results.size() > 0) {
            StringBuilder strInfos = new StringBuilder();
            results.forEach(o -> strInfos.append(o.getBizBillNo()).append(o.getInfo()).append("\r\n"));
            throw new KDBizException(strInfos.toString());
        }
        for (DynamicObject agentPayBill : agentPayBillList) {
            String source = agentPayBill.getString("source");
            if (!"BOTP".equals(source)) continue;
            WriteBackTaskHelper.addRealtimeTask((DynamicObject)agentPayBill, (String)agentPayBill.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.PAY, AgentWriteBackConsumer.class);
        }
        if (pushBills.size() > 0) {
            OperateServiceHelper.execOperate((String)"genotherarbill", (String)"cas_agentpaybill", (DynamicObject[])pushBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AgentPayValidator());
        e.addValidator((AbstractValidator)new AgentPayBillWriteValidator(WriteBackOperateEnum.PAYVALIDATE));
        e.getValidators().add(new AgentPayBillIsFreezeValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ArrayList<DynamicObject> checkBills = new ArrayList<DynamicObject>();
        List<Object> agentIdList = Arrays.stream(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObject[] agentDts = BusinessDataServiceHelper.load((Object[])agentIdList.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_agentpaybill"));
        Map agentDtsMap = Arrays.stream(agentDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject bill = (DynamicObject)agentDtsMap.get(info.getPkValue());
            if (null == bill || !BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) continue;
            checkBills.add(info);
        }
        if (EmptyUtil.isNoEmpty(checkBills)) {
            VoucherCheckHepler.batchDoVoucherCheck(checkBills);
        }
        OperateServiceHelper.execOperate((String)"synctrigger", (String)"cas_agentpaybill", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
    }

    private void batchUpdatePayDate(List<DynamicObject> agentPayBills, Set<Long> orgIds) {
        Map payDateMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(orgIds), (String)"selectpaydate");
        for (DynamicObject agentPayBill : agentPayBills) {
            DynamicObjectCollection agentEntry = agentPayBill.getDynamicObjectCollection("entry");
            String orgId = agentPayBill.getDynamicObject("org").getString("id");
            Object value = payDateMap.get(orgId);
            String paydateStr = value == null ? "sysdate" : value.toString();
            Date payDate = PaymentPayHelper.confirmPayDate((DynamicObject)agentPayBill, (String)paydateStr);
            for (DynamicObject agentRow : agentEntry) {
                if (!agentRow.getBoolean("e_issuccess")) continue;
                agentRow.set("e_paytime", (Object)payDate);
            }
            if ("sysdate".equals(paydateStr)) {
                Date latestDate = agentEntry.stream().map(e -> e.getDate("e_paytime")).max(Comparator.naturalOrder()).orElse(null);
                agentPayBill.set("paytime", (Object)latestDate);
                continue;
            }
            agentPayBill.set("paytime", (Object)payDate);
        }
    }

    private void setAgentPayField(DynamicObject info) {
        PluginProxy pluginProxy = PluginProxy.create(IAgentPayField.class, (String)"fi.cas.agentpay.IAgentPayField");
        pluginProxy.callReplace(proxy -> {
            proxy.setAgentPayField(info);
            return null;
        });
    }
}

